/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io.enc;

import com.twelvemonkeys.io.FileUtil;
import com.twelvemonkeys.io.enc.Base64Decoder;
import com.twelvemonkeys.io.enc.Base64Encoder;
import com.twelvemonkeys.io.enc.Decoder;
import com.twelvemonkeys.io.enc.DecoderAbstractTest;
import com.twelvemonkeys.io.enc.DecoderStream;
import com.twelvemonkeys.io.enc.Encoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.junit.Assert;
import org.junit.Test;

public class Base64DecoderTest
extends DecoderAbstractTest {
    @Override
    public Decoder createDecoder() {
        return new Base64Decoder();
    }

    @Override
    public Encoder createCompatibleEncoder() {
        return new Base64Encoder();
    }

    @Test
    public void testEmptyDecode2() throws IOException {
        String string = "";
        DecoderStream decoderStream = new DecoderStream((InputStream)new ByteArrayInputStream(string.getBytes()), this.createDecoder());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FileUtil.copy((InputStream)decoderStream, (OutputStream)byteArrayOutputStream);
        Assert.assertEquals((String)"Strings does not match", (Object)"", (Object)new String(byteArrayOutputStream.toByteArray()));
    }

    @Test
    public void testShortDecode() throws IOException {
        String string = "dGVzdA==";
        DecoderStream decoderStream = new DecoderStream((InputStream)new ByteArrayInputStream(string.getBytes()), this.createDecoder());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FileUtil.copy((InputStream)decoderStream, (OutputStream)byteArrayOutputStream);
        Assert.assertEquals((String)"Strings does not match", (Object)"test", (Object)new String(byteArrayOutputStream.toByteArray()));
    }

    @Test
    public void testLongDecode() throws IOException {
        String string = "TG9yZW0gaXBzdW0gZG9sb3Igc2l0IGFtZXQsIGNvbnNlY3RldHVlciBhZGlwaXNjaW5nIGVsaXQuIEZ1c2NlIGVzdC4gTW9yYmkgbHVjdHVzIGNvbnNlY3RldHVlciBqdXN0by4gVml2YW11cyBkYXBpYnVzIGxhb3JlZXQgcHVydXMuIE51bmMgdml2ZXJyYSBkaWN0dW0gbmlzbC4gSW50ZWdlciB1bGxhbWNvcnBlciwgbmlzaSBpbiBkaWN0dW0gYW1ldC4=";
        DecoderStream decoderStream = new DecoderStream((InputStream)new ByteArrayInputStream(string.getBytes()), this.createDecoder());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FileUtil.copy((InputStream)decoderStream, (OutputStream)byteArrayOutputStream);
        Assert.assertEquals((String)"Strings does not match", (Object)"Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Fusce est. Morbi luctus consectetuer justo. Vivamus dapibus laoreet purus. Nunc viverra dictum nisl. Integer ullamcorper, nisi in dictum amet.", (Object)new String(byteArrayOutputStream.toByteArray()));
    }
}

