/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io;

import com.twelvemonkeys.io.SubStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class SubStreamTest {
    private final Random rng = new Random(2918475687L);

    @Test(expected=IllegalArgumentException.class)
    public void testCreateNullStream() {
        new SubStream(null, 42L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateNegativeLength() {
        new SubStream((InputStream)new ByteArrayInputStream(new byte[1]), -1L);
    }

    @Test
    public void testReadAll() throws IOException {
        byte[] byArray = new byte[128];
        this.rng.nextBytes(byArray);
        try (SubStream subStream = new SubStream((InputStream)new ByteArrayInputStream(byArray), (long)byArray.length);){
            for (byte by : byArray) {
                Assert.assertEquals((long)by, (long)((byte)subStream.read()));
            }
            Assert.assertEquals((long)-1L, (long)subStream.read());
        }
    }

    @Test
    public void testReadAllArray() throws IOException {
        byte[] byArray = new byte[128];
        this.rng.nextBytes(byArray);
        try (SubStream subStream = new SubStream((InputStream)new ByteArrayInputStream(byArray), (long)byArray.length);){
            byte[] byArray2 = new byte[byArray.length / 4];
            for (int i = 0; i < 4; ++i) {
                Assert.assertEquals((long)byArray2.length, (long)subStream.read(byArray2));
                Assert.assertArrayEquals((byte[])Arrays.copyOfRange(byArray, i * byArray2.length, (i + 1) * byArray2.length), (byte[])byArray2);
            }
            Assert.assertEquals((long)-1L, (long)subStream.read());
        }
    }

    @Test
    public void testSkipAll() throws IOException {
        byte[] byArray = new byte[128];
        try (SubStream subStream = new SubStream((InputStream)new ByteArrayInputStream(byArray), (long)byArray.length);){
            Assert.assertEquals((long)128L, (long)subStream.skip(byArray.length));
            Assert.assertEquals((long)-1L, (long)subStream.read());
        }
    }

    @Test
    public void testCloseConsumesAll() throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(new byte[128]);
        SubStream subStream = new SubStream((InputStream)byteArrayInputStream, 128L);
        Throwable throwable = null;
        if (subStream != null) {
            if (throwable != null) {
                try {
                    subStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                subStream.close();
            }
        }
        Assert.assertEquals((long)0L, (long)byteArrayInputStream.available());
        Assert.assertEquals((long)-1L, (long)byteArrayInputStream.read());
    }

    @Test
    public void testCloseConsumesAllLongStream() throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(new byte[256]);
        SubStream subStream = new SubStream((InputStream)byteArrayInputStream, 128L);
        Throwable throwable = null;
        if (subStream != null) {
            if (throwable != null) {
                try {
                    subStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                subStream.close();
            }
        }
        Assert.assertEquals((long)128L, (long)byteArrayInputStream.available());
        Assert.assertEquals((long)0L, (long)byteArrayInputStream.read());
    }

    @Test(timeout=500L)
    public void testCloseConsumesAllShortStream() throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(new byte[13]);
        SubStream subStream = new SubStream((InputStream)byteArrayInputStream, 42L);
        Throwable throwable = null;
        if (subStream != null) {
            if (throwable != null) {
                try {
                    subStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                subStream.close();
            }
        }
        Assert.assertEquals((long)0L, (long)byteArrayInputStream.available());
        Assert.assertEquals((long)-1L, (long)byteArrayInputStream.read());
    }
}

