/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io;

import com.twelvemonkeys.io.ReaderAbstractTest;
import com.twelvemonkeys.io.StringArrayReader;
import com.twelvemonkeys.lang.StringUtil;
import java.io.IOException;
import java.io.Reader;
import org.junit.Assert;
import org.junit.Test;

public class StringArrayReaderTest
extends ReaderAbstractTest {
    @Override
    protected Reader makeReader(String string) {
        String[] stringArray = StringUtil.toStringArray((String)string, (String)" ");
        for (int i = 0; i < stringArray.length; ++i) {
            if (i == 0) continue;
            stringArray[i] = " " + stringArray[i];
        }
        return new StringArrayReader(stringArray);
    }

    @Test
    public void testNullConstructor() {
        try {
            new StringArrayReader(null);
            Assert.fail((String)"Should not allow null argument");
        }
        catch (RuntimeException runtimeException) {
            Assert.assertNotNull((Object)runtimeException.getMessage());
        }
    }

    @Test
    public void testEmptyArrayConstructor() throws IOException {
        StringArrayReader stringArrayReader = new StringArrayReader(new String[0]);
        Assert.assertEquals((long)-1L, (long)stringArrayReader.read());
    }

    @Test
    public void testEmptyStringConstructor() throws IOException {
        StringArrayReader stringArrayReader = new StringArrayReader(new String[]{""});
        Assert.assertEquals((long)-1L, (long)stringArrayReader.read());
    }
}

