/*
 * Decompiled with CFR 0.152.
 */
package com.tuyenmonkey.mkloader.type;

import android.animation.ValueAnimator;
import android.graphics.Canvas;
import com.tuyenmonkey.mkloader.model.Circle;
import com.tuyenmonkey.mkloader.type.LoaderView;

public class ClassicSpinner
extends LoaderView {
    private Circle[] circles;
    private int circlesSize = 8;

    @Override
    public void initializeObjects() {
        float size = Math.min(this.width, this.height);
        float circleRadius = size / 10.0f;
        this.circles = new Circle[this.circlesSize];
        for (int i = 0; i < this.circlesSize; ++i) {
            this.circles[i] = new Circle();
            this.circles[i].setCenter(this.center.x, circleRadius);
            this.circles[i].setColor(this.color);
            this.circles[i].setAlpha(126);
            this.circles[i].setRadius(circleRadius);
        }
    }

    @Override
    public void setUpAnimation() {
        int i = 0;
        while (i < this.circlesSize) {
            final int index = i++;
            ValueAnimator fadeAnimator = ValueAnimator.ofInt((int[])new int[]{126, 255, 126});
            fadeAnimator.setRepeatCount(-1);
            fadeAnimator.setDuration(1000L);
            fadeAnimator.setStartDelay((long)(index * 120));
            fadeAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    ClassicSpinner.this.circles[index].setAlpha((Integer)animation.getAnimatedValue());
                    if (ClassicSpinner.this.invalidateListener != null) {
                        ClassicSpinner.this.invalidateListener.reDraw();
                    }
                }
            });
            fadeAnimator.start();
        }
    }

    @Override
    public void draw(Canvas canvas) {
        for (int i = 0; i < this.circlesSize; ++i) {
            canvas.save();
            canvas.rotate((float)(45 * i), this.center.x, this.center.y);
            this.circles[i].draw(canvas);
            canvas.restore();
        }
    }
}

