/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.sdk.bean;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.room.ColumnInfo;
import androidx.room.Entity;
import androidx.room.PrimaryKey;
import androidx.room.TypeConverters;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.tuya.smart.android.device.bean.SchemaBean;
import com.tuya.smart.android.device.enums.DataTypeEnum;
import com.tuya.smart.home.sdk.db.MapTypeConverter;
import com.tuya.smart.home.sdk.db.SchemaInfoConverter;
import com.tuya.smart.home.sdk.db.ShortcutBeanConverter;
import com.tuya.smart.home.sdk.db.StandardSchemaConverter;
import com.tuya.smart.home.sdk.db.UiInfoConverter;
import com.tuya.smart.sdk.api.IStorageCache;
import com.tuya.smart.sdk.bean.ShortCutBean;
import com.tuya.smart.sdk.bean.StandSchema;
import com.tuya.smart.sdk.bean.UiInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Entity(tableName="products")
public class ProductBean
implements IStorageCache {
    public static final int CAP_WIFI = 1;
    public static final int CAP_CABLE = 2;
    public static final int CAP_GPRS = 4;
    public static final int CAP_NB_IOT = 8;
    public static final int CAP_BLUETOOTH = 1024;
    public static final int CAP_BLEMESH = 2048;
    public static final int CAP_ZIGBEE = 4096;
    public static final int CAP_HONGWAI = 8192;
    public static final int CAP_SIGMESH = 32768;
    public static final int ATTR_HONGWAI_SUB = 0x2000000;
    public static final int CAP_433 = 16384;
    public static final int ATTRIBUTE_LOW_POWER = 4096;
    public long ownerId;
    private long resptime;
    @PrimaryKey
    @NonNull
    @ColumnInfo(name="product_id")
    private String id = "";
    private boolean supportGroup;
    private long attribute;
    private String category;
    private String meshCategory;
    private long i18nTime;
    @TypeConverters(value={MapTypeConverter.class})
    private Map<String, Object> panelConfig;
    @TypeConverters(value={SchemaInfoConverter.class})
    private SchemaInfo schemaInfo;
    @TypeConverters(value={ShortcutBeanConverter.class})
    private ShortCutBean shortcut;
    private int capability;
    @TypeConverters(value={UiInfoConverter.class})
    private UiInfo uiInfo;
    @JSONField(name="sSchema")
    @TypeConverters(value={StandardSchemaConverter.class})
    private StandSchema standardSchema;
    private boolean standard;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public long getAttribute() {
        return this.attribute;
    }

    public void setAttribute(long attribute) {
        this.attribute = attribute;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public long getI18nTime() {
        return this.i18nTime;
    }

    public void setI18nTime(long i18nTime) {
        this.i18nTime = i18nTime;
    }

    public SchemaInfo getSchemaInfo() {
        return this.schemaInfo;
    }

    public void setSchemaInfo(SchemaInfo schemaInfo) {
        this.schemaInfo = schemaInfo;
    }

    public ShortCutBean getShortcut() {
        return this.shortcut;
    }

    public void setShortcut(ShortCutBean shortcut) {
        this.shortcut = shortcut;
    }

    public UiInfo getUiInfo() {
        return this.uiInfo;
    }

    public void setUiInfo(UiInfo uiInfo) {
        this.uiInfo = uiInfo;
    }

    public Map<String, Object> getPanelConfig() {
        return this.panelConfig;
    }

    public void setPanelConfig(Map<String, Object> panelConfig) {
        this.panelConfig = panelConfig;
    }

    public boolean isSupportGroup() {
        return this.supportGroup;
    }

    public void setSupportGroup(boolean supportGroup) {
        this.supportGroup = supportGroup;
    }

    @Override
    public long getResptime() {
        return this.resptime;
    }

    @Override
    public void setResptime(long resptime) {
        this.resptime = resptime;
    }

    @Override
    public Object getKey() {
        return this.id;
    }

    public String getMeshCategory() {
        return this.meshCategory;
    }

    public void setMeshCategory(String meshCategory) {
        this.meshCategory = meshCategory;
    }

    public int getCapability() {
        return this.capability;
    }

    public void setCapability(int capability) {
        this.capability = capability;
    }

    public boolean hasZigBee() {
        return (this.capability & 0x1000) > 0;
    }

    public boolean hasBleMesh() {
        return this.hasBlueMesh() || this.hasSigMesh();
    }

    public boolean hasBlueMesh() {
        return (this.capability & 0x800) > 0;
    }

    public boolean hasSigMesh() {
        return (this.capability & 0x8000) > 0;
    }

    public boolean hasWifi() {
        return (this.capability & 1) > 0;
    }

    public boolean isWifi() {
        return this.capability == 1;
    }

    public boolean hasBluetooth() {
        return (this.capability & 0x400) > 0;
    }

    public boolean isBluetooth() {
        return this.capability == 1024;
    }

    public boolean isInfraredSubDevDisplayInList() {
        return (this.attribute & 0x2000000L) > 0L;
    }

    public boolean hasInfrared() {
        return (this.capability & 0x2000) > 0;
    }

    public boolean has433() {
        return (this.capability & 0x4000) > 0;
    }

    public StandSchema getStandardSchema() {
        return this.standardSchema;
    }

    public void setStandardSchema(StandSchema standardSchema) {
        this.standardSchema = standardSchema;
    }

    public boolean isStandard() {
        return this.standard;
    }

    public void setStandard(boolean standard) {
        this.standard = standard;
    }

    public static class SchemaInfo {
        private String schema;
        private String schemaExt;
        @JSONField(serialize=false)
        private Map<String, SchemaBean> schemaMap = new HashMap<String, SchemaBean>();
        @JSONField(serialize=false)
        private Map<String, SchemaBean> schemaCodeMap = new HashMap<String, SchemaBean>();

        public String getSchema() {
            return this.schema;
        }

        public void setSchema(String schema) {
            this.schema = schema;
        }

        public String getSchemaExt() {
            return this.schemaExt;
        }

        public void setSchemaExt(String schemaExt) {
            this.schemaExt = schemaExt;
        }

        public Map<String, SchemaBean> getSchemaMap() {
            this.buildSchema();
            return this.schemaMap;
        }

        public void setSchemaMap(Map<String, SchemaBean> schemaMap) {
            this.schemaMap = schemaMap;
        }

        public Map<String, SchemaBean> getDpCodeSchemaMap() {
            this.buildCodeSchema();
            int size = this.schemaCodeMap.size();
            HashMap<String, SchemaBean> copySchemaCodeMap = new HashMap<String, SchemaBean>(size);
            copySchemaCodeMap.putAll(this.schemaCodeMap);
            return copySchemaCodeMap;
        }

        public void buildSchema() {
            if (!TextUtils.isEmpty((CharSequence)this.schema)) {
                List schemaBeanList = JSONObject.parseArray((String)this.schema, SchemaBean.class);
                for (SchemaBean schemaBean : schemaBeanList) {
                    if (schemaBean.getType().equals(DataTypeEnum.OBJ.getType())) {
                        schemaBean.setSchemaType(JSONObject.parseObject((String)schemaBean.getProperty()).getString("type"));
                    }
                    this.schemaMap.put(schemaBean.getId(), schemaBean);
                }
            }
        }

        private void buildCodeSchema() {
            if (!TextUtils.isEmpty((CharSequence)this.schema)) {
                List schemaBeanList = JSONObject.parseArray((String)this.schema, SchemaBean.class);
                for (SchemaBean schemaBean : schemaBeanList) {
                    if (schemaBean.getType().equals(DataTypeEnum.OBJ.getType())) {
                        schemaBean.setSchemaType(JSONObject.parseObject((String)schemaBean.getProperty()).getString("type"));
                    }
                    this.schemaCodeMap.put(schemaBean.getCode(), schemaBean);
                }
            }
        }
    }
}

