/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.home.sdk.bean.scene;

import android.text.TextUtils;
import com.tuya.smart.android.device.bean.SchemaBean;
import com.tuya.smart.home.sdk.bean.scene.ActionBean;
import com.tuya.smart.home.sdk.bean.scene.ConditionExtraInfoBean;
import com.tuya.smart.home.sdk.bean.scene.ConditionRespBean;
import com.tuya.smart.home.sdk.bean.scene.MCGroup;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

public class ConditionActionBean
extends ActionBean {
    private SchemaBean schema;
    private List<String> operators;
    private String choosedOperator;
    private int entityType;
    private String entitySubId;
    private String entityId;
    private String entityName;
    private String newIcon;
    private List<String> mcGroupNames;
    private ConditionExtraInfoBean condCalExtraInfo;

    public ConditionActionBean() {
    }

    public ConditionActionBean(ConditionRespBean actBean) {
        this.setName(actBean.getEntityName());
        this.setId(actBean.getId());
        this.setEntityType(actBean.getEntityType());
        this.setEntitySubId(actBean.getEntitySubId());
        this.setEntityId(actBean.getEntityId());
        this.setEntityName(actBean.getEntityName());
        this.setCondCalExtraInfo(actBean.getCondCalExtraInfo());
        List<MCGroup> mcGroups = actBean.getMcGroups();
        this.mcGroupNames = new ArrayList<String>();
        if (null != mcGroups && !mcGroups.isEmpty()) {
            for (MCGroup mCGroup : mcGroups) {
                this.mcGroupNames.add(mCGroup.getGroupName());
            }
        }
        if (actBean.getEntityType() == 1 || actBean.getEntityType() == 7) {
            this.setDpId(Long.parseLong(actBean.getProperty().getId()));
        } else {
            this.setDpId(actBean.getId());
        }
        this.actDetail = actBean.getValueRangeDisplay();
        List<List<Object>> valueRangeJson = actBean.getValueRangeJson();
        if (valueRangeJson != null) {
            for (List<Object> list : valueRangeJson) {
                this.rangeKeys.add(list.get(0));
                this.rangeValues.add(list.get(1).toString());
            }
        }
        this.setSchema(actBean.getProperty());
        try {
            if (!TextUtils.isEmpty((CharSequence)actBean.getOperators())) {
                this.operators = com.alibaba.fastjson.JSONObject.parseArray((String)actBean.getOperators(), String.class);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            if (null != actBean.getProperty()) {
                JSONObject jSONObject = new JSONObject(actBean.getProperty().getProperty());
                this.setType(jSONObject.getString("type"));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setNewIcon(actBean.getNewIcon());
    }

    public void setEntitySubId(String entitySubId) {
        this.entitySubId = entitySubId;
    }

    @Override
    public SchemaBean getSchema() {
        return this.schema;
    }

    public String getNewIcon() {
        return this.newIcon;
    }

    public void setNewIcon(String newIcon) {
        this.newIcon = newIcon;
    }

    public void setSchema(SchemaBean schema) {
        this.schema = schema;
    }

    @Override
    public List<String> getOperators() {
        return this.operators;
    }

    @Override
    public void setOperators(List<String> operators) {
        this.operators = operators;
    }

    public String getChoosedOperator() {
        return this.choosedOperator;
    }

    public void setChoosedOperator(String choosedOperator) {
        this.choosedOperator = choosedOperator;
    }

    public void setEntityType(int entityType) {
        this.entityType = entityType;
    }

    public int getEntityType() {
        return this.entityType;
    }

    public String getEntitySubId() {
        return this.entitySubId;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public List<String> getMcGroupNames() {
        return this.mcGroupNames;
    }

    public void setMcGroupNames(List<String> mcGroupNames) {
        this.mcGroupNames = mcGroupNames;
    }

    public ConditionExtraInfoBean getCondCalExtraInfo() {
        return this.condCalExtraInfo;
    }

    public void setCondCalExtraInfo(ConditionExtraInfoBean condCalExtraInfo) {
        this.condCalExtraInfo = condCalExtraInfo;
    }
}

