/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.android.device.standard;

import com.tuya.sdk.core.PluginManager;
import com.tuya.smart.android.device.standard.IDpConverter;
import com.tuya.smart.interior.api.ITuyaDevicePlugin;
import com.tuya.smart.interior.device.ITuyaDevListCacheManager;
import java.util.HashMap;
import java.util.Map;

public class DpConverterUtil {
    public static IDpConverter getDpConverter() {
        ITuyaDevicePlugin devicePlugin = (ITuyaDevicePlugin)PluginManager.service(ITuyaDevicePlugin.class);
        if (devicePlugin != null) {
            ITuyaDevListCacheManager manager = devicePlugin.getDevListCacheManager();
            return manager.getDpConverter();
        }
        return null;
    }

    public static String convertDpId(String devId, long dpId) {
        IDpConverter dpConverter = DpConverterUtil.getDpConverter();
        if (dpConverter == null) {
            return "";
        }
        return dpConverter.convertId2Code(devId, String.valueOf(dpId));
    }

    public static Map<String, Object> convertDpIds(String devId, HashMap<String, Object> dpIds) {
        IDpConverter dpConverter = DpConverterUtil.getDpConverter();
        if (dpConverter == null) {
            return null;
        }
        return dpConverter.convertIds2CodesMap(devId, dpIds);
    }

    public static Map<String, Object> convertDpCodes(String devId, HashMap<String, Object> dpCodes) {
        IDpConverter dpConverter = DpConverterUtil.getDpConverter();
        if (dpConverter == null) {
            return null;
        }
        return dpConverter.convertCodes2IdsMap(devId, dpCodes);
    }

    public static long convertDpCode(String devId, String dpCode) {
        try {
            IDpConverter dpConverter = DpConverterUtil.getDpConverter();
            if (dpConverter == null) {
                return 0L;
            }
            return Long.parseLong(dpConverter.convertCode2Id(devId, dpCode));
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static String convertCodes2IdsByPid(String pid, String dpCodes) {
        try {
            IDpConverter dpConverter = DpConverterUtil.getDpConverter();
            if (dpConverter != null) {
                return dpConverter.convertCodes2IdsByPid(pid, dpCodes);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public static String convertCodes2IdsByPid(String pid, Map<String, Object> dpCodeMap) {
        try {
            IDpConverter dpConverter = DpConverterUtil.getDpConverter();
            if (dpConverter != null) {
                return dpConverter.convertCodes2IdsByPid(pid, dpCodeMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public static String convertIds2CodesByPid(String pid, String dps) {
        try {
            IDpConverter dpConverter = DpConverterUtil.getDpConverter();
            if (dpConverter != null) {
                return dpConverter.convertIds2CodesByPid(pid, dps);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }
}

