/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.android.ble.api;

import com.tuya.smart.android.ble.api.ScanType;
import java.util.ArrayList;
import java.util.List;

public class LeScanSetting {
    private long timeout;
    private List<ScanType> scanTypeList;
    private boolean repeatFilter = true;

    private LeScanSetting(Builder builder) {
        this.timeout = builder.timeout;
        this.scanTypeList = builder.scanTypeList;
        this.repeatFilter = builder.repeatFilter;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public List<ScanType> getScanTypeList() {
        return this.scanTypeList;
    }

    public boolean isRepeatFilter() {
        return this.repeatFilter;
    }

    public static class Builder {
        private long timeout = 40000L;
        private List<ScanType> scanTypeList = new ArrayList<ScanType>();
        private boolean repeatFilter = true;

        public Builder setTimeout(long timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder addScanType(ScanType type) {
            this.scanTypeList.add(type);
            return this;
        }

        public Builder setRepeatFilter(boolean filter) {
            this.repeatFilter = filter;
            return this;
        }

        public LeScanSetting build() {
            if (this.scanTypeList.size() == 0) {
                throw new IllegalArgumentException("At least one ScanType needs to be added!");
            }
            return new LeScanSetting(this);
        }
    }
}

