/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.android.device.builder;

import com.tuya.smart.android.device.enums.TimerDeviceTypeEnum;

public class TuyaTimerBuilder {
    public static int STATUS_OPEN = 1;
    public static int STATUS_CLOSE = 0;
    private String taskName;
    private String devId;
    private String loops;
    private int status;
    private String actions;
    private boolean appPush;
    private String aliasName;
    private long timerId;
    private TimerDeviceTypeEnum deviceTimerTypeEnum;

    public TuyaTimerBuilder(Builder builder) {
        this.taskName = builder.taskName;
        this.devId = builder.devId;
        this.loops = builder.loops;
        this.status = builder.status;
        this.actions = builder.actions;
        this.appPush = builder.appPush;
        this.aliasName = builder.aliasName;
        this.timerId = builder.timerId;
        this.deviceTimerTypeEnum = builder.deviceTimerTypeEnum;
    }

    public String taskName() {
        return this.taskName;
    }

    public String devId() {
        return this.devId;
    }

    public String loops() {
        return this.loops;
    }

    public int status() {
        return this.status;
    }

    public String actions() {
        return this.actions;
    }

    public boolean isAppPush() {
        return this.appPush;
    }

    public String aliasName() {
        return this.aliasName;
    }

    public long timerId() {
        return this.timerId;
    }

    public TimerDeviceTypeEnum deviceTimerTypeEnum() {
        return this.deviceTimerTypeEnum;
    }

    public static final class Builder {
        private String taskName;
        private String devId;
        private String loops;
        private int status;
        private String actions;
        private boolean appPush;
        private String aliasName;
        private long timerId;
        private TimerDeviceTypeEnum deviceTimerTypeEnum;

        public Builder timerId(long timerId) {
            this.timerId = timerId;
            return this;
        }

        public Builder taskName(String taskName) {
            this.taskName = taskName;
            return this;
        }

        public Builder devId(String devId) {
            this.devId = devId;
            return this;
        }

        public Builder loops(String loops) {
            this.loops = loops;
            return this;
        }

        public Builder status(int status) {
            this.status = status;
            return this;
        }

        public Builder actions(String actions) {
            this.actions = actions;
            return this;
        }

        public Builder appPush(boolean isAppPush) {
            this.appPush = isAppPush;
            return this;
        }

        public Builder aliasName(String aliasName) {
            this.aliasName = aliasName;
            return this;
        }

        public Builder deviceType(TimerDeviceTypeEnum typeEnum) {
            this.deviceTimerTypeEnum = typeEnum;
            return this;
        }

        public TuyaTimerBuilder build() {
            return new TuyaTimerBuilder(this);
        }
    }
}

