/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.home.sdk.bean.scene.condition;

import android.text.TextUtils;
import com.alibaba.fastjson.JSONObject;
import com.tuya.smart.home.sdk.bean.scene.ActionBean;
import com.tuya.smart.home.sdk.bean.scene.ConditionActionBean;
import com.tuya.smart.home.sdk.bean.scene.condition.property.BoolProperty;
import com.tuya.smart.home.sdk.bean.scene.condition.property.EnumProperty;
import com.tuya.smart.home.sdk.bean.scene.condition.property.IProperty;
import com.tuya.smart.home.sdk.bean.scene.condition.property.TimerProperty;
import com.tuya.smart.home.sdk.bean.scene.condition.property.ValueProperty;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;

public class ConditionListBean
implements Serializable {
    private static final long serialVersionUID = 304714977183918709L;
    private long id;
    private String name;
    private String entityName;
    private String type;
    private IProperty property;
    private List<String> operators;
    private String newIcon;
    private int entityType;

    public ConditionListBean() {
    }

    public ConditionListBean(ActionBean bean) {
        ConditionActionBean actionBean;
        this.name = bean.getSchema().getName();
        this.type = bean.getSchema().getCode();
        if (bean instanceof ConditionActionBean && ((actionBean = (ConditionActionBean)bean).getEntityType() == 9 || actionBean.getEntityType() == 11)) {
            this.type = actionBean.getEntitySubId();
        }
        if (!TextUtils.isEmpty((CharSequence)bean.getType())) {
            switch (bean.getType()) {
                case "value": {
                    this.property = (IProperty)JSONObject.parseObject((String)bean.getSchema().getProperty(), ValueProperty.class);
                    break;
                }
                case "enum": {
                    this.property = new EnumProperty();
                    HashMap<Object, String> enums = ((EnumProperty)this.property).getEnums();
                    for (Object key : bean.rangeKeys) {
                        enums.put(key, bean.rangeValues.get(bean.rangeKeys.indexOf(key)));
                    }
                    break;
                }
                case "bool": {
                    this.property = new BoolProperty();
                    HashMap<Boolean, String> bools = ((BoolProperty)this.property).getBoolMap();
                    for (Object key : bean.rangeKeys) {
                        bools.put((Boolean)key, bean.rangeValues.get(bean.rangeKeys.indexOf(key)));
                    }
                    break;
                }
                case "timer": {
                    this.property = (IProperty)JSONObject.parseObject((String)bean.getSchema().getProperty(), TimerProperty.class);
                    break;
                }
            }
        }
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getNewIcon() {
        return this.newIcon;
    }

    public void setNewIcon(String newIcon) {
        this.newIcon = newIcon;
    }

    public String getType() {
        return this.type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setProperty(IProperty property) {
        this.property = property;
    }

    public IProperty getProperty() {
        return this.property;
    }

    public void setOperators(List<String> operators) {
        this.operators = operators;
    }

    public List<String> getOperators() {
        return this.operators;
    }

    public int getEntityType() {
        return this.entityType;
    }

    public void setEntityType(int entityType) {
        this.entityType = entityType;
    }
}

