/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.home.sdk.bean.scene;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tuya.smart.home.sdk.bean.scene.PreCondition;
import com.tuya.smart.home.sdk.bean.scene.SceneCondition;
import com.tuya.smart.home.sdk.bean.scene.SceneTask;
import java.io.Serializable;
import java.util.List;

public class SceneBean
implements Serializable {
    private static final long serialVersionUID = 4267985378494994443L;
    public static final int MATCH_TYPE_OR = 1;
    public static final int MATCH_TYPE_AND = 2;
    public static final int MATCH_TYPE_BY_EXPR = 3;
    public static final int RULEGENRE_TYPE_MANUAL = 1;
    public static final int RULEGENRE_TYPE_SMART = 2;
    private String id;
    private String name;
    private String code;
    private boolean enabled;
    private String background;
    private boolean stickyOnTop;
    private List<SceneCondition> conditions;
    private List<SceneTask> actions;
    private int matchType;
    private boolean boundForPanel;
    private List<PreCondition> preConditions;
    private boolean localLinkage;
    public boolean newLocalScene;
    private int ruleGenre;
    private String coverIcon;
    private String displayColor;
    private long disableTime;
    private String recomDescription;
    private int recomCoefficient;
    private boolean boundForWiFiPanel;
    private boolean cached;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<SceneCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<SceneCondition> conditions) {
        this.conditions = conditions;
    }

    public List<SceneTask> getActions() {
        return this.actions;
    }

    public void setActions(List<SceneTask> actions) {
        this.actions = actions;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public int getMatchType() {
        return this.matchType;
    }

    public void setMatchType(int matchType) {
        this.matchType = matchType;
    }

    public static SceneBean createSceneBean(@NonNull String name, String background, List<SceneCondition> conditions, @NonNull List<SceneTask> tasks, int matchType) {
        return SceneBean.createSceneBean(name, null, false, background, conditions, tasks, matchType);
    }

    public static SceneBean createSceneBean(@NonNull String name, @Nullable String id, boolean stickyOnTop, String background, @Nullable List<SceneCondition> conditions, @NonNull List<SceneTask> tasks, int matchType) {
        return SceneBean.createSceneBean(name, id, stickyOnTop, background, conditions, tasks, null, matchType);
    }

    public static SceneBean createSceneBean(@NonNull String name, @Nullable String id, boolean stickyOnTop, String background, @Nullable List<SceneCondition> conditions, @NonNull List<SceneTask> tasks, List<PreCondition> preConditions, int matchType) {
        SceneBean sceneBean = new SceneBean();
        sceneBean.setName(name);
        sceneBean.setStickyOnTop(stickyOnTop);
        sceneBean.setBackground(background);
        sceneBean.setMatchType(matchType);
        if (id != null & !TextUtils.isEmpty((CharSequence)id)) {
            sceneBean.setId(id);
        }
        if (conditions != null) {
            sceneBean.setConditions(conditions);
            if (conditions.isEmpty()) {
                sceneBean.setEnabled(true);
            }
        } else {
            sceneBean.setEnabled(true);
        }
        if (null != preConditions) {
            sceneBean.setPreConditions(preConditions);
        }
        sceneBean.setActions(tasks);
        return sceneBean;
    }

    public static SceneBean createSceneBean(@NonNull String name, @NonNull String id, boolean stickyOnTop, String background, String displayColor, String coverIcon, @Nullable List<SceneCondition> conditions, @NonNull List<SceneTask> tasks, List<PreCondition> preConditions, int matchType) {
        SceneBean sceneBean = new SceneBean();
        sceneBean.setName(name);
        sceneBean.setStickyOnTop(stickyOnTop);
        sceneBean.setMatchType(matchType);
        if (!TextUtils.isEmpty((CharSequence)background)) {
            sceneBean.setBackground(background);
        }
        if (!TextUtils.isEmpty((CharSequence)displayColor)) {
            sceneBean.setDisplayColor(displayColor);
        }
        if (!TextUtils.isEmpty((CharSequence)coverIcon)) {
            sceneBean.setCoverIcon(coverIcon);
        }
        if (!TextUtils.isEmpty((CharSequence)id)) {
            sceneBean.setId(id);
        }
        if (conditions != null) {
            sceneBean.setConditions(conditions);
            if (conditions.isEmpty()) {
                sceneBean.setEnabled(true);
            }
        } else {
            sceneBean.setEnabled(true);
        }
        if (null != preConditions) {
            sceneBean.setPreConditions(preConditions);
        }
        sceneBean.setActions(tasks);
        return sceneBean;
    }

    public String getBackground() {
        return this.background;
    }

    public void setBackground(String background) {
        this.background = background;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isStickyOnTop() {
        return this.stickyOnTop;
    }

    public void setStickyOnTop(boolean stickyOnTop) {
        this.stickyOnTop = stickyOnTop;
    }

    public boolean isBoundForPanel() {
        return this.boundForPanel;
    }

    public void setBoundForPanel(boolean boundForPanel) {
        this.boundForPanel = boundForPanel;
    }

    public List<PreCondition> getPreConditions() {
        return this.preConditions;
    }

    public void setPreConditions(List<PreCondition> preConditions) {
        this.preConditions = preConditions;
    }

    public boolean isLocalLinkage() {
        return this.localLinkage;
    }

    public void setLocalLinkage(boolean localLinkage) {
        this.localLinkage = localLinkage;
    }

    public int getRuleGenre() {
        return this.ruleGenre;
    }

    public void setRuleGenre(int ruleGenre) {
        this.ruleGenre = ruleGenre;
    }

    public boolean isNewLocalScene() {
        return this.newLocalScene;
    }

    public void setNewLocalScene(boolean newLocalScene) {
        this.newLocalScene = newLocalScene;
    }

    public String getCoverIcon() {
        return this.coverIcon;
    }

    public void setCoverIcon(String coverIcon) {
        this.coverIcon = coverIcon;
    }

    public String getDisplayColor() {
        return this.displayColor;
    }

    public void setDisplayColor(String displayColor) {
        this.displayColor = displayColor;
    }

    public long getDisableTime() {
        return this.disableTime;
    }

    public void setDisableTime(long disableTime) {
        this.disableTime = disableTime;
    }

    public String getRecomDescription() {
        return this.recomDescription;
    }

    public void setRecomDescription(String recomDescription) {
        this.recomDescription = recomDescription;
    }

    public int getRecomCoefficient() {
        return this.recomCoefficient;
    }

    public void setRecomCoefficient(int recomCoefficient) {
        this.recomCoefficient = recomCoefficient;
    }

    public boolean isBoundForWiFiPanel() {
        return this.boundForWiFiPanel;
    }

    public void setBoundForWiFiPanel(boolean boundForWiFiPanel) {
        this.boundForWiFiPanel = boundForWiFiPanel;
    }

    public boolean isCached() {
        return this.cached;
    }

    public void setCached(boolean cached) {
        this.cached = cached;
    }
}

