/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.reactnativesweeper.view.sweepercommon.virtualwall;

import android.content.Context;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tuya.reactnativesweeper.bean.MapAreaData;
import com.tuya.reactnativesweeper.bean.MapTypeAreaBean;
import com.tuya.reactnativesweeper.manager.SweeperMapStateManager;
import com.tuya.reactnativesweeper.view.sweepercommon.MatrixView;
import com.tuya.reactnativesweeper.view.sweepercommon.virtualwall.OnVirtualActionListener;
import com.tuya.reactnativesweeper.view.sweepercommon.virtualwall.VirtualWallView;
import com.tuya.smart.android.common.utils.L;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class VirtualWallLayout
extends FrameLayout
implements MatrixView {
    private static final String TAG = VirtualWallLayout.class.getSimpleName();
    private List<VirtualWallView> virtualWallViewList;
    private static final int WALL_POINT_COUNT = 2;
    private int viewManagerId = 0;
    private String mapId;
    private int offset = 0;

    public VirtualWallLayout(@NonNull Context context) {
        this(context, null);
    }

    public VirtualWallLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public VirtualWallLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.virtualWallViewList = new ArrayList<VirtualWallView>();
    }

    public void setMapId(String mapId) {
        this.mapId = mapId;
    }

    public boolean onTouchEvent(MotionEvent event) {
        for (VirtualWallView item : this.virtualWallViewList) {
            item.setEdit(false, true);
        }
        return super.onTouchEvent(event);
    }

    private boolean haveNotFinishWall() {
        if (this.virtualWallViewList.isEmpty()) {
            return false;
        }
        boolean mark = false;
        for (VirtualWallView virtualWallView : this.virtualWallViewList) {
            if (virtualWallView.getDrawMode() == 4) continue;
            mark = true;
        }
        return mark;
    }

    @Override
    public void postTranslate(float xDiff, float yDiff) {
        for (VirtualWallView item : this.virtualWallViewList) {
            item.tran(xDiff, yDiff);
        }
    }

    @Override
    public void postScale(float scale, PointF pointF) {
        for (VirtualWallView item : this.virtualWallViewList) {
            item.scale(scale, pointF);
        }
    }

    public void setViewManagerId(int id) {
        this.viewManagerId = id;
    }

    public void addVirtualWall(MapAreaData mapAreaData, float mapScale, boolean isEdit) {
        if (this.haveNotFinishWall()) {
            L.w((String)TAG, (String)"haveNotFinishWall  so do nothing");
            return;
        }
        VirtualWallView virtualWallView = this.createVirtualWall(mapScale);
        virtualWallView.setMapId(this.mapId);
        if (mapAreaData.getPoints() != null && mapAreaData.getPoints().size() == 2) {
            virtualWallView.setStartAndEnd(mapAreaData.getPoints().get(0), mapAreaData.getPoints().get(1));
            virtualWallView.setEdit(false, false);
        }
        virtualWallView.setMapAreaData(mapAreaData);
        this.virtualWallViewList.add(virtualWallView);
        this.addView((View)virtualWallView, -1, -1);
        this.requestLayout();
    }

    public void addVirtualWallList(List<MapAreaData> list, float mapScale) {
        if (list == null || list.size() == 0) {
            return;
        }
        for (MapAreaData mapAreaData : list) {
            this.addVirtualWall(mapAreaData, mapScale, false);
        }
    }

    private void addVirtualWall(String color, PointF start, PointF end, float mapScale) {
        if (this.haveNotFinishWall()) {
            L.w((String)TAG, (String)"haveNotFinishWall  so do nothing");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)color)) {
            return;
        }
        VirtualWallView virtualWallView = this.createVirtualWall(mapScale);
        virtualWallView.setMapId(this.mapId);
        if (null != start && null != end) {
            virtualWallView.setStartAndEnd(start, end);
            virtualWallView.setEdit(true, false);
        }
        virtualWallView.setColor(color);
        this.virtualWallViewList.add(virtualWallView);
        this.addView((View)virtualWallView, -1, -1);
        this.requestLayout();
        virtualWallView.sendPointsToRN();
    }

    public void addVirtualWallVisible(String color, float mapScale) {
        int width = this.getWidth();
        int height = this.getHeight();
        int insertOffset = 0;
        if (this.offset > 0) {
            insertOffset = this.offset * 50;
        }
        PointF start = new PointF((float)(width / 3 + insertOffset), (float)(height / 2 + insertOffset));
        PointF end = new PointF((float)(width / 3 * 2 + insertOffset), (float)(height / 2 + insertOffset));
        this.addVirtualWall(color, start, end, mapScale);
        ++this.offset;
    }

    private VirtualWallView createVirtualWall(float mapScale) {
        final VirtualWallView virtualWallView = new VirtualWallView(this.getContext());
        virtualWallView.setPreScale(mapScale);
        virtualWallView.setViewManagerId(this.viewManagerId);
        HashMap<String, Object> zoomFactor = SweeperMapStateManager.getInstance().getZoomFactor();
        virtualWallView.setZoomFactor(zoomFactor);
        virtualWallView.setOnActionListener(new OnVirtualActionListener(){

            @Override
            public void onDelete() {
                if (VirtualWallLayout.this.offset > 0) {
                    VirtualWallLayout.this.offset--;
                }
                VirtualWallLayout.this.virtualWallViewList.remove(virtualWallView);
                VirtualWallLayout.this.removeView((View)virtualWallView);
                VirtualWallLayout.this.requestLayout();
            }

            @Override
            public void onEdit(VirtualWallView view) {
                int position = VirtualWallLayout.this.virtualWallViewList.indexOf(view);
                view.setEdit(true, true);
                view.bringToFront();
                int size = VirtualWallLayout.this.virtualWallViewList.size();
                for (int i = 0; i < size; ++i) {
                    VirtualWallView item = (VirtualWallView)VirtualWallLayout.this.virtualWallViewList.get(i);
                    if (item == null || position == i) continue;
                    item.setEdit(false, true);
                }
            }
        });
        return virtualWallView;
    }

    public List<List<PointF>> getPointInfo() {
        ArrayList<List<PointF>> pointList = new ArrayList<List<PointF>>();
        for (VirtualWallView virtualWallView : this.virtualWallViewList) {
            pointList.add(virtualWallView.getStartAndEndPoint());
        }
        return pointList;
    }

    public MapTypeAreaBean getVirtualWallInfo() {
        MapTypeAreaBean mapTypeAreaBean = new MapTypeAreaBean();
        mapTypeAreaBean.setType(4);
        ArrayList<MapTypeAreaBean.DataBean> list = new ArrayList<MapTypeAreaBean.DataBean>();
        for (VirtualWallView virtualWallView : this.virtualWallViewList) {
            MapTypeAreaBean.DataBean dataBean = new MapTypeAreaBean.DataBean();
            dataBean.setId(virtualWallView.getMapAreaData().getId());
            dataBean.setExtend(virtualWallView.getMapAreaData().getExtend());
            dataBean.setPoints(virtualWallView.getMapAreaData().getPoints());
            list.add(dataBean);
        }
        mapTypeAreaBean.setData(list);
        return mapTypeAreaBean;
    }

    public void removeAllWall() {
        if (this.virtualWallViewList.isEmpty()) {
            return;
        }
        this.virtualWallViewList.clear();
        this.removeAllViews();
        this.requestLayout();
    }

    public void reset(Matrix matrix) {
        for (VirtualWallView virtualWallView : this.virtualWallViewList) {
            virtualWallView.reset(matrix);
        }
    }
}

