/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.reactnativesweeper.view.sweepercommon.sticker;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.Pair;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.appcompat.widget.AppCompatImageView;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.events.RCTEventEmitter;
import com.tuya.reactnativesweeper.anim.MatrixAnimator;
import com.tuya.reactnativesweeper.bean.MapAreaData;
import com.tuya.reactnativesweeper.bean.MapPointsData;
import com.tuya.reactnativesweeper.manager.SweeperMapStateManager;
import com.tuya.reactnativesweeper.util.RNComponentUtil;
import com.tuya.reactnativesweeper.view.sweepercommon.SweeperUtil;
import com.tuya.reactnativesweeper.view.sweepercommon.sticker.ActionIcon;
import com.tuya.reactnativesweeper.view.sweepercommon.sticker.OnStickerActionListener;
import com.tuya.reactnativesweeper.view.sweepercommon.sticker.Sticker;
import com.tuya.reactnativesweeper.view.sweepercommon.sticker.StickerUtils;
import com.tuya.smart.android.common.utils.L;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class StickerView
extends AppCompatImageView
implements SweeperMapStateManager.SweeperStateListener {
    private static final String TAG = "StickerView";
    private static float MIN_WIDTH = 10.0f;
    private static float MIN_HEIGHT = 10.0f;
    private Sticker sticker;
    private Matrix downMatrix = new Matrix();
    private Matrix moveMatrix = new Matrix();
    private Matrix mMatrix = new Matrix();
    private PointF leftTopPoint = new PointF();
    private int mode;
    private boolean isEdit;
    private boolean renameEnable = false;
    private OnStickerActionListener listener;
    float preScale = 1.0f;
    private float downX;
    private float downY;
    private float oldMoveLocationX;
    private float oldMoveLocationY;
    private ActionIcon rightBottomIcon;
    private ActionIcon rightTopIcon;
    private ActionIcon leftTopIcon;
    private ActionIcon leftBottomIcon;
    private boolean downInSticker;
    private int type;
    private HashMap<String, Object> zoomFactor;
    private float factor;
    private Paint areaSizePaint;
    private Context context;
    private boolean isMainMap = true;
    private int angle;
    private int initAngle;
    private Path mPath;
    private int viewManagerId;
    private List<PointF> pointFList;
    private boolean isDefault;
    private String mapId;
    private ActionIcon centerIcon;
    private MapAreaData mapAreaData;
    private OnLongClickCenterListener onLongClickCenterListener;
    private Runnable longClickRunnable;

    public void setOnStickerActionListener(OnStickerActionListener listener) {
        this.listener = listener;
    }

    public StickerView(Context context) {
        this(context, null);
    }

    public StickerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public StickerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.context = context;
        this.init();
    }

    private void init() {
        this.setScaleType(ImageView.ScaleType.MATRIX);
        this.sticker = new Sticker();
        SweeperMapStateManager.getInstance().registerStateListener(this);
        this.mPath = new Path();
        if (SweeperMapStateManager.getInstance().getMinAreaWidth() > 0.0f) {
            MIN_WIDTH = MIN_HEIGHT = SweeperMapStateManager.getInstance().getMinAreaWidth();
        }
        this.longClickRunnable = new Runnable(){

            @Override
            public void run() {
                if (StickerView.this.onLongClickCenterListener != null) {
                    StickerView.this.onLongClickCenterListener.onCenterClick(StickerView.this);
                }
            }
        };
    }

    public void postTranslate(float xDiff, float yDiff) {
        this.sticker.getMatrix().postTranslate(xDiff, yDiff);
        this.mMatrix.reset();
        this.mMatrix.postTranslate(xDiff, yDiff);
        this.sticker.updatePoints(this.mMatrix);
        this.invalidate();
    }

    public void postScale(float scale, PointF pointF) {
        this.sticker.getMatrix().postScale(scale / this.preScale, scale / this.preScale, pointF.x, pointF.y);
        this.mMatrix.reset();
        this.mMatrix.postScale(scale / this.preScale, scale / this.preScale, pointF.x, pointF.y);
        this.sticker.updatePoints(this.mMatrix);
        this.invalidate();
        this.preScale = scale;
    }

    private Paint getAreaSizePaint() {
        if (this.areaSizePaint != null) {
            return this.areaSizePaint;
        }
        this.areaSizePaint = new Paint();
        if (this.zoomFactor.containsKey("color")) {
            this.areaSizePaint.setColor(Color.parseColor((String)((String)this.zoomFactor.get("color"))));
        } else {
            this.areaSizePaint.setColor(-1);
        }
        if (this.zoomFactor.containsKey("font")) {
            double fontSize = (Double)this.zoomFactor.get("font");
            this.areaSizePaint.setTextSize((float)SweeperUtil.dip2px(this.context, (int)fontSize));
            this.areaSizePaint.setTextAlign(Paint.Align.CENTER);
        } else {
            this.areaSizePaint.setTextSize(18.0f);
            this.areaSizePaint.setTextAlign(Paint.Align.CENTER);
        }
        this.areaSizePaint.setStrokeWidth(3.0f);
        return this.areaSizePaint;
    }

    public void setOnLongClickCenterListener(OnLongClickCenterListener listener) {
        this.onLongClickCenterListener = listener;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
    }

    public boolean hasZoom() {
        return null != this.zoomFactor && this.zoomFactor.containsKey("factor") && (Double)this.zoomFactor.get("factor") > 0.0;
    }

    public void reset(Matrix sMatrix) {
        if (this.pointFList == null) {
            L.e((String)TAG, (String)"data error");
            return;
        }
        final ArrayList<PointF> originPointList = new ArrayList<PointF>();
        for (PointF pointF : this.sticker.getCurrentPointList()) {
            originPointList.add(this.getInvertPoint(pointF));
        }
        Matrix endMatrix = new Matrix();
        endMatrix.set(this.sticker.getMatrix());
        endMatrix.postConcat(sMatrix);
        MatrixAnimator matrixAnimator = new MatrixAnimator(this.sticker.getMatrix(), endMatrix);
        matrixAnimator.setListener(new MatrixAnimator.AnimationListener(){

            @Override
            public void onAnimationUpdate(Matrix matrix) {
                StickerView.this.sticker.setMatrix(matrix);
                StickerView.this.sticker.updatePoints(matrix, originPointList);
                StickerView.this.invalidate();
            }

            @Override
            public void onAnimationEnd() {
                StickerView.this.preScale = 1.0f;
            }
        });
        matrixAnimator.start();
    }

    protected void onDraw(Canvas canvas) {
        if (this.sticker == null) {
            return;
        }
        this.sticker.draw(canvas);
        PointF rightTopPoint = this.sticker.getRightTopPoint();
        PointF rightBottomPoint = this.sticker.getRightBottomPoint();
        PointF leftTopPoint = this.sticker.getLeftTopPoint();
        PointF leftBottomPoint = this.sticker.getLeftBottomPoint();
        if (this.isEdit) {
            if (null != this.rightTopIcon) {
                this.rightTopIcon.draw(canvas, rightTopPoint.x, rightTopPoint.y);
            }
            if (null != this.rightBottomIcon) {
                this.rightBottomIcon.draw(canvas, rightBottomPoint.x, rightBottomPoint.y);
            }
            if (null != this.leftTopIcon) {
                this.leftTopIcon.draw(canvas, leftTopPoint.x, leftTopPoint.y);
            }
            if (null != this.leftBottomIcon && this.renameEnable) {
                this.leftBottomIcon.draw(canvas, leftBottomPoint.x, leftBottomPoint.y);
            }
        }
        this.drawText(canvas);
        if (this.isDefault && this.type == 3) {
            this.isDefault = false;
            this.sendPointToRN();
        }
    }

    private void drawText(Canvas canvas) {
        if (SweeperMapStateManager.getInstance().getState(this.mapId) == this.type && this.hasZoom() && SweeperMapStateManager.getInstance().isEdit(this.mapId)) {
            BigDecimal bigDecimal = new BigDecimal((Double)this.zoomFactor.get("factor"));
            this.factor = bigDecimal.floatValue();
            this.mPath.reset();
            String realSize = this.getRealSize(this.getDistanceInMap(this.sticker.getLeftTopPoint(), this.sticker.getRightTopPoint())) + "m x " + this.getRealSize(this.getDistanceInMap(this.sticker.getRightTopPoint(), this.sticker.getRightBottomPoint())) + "m";
            PointF originCenter = new PointF((this.sticker.getLeftBottomPoint().x + this.sticker.getRightBottomPoint().x) / 2.0f, (this.sticker.getLeftBottomPoint().y + this.sticker.getRightBottomPoint().y) / 2.0f);
            int degrees = 0;
            canvas.save();
            if (this.sticker.getLeftBottomPoint().x != this.sticker.getRightBottomPoint().x) {
                double tan = (this.sticker.getLeftBottomPoint().y - this.sticker.getRightBottomPoint().y) / (this.sticker.getLeftBottomPoint().x - this.sticker.getRightBottomPoint().x);
                degrees = (int)Math.toDegrees(Math.atan(tan));
            } else {
                degrees = this.sticker.getLeftBottomPoint().y > this.sticker.getRightBottomPoint().y ? 90 : 270;
            }
            canvas.translate(originCenter.x, originCenter.y);
            canvas.rotate((float)(degrees %= 360));
            if (this.sticker.getLeftBottomPoint().x > this.sticker.getRightBottomPoint().x) {
                canvas.translate(0.0f, -40.0f);
            } else {
                canvas.translate(0.0f, 40.0f);
            }
            canvas.drawText(realSize, 0.0f, 0.0f, this.getAreaSizePaint());
            canvas.restore();
        }
    }

    public float getScaleX(Matrix matrix) {
        if (null == matrix) {
            return 1.0f;
        }
        float[] values = new float[9];
        matrix.getValues(values);
        return values[0];
    }

    public float getScaleY(Matrix matrix) {
        if (null == matrix) {
            return 1.0f;
        }
        float[] values = new float[9];
        matrix.getValues(values);
        return values[4];
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!SweeperMapStateManager.getInstance().isEdit(this.mapId)) {
            return false;
        }
        if (SweeperMapStateManager.getInstance().getState(this.mapId) != this.mapAreaData.getType()) {
            return false;
        }
        int action = event.getActionMasked();
        boolean isStickerOnEdit = true;
        this.downInSticker = false;
        switch (action) {
            case 0: {
                this.downX = event.getX();
                this.downY = event.getY();
                if (this.sticker == null) {
                    return false;
                }
                if (null != this.rightTopIcon && this.rightTopIcon.isInActionCheck(event) && this.isEdit) {
                    if (this.listener != null) {
                        this.listener.onRightTopClick(this);
                    }
                    this.mode = 0;
                    break;
                }
                if (null != this.rightBottomIcon && this.rightBottomIcon.isInActionCheck(event) && this.isEdit) {
                    this.mode = 2;
                    this.downMatrix.set(this.sticker.getMatrix());
                    this.leftTopPoint = this.sticker.getLeftTopPoint();
                    break;
                }
                if (this.isInStickerArea(this.sticker, event)) {
                    this.downInSticker = true;
                    this.mode = 1;
                    this.downMatrix.set(this.sticker.getMatrix());
                    this.listener.onFocus(this);
                    this.postDelayed(this.longClickRunnable, ViewConfiguration.getLongPressTimeout() + 500);
                    break;
                }
                if (null != this.leftTopIcon && this.leftTopIcon.isInActionCheck(event) && this.isEdit) {
                    this.mode = 3;
                    this.downMatrix.set(this.sticker.getMatrix());
                    this.oldMoveLocationX = event.getX();
                    this.oldMoveLocationY = event.getY();
                    this.angle = 0;
                    break;
                }
                if (null != this.leftBottomIcon && this.leftBottomIcon.isInActionCheck(event) && this.isEdit) {
                    this.mode = 4;
                    break;
                }
                isStickerOnEdit = false;
                break;
            }
            case 2: {
                int lastX = (int)event.getX();
                int lastY = (int)event.getY();
                if (Math.abs((float)lastX - this.downX) > 0.0f || Math.abs((float)lastY - this.downY) > 0.0f) {
                    this.removeCallbacks(this.longClickRunnable);
                }
                if (this.mode == 2) {
                    this.moveMatrix.set(this.downMatrix);
                    PointF[] pointFS = this.getScalePoint(this.leftTopPoint, new PointF(event.getX(), event.getY()));
                    PointF leftBottom = pointFS[0];
                    PointF rightTop = pointFS[1];
                    ArrayList<PointF> list = new ArrayList<PointF>();
                    list.add(this.leftTopPoint);
                    list.add(rightTop);
                    list.add(new PointF(event.getX(), event.getY()));
                    list.add(leftBottom);
                    if (!this.checkWidthHeightLimit(list) || this.isRectChanged(list)) break;
                    this.sticker.updatePointList(list);
                    this.invalidate();
                    break;
                }
                if (this.mode == 1) {
                    this.moveMatrix.set(this.downMatrix);
                    this.moveMatrix.postTranslate(event.getX() - this.downX, event.getY() - this.downY);
                    this.mMatrix.reset();
                    this.mMatrix.postTranslate(event.getX() - this.downX, event.getY() - this.downY);
                    this.sticker.getMatrix().set(this.moveMatrix);
                    this.sticker.updatePoints(this.mMatrix);
                    this.invalidate();
                    this.downX = event.getX();
                    this.downY = event.getY();
                    break;
                }
                if (this.mode != 3) break;
                this.moveMatrix.set(this.downMatrix);
                PointF rotatePoint = new PointF((float)((int)event.getX()), (float)((int)event.getY()));
                PointF centerPoint = this.getCenterPoint();
                PointF initPoint = new PointF(this.oldMoveLocationX, this.oldMoveLocationY);
                this.initAngle = (int)this.sticker.calRotateAngle(centerPoint, initPoint, rotatePoint);
                this.angle += this.initAngle;
                L.d((String)TAG, (String)("angle:" + this.angle + "  initAngle:" + this.initAngle));
                if (this.angle > 360) {
                    this.angle -= 360;
                } else if (this.angle < -360) {
                    this.angle += 360;
                }
                if (this.initAngle == 0) break;
                this.moveMatrix.postRotate((float)this.angle, centerPoint.x, centerPoint.y);
                this.sticker.getMatrix().set(this.moveMatrix);
                this.mMatrix.reset();
                this.mMatrix.setRotate((float)this.initAngle, centerPoint.x, centerPoint.y);
                this.sticker.updatePoints(this.mMatrix);
                this.sticker.setRotate(this.initAngle);
                this.invalidate();
                this.oldMoveLocationX = event.getX();
                this.oldMoveLocationY = event.getY();
                break;
            }
            case 1: 
            case 6: {
                if (this.mode == 4 && this.onLongClickCenterListener != null) {
                    this.onLongClickCenterListener.onCenterClick(this);
                }
                this.mode = 0;
                this.removeCallbacks(this.longClickRunnable);
                this.leftTopPoint = null;
                this.sendPointToRN();
                break;
            }
        }
        if (this.downInSticker && this.listener != null) {
            this.listener.onCenterClick(this);
        }
        return isStickerOnEdit;
    }

    private void sendPointToRN() {
        if (this.context instanceof ThemedReactContext && this.type == 3 && this.isEdit) {
            MapPointsData<PointF> typePointData = new MapPointsData<PointF>();
            typePointData.setData(this.getPointInfo());
            typePointData.setType(this.type);
            WritableMap writableMap = RNComponentUtil.parseToWritableMap(typePointData);
            if (this.viewManagerId != 0) {
                ((RCTEventEmitter)((ThemedReactContext)this.context).getJSModule(RCTEventEmitter.class)).receiveEvent(this.viewManagerId, "onLaserMapPoints", writableMap);
            }
        }
    }

    public void sendDialogEventToRN(Context context) {
        if (context instanceof ThemedReactContext) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", this.mapAreaData.getId());
            WritableMap writableMap = RNComponentUtil.parseToWritableMap(map);
            ((RCTEventEmitter)((ThemedReactContext)context).getJSModule(RCTEventEmitter.class)).receiveEvent(this.viewManagerId, "onLongPressInAreaView", writableMap);
            L.d((String)TAG, (String)("sendDialogEventToRN id:" + this.mapAreaData.getId()));
        }
    }

    public boolean performClick() {
        return super.performClick();
    }

    private Pair<Float, Float> getScaleP(List<PointF> initPointList, PointF currentRightBottom) {
        Matrix invertMatrix = new Matrix();
        this.sticker.getMatrix().invert(invertMatrix);
        float[] originPointArr = new float[6];
        invertMatrix.mapPoints(originPointArr, new float[]{initPointList.get((int)1).y, initPointList.get((int)2).x, initPointList.get((int)2).y, initPointList.get((int)3).x, currentRightBottom.x, currentRightBottom.y});
        float initDistanceX = Math.abs(originPointArr[3] - originPointArr[1]);
        float initDistanceY = Math.abs(originPointArr[0] - originPointArr[2]);
        float currentDistanceX = Math.abs(originPointArr[4] - originPointArr[3]);
        float currentDistanceY = Math.abs(originPointArr[5] - originPointArr[0]);
        float scaleX = currentDistanceX / initDistanceX;
        float scaleY = currentDistanceY / initDistanceY;
        return new Pair((Object)Float.valueOf(scaleX), (Object)Float.valueOf(scaleY));
    }

    private PointF[] getScalePoint(PointF leftTopPoint, PointF rightBottomPoint) {
        Matrix invertMatrix = new Matrix();
        this.sticker.getMatrix().invert(invertMatrix);
        float[] alreadyKnowPoint = new float[4];
        invertMatrix.mapPoints(alreadyKnowPoint, new float[]{leftTopPoint.x, leftTopPoint.y, rightBottomPoint.x, rightBottomPoint.y});
        PointF originLeftBottom = new PointF();
        originLeftBottom.x = alreadyKnowPoint[0];
        originLeftBottom.y = alreadyKnowPoint[3];
        PointF originRightTop = new PointF();
        originRightTop.x = alreadyKnowPoint[2];
        originRightTop.y = alreadyKnowPoint[1];
        float[] newCurrentPoint = new float[4];
        this.sticker.getMatrix().mapPoints(newCurrentPoint, new float[]{originLeftBottom.x, originLeftBottom.y, originRightTop.x, originRightTop.y});
        PointF leftBottom = new PointF();
        leftBottom.x = newCurrentPoint[0];
        leftBottom.y = newCurrentPoint[1];
        PointF rightTopPoint = new PointF();
        rightTopPoint.x = newCurrentPoint[2];
        rightTopPoint.y = newCurrentPoint[3];
        PointF[] pointFS = new PointF[]{leftBottom, rightTopPoint};
        return pointFS;
    }

    public boolean isFocused() {
        return true;
    }

    public PointF getInvertPoint(PointF pointF) {
        Matrix invertMatrix = new Matrix();
        this.sticker.getMatrix().invert(invertMatrix);
        float[] pointArr = new float[2];
        invertMatrix.mapPoints(pointArr, new float[]{pointF.x, pointF.y});
        return new PointF(pointArr[0], pointArr[1]);
    }

    public PointF getCurrentPoint(PointF pointF) {
        float[] pointArr = new float[2];
        this.sticker.getMatrix().mapPoints(pointArr, new float[]{pointF.x, pointF.y});
        return new PointF(pointArr[0], pointArr[1]);
    }

    private boolean isRectChanged(List<PointF> list) {
        Matrix invertMatrix = new Matrix();
        this.sticker.getMatrix().invert(invertMatrix);
        float[] inverPoint = new float[4];
        invertMatrix.mapPoints(inverPoint, new float[]{list.get((int)0).x, list.get((int)0).y, list.get((int)2).x, list.get((int)2).y});
        return !(inverPoint[2] > inverPoint[0]) || !(inverPoint[3] > inverPoint[1]);
    }

    private boolean isMove(float oldMoveLocationX, float oldMoveLocationY, MotionEvent event) {
        return Math.abs(event.getRawX() - oldMoveLocationX) > 10.0f || Math.abs(event.getRawY() - oldMoveLocationY) > 10.0f;
    }

    private PointF getCenterPoint() {
        float centerX = (this.sticker.getLeftTopPoint().x + this.sticker.getRightBottomPoint().x) / 2.0f;
        float centerY = (this.sticker.getLeftTopPoint().y + this.sticker.getRightBottomPoint().y) / 2.0f;
        return new PointF(centerX, centerY);
    }

    private boolean isInStickerArea(Sticker sticker, MotionEvent event) {
        RectF dst = sticker.getBound();
        return dst.contains(event.getX(), event.getY());
    }

    private boolean checkWidthHeightLimit(Matrix matrix) {
        Pair<Float, Float> widthAndHeight = this.sticker.getWidthAndHeight(matrix);
        return ((Float)widthAndHeight.first).floatValue() > MIN_WIDTH && ((Float)widthAndHeight.second).floatValue() > MIN_HEIGHT;
    }

    private boolean checkWidthHeightLimit(List<PointF> list) {
        float side1 = this.getRealFloatSize(this.getDistanceInMap(list.get(0), list.get(1)));
        float side2 = this.getRealFloatSize(this.getDistanceInMap(list.get(1), list.get(2)));
        float minWidth = MIN_WIDTH * this.factor;
        L.i((String)"StickerViewTag", (String)("MIN_WIDTH:" + MIN_WIDTH + ",factor:" + this.factor + "side1:" + side1 + "----side2:" + side2));
        return side1 >= minWidth && side2 >= minWidth;
    }

    public void setEdit(boolean edit) {
        this.isEdit = edit;
        this.postInvalidate();
    }

    public List<PointF> getPointInfo() {
        ArrayList<PointF> pointList = new ArrayList<PointF>();
        pointList.add(this.sticker.getLeftTopPoint());
        pointList.add(this.sticker.getRightTopPoint());
        pointList.add(this.sticker.getRightBottomPoint());
        pointList.add(this.sticker.getLeftBottomPoint());
        return pointList;
    }

    private float getDistanceInMap(PointF pointF, PointF pointF1) {
        PointF newPoint = SweeperMapStateManager.getInstance().getXYInMap(this.mapId, pointF);
        PointF newPoint1 = SweeperMapStateManager.getInstance().getXYInMap(this.mapId, pointF1);
        return (float)Math.sqrt(Math.pow(newPoint.x - newPoint1.x, 2.0) + Math.pow(newPoint.y - newPoint1.y, 2.0));
    }

    private float getHeightInMap(PointF bottomPointF, PointF topPointF) {
        return SweeperMapStateManager.getInstance().getXYInMap((String)this.mapId, (PointF)bottomPointF).y - SweeperMapStateManager.getInstance().getXYInMap((String)this.mapId, (PointF)topPointF).y;
    }

    private String getRealSize(float lengthOnScreen) {
        DecimalFormat decimalFormat = new DecimalFormat("0.0");
        float value = lengthOnScreen * this.factor;
        return decimalFormat.format(value);
    }

    private float getRealFloatSize(float lengthOnScreen) {
        return lengthOnScreen * this.factor;
    }

    public Sticker getSticker() {
        return this.sticker;
    }

    public void setViewManagerId(int id) {
        this.viewManagerId = id;
    }

    public static Builder newBuilder(Context context) {
        return new Builder(context);
    }

    @Override
    public void onStateChanged(String mapId, int state) {
        if (this.mapId != null && this.mapId.equals(mapId)) {
            if (state == 0) {
                this.isEdit = false;
            } else if (!SweeperMapStateManager.getInstance().isEdit(mapId)) {
                this.isEdit = false;
            }
            this.postInvalidate();
        }
    }

    public MapAreaData getMapAreaData() {
        this.mapAreaData.setPoints(this.getPointInfo());
        return this.mapAreaData;
    }

    public void setMapAreaData(MapAreaData mapAreaData) {
        this.mapAreaData = mapAreaData;
        StickerUtils.buildAreaView(this.mapAreaData, this);
        this.postInvalidate();
    }

    public void setRightBottomIcon(ActionIcon rightBottomIcon) {
        this.rightBottomIcon = rightBottomIcon;
    }

    public void setRightTopIcon(ActionIcon rightTopIcon) {
        this.rightTopIcon = rightTopIcon;
    }

    public void setLeftBottomIcon(ActionIcon leftBottomIcon) {
        this.leftBottomIcon = leftBottomIcon;
    }

    public void setCenterIcon(ActionIcon centerIcon) {
        this.centerIcon = centerIcon;
    }

    public ActionIcon getCenterIcon() {
        return this.centerIcon;
    }

    public boolean isRenameEnable() {
        return this.renameEnable;
    }

    public void setRenameEnable(boolean renameEnable) {
        this.renameEnable = renameEnable;
    }

    public void setAreaName(String o) {
        this.sticker.setContent(o);
        this.postInvalidate();
    }

    public static class Builder {
        private StickerView stickerView;

        private Builder(Context context) {
            this.stickerView = new StickerView(context);
        }

        public Builder edit(boolean edit) {
            this.stickerView.isEdit = edit;
            return this;
        }

        public Builder isRenameEnable(boolean enable) {
            this.stickerView.renameEnable = enable;
            return this;
        }

        public Builder layoutParams(FrameLayout.LayoutParams layoutParams) {
            this.stickerView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            return this;
        }

        public Builder preScale(float scale) {
            this.stickerView.preScale = scale;
            return this;
        }

        public Builder type(int type) {
            this.stickerView.type = type;
            return this;
        }

        public Builder rightBottomIcon(ActionIcon rightBottomIcon) {
            this.stickerView.rightBottomIcon = rightBottomIcon;
            return this;
        }

        public Builder rightTopIcon(ActionIcon rightTopIcon) {
            this.stickerView.rightTopIcon = rightTopIcon;
            return this;
        }

        public Builder leftTopIcon(ActionIcon leftTopIcon) {
            this.stickerView.leftTopIcon = leftTopIcon;
            return this;
        }

        public Builder leftBottomIcon(ActionIcon leftBottomIcon) {
            this.stickerView.leftBottomIcon = leftBottomIcon;
            return this;
        }

        public Builder color(String color) {
            this.stickerView.sticker.setContentColor(color);
            return this;
        }

        public Builder points(List<PointF> pointList) {
            this.stickerView.sticker.setPointList(pointList);
            this.stickerView.pointFList = pointList;
            return this;
        }

        public Builder zoomFactor(HashMap<String, Object> zoomFactor) {
            this.stickerView.zoomFactor = zoomFactor;
            return this;
        }

        public Builder isMainMap(boolean isMainMap) {
            this.stickerView.isMainMap = isMainMap;
            return this;
        }

        public Builder viewManagerId(int id) {
            this.stickerView.viewManagerId = id;
            return this;
        }

        public Builder data(MapAreaData data) {
            this.stickerView.setMapAreaData(data);
            return this;
        }

        public Builder mapId(String mapId) {
            this.stickerView.mapId = mapId;
            return this;
        }

        public Builder isDefault(boolean isDefault) {
            this.stickerView.isDefault = isDefault;
            return this;
        }

        public StickerView build() {
            return this.stickerView;
        }
    }

    public static interface OnLongClickCenterListener {
        public void onCenterClick(StickerView var1);
    }
}

