/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.reactnativesweeper.view.sweepercommon.sticker;

import android.text.TextUtils;
import com.tuya.react_sweeper_common.R;
import com.tuya.reactnativesweeper.bean.MapAreaBoxBean;
import com.tuya.reactnativesweeper.bean.MapAreaContentBean;
import com.tuya.reactnativesweeper.bean.MapAreaData;
import com.tuya.reactnativesweeper.util.BitmapUtil;
import com.tuya.reactnativesweeper.view.sweepercommon.sticker.ActionIcon;
import com.tuya.reactnativesweeper.view.sweepercommon.sticker.Sticker;
import com.tuya.reactnativesweeper.view.sweepercommon.sticker.StickerView;

public class StickerUtils {
    private static final String DEFAULT_SWEEP_COLOR = "#3DFFFFFF";
    private static final String DEFAULT_VIRTUAL_COLOR = "#80F53D23";

    public static void buildAreaView(MapAreaData data, StickerView stickerView) {
        StickerUtils.buildEditView(data, stickerView);
    }

    private static void buildEditView(MapAreaData data, StickerView stickerView) {
        ActionIcon rightTopIcon = new ActionIcon(stickerView.getContext());
        rightTopIcon.setSrcIcon(R.drawable.panel_sticker_remove);
        stickerView.setRightTopIcon(rightTopIcon);
        ActionIcon rightBottomIcon = new ActionIcon(stickerView.getContext());
        rightBottomIcon.setSrcIcon(R.drawable.panel_sticker_resize);
        stickerView.setRightBottomIcon(rightBottomIcon);
        stickerView.getSticker().setPointList(data.getPoints());
        StickerUtils.buildBox(data.getType(), data.getBox(), stickerView.getSticker());
        StickerUtils.buildContent(data.getContent(), stickerView.getSticker());
    }

    private static void buildActiveView(MapAreaData data, StickerView stickerView) {
        ActionIcon centerIcon = new ActionIcon(stickerView.getContext());
        centerIcon.setSrcIcon(R.drawable.panel_sticker_acitve);
        stickerView.setCenterIcon(centerIcon);
        ActionIcon rightTopIcon = new ActionIcon(stickerView.getContext());
        rightTopIcon.setSrcIcon(BitmapUtil.getBitmap(stickerView.getContext().getResources(), R.drawable.panel_action_icon_bg));
        stickerView.setRightTopIcon(rightTopIcon);
        stickerView.getSticker().setPointList(data.getPoints());
        StickerUtils.buildBox(data.getType(), data.getBox(), stickerView.getSticker());
        StickerUtils.buildContent(data.getContent(), stickerView.getSticker());
    }

    private static void buildEditAndActiveIcon(MapAreaData data, StickerView stickerView) {
        ActionIcon rightTopIcon = new ActionIcon(stickerView.getContext());
        rightTopIcon.setSrcIcon(R.drawable.panel_sticker_remove);
        stickerView.setRightTopIcon(rightTopIcon);
        ActionIcon rightBottomIcon = new ActionIcon(stickerView.getContext());
        rightBottomIcon.setSrcIcon(R.drawable.panel_sticker_resize);
        stickerView.setRightBottomIcon(rightBottomIcon);
        ActionIcon centerIcon = new ActionIcon(stickerView.getContext());
        centerIcon.setSrcIcon(R.drawable.panel_sticker_acitve);
        stickerView.setCenterIcon(centerIcon);
        stickerView.getSticker().setPointList(data.getPoints());
        StickerUtils.buildBox(data.getType(), data.getBox(), stickerView.getSticker());
        StickerUtils.buildContent(data.getContent(), stickerView.getSticker());
    }

    private static void buildBox(int type, MapAreaBoxBean box, Sticker sticker) {
        String bgColor = "";
        String borderColor = "#FFFFFF";
        String string = bgColor = type == 3 ? DEFAULT_VIRTUAL_COLOR : DEFAULT_SWEEP_COLOR;
        if (null != box && !TextUtils.isEmpty((CharSequence)box.getBorderColor())) {
            borderColor = box.getBorderColor();
        }
        if (null != box && !TextUtils.isEmpty((CharSequence)box.getBgColor())) {
            bgColor = box.getBgColor();
        }
        sticker.setBoxColor(bgColor, borderColor);
    }

    private static void buildContent(MapAreaContentBean contentBean, Sticker sticker) {
        String contentTxt = "";
        String contentTxtColor = "#000000";
        int contentTxtSize = 12;
        if (null != contentBean && !TextUtils.isEmpty((CharSequence)contentBean.getTextColor())) {
            contentTxtColor = contentBean.getTextColor();
        }
        if (null != contentBean && !TextUtils.isEmpty((CharSequence)contentBean.getText())) {
            contentTxt = contentBean.getText();
        }
        if (null != contentBean && contentBean.getTextSize() > 0) {
            contentTxtSize = contentBean.getTextSize();
        }
        sticker.setContent(contentTxt, contentTxtColor, contentTxtSize);
    }
}

