/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.reactnativesweeper.view.sweepercommon.sticker;

import android.content.Context;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.MotionEvent;
import android.view.View;
import android.widget.FrameLayout;
import com.tuya.react_sweeper_common.R;
import com.tuya.reactnativesweeper.bean.MapAreaBoxBean;
import com.tuya.reactnativesweeper.bean.MapAreaContentBean;
import com.tuya.reactnativesweeper.bean.MapAreaData;
import com.tuya.reactnativesweeper.bean.MapTypeAreaBean;
import com.tuya.reactnativesweeper.manager.SweeperMapStateManager;
import com.tuya.reactnativesweeper.util.CollectionUtils;
import com.tuya.reactnativesweeper.util.SizeUtils;
import com.tuya.reactnativesweeper.view.sweepercommon.MatrixView;
import com.tuya.reactnativesweeper.view.sweepercommon.sticker.ActionIcon;
import com.tuya.reactnativesweeper.view.sweepercommon.sticker.OnStickerActionListener;
import com.tuya.reactnativesweeper.view.sweepercommon.sticker.StickerView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StickerLayout
extends FrameLayout
implements MatrixView,
SweeperMapStateManager.SweeperStateListener {
    private static final int POINT_COUNT = 4;
    private static final int DEFAULT_SIZE = 140;
    private SparseArray<List<StickerView>> mStateStickerArray;
    private Context mContext;
    private Map<String, StickerView> mAreaViewMap;
    private String mapId;
    private int viewManagerId = 0;
    private int offset = 0;
    private PointF currentPoint;

    public StickerLayout(Context context) {
        this(context, null);
    }

    public StickerLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public StickerLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.mContext = context;
        this.mStateStickerArray = new SparseArray();
        this.mAreaViewMap = new HashMap<String, StickerView>();
        SweeperMapStateManager.getInstance().registerStateListener(this);
    }

    public PointF getCurrentPoint() {
        return this.currentPoint;
    }

    public void setCurrentPoint(PointF currentPoint) {
        this.currentPoint = currentPoint;
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.showPreview();
        return super.onTouchEvent(event);
    }

    @Override
    public void postTranslate(float xDiff, float yDiff) {
        for (int i = 0; i < this.mStateStickerArray.size(); ++i) {
            for (StickerView stickerView : (List)this.mStateStickerArray.valueAt(i)) {
                stickerView.postTranslate(xDiff, yDiff);
            }
        }
    }

    @Override
    public void postScale(float scale, PointF centerPoint) {
        for (int i = 0; i < this.mStateStickerArray.size(); ++i) {
            for (StickerView stickerView : (List)this.mStateStickerArray.valueAt(i)) {
                stickerView.postScale(scale, centerPoint);
            }
        }
    }

    public void setViewManagerId(int id) {
        this.viewManagerId = id;
    }

    public void setMapId(String mapId) {
        this.mapId = mapId;
    }

    public List<List<PointF>> getPointInfo(int type) {
        List stickerViewList = (List)this.mStateStickerArray.get(type);
        if (null == stickerViewList || stickerViewList.isEmpty()) {
            return null;
        }
        ArrayList<List<PointF>> pointList = new ArrayList<List<PointF>>();
        for (StickerView stickerView : stickerViewList) {
            pointList.add(stickerView.getPointInfo());
        }
        return pointList;
    }

    public void removeAllSticker(int type) {
        List stickerViewList = (List)this.mStateStickerArray.get(type);
        if (CollectionUtils.isEmpty(stickerViewList)) {
            return;
        }
        for (StickerView stickerView : stickerViewList) {
            this.removeView((View)stickerView);
        }
        this.mStateStickerArray.remove(type);
        this.requestLayout();
    }

    public void reset(Matrix matrix) {
        for (int i = 0; i < this.mStateStickerArray.size(); ++i) {
            for (StickerView stickerView : (List)this.mStateStickerArray.valueAt(i)) {
                stickerView.reset(matrix);
            }
        }
    }

    public MapTypeAreaBean getMapAreaInfo(int type) {
        MapTypeAreaBean mapTypeAreaBean = new MapTypeAreaBean();
        mapTypeAreaBean.setType(type);
        List stickerViewList = (List)this.mStateStickerArray.get(type);
        if (null == stickerViewList || stickerViewList.isEmpty()) {
            return mapTypeAreaBean;
        }
        ArrayList<MapTypeAreaBean.DataBean> dataBeans = new ArrayList<MapTypeAreaBean.DataBean>();
        for (StickerView stickerView : stickerViewList) {
            MapAreaData mapAreaData = stickerView.getMapAreaData();
            MapTypeAreaBean.DataBean dataBean = new MapTypeAreaBean.DataBean();
            dataBean.setId(mapAreaData.getId());
            dataBean.setPoints(stickerView.getPointInfo());
            dataBean.setExtend(mapAreaData.getExtend());
            MapTypeAreaBean.ContentBean contentBean = new MapTypeAreaBean.ContentBean();
            contentBean.setText(stickerView.getSticker().getContent());
            dataBean.setContent(contentBean);
            dataBeans.add(dataBean);
        }
        mapTypeAreaBean.setData(dataBeans);
        return mapTypeAreaBean;
    }

    public List<MapAreaData> getMapAreaDataList(int type) {
        ArrayList<MapAreaData> list = new ArrayList<MapAreaData>();
        List stickerViewList = (List)this.mStateStickerArray.get(type);
        if (null == stickerViewList || stickerViewList.isEmpty()) {
            return list;
        }
        for (StickerView stickerView : stickerViewList) {
            list.add(stickerView.getMapAreaData());
        }
        return list;
    }

    public void addSticker(String color, int state, float mapScale) {
        this.addArea(this.generateDefaultAreaData(state, color), mapScale, true, true);
    }

    public void addArea(MapAreaData mapAreaData, float mapScale, boolean isDefaultSticker) {
        this.addArea(mapAreaData, mapScale, isDefaultSticker, true);
    }

    public void addAreaList(List<MapAreaData> areaDataList, float mapScale, boolean isDefaultSticker) {
        if (areaDataList == null || areaDataList.size() == 0) {
            return;
        }
        for (MapAreaData mapAreaData : areaDataList) {
            this.addArea(mapAreaData, mapScale, isDefaultSticker, false);
        }
    }

    public void addArea(MapAreaData mapAreaData, float mapScale, boolean isDefaultSticker, boolean isEdit) {
        if (null == mapAreaData) {
            return;
        }
        if (CollectionUtils.isEmpty(mapAreaData.getPoints())) {
            List<PointF> defaultPointList = this.generatePointList();
            mapAreaData.setPoints(defaultPointList);
            this.addArea(mapAreaData, mapScale, isDefaultSticker, isEdit);
            return;
        }
        if (mapAreaData.getPoints().size() != 4) {
            return;
        }
        final int state = mapAreaData.getType();
        if (null == this.mStateStickerArray.get(state)) {
            this.mStateStickerArray.put(mapAreaData.getType(), new ArrayList());
        }
        final List stickerViewList = (List)this.mStateStickerArray.get(state);
        HashMap<String, Object> zoomFactor = SweeperMapStateManager.getInstance().getZoomFactor();
        ActionIcon rightTopIcon = new ActionIcon(this.getContext());
        rightTopIcon.setSrcIcon(R.drawable.panel_sticker_remove);
        ActionIcon rightBottomIcon = new ActionIcon(this.getContext());
        rightBottomIcon.setSrcIcon(R.drawable.panel_sticker_resize);
        ActionIcon leftBottomIcon = new ActionIcon(this.getContext());
        leftBottomIcon.setSrcIcon(R.drawable.sweeper_edit_name);
        ActionIcon leftTopIcon = null;
        if (state == 3 && SweeperMapStateManager.getInstance().isRotate()) {
            leftTopIcon = new ActionIcon(this.getContext());
            leftTopIcon.setSrcIcon(R.drawable.sweeper_rotate);
        }
        boolean isRenameEnable = false;
        if (mapAreaData.getContent() != null) {
            isRenameEnable = mapAreaData.getContent().isRenameEnable();
        }
        StickerView stickerView = StickerView.newBuilder(this.mContext).data(mapAreaData).edit(isEdit).isRenameEnable(isRenameEnable).preScale(mapScale).mapId(this.mapId).layoutParams(new FrameLayout.LayoutParams(-1, -1)).rightTopIcon(rightTopIcon).rightBottomIcon(rightBottomIcon).leftTopIcon(leftTopIcon).leftBottomIcon(leftBottomIcon).viewManagerId(this.viewManagerId).isDefault(isDefaultSticker).points(mapAreaData.getPoints()).type(state).zoomFactor(zoomFactor).build();
        if (!TextUtils.isEmpty((CharSequence)mapAreaData.getId())) {
            this.mAreaViewMap.put(mapAreaData.getId(), stickerView);
        }
        stickerView.setOnStickerActionListener(new OnStickerActionListener(){

            @Override
            public void onRightTopClick(StickerView view) {
                StickerLayout.this.removeViewRedraw(view, state);
                if (StickerLayout.this.offset > 0) {
                    StickerLayout.this.offset--;
                }
            }

            @Override
            public void onCenterClick(StickerView view) {
                int index = stickerViewList.indexOf(view);
                view.bringToFront();
                StickerLayout.this.redrawByIndex(index, state);
            }

            @Override
            public void onFocus(StickerView stickerView) {
                for (int i = 0; i < StickerLayout.this.mStateStickerArray.size(); ++i) {
                    for (StickerView view : (List)StickerLayout.this.mStateStickerArray.valueAt(i)) {
                        if (view == stickerView) continue;
                        view.setFocusable(false);
                        view.setFocusableInTouchMode(false);
                    }
                }
            }
        });
        stickerView.setOnLongClickCenterListener(new StickerView.OnLongClickCenterListener(){

            @Override
            public void onCenterClick(StickerView stickerView) {
                if (stickerView.isRenameEnable()) {
                    stickerView.sendDialogEventToRN(StickerLayout.this.mContext);
                }
            }
        });
        this.addViewRedraw(stickerView, state, isEdit);
    }

    private void addViewRedraw(StickerView stickerView, int state, boolean edit) {
        this.addView((View)stickerView);
        stickerView.requestLayout();
        List stickerViewList = (List)this.mStateStickerArray.get(state);
        if (null != stickerViewList) {
            stickerViewList.add(stickerView);
        }
        if (edit) {
            this.redraw(state);
        }
    }

    private void removeViewRedraw(StickerView stickerView, int state) {
        List stickerViewList = (List)this.mStateStickerArray.get(state);
        if (!CollectionUtils.isEmpty(stickerViewList)) {
            stickerViewList.remove(stickerView);
        }
        this.removeView((View)stickerView);
        MapAreaData mapAreaData = stickerView.getMapAreaData();
        if (null != mapAreaData && !TextUtils.isEmpty((CharSequence)mapAreaData.getId())) {
            this.mAreaViewMap.remove(mapAreaData.getId());
        }
    }

    private MapAreaData generateDefaultAreaData(int state, String color) {
        if (TextUtils.isEmpty((CharSequence)color)) {
            return null;
        }
        MapAreaBoxBean mapAreaBoxBean = new MapAreaBoxBean();
        mapAreaBoxBean.setBgColor(color);
        mapAreaBoxBean.setBorderColor("#FFFFFF");
        MapAreaContentBean mapAreaContentBean = new MapAreaContentBean();
        mapAreaContentBean.setTextSize(18);
        mapAreaContentBean.setTextColor("#DDDDDD");
        return new MapAreaData.Builder().box(mapAreaBoxBean).content(mapAreaContentBean).type(state).points(this.generatePointList()).build();
    }

    private List<PointF> generatePointList() {
        ArrayList<PointF> pointFList = new ArrayList<PointF>();
        if (this.currentPoint != null) {
            int bonds = (int)SizeUtils.dip2px(this.getContext(), 140.0f);
            float x = (float)(this.offset * 50) + this.currentPoint.x - (float)(bonds / 2);
            float y = (float)(this.offset * 50) + this.currentPoint.y - (float)(bonds / 2);
            pointFList.add(new PointF(x, y));
            pointFList.add(new PointF(x + (float)bonds, y));
            pointFList.add(new PointF(x + (float)bonds, y + (float)bonds));
            pointFList.add(new PointF(x, y + (float)bonds));
        } else {
            int bonds = (int)SizeUtils.dip2px(this.getContext(), 140.0f);
            int width = this.getWidth();
            int height = this.getHeight();
            float x = this.offset * 50 + (width - bonds) / 2;
            float y = this.offset * 50 + (height - bonds) / 2;
            pointFList.add(new PointF(x, y));
            pointFList.add(new PointF(x + (float)bonds, y));
            pointFList.add(new PointF(x + (float)bonds, y + (float)bonds));
            pointFList.add(new PointF(x, y + (float)bonds));
        }
        ++this.offset;
        return pointFList;
    }

    private void showPreview() {
        for (int i = 0; i < this.mStateStickerArray.size(); ++i) {
            for (StickerView stickerView : (List)this.mStateStickerArray.valueAt(i)) {
                stickerView.setEdit(false);
            }
        }
    }

    private void redraw(int state) {
        List stickerViewList = (List)this.mStateStickerArray.get(state);
        if (CollectionUtils.isEmpty(stickerViewList)) {
            return;
        }
        this.redrawByIndex(stickerViewList.size() - 1, state);
    }

    private void redrawByIndex(int index, int state) {
        List stickerViewList = (List)this.mStateStickerArray.get(state);
        if (CollectionUtils.isEmpty(stickerViewList)) {
            return;
        }
        int size = stickerViewList.size();
        for (int i = 0; i < size; ++i) {
            StickerView item = (StickerView)stickerViewList.get(i);
            if (index != i) {
                item.setEdit(false);
                continue;
            }
            item.setEdit(true);
        }
    }

    public void updateAreaInfo(MapAreaData mapAreaData) {
        if (null == mapAreaData || TextUtils.isEmpty((CharSequence)mapAreaData.getId())) {
            return;
        }
        StickerView stickerView = this.mAreaViewMap.get(mapAreaData.getId());
        if (null == stickerView) {
            return;
        }
        this.updateAreaData(stickerView.getMapAreaData(), mapAreaData);
        stickerView.setMapAreaData(stickerView.getMapAreaData());
    }

    private void updateAreaData(MapAreaData originData, MapAreaData newData) {
        if (newData.getContent() != null) {
            if (!TextUtils.isEmpty((CharSequence)newData.getContent().getText())) {
                originData.getContent().setText(newData.getContent().getText());
            }
            if (!TextUtils.isEmpty((CharSequence)newData.getContent().getTextColor())) {
                originData.getContent().setTextColor(newData.getContent().getTextColor());
            }
            if (newData.getContent().getTextSize() != 0) {
                originData.getContent().setTextSize(newData.getContent().getTextSize());
            }
        }
    }

    public void requestLayout() {
        super.requestLayout();
        this.reLayout();
    }

    public void reLayout() {
        if (this.getWidth() > 0 && this.getHeight() > 0) {
            int w = View.MeasureSpec.makeMeasureSpec((int)this.getWidth(), (int)0x40000000);
            int h = View.MeasureSpec.makeMeasureSpec((int)this.getHeight(), (int)0x40000000);
            this.measure(w, h);
            this.layout(this.getPaddingLeft() + this.getLeft(), this.getPaddingTop() + this.getTop(), this.getWidth() + this.getPaddingLeft() + this.getLeft(), this.getHeight() + this.getPaddingTop() + this.getTop());
        }
    }

    @Override
    public void onStateChanged(String mapId, int state) {
        this.offset = 0;
    }
}

