/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.reactnativesweeper.view.sweepercommon.sticker;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.DashPathEffect;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.text.TextUtils;
import android.util.Pair;
import android.view.MotionEvent;
import com.facebook.react.uimanager.PixelUtil;
import com.tuya.reactnativesweeper.util.CollectionUtils;
import com.tuya.smart.android.common.utils.L;
import java.util.ArrayList;
import java.util.List;

public class Sticker {
    private final String TAG = "Sticker";
    private static int TEXT_HEIGHT_SPACE = 10;
    private Matrix mMatrix = new Matrix();
    private List<PointF> mPointList;
    private Path mPath;
    private Path mNamePath;
    private String content;
    private Paint mBorderPaint = new Paint();
    private Paint mBgPaint;
    private Paint mContentPaint;
    private float originAngle;

    Sticker() {
        this.mBorderPaint.setAntiAlias(true);
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
        this.mBorderPaint.setColor(-1);
        this.mBorderPaint.setStrokeWidth(PixelUtil.toPixelFromDIP((float)1.0f));
        this.mBorderPaint.setPathEffect((PathEffect)new DashPathEffect(new float[]{10.0f, 5.0f, 10.0f, 5.0f}, 0.0f));
        this.mBgPaint = new Paint();
        this.mBgPaint.setAntiAlias(true);
        this.mBgPaint.setStyle(Paint.Style.FILL);
        this.mContentPaint = new Paint();
        this.mContentPaint.setAntiAlias(true);
        this.mContentPaint.setTextAlign(Paint.Align.CENTER);
    }

    void setPointList(List<PointF> pointFList) {
        this.mPointList = pointFList;
        if (CollectionUtils.isEmpty(this.mPointList)) {
            return;
        }
        this.mPath = new Path();
        for (int i = 0; i < this.mPointList.size(); ++i) {
            if (i == 0) {
                this.mPath.setLastPoint(this.mPointList.get((int)i).x, this.mPointList.get((int)i).y);
                continue;
            }
            this.mPath.lineTo(this.mPointList.get((int)i).x, this.mPointList.get((int)i).y);
        }
        this.mPath.close();
        if (this.isRotated(this.mPointList)) {
            this.initRotateRect();
        }
    }

    void updatePointList(List<PointF> pointFList) {
        this.mPointList = pointFList;
        if (CollectionUtils.isEmpty(this.mPointList)) {
            return;
        }
        this.mPath = new Path();
        for (int i = 0; i < this.mPointList.size(); ++i) {
            if (i == 0) {
                this.mPath.setLastPoint(this.mPointList.get((int)i).x, this.mPointList.get((int)i).y);
                continue;
            }
            this.mPath.lineTo(this.mPointList.get((int)i).x, this.mPointList.get((int)i).y);
        }
        this.mPath.close();
    }

    void setBoxColor(String bgColor, String borderColor) {
        this.mBgPaint.setColor(Color.parseColor((String)bgColor));
        this.mBorderPaint.setColor(Color.parseColor((String)borderColor));
    }

    void setContent(String content, String color, int size) {
        this.content = content;
        this.mContentPaint.setTextSize(PixelUtil.toPixelFromSP((float)size));
        this.mContentPaint.setColor(Color.parseColor((String)color));
    }

    String getContent() {
        return this.content;
    }

    void setContent(String content) {
        this.content = content;
    }

    private void initRotateRect() {
        PointF leftTopPoint = this.getUnRotatedLeftTopPoint();
        L.d((String)"Sticker", (String)("origin left:" + leftTopPoint.x + " y:" + leftTopPoint.y + "  now left x:" + this.mPointList.get((int)0).x + " y:" + this.mPointList.get((int)0).y));
        this.originAngle = this.calRotateAngle(this.getOriginCenterPoint(), leftTopPoint, this.mPointList.get(0));
        L.d((String)"Sticker", (String)("orgin angle:" + this.originAngle));
        this.mMatrix.setRotate(this.originAngle, this.getOriginCenterPoint().x, this.getOriginCenterPoint().y);
    }

    private PointF getOriginCenterPoint() {
        return new PointF((this.mPointList.get((int)0).x + this.mPointList.get((int)2).x) / 2.0f, (this.mPointList.get((int)0).y + this.mPointList.get((int)2).y) / 2.0f);
    }

    public List<PointF> getCurrentPointList() {
        return this.mPointList;
    }

    private boolean isRotated(List<PointF> mPointList) {
        return mPointList.get((int)1).y - mPointList.get((int)0).y != 0.0f || mPointList.get((int)0).x > mPointList.get((int)2).x && mPointList.get((int)0).y > mPointList.get((int)2).y;
    }

    private PointF getUnRotatedLeftTopPoint() {
        int acrossSide = (int)this.getDistance(this.mPointList.get(0), this.mPointList.get(1));
        int verticalSide = (int)this.getDistance(this.mPointList.get(1), this.mPointList.get(2));
        PointF centerPoint = this.getOriginCenterPoint();
        L.d((String)"Sticker", (String)("acrossSide:" + acrossSide + " verticalSide:" + verticalSide));
        L.d((String)"Sticker", (String)("center:" + centerPoint.x + " y:" + centerPoint.y));
        return new PointF(centerPoint.x - (float)(acrossSide / 2), centerPoint.y - (float)(verticalSide / 2));
    }

    void setContentColor(String color) {
        if (TextUtils.isEmpty((CharSequence)color)) {
            return;
        }
        this.mBgPaint.setColor(Color.parseColor((String)color));
    }

    void draw(Canvas canvas) {
        if (null == this.mPath) {
            return;
        }
        Path dst = new Path();
        dst.addPath(this.mPath);
        canvas.drawPath(dst, this.mBorderPaint);
        canvas.drawPath(dst, this.mBgPaint);
        if (!TextUtils.isEmpty((CharSequence)this.content)) {
            this.drawAreaName(canvas);
        }
    }

    private void drawAreaName(Canvas canvas) {
        Paint.FontMetrics fontMetrics = this.mContentPaint.getFontMetrics();
        float fontHeight = fontMetrics.bottom - fontMetrics.top;
        RectF rectF = this.getBound();
        float areaWidth = rectF.right - rectF.left;
        String[] texts = this.newAutoSplit(this.content, this.mContentPaint, areaWidth);
        if ((texts = this.clearDuplicateContent(texts)) == null) {
            return;
        }
        float verticalOffset = ((float)texts.length / 2.0f - 1.0f) * fontHeight;
        for (String text : texts) {
            if (TextUtils.isEmpty((CharSequence)text)) continue;
            canvas.drawText(text, rectF.centerX(), rectF.centerY() - verticalOffset, this.mContentPaint);
            verticalOffset -= fontHeight;
        }
    }

    PointF getCenterPoint(PointF pointF, PointF pointF1) {
        PointF pointF2 = new PointF();
        pointF2.x = (pointF.x + pointF1.x) / 2.0f;
        pointF2.y = (pointF.y + pointF1.y) / 2.0f;
        return pointF2;
    }

    int getSingleLineTextHeight(String content, Paint p) {
        Rect rect = new Rect();
        p.getTextBounds(content, 0, 1, rect);
        return rect.bottom - rect.top;
    }

    int getAllTextHeight(String[] texts) {
        if (texts == null || texts.length == 0) {
            return 0;
        }
        int singleLineTextHeight = this.getSingleLineTextHeight(texts[0], this.mContentPaint);
        return texts.length * (singleLineTextHeight + TEXT_HEIGHT_SPACE);
    }

    int getAreaWidth() {
        PointF left = this.getLeftTopPoint();
        PointF right = this.getRightTopPoint();
        return (int)Math.abs(left.x - right.x);
    }

    int getAreaHeight() {
        PointF left = this.getLeftTopPoint();
        PointF right = this.getRightTopPoint();
        return (int)Math.abs(left.y - right.y);
    }

    private String[] autoSplit(String content, Paint p, float width) {
        if (TextUtils.isEmpty((CharSequence)content)) {
            return null;
        }
        int length = content.length();
        float textWidth = p.measureText(content);
        if (textWidth <= width) {
            return new String[]{content};
        }
        int start = 0;
        int end = 1;
        int i = 0;
        int padding = 40;
        float singleCharWidth = p.measureText(content.charAt(0) + "");
        float minWidth = 0.0f;
        minWidth = width - (float)(padding * 2) > singleCharWidth ? width - (float)(padding * 2) : singleCharWidth;
        int lines = (int)Math.ceil(textWidth / minWidth);
        if (lines <= 0) {
            return null;
        }
        String[] lineTexts = new String[lines];
        while (start < length) {
            if (p.measureText(content, start, end) + (float)(padding * 2) > width) {
                lineTexts[i++] = (String)content.subSequence(start, end);
                start = end;
            }
            if (end == length && start < length) {
                lineTexts[i] = (String)content.subSequence(start, end);
                break;
            }
            ++end;
        }
        return lineTexts;
    }

    private String[] newAutoSplit(String content, Paint p, float width) {
        if (TextUtils.isEmpty((CharSequence)content)) {
            return null;
        }
        int length = content.length();
        float textWidth = p.measureText(content);
        int start = 0;
        int end = 1;
        int i = 0;
        int singleLineWidthDp = 120;
        float singleLineWidthPx = PixelUtil.toPixelFromDIP((float)singleLineWidthDp);
        int lines = (int)Math.ceil(textWidth / singleLineWidthPx);
        if (lines <= 0) {
            return null;
        }
        String[] lineTexts = new String[lines];
        while (start < length) {
            if (p.measureText(content, start, end) > singleLineWidthPx) {
                lineTexts[i++] = (String)content.subSequence(start, end);
                start = end;
            }
            if (end == length && start < length) {
                lineTexts[i] = (String)content.subSequence(start, end);
                break;
            }
            ++end;
        }
        return lineTexts;
    }

    private String[] clearDuplicateContent(String[] texts) {
        ArrayList<String> list = new ArrayList<String>();
        if (texts != null) {
            for (String content : texts) {
                if (TextUtils.isEmpty((CharSequence)content)) continue;
                list.add(content);
            }
        }
        return list.toArray(new String[list.size()]);
    }

    PointF getMidPoint(MotionEvent event) {
        PointF point = new PointF();
        float x = event.getX(0) + event.getX(1);
        float y = event.getY(0) + event.getY(1);
        point.set(x / 2.0f, y / 2.0f);
        return point;
    }

    PointF getLeftTopPoint() {
        return this.mPointList.get(0);
    }

    PointF getRightTopPoint() {
        return this.mPointList.get(1);
    }

    PointF getRightBottomPoint() {
        return this.mPointList.get(2);
    }

    PointF getLeftBottomPoint() {
        return this.mPointList.get(3);
    }

    public PointF getCenterPoint() {
        float[] points = new float[4];
        PointF leftTop = this.mPointList.get(0);
        PointF rightBottom = this.mPointList.get(2);
        this.mMatrix.mapPoints(points, new float[]{leftTop.x, leftTop.y, rightBottom.x, rightBottom.y});
        return new PointF((points[2] + points[0]) / 2.0f, (points[3] + points[1]) / 2.0f);
    }

    Pair<Float, Float> getWidthAndHeight(Matrix matrix) {
        PointF leftTop = this.mPointList.get(0);
        PointF rightTop = this.mPointList.get(1);
        PointF rightBottom = this.mPointList.get(2);
        float width = (float)Math.sqrt(Math.pow(leftTop.x - rightTop.x, 2.0) + Math.pow(leftTop.y - rightTop.y, 2.0));
        float height = (float)Math.sqrt(Math.pow(rightTop.x - rightBottom.x, 2.0) + Math.pow(rightTop.y - rightBottom.y, 2.0));
        return Pair.create((Object)Float.valueOf(width), (Object)Float.valueOf(height));
    }

    Pair<Float, Float> getWidthAndHeight(List<PointF> mPointList) {
        PointF leftTop = mPointList.get(0);
        PointF rightTop = mPointList.get(1);
        PointF rightBottom = mPointList.get(2);
        float width = (float)Math.sqrt(Math.pow(leftTop.x - rightTop.x, 2.0) + Math.pow(leftTop.y - rightTop.y, 2.0));
        float height = (float)Math.sqrt(Math.pow(rightTop.x - rightBottom.x, 2.0) + Math.pow(rightTop.y - rightBottom.y, 2.0));
        return Pair.create((Object)Float.valueOf(width), (Object)Float.valueOf(height));
    }

    float getMultiTouchDistance(MotionEvent event) {
        float x = event.getX(0) - event.getX(1);
        float y = event.getY(0) - event.getY(1);
        return (float)Math.sqrt(x * x + y * y);
    }

    float getSingleTouchDistance(MotionEvent event, PointF imageMidPoint) {
        float x = event.getX(0) - imageMidPoint.x;
        float y = event.getY(0) - imageMidPoint.y;
        return (float)Math.sqrt(x * x + y * y);
    }

    float getSingleTouchDistanceX(MotionEvent event, PointF imageMidPoint) {
        return event.getX(0) - imageMidPoint.x;
    }

    float getSingleTouchDistanceY(MotionEvent event, PointF imageMidPoint) {
        return event.getY(0) - imageMidPoint.y;
    }

    float getDistance(PointF pointF, PointF pointF1) {
        return (float)Math.sqrt(Math.pow(pointF.x - pointF1.x, 2.0) + Math.pow(pointF.y - pointF1.y, 2.0));
    }

    RectF getBound() {
        Path transformPath = new Path();
        transformPath.addPath(this.mPath);
        RectF dst = new RectF();
        transformPath.computeBounds(dst, true);
        return dst;
    }

    Matrix getMatrix() {
        return this.mMatrix;
    }

    public void setMatrix(Matrix matrix) {
        this.mMatrix = matrix;
    }

    public float calRotateAngle(PointF centerPoint, PointF initPoint, PointF rotatePoint) {
        float init_rotate;
        float center_rotate;
        float center_init = (float)Math.pow(centerPoint.x - initPoint.x, 2.0) + (float)Math.pow(centerPoint.y - initPoint.y, 2.0);
        double cosAngle = (double)(center_init + (center_rotate = (float)Math.pow(centerPoint.x - rotatePoint.x, 2.0) + (float)Math.pow(centerPoint.y - rotatePoint.y, 2.0)) - (init_rotate = (float)Math.pow(initPoint.x - rotatePoint.x, 2.0) + (float)Math.pow(initPoint.y - rotatePoint.y, 2.0))) / (2.0 * Math.sqrt(center_init) * Math.sqrt(center_rotate));
        if (cosAngle > 1.0) {
            cosAngle = 1.0;
        } else if (cosAngle < -1.0) {
            cosAngle = -1.0;
        }
        double angle = Math.acos(cosAngle);
        boolean isClockwise = (initPoint.x - centerPoint.x) * (rotatePoint.y - centerPoint.y) - (initPoint.y - centerPoint.y) * (rotatePoint.x - centerPoint.x) > 0.0f;
        return (float)(isClockwise ? Math.toDegrees(angle) : -Math.toDegrees(angle));
    }

    public void postTranslate(float xValue, float yValue) {
        ArrayList<PointF> list = new ArrayList<PointF>();
        list.addAll(this.mPointList);
        for (PointF pointF : list) {
            pointF.x += xValue;
            pointF.y += yValue;
        }
        this.updatePointList(list);
    }

    public void updatePoints(Matrix moveMatrix) {
        ArrayList<PointF> list = new ArrayList<PointF>();
        float[] dst = new float[8];
        moveMatrix.mapPoints(dst, new float[]{this.mPointList.get((int)0).x, this.mPointList.get((int)0).y, this.mPointList.get((int)1).x, this.mPointList.get((int)1).y, this.mPointList.get((int)2).x, this.mPointList.get((int)2).y, this.mPointList.get((int)3).x, this.mPointList.get((int)3).y});
        PointF pointF = new PointF(dst[0], dst[1]);
        PointF pointF1 = new PointF(dst[2], dst[3]);
        PointF pointF2 = new PointF(dst[4], dst[5]);
        PointF pointF3 = new PointF(dst[6], dst[7]);
        list.add(pointF);
        list.add(pointF1);
        list.add(pointF2);
        list.add(pointF3);
        this.updatePointList(list);
    }

    public void updatePoints(Matrix moveMatrix, List<PointF> mPointList) {
        if (mPointList == null) {
            return;
        }
        ArrayList<PointF> list = new ArrayList<PointF>();
        float[] dst = new float[8];
        moveMatrix.mapPoints(dst, new float[]{mPointList.get((int)0).x, mPointList.get((int)0).y, mPointList.get((int)1).x, mPointList.get((int)1).y, mPointList.get((int)2).x, mPointList.get((int)2).y, mPointList.get((int)3).x, mPointList.get((int)3).y});
        PointF pointF = new PointF(dst[0], dst[1]);
        PointF pointF1 = new PointF(dst[2], dst[3]);
        PointF pointF2 = new PointF(dst[4], dst[5]);
        PointF pointF3 = new PointF(dst[6], dst[7]);
        list.add(pointF);
        list.add(pointF1);
        list.add(pointF2);
        list.add(pointF3);
        this.updatePointList(list);
    }

    public void setRotate(int initAngle) {
    }
}

