/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.reactnativesweeper.view.sweepercommon.sticker;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.text.TextUtils;
import android.view.MotionEvent;
import com.facebook.react.uimanager.PixelUtil;

public class ActionIcon {
    public static final int TYPE_LEFTTOP = 0;
    public static final int TYPE_RIGHT_TOP = 1;
    public static final int TYPE_RIGHTBOTTOM = 2;
    private Context context;
    private Bitmap srcIcon;
    private RectF rect;
    private Matrix rotateMatrix;
    private float[] pointLocation = new float[2];
    private String text;
    private boolean visible = true;
    private Paint mTextPaint;

    public ActionIcon(Context context) {
        this.context = context;
        this.rect = new RectF();
        this.rotateMatrix = new Matrix();
        this.mTextPaint = new Paint();
        this.mTextPaint.setColor(-16777216);
        this.mTextPaint.setTypeface(Typeface.DEFAULT_BOLD);
        this.mTextPaint.setAntiAlias(true);
        this.mTextPaint.setTextAlign(Paint.Align.CENTER);
        this.mTextPaint.setTextSize(PixelUtil.toPixelFromSP((float)12.0f));
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setSrcIcon(int resource) {
        this.srcIcon = BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)resource);
    }

    public Bitmap getSrcIcon() {
        return this.srcIcon;
    }

    public void setSrcIcon(Bitmap bitmap) {
        this.srcIcon = bitmap;
    }

    public void draw(Canvas canvas, float x, float y) {
        if (!this.visible) {
            return;
        }
        this.pointLocation[0] = x;
        this.pointLocation[1] = y;
        this.rect.left = x - (float)(this.srcIcon.getWidth() / 2);
        this.rect.right = x + (float)(this.srcIcon.getWidth() / 2);
        this.rect.top = y - (float)(this.srcIcon.getHeight() / 2);
        this.rect.bottom = y + (float)(this.srcIcon.getHeight() / 2);
        canvas.drawBitmap(this.srcIcon, null, this.rect, null);
        if (!TextUtils.isEmpty((CharSequence)this.text)) {
            Paint.FontMetrics fontMetrics = this.mTextPaint.getFontMetrics();
            float top = fontMetrics.top;
            float bottom = fontMetrics.bottom;
            float baseLineY = this.rect.centerY() - top / 2.0f - bottom / 2.0f;
            canvas.drawText(this.text, this.rect.centerX(), baseLineY, this.mTextPaint);
        }
    }

    public void draw(Canvas canvas, int type, int viewWidth, int viewHeight) {
        if (type == 0) {
            this.rect.left = 0.0f;
            this.rect.right = this.srcIcon.getWidth();
            this.rect.top = 0.0f;
            this.rect.bottom = this.srcIcon.getHeight();
        } else if (type == 1) {
            this.rect.left = viewWidth - this.srcIcon.getWidth();
            this.rect.right = viewWidth;
            this.rect.top = 0.0f;
            this.rect.bottom = this.srcIcon.getHeight();
        } else if (type == 2) {
            this.rect.left = viewWidth - this.srcIcon.getWidth();
            this.rect.right = viewWidth;
            this.rect.top = viewHeight - this.srcIcon.getHeight();
            this.rect.bottom = viewHeight;
        }
        canvas.drawBitmap(this.srcIcon, null, this.rect, null);
    }

    public void setMatrix(Matrix matrix) {
        this.rotateMatrix.set(matrix);
    }

    public boolean isInActionCheck(MotionEvent event) {
        float left = this.rect.left;
        float right = this.rect.right;
        float top = this.rect.top;
        float bottom = this.rect.bottom;
        return event.getX(0) >= left && event.getX(0) <= right && event.getY(0) >= top && event.getY(0) <= bottom;
    }
}

