/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.reactnativesweeper.view.sweepercommon.property.icon;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.facebook.common.executors.CallerThreadExecutor;
import com.facebook.common.references.CloseableReference;
import com.facebook.datasource.DataSource;
import com.facebook.datasource.DataSubscriber;
import com.facebook.drawee.backends.pipeline.Fresco;
import com.facebook.imagepipeline.common.RotationOptions;
import com.facebook.imagepipeline.core.ImagePipeline;
import com.facebook.imagepipeline.datasource.BaseBitmapDataSubscriber;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imagepipeline.request.ImageRequestBuilder;
import com.tuya.reactnativesweeper.bean.RoomPropertyInfo;
import com.tuya.reactnativesweeper.bean.RoomPropertyPanelBean;
import com.tuya.reactnativesweeper.util.CollectionUtils;
import com.tuya.reactnativesweeper.view.sweepercommon.property.icon.ILoadIconBitmap;
import com.tuya.smart.asynclib.schedulers.ThreadEnv;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

public class PropertyIconManager {
    private AtomicBoolean isLoading = new AtomicBoolean(false);
    public HashMap<String, Bitmap> iconMap = new HashMap();
    private HashMap<String, Bitmap> defaultIconMap;
    private CountDownLatch downloadNum;
    public volatile boolean loadFinish = true;
    private List<String> iconUrls;
    public static float defaultIconHeight = 50.0f;

    public void loadIcon(List<RoomPropertyInfo> data, final Context context, final ILoadIconBitmap listener) {
        if (CollectionUtils.isEmpty(data)) {
            listener.onIconLoadFinish();
            return;
        }
        final List<String> iconUrls = this.getAllIconUrl(data);
        if (CollectionUtils.isEmpty(iconUrls)) {
            listener.onIconLoadFinish();
            return;
        }
        if (!this.loadFinish) {
            return;
        }
        if (!this.isDiffList(this.iconUrls, iconUrls)) {
            listener.onIconLoadFinish();
            return;
        }
        this.iconUrls = iconUrls;
        this.loadFinish = false;
        ThreadEnv.io().execute(new Runnable(){

            @Override
            public void run() {
                PropertyIconManager.this.downloadNum = new CountDownLatch(iconUrls.size());
                for (String url : iconUrls) {
                    PropertyIconManager.this.createRequest(url, context, listener);
                }
                try {
                    PropertyIconManager.this.downloadNum.await();
                    PropertyIconManager.this.loadFinish = true;
                    listener.onIconLoadFinish();
                }
                catch (InterruptedException e) {
                    PropertyIconManager.this.loadFinish = true;
                    listener.onIconLoadFinish();
                }
            }
        });
    }

    private List<String> getAllIconUrl(List<RoomPropertyInfo> data) {
        ArrayList<String> iconUrls = new ArrayList<String>();
        for (RoomPropertyInfo roomPropertyInfo : data) {
            List<RoomPropertyPanelBean.RoomPropertyBean> roomPropertyBeanList = roomPropertyInfo.getRoomProperty();
            if (CollectionUtils.isEmpty(roomPropertyBeanList)) continue;
            for (RoomPropertyPanelBean.RoomPropertyBean roomPropertyBean : roomPropertyBeanList) {
                if (!TextUtils.equals((CharSequence)roomPropertyBean.getPropertyType(), (CharSequence)"uri") || iconUrls.contains(roomPropertyBean.getValue())) continue;
                iconUrls.add(roomPropertyBean.getValue());
            }
        }
        return iconUrls;
    }

    private void createRequest(final String url, Context context, ILoadIconBitmap listener) {
        ImageRequest imageRequest = ImageRequestBuilder.newBuilderWithSource((Uri)Uri.parse((String)url)).setRotationOptions(RotationOptions.autoRotate()).build();
        ImagePipeline imagePipeline = Fresco.getImagePipeline();
        final DataSource dataSource = imagePipeline.fetchDecodedImage(imageRequest, (Object)context);
        dataSource.subscribe((DataSubscriber)new BaseBitmapDataSubscriber(){

            protected void onNewResultImpl(@Nullable Bitmap bmp) {
                if (dataSource.isFinished() && bmp != null) {
                    dataSource.close();
                    float scale = defaultIconHeight / (float)bmp.getHeight();
                    Matrix matrix = new Matrix();
                    matrix.postScale(scale, scale);
                    Bitmap resizeBmp = Bitmap.createBitmap((Bitmap)bmp, (int)0, (int)0, (int)bmp.getWidth(), (int)bmp.getHeight(), (Matrix)matrix, (boolean)true);
                    PropertyIconManager.this.iconMap.put(url, resizeBmp);
                }
                PropertyIconManager.this.downloadNum.countDown();
            }

            protected void onFailureImpl(DataSource<CloseableReference<CloseableImage>> dataSource2) {
                if (dataSource2 != null) {
                    dataSource2.close();
                }
                PropertyIconManager.this.downloadNum.countDown();
            }
        }, (Executor)CallerThreadExecutor.getInstance());
    }

    private boolean isDiffList(List<String> l1, List<String> l2) {
        if (CollectionUtils.isEmpty(l1) && !CollectionUtils.isEmpty(l2)) {
            return true;
        }
        if (CollectionUtils.isEmpty(l2) && !CollectionUtils.isEmpty(l1)) {
            return true;
        }
        if (l1.size() != l2.size()) {
            return true;
        }
        boolean ret = false;
        for (int i = 0; i < l1.size(); ++i) {
            if (TextUtils.equals((CharSequence)l1.get(i), (CharSequence)l2.get(i))) continue;
            ret = true;
            break;
        }
        return ret;
    }
}

