/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.reactnativesweeper.view.sweepercommon.property;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.Nullable;
import com.tuya.reactnativesweeper.bean.RoomColorInfo;
import com.tuya.reactnativesweeper.bean.RoomPropertyInfo;
import com.tuya.reactnativesweeper.bean.RoomPropertyPanelBean;
import com.tuya.reactnativesweeper.manager.SweeperMapStateManager;
import com.tuya.reactnativesweeper.util.CollectionUtils;
import com.tuya.reactnativesweeper.util.SizeUtils;
import com.tuya.reactnativesweeper.view.lasermap.callback.LaserMapStateListener;
import com.tuya.reactnativesweeper.view.sweepercommon.map.ISweeperSelectCleanListener;
import com.tuya.reactnativesweeper.view.sweepercommon.property.IPropView;
import com.tuya.reactnativesweeper.view.sweepercommon.property.RoomPropertyModel;
import java.util.HashMap;
import java.util.List;

public class RoomPropertyView
extends View
implements IPropView,
LaserMapStateListener,
ISweeperSelectCleanListener {
    private String mapId;
    private RoomPropertyModel roomPropertyModel;
    private static int roomPropertyPadding = 5;
    private static int defaultPropHeight = 60;
    private Matrix currentMatrix;

    public RoomPropertyView(Context context) {
        this(context, null);
    }

    public RoomPropertyView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RoomPropertyView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.roomPropertyModel = new RoomPropertyModel(this.getContext(), this);
        defaultPropHeight = (int)SizeUtils.dip2px(context, 25.0f);
        roomPropertyPadding = (int)SizeUtils.dip2px(context, 2.0f);
    }

    public void setMapId(String mapId) {
        this.mapId = mapId;
        this.roomPropertyModel.setMapId(mapId);
    }

    public void setMapBitmap(Bitmap bitmap) {
        this.roomPropertyModel.setBitMap(bitmap);
    }

    public void setMapOriginalBitmap(Bitmap bitmap) {
        this.roomPropertyModel.setOriginalBitmap(bitmap);
    }

    @Override
    public void refresh() {
        this.postInvalidate();
    }

    @Override
    public void onClick(String roomId) {
        this.roomPropertyModel.clickSplitEditOrder(roomId);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (CollectionUtils.isEmpty(this.roomPropertyModel.getRoomPropertyBeanList())) {
            return;
        }
        if (!this.roomPropertyModel.isLoadIconCompleted()) {
            return;
        }
        HashMap<String, RoomColorInfo> roomInfo = SweeperMapStateManager.getInstance().getRoomInfo(this.mapId);
        if (roomInfo == null) {
            return;
        }
        this.roomPropertyModel.setInited();
        int height = defaultPropHeight;
        Paint textPaint = new Paint();
        Paint iconPaint = new Paint();
        Paint bgPaint = new Paint();
        Paint numBgPaint = new Paint();
        bgPaint.setColor(-1);
        bgPaint.setStrokeCap(Paint.Cap.ROUND);
        bgPaint.setStrokeWidth((float)height);
        textPaint.setTextSize(SizeUtils.dip2px(this.getContext(), 12.0f));
        textPaint.setStyle(Paint.Style.FILL);
        Paint.FontMetrics fontMetrics = textPaint.getFontMetrics();
        for (RoomPropertyInfo roomPropertyInfo : this.roomPropertyModel.getRoomPropertyBeanList()) {
            String roomId;
            List<RoomPropertyPanelBean.RoomPropertyBean> roomProperty = roomPropertyInfo.getRoomProperty();
            if (CollectionUtils.isEmpty(roomProperty)) continue;
            PointF pointF = roomPropertyInfo.getLocation();
            Matrix matrix = roomPropertyInfo.getMatrix();
            float left = pointF.x;
            float top = pointF.y;
            float[] values = new float[]{left, top};
            if (matrix != null) {
                Matrix nullMatrix = new Matrix();
                matrix.invert(nullMatrix);
                nullMatrix.mapPoints(values);
                this.currentMatrix.mapPoints(values);
            }
            if (!roomInfo.containsKey(roomId = roomPropertyInfo.getRoomId())) continue;
            RoomColorInfo roomColorInfo = roomInfo.get(roomId);
            int intColor = roomColorInfo.isDefaultSelected() ? Color.parseColor((String)roomColorInfo.getHighlightColor()) : Color.parseColor((String)roomColorInfo.getNormalColor());
            iconPaint.setColorFilter((ColorFilter)new PorterDuffColorFilter(intColor, PorterDuff.Mode.SRC_ATOP));
            float textY = values[1] + (Math.abs(fontMetrics.ascent) - fontMetrics.descent) / 2.0f;
            int width = this.calculateRoomPropertyWidth(roomPropertyInfo, height, textPaint);
            int defaultOrder = roomPropertyInfo.getDefaultOrder();
            float currX = values[0] - (float)(width / 2) - (float)(height / 2) + (float)roomPropertyPadding;
            Rect rect = new Rect();
            canvas.drawLine(values[0] - (float)(width / 2), values[1], values[0] + (float)(width / 2), values[1], bgPaint);
            if (defaultOrder > 0) {
                numBgPaint.setColor(intColor);
                canvas.drawCircle(values[0] - (float)(width / 2), values[1], (float)((height - roomPropertyPadding * 2) / 2), numBgPaint);
                textPaint.setColor(-1);
                String numString = String.valueOf(defaultOrder);
                float textWidth = textPaint.measureText(numString);
                canvas.drawText(numString, values[0] - (float)(width / 2) - textWidth / 2.0f, textY, textPaint);
                currX += (float)height;
            }
            textPaint.setColor(-16777216);
            for (RoomPropertyPanelBean.RoomPropertyBean dRoomPropertyBean : roomProperty) {
                String url;
                String type = dRoomPropertyBean.getPropertyType();
                if (TextUtils.equals((CharSequence)type, (CharSequence)"text")) {
                    textPaint.getTextBounds(dRoomPropertyBean.getValue(), 0, dRoomPropertyBean.getValue().length(), rect);
                    int w = rect.width();
                    canvas.drawText(dRoomPropertyBean.getValue(), currX, textY, textPaint);
                    currX = currX + (float)w + (float)(roomPropertyPadding * 2);
                    continue;
                }
                if (!TextUtils.equals((CharSequence)type, (CharSequence)"uri") || !this.roomPropertyModel.propertyIconManager.iconMap.containsKey(url = dRoomPropertyBean.getValue())) continue;
                Bitmap bitmap = this.roomPropertyModel.propertyIconManager.iconMap.get(url);
                canvas.drawBitmap(bitmap, currX, values[1] - (float)(bitmap.getHeight() / 2), iconPaint);
                currX = currX + (float)bitmap.getWidth() + (float)(roomPropertyPadding * 2);
            }
        }
    }

    private int calculateRoomPropertyWidth(RoomPropertyInfo roomPropertyInfo, int height, Paint paint) {
        List<RoomPropertyPanelBean.RoomPropertyBean> roomProperty = roomPropertyInfo.getRoomProperty();
        if (CollectionUtils.isEmpty(roomProperty)) {
            return 0;
        }
        int result = 0;
        result = roomPropertyInfo.getDefaultOrder() > 0 ? result + height + roomPropertyPadding : (result += roomPropertyPadding);
        for (int i = 0; i < roomProperty.size(); ++i) {
            Bitmap bitmap;
            HashMap<String, Bitmap> iconMap;
            String value;
            RoomPropertyPanelBean.RoomPropertyBean roomPropertyBean = roomProperty.get(i);
            String type = roomPropertyBean.getPropertyType();
            if (TextUtils.equals((CharSequence)type, (CharSequence)"number")) {
                result += height - roomPropertyPadding;
            } else if (TextUtils.equals((CharSequence)type, (CharSequence)"text")) {
                value = roomPropertyBean.getValue();
                if (!TextUtils.isEmpty((CharSequence)value)) {
                    float textWidth = paint.measureText(value);
                    result += (int)textWidth;
                }
            } else if (TextUtils.equals((CharSequence)type, (CharSequence)"uri") && (iconMap = this.roomPropertyModel.propertyIconManager.iconMap).containsKey(value = roomPropertyBean.getValue()) && (bitmap = iconMap.get(value)) != null && !bitmap.isRecycled()) {
                result += bitmap.getWidth();
            }
            if (i == roomProperty.size() - 1) continue;
            result += roomPropertyPadding * 2;
        }
        return result - height + roomPropertyPadding;
    }

    @Override
    public void onMatrixChanged(Matrix currentMatrix, Matrix outerMatrix) {
        this.currentMatrix = currentMatrix;
        this.refresh();
    }

    @Override
    public void onOriginPointChanged(PointF originPoint) {
        this.refresh();
    }

    public HashMap<String, RoomColorInfo> getRoomInfo() {
        return this.roomPropertyModel.getCurrentRoomInfo();
    }
}

