/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.reactnativesweeper.view.sweepercommon.property;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.text.TextUtils;
import com.tuya.reactnativesweeper.bean.ColorDistributionInfo;
import com.tuya.reactnativesweeper.bean.RoomColorInfo;
import com.tuya.reactnativesweeper.bean.RoomPropertyInfo;
import com.tuya.reactnativesweeper.bean.RoomPropertyPanelBean;
import com.tuya.reactnativesweeper.manager.SweeperMapStateManager;
import com.tuya.reactnativesweeper.util.CollectionUtils;
import com.tuya.reactnativesweeper.util.SizeUtils;
import com.tuya.reactnativesweeper.view.sweepercommon.property.IPropView;
import com.tuya.reactnativesweeper.view.sweepercommon.property.icon.ILoadIconBitmap;
import com.tuya.reactnativesweeper.view.sweepercommon.property.icon.PropertyIconManager;
import com.tuya.smart.asynclib.schedulers.ThreadEnv;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class RoomPropertyModel
implements SweeperMapStateManager.LaserMapRefreshListener {
    private Bitmap mMapBitmap;
    private Bitmap currBitmap;
    private Context context;
    private Matrix matrix = new Matrix();
    public PropertyIconManager propertyIconManager;
    private IPropView iPropView;
    private String mapId;
    private volatile boolean isInit = false;
    private Object lock = new Object();
    private CopyOnWriteArrayList<RoomPropertyInfo> mRoomPropertyInfoList;
    private HashMap<String, RoomColorInfo> preRoomInfo = new HashMap();

    public RoomPropertyModel(Context context, IPropView iPropView) {
        this.context = context;
        this.iPropView = iPropView;
        PropertyIconManager.defaultIconHeight = SizeUtils.dip2px(context, 20.0f);
        this.propertyIconManager = new PropertyIconManager();
        this.mRoomPropertyInfoList = new CopyOnWriteArrayList();
        SweeperMapStateManager.getInstance().registerMapRefreshListener(this);
    }

    public String getMapId() {
        return this.mapId;
    }

    public void setMapId(String mapId) {
        this.mapId = mapId;
    }

    public CopyOnWriteArrayList<RoomPropertyInfo> getRoomPropertyBeanList() {
        return this.mRoomPropertyInfoList;
    }

    public boolean isLoadIconCompleted() {
        return this.propertyIconManager.loadFinish;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clickSplitEditOrder(String id) {
        Object object = this.lock;
        synchronized (object) {
            String setID;
            if (CollectionUtils.isEmpty(this.mRoomPropertyInfoList)) {
                return;
            }
            int maxIndex = 0;
            RoomPropertyInfo setRoomPropertyInfo = null;
            for (RoomPropertyInfo roomPropertyInfo : this.mRoomPropertyInfoList) {
                if (TextUtils.equals((CharSequence)roomPropertyInfo.getRoomId(), (CharSequence)id)) {
                    setRoomPropertyInfo = roomPropertyInfo;
                }
                if (roomPropertyInfo.getDefaultOrder() <= maxIndex) continue;
                maxIndex = roomPropertyInfo.getDefaultOrder();
            }
            if (setRoomPropertyInfo == null) {
                return;
            }
            int order = setRoomPropertyInfo.getDefaultOrder();
            if (order > 0) {
                setRoomPropertyInfo.setDefaultOrder(0);
                setID = setRoomPropertyInfo.getRoomId();
                if (this.preRoomInfo != null && this.preRoomInfo.containsKey(setID)) {
                    RoomColorInfo roomColorInfo = this.preRoomInfo.get(setID);
                    roomColorInfo.setDefaultOrder(0);
                }
                for (RoomPropertyInfo roomPropertyInfo : this.mRoomPropertyInfoList) {
                    int itemOrder = roomPropertyInfo.getDefaultOrder();
                    if (itemOrder <= order) continue;
                    roomPropertyInfo.setDefaultOrder(itemOrder - 1);
                    String idStr = roomPropertyInfo.getRoomId();
                    if (this.preRoomInfo == null || !this.preRoomInfo.containsKey(idStr)) continue;
                    RoomColorInfo roomColorInfo = this.preRoomInfo.get(idStr);
                    roomColorInfo.setDefaultOrder(itemOrder - 1);
                }
            } else {
                setRoomPropertyInfo.setDefaultOrder(maxIndex + 1);
                setID = setRoomPropertyInfo.getRoomId();
                if (this.preRoomInfo != null && this.preRoomInfo.containsKey(setID)) {
                    RoomColorInfo roomColorInfo = this.preRoomInfo.get(setID);
                    roomColorInfo.setDefaultOrder(maxIndex + 1);
                }
            }
            this.iPropView.refresh();
        }
    }

    public void updateRoomPropertyInfo() {
        ThreadEnv.computation().execute(new Runnable(){

            @Override
            public void run() {
                RoomPropertyModel.this.setRoomProps();
            }
        });
    }

    public void setInited() {
        this.isInit = true;
    }

    private boolean isDiffRoomInfo(HashMap<String, RoomColorInfo> roomInfo1, HashMap<String, RoomColorInfo> roomInfo2) {
        if (roomInfo1 == null && roomInfo2 != null) {
            return true;
        }
        if (roomInfo1 != null && roomInfo2 == null) {
            return true;
        }
        if (roomInfo1 == null && roomInfo2 == null) {
            return false;
        }
        if (roomInfo1.size() != roomInfo2.size()) {
            return true;
        }
        if (roomInfo1.size() == 0) {
            return false;
        }
        boolean ret = false;
        ArrayList<String> keys = new ArrayList<String>(roomInfo1.keySet());
        block0: for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            if (!roomInfo2.containsKey(key)) {
                ret = true;
                break;
            }
            RoomColorInfo roomColorInfo1 = roomInfo1.get(key);
            RoomColorInfo roomColorInfo2 = roomInfo2.get(key);
            if (roomColorInfo1.getDefaultOrder() != roomColorInfo2.getDefaultOrder()) {
                ret = true;
                break;
            }
            List<RoomPropertyPanelBean.RoomPropertyBean> roomProperty1 = roomColorInfo1.getRoomProperty();
            List<RoomPropertyPanelBean.RoomPropertyBean> roomProperty2 = roomColorInfo2.getRoomProperty();
            if (CollectionUtils.isEmpty(roomProperty1) && CollectionUtils.isEmpty(roomProperty2)) continue;
            if (CollectionUtils.isEmpty(roomProperty1) && !CollectionUtils.isEmpty(roomProperty2)) {
                ret = true;
                break;
            }
            if (!CollectionUtils.isEmpty(roomProperty1) && CollectionUtils.isEmpty(roomProperty2)) {
                ret = true;
                break;
            }
            if (roomProperty1.size() != roomProperty2.size()) {
                ret = true;
                break;
            }
            for (int j = 0; j < roomProperty1.size(); ++j) {
                if (roomProperty1.get(j).equals(roomProperty2.get(j))) continue;
                ret = true;
                continue block0;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRoomProps() {
        Object object = this.lock;
        synchronized (object) {
            if (this.mMapBitmap == null) {
                return;
            }
            if (this.mMapBitmap.getHeight() == 1 && this.mMapBitmap.getWidth() == 1) {
                return;
            }
            if (this.matrix == null) {
                return;
            }
            HashMap<String, RoomColorInfo> roomInfo = SweeperMapStateManager.getInstance().getRoomInfo(this.mapId);
            this.currBitmap = this.mMapBitmap.copy(Bitmap.Config.ARGB_8888, false);
            CopyOnWriteArrayList<RoomPropertyInfo> calculationRoomPropertyInfoList = new CopyOnWriteArrayList<RoomPropertyInfo>();
            this.preRoomInfo = roomInfo;
            Matrix roomMatrix = new Matrix(this.matrix);
            HashMap<Integer, ColorDistributionInfo> colorInfo = new HashMap<Integer, ColorDistributionInfo>();
            for (int i = 0; i < this.currBitmap.getWidth(); i += 4) {
                for (int j = 0; j < this.currBitmap.getHeight(); j += 4) {
                    int color = this.currBitmap.getPixel(i, j);
                    if (color == -1) continue;
                    if (colorInfo.containsKey(color)) {
                        ColorDistributionInfo colorDistributionInfo = (ColorDistributionInfo)colorInfo.get(color);
                        colorDistributionInfo.setX(colorDistributionInfo.getX() + i);
                        colorDistributionInfo.setY(colorDistributionInfo.getY() + j);
                        colorDistributionInfo.setNum(colorDistributionInfo.getNum() + 1);
                        continue;
                    }
                    colorInfo.put(color, new ColorDistributionInfo(i, j, 1));
                }
            }
            block5: for (Map.Entry colorDistributionInfoEntry : colorInfo.entrySet()) {
                for (String key : roomInfo.keySet()) {
                    RoomColorInfo roomColorInfo = roomInfo.get(key);
                    if ((Integer)colorDistributionInfoEntry.getKey() != Color.parseColor((String)roomColorInfo.getNormalColor()) && (Integer)colorDistributionInfoEntry.getKey() != Color.parseColor((String)roomColorInfo.getHighlightColor())) continue;
                    RoomPropertyInfo roomPropertyInfo = new RoomPropertyInfo();
                    roomPropertyInfo.setDefaultOrder(roomColorInfo.getDefaultOrder());
                    roomPropertyInfo.setRoomId(key);
                    roomPropertyInfo.setExtend(roomColorInfo.getExtend());
                    roomPropertyInfo.setMatrix(roomMatrix);
                    ColorDistributionInfo colorDistributionInfo = (ColorDistributionInfo)colorDistributionInfoEntry.getValue();
                    PointF pointF = new PointF((float)(colorDistributionInfo.getX() / colorDistributionInfo.getNum()), (float)(colorDistributionInfo.getY() / colorDistributionInfo.getNum()));
                    roomPropertyInfo.setLocation(pointF);
                    roomPropertyInfo.setRoomProperty(roomColorInfo.getRoomProperty());
                    calculationRoomPropertyInfoList.add(roomPropertyInfo);
                    continue block5;
                }
            }
            this.mRoomPropertyInfoList = calculationRoomPropertyInfoList;
            this.propertyIconManager.loadIcon(this.mRoomPropertyInfoList, this.context, new ILoadIconBitmap(){

                @Override
                public void onIconLoadFinish() {
                    RoomPropertyModel.this.refreshView();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshView() {
        Object object = this.lock;
        synchronized (object) {
            this.iPropView.refresh();
        }
    }

    @Override
    public void onMapDataReached(String mapId) {
        if (!TextUtils.equals((CharSequence)this.mapId, (CharSequence)mapId)) {
            return;
        }
        this.updateRoomPropertyInfo();
    }

    public void setBitMap(Bitmap bitmap) {
    }

    public void setMatrix(Matrix matrix) {
    }

    public void setOriginalBitmap(Bitmap bitmap) {
        this.mMapBitmap = bitmap;
        this.updateRoomPropertyInfo();
    }

    public HashMap<String, RoomColorInfo> getCurrentRoomInfo() {
        return this.preRoomInfo;
    }
}

