/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.reactnativesweeper.view.sweepercommon.map;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.DashPathEffect;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PointF;
import android.util.AttributeSet;
import android.util.Pair;
import android.view.MotionEvent;
import androidx.appcompat.widget.AppCompatImageView;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.events.RCTEventEmitter;
import com.tuya.reactnativesweeper.anim.MatrixAnimator;
import com.tuya.reactnativesweeper.bean.MapSplitData;
import com.tuya.reactnativesweeper.bean.MapSplitEnum;
import com.tuya.reactnativesweeper.bean.MapTypeAreaBean;
import com.tuya.reactnativesweeper.bean.MergeInfoBean;
import com.tuya.reactnativesweeper.bean.RoomColorInfo;
import com.tuya.reactnativesweeper.manager.SweeperMapStateManager;
import com.tuya.reactnativesweeper.util.CollectionUtils;
import com.tuya.reactnativesweeper.util.PointUtil;
import com.tuya.reactnativesweeper.util.SizeUtils;
import com.tuya.reactnativesweeper.view.lasermap.callback.LaserMapStateListener;
import com.tuya.reactnativesweeper.view.sweepercommon.MatrixView;
import com.tuya.reactnativesweeper.view.sweepercommon.ScaleLayout;
import com.tuya.reactnativesweeper.view.sweepercommon.SelectAreaUtil;
import com.tuya.reactnativesweeper.view.sweepercommon.map.IMapSplitView;
import com.tuya.reactnativesweeper.view.sweepercommon.map.ISweeperDataObserver;
import com.tuya.reactnativesweeper.view.sweepercommon.map.ISweeperMapSplitView;
import com.tuya.reactnativesweeper.view.sweepercommon.map.ISweeperMapUpdateListener;
import com.tuya.reactnativesweeper.view.sweepercommon.map.ISweeperSelectCleanListener;
import com.tuya.reactnativesweeper.view.sweepercommon.map.ISweeperTypeData;
import com.tuya.reactnativesweeper.view.sweepercommon.map.MapSplitModel;
import com.tuya.smart.android.common.utils.L;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;

public class MapSplitView
extends AppCompatImageView
implements SweeperMapStateManager.SweeperStateListener,
MatrixView,
IMapSplitView,
ISweeperMapSplitView,
ISweeperTypeData,
ISweeperMapUpdateListener,
LaserMapStateListener,
ISweeperDataObserver,
ScaleLayout.ActionListener {
    public static final String TAG = "MapSplitView";
    private int viewManagerId = 0;
    private Paint mPaint;
    private Paint judgePaint;
    private Paint mergeIconPaint;
    private float mPathWidth = 10.0f;
    private Path mLinePath;
    private float lineStartX;
    private float lineStartY;
    private float lineEndX;
    private float lineEndY;
    private boolean isEdit = true;
    private float preScale = 1.0f;
    private Matrix matrix = new Matrix();
    private Context mContext;
    private MapSplitModel mMapSplitModel;
    private MapSplitEnum mapSplitEnum;
    private String mapId;
    private PointF dragPoint;
    private PointF anchorPoint;
    private boolean isSingleClick = true;
    private boolean mIsSelected = false;
    private OnMapAreaSelectListener onMapAreaSelectListener;
    private ISweeperMapUpdateListener iSweeperMapUpdateListener;
    private CopyOnWriteArrayList<ISweeperSelectCleanListener> iSweeperSelectCleanListeners = new CopyOnWriteArrayList();
    private int mapState;
    private Bitmap spiltMapLayerBitmap;
    private Matrix currentMatrix;
    private static final int roomPropertyPadding = 10;
    private static final int defaultPropHeight = 50;

    public MapSplitView(Context context) {
        this(context, null);
    }

    public MapSplitView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MapSplitView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.init();
    }

    private void init() {
        this.mLinePath = new Path();
        this.mPaint = new Paint();
        this.mPathWidth = SizeUtils.dip2px(this.getContext(), 1.0f);
        this.mPaint.setStrokeWidth(this.mPathWidth);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setAntiAlias(true);
        this.mPaint.setColor(Color.parseColor((String)"#FFFFFF"));
        this.mPaint.setPathEffect((PathEffect)new DashPathEffect(new float[]{20.0f, 10.0f, 20.0f, 10.0f}, 0.0f));
        this.judgePaint = new Paint();
        this.judgePaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.judgePaint.setStrokeWidth(this.mPathWidth * 2.0f);
        this.judgePaint.setColor(Color.parseColor((String)"#FFFFFF"));
        this.mergeIconPaint = new Paint();
        this.mergeIconPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mergeIconPaint.setAntiAlias(true);
        SweeperMapStateManager.getInstance().registerMapAttributeChangedListener(this);
        SweeperMapStateManager.getInstance().registerStateListener(this);
        this.mapSplitEnum = MapSplitEnum.to(SweeperMapStateManager.getInstance().getMapSplitType(this.mapId));
        this.mMapSplitModel = new MapSplitModel(this.mContext, this);
        this.mMapSplitModel.registerMapUpdateListener(this);
        this.mapState = SweeperMapStateManager.getInstance().getState(this.mapId);
    }

    public void setParentView(ScaleLayout parentView) {
        parentView.setActionListener(this);
    }

    public String getMapId() {
        return this.mapId;
    }

    public void setMapId(String mapId) {
        this.mapId = mapId;
        this.mMapSplitModel.setMapId(mapId);
        SweeperMapStateManager.getInstance().registerSweepTypeListener(mapId, 6, this);
    }

    public void setMapBitmap(Bitmap bitmap) {
        this.mMapSplitModel.setBitMap(bitmap);
    }

    public void registerSelectCleanListener(ISweeperSelectCleanListener listener) {
        if (!this.iSweeperSelectCleanListeners.contains(listener)) {
            this.iSweeperSelectCleanListeners.add(listener);
        }
    }

    public void unRegisterSelectCleanListener(SweeperMapStateManager.SweeperStateListener listener) {
        if (this.iSweeperSelectCleanListeners.contains(listener)) {
            this.iSweeperSelectCleanListeners.remove(listener);
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.spiltMapLayerBitmap != null && this.currentMatrix != null) {
            canvas.drawBitmap(this.spiltMapLayerBitmap, this.currentMatrix, null);
        }
        if (this.getCurrentType() == MapSplitEnum.MERGE || this.mapState == 6) {
            this.drawIcon(canvas);
        } else if (this.getCurrentType() == MapSplitEnum.SPLIT && this.mIsSelected) {
            this.drawIcon(canvas);
            this.drawLine(canvas);
            this.drawSplitLine(canvas);
        }
    }

    private void drawIcon(Canvas canvas) {
        if (this.mMapSplitModel.getIconInfoList() == null || this.mMapSplitModel.getIconInfoList().size() == 0) {
            return;
        }
        for (MergeInfoBean iconInfoBean : this.mMapSplitModel.getIconInfoList()) {
            if (iconInfoBean == null || !iconInfoBean.isShowing() || iconInfoBean.getBitmap() == null || iconInfoBean.getLocation() == null) continue;
            PointF pointF = iconInfoBean.getLocation();
            Matrix matrix = iconInfoBean.getMatrix();
            float left = pointF.x;
            float top = pointF.y;
            float[] values = new float[]{left, top};
            if (matrix != null) {
                Matrix nullMatrix = new Matrix();
                matrix.invert(nullMatrix);
                nullMatrix.mapPoints(values);
                this.currentMatrix.mapPoints(values);
            }
            float finalX = values[0] - (float)(iconInfoBean.getBitmap().getWidth() / 2);
            float finalY = values[1] - (float)(iconInfoBean.getBitmap().getHeight() / 2);
            canvas.drawBitmap(iconInfoBean.getBitmap(), finalX, finalY, null);
        }
    }

    private void drawSplitLine(Canvas canvas) {
        if (this.mMapSplitModel.getSplitList() != null && this.mMapSplitModel.getSplitList().size() >= 2) {
            PointF lineStart = PointUtil.getInstance().transformPointWithM(this.mMapSplitModel.getSplitList().get(0), this.mMapSplitModel.splitListMatrix, this.currentMatrix);
            PointF lineEnd = PointUtil.getInstance().transformPointWithM(this.mMapSplitModel.getSplitList().get(this.mMapSplitModel.getSplitList().size() - 1), this.mMapSplitModel.splitListMatrix, this.currentMatrix);
            Path path = new Path();
            path.moveTo(lineStart.x, lineStart.y);
            path.lineTo(lineEnd.x, lineEnd.y);
            canvas.drawPath(path, this.judgePaint);
        }
    }

    private void drawPoint(Canvas canvas, PointF pointF) {
        canvas.drawCircle(pointF.x, pointF.y, 20.0f, this.judgePaint);
    }

    private PointF getPointInMap(float x, float y) {
        PointF startPoint = new PointF();
        startPoint.x = x;
        startPoint.y = y;
        return SweeperMapStateManager.getInstance().getXYInMap(this.mapId, startPoint);
    }

    public void reset(Matrix matrix) {
        final float animatorStartX = this.lineStartX;
        final float animatorStartY = this.lineStartY;
        final float animatorEndX = this.lineEndX;
        final float animatorEndY = this.lineEndY;
        MatrixAnimator matrixAnimator = new MatrixAnimator(new Matrix(), matrix);
        matrixAnimator.setListener(new MatrixAnimator.AnimationListener(){

            @Override
            public void onAnimationUpdate(Matrix matrix) {
                float[] points = new float[]{animatorStartX, animatorStartY, animatorEndX, animatorEndY};
                L.i((String)MapSplitView.TAG, (String)("onAnimationUpdate " + matrix.toShortString()));
                matrix.mapPoints(points);
                MapSplitView.this.lineStartX = points[0];
                MapSplitView.this.lineStartY = points[1];
                MapSplitView.this.lineEndX = points[2];
                MapSplitView.this.lineEndY = points[3];
                MapSplitView.this.invalidate();
            }

            @Override
            public void onAnimationEnd() {
                MapSplitView.this.preScale = 1.0f;
            }
        });
        matrixAnimator.start();
    }

    private MapSplitEnum getCurrentType() {
        return MapSplitEnum.to(SweeperMapStateManager.getInstance().getMapSplitType(this.mapId));
    }

    public PointF getCurrentPoint(PointF pointF) {
        float[] pointArr = new float[2];
        this.matrix.mapPoints(pointArr, new float[]{pointF.x, pointF.y});
        return new PointF(pointArr[0], pointArr[1]);
    }

    private void drawLine(Canvas canvas) {
        this.mLinePath = new Path();
        if (this.mMapSplitModel.whitePoint1 != null && this.mMapSplitModel.whitePoint2 != null && this.mMapSplitModel.whitePointMatrix != null) {
            PointF pointF1 = PointUtil.getInstance().transformPointWithM(this.mMapSplitModel.whitePoint1, this.mMapSplitModel.whitePointMatrix, this.currentMatrix);
            PointF pointF2 = PointUtil.getInstance().transformPointWithM(this.mMapSplitModel.whitePoint2, this.mMapSplitModel.whitePointMatrix, this.currentMatrix);
            this.mLinePath.moveTo(pointF1.x, pointF1.y);
            this.mLinePath.lineTo(pointF2.x, pointF2.y);
            this.drawPoint(canvas, pointF1);
            this.drawPoint(canvas, pointF2);
            canvas.drawPath(this.mLinePath, this.mPaint);
        }
    }

    public void setEdit(boolean edit, boolean invalidate) {
        if (edit == this.isEdit) {
            return;
        }
        this.isEdit = edit;
        if (invalidate) {
            this.postInvalidate();
        }
        L.i((String)TAG, (String)("setEdit edit=" + edit));
    }

    public void setColor(String color) {
        this.mPaint.setColor(Color.parseColor((String)color));
    }

    public void registerOnMapAreaSelectListener(OnMapAreaSelectListener listener) {
        this.onMapAreaSelectListener = listener;
    }

    public void unregisterOnMapAreaSelectListener(OnMapAreaSelectListener listener) {
        this.onMapAreaSelectListener = null;
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        if (event.getAction() == 5 || event.getAction() == 6) {
            return false;
        }
        return super.dispatchTouchEvent(event);
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.mapState = SweeperMapStateManager.getInstance().getState(this.mapId);
        if (this.mapState != 5 && this.mapState != 6) {
            return false;
        }
        if (this.mapState == 5 && (this.mapSplitEnum == MapSplitEnum.NORMAL || this.mapSplitEnum == MapSplitEnum.REST)) {
            return false;
        }
        if (this.mapState == 6 && !SweeperMapStateManager.getInstance().isEdit(this.mapId)) {
            return false;
        }
        if (event.getPointerCount() >= 2 || !this.mIsSelected) {
            return false;
        }
        int action = event.getActionMasked();
        boolean useEvent = true;
        switch (action) {
            case 0: {
                this.lineStartX = event.getX();
                this.lineStartY = event.getY();
                if (this.mIsSelected && this.mapSplitEnum == MapSplitEnum.SPLIT) {
                    PointF pointF = new PointF(this.lineStartX, this.lineStartY);
                    this.dragPoint = null;
                    this.anchorPoint = null;
                    if (PointUtil.getInstance().getPointsDistance(pointF, PointUtil.getInstance().transformPointWithM(this.mMapSplitModel.whitePoint1, this.mMapSplitModel.whitePointMatrix, this.currentMatrix)) < 30.0) {
                        this.mMapSplitModel.whitePoint1 = pointF;
                        this.mMapSplitModel.whitePoint2 = PointUtil.getInstance().transformPointWithM(this.mMapSplitModel.whitePoint2, this.mMapSplitModel.whitePointMatrix, this.currentMatrix);
                        this.mMapSplitModel.whitePointMatrix = new Matrix(this.currentMatrix);
                        this.dragPoint = this.mMapSplitModel.whitePoint1;
                        this.anchorPoint = this.mMapSplitModel.whitePoint2;
                        this.lineStartX = this.anchorPoint.x;
                        this.lineStartY = this.anchorPoint.y;
                    } else if (PointUtil.getInstance().getPointsDistance(pointF, PointUtil.getInstance().transformPointWithM(this.mMapSplitModel.whitePoint2, this.mMapSplitModel.whitePointMatrix, this.currentMatrix)) < 30.0) {
                        this.mMapSplitModel.whitePoint2 = pointF;
                        this.mMapSplitModel.whitePoint1 = PointUtil.getInstance().transformPointWithM(this.mMapSplitModel.whitePoint1, this.mMapSplitModel.whitePointMatrix, this.currentMatrix);
                        this.mMapSplitModel.whitePointMatrix = new Matrix(this.currentMatrix);
                        this.dragPoint = this.mMapSplitModel.whitePoint2;
                        this.anchorPoint = this.mMapSplitModel.whitePoint1;
                        this.lineStartX = this.anchorPoint.x;
                        this.lineStartY = this.anchorPoint.y;
                    } else {
                        return false;
                    }
                }
                if (this.mapSplitEnum != MapSplitEnum.MERGE && this.mapState != 6) break;
                useEvent = false;
                break;
            }
            case 2: {
                if (this.mIsSelected && this.mapSplitEnum == MapSplitEnum.SPLIT) {
                    this.lineEndX = event.getX();
                    this.lineEndY = event.getY();
                    if (this.dragPoint != null) {
                        if (!CollectionUtils.isEmpty(this.mMapSplitModel.getSplitList())) {
                            this.mMapSplitModel.clearSelect();
                        }
                        this.dragPoint.x = this.lineEndX;
                        this.dragPoint.y = this.lineEndY;
                    }
                    if (Math.abs(this.lineStartX - this.lineEndX) < 5.0f || Math.abs(this.lineStartY - this.lineEndY) < 5.0f) {
                        L.w((String)TAG, (String)"ACTION_MOVE  too nearly--- so reset NONE");
                        break;
                    }
                    if (Math.abs(this.lineStartX - this.lineEndX) > 10.0f || Math.abs(this.lineStartY - this.lineEndY) > 10.0f) {
                        this.isSingleClick = false;
                    }
                }
                this.invalidate();
                if (this.mapSplitEnum != MapSplitEnum.MERGE && this.mapState != 6) break;
                useEvent = false;
                break;
            }
            case 1: {
                this.lineEndX = event.getX();
                this.lineEndY = event.getY();
                if (this.isSingleClick) {
                    PointF pointF1 = new PointF(this.lineEndX, this.lineEndY);
                    this.onSingleClick(pointF1);
                }
                this.invalidate();
                if (!this.mIsSelected || this.mapSplitEnum != MapSplitEnum.SPLIT || this.anchorPoint == null || this.dragPoint == null) break;
                this.dragPoint.x = this.lineEndX;
                this.dragPoint.y = this.lineEndY;
                this.mMapSplitModel.areaSplit(this.lineStartX, this.lineStartY, this.lineEndX, this.lineEndY);
                this.dragPoint = null;
                this.anchorPoint = null;
                this.isSingleClick = true;
                break;
            }
        }
        return useEvent;
    }

    private void onSingleClick(PointF pointF) {
        int color;
        Pair<String, RoomColorInfo> pair;
        if (this.mapState == 5 && this.mapSplitEnum != MapSplitEnum.CLICK) {
            this.mIsSelected = this.mMapSplitModel.selectArea(pointF, this.mapSplitEnum, this.currentMatrix);
            int color2 = this.mMapSplitModel.selectColor(pointF);
            if (color2 != -1) {
                if (!CollectionUtils.isEmpty(this.mMapSplitModel.getSplitList())) {
                    this.mMapSplitModel.clearSelect();
                }
                if (this.mapSplitEnum == MapSplitEnum.SPLIT) {
                    this.mMapSplitModel.genLineInArea();
                }
                this.mMapSplitModel.refreshMap(5);
            }
        } else if (this.mapState == 6) {
            int selectNum;
            int color3 = this.mMapSplitModel.selectColor(pointF);
            Pair<String, RoomColorInfo> pair2 = SelectAreaUtil.getRoomIdByColor(color3, SweeperMapStateManager.getInstance().getRoomInfo(this.mapId));
            if (pair2 != null) {
                for (ISweeperSelectCleanListener listener : this.iSweeperSelectCleanListeners) {
                    listener.onClick((String)pair2.first);
                }
            }
            this.mIsSelected = (selectNum = this.mMapSplitModel.selectCleanAreaMode(MapSplitModel.TYPE_SPILIT_CLEAN_AREA_NUM, pointF, this.currentMatrix)) > 0;
            this.mMapSplitModel.refreshMap(6);
        } else if (this.mapState == 5 && this.mapSplitEnum == MapSplitEnum.CLICK && (pair = SelectAreaUtil.getRoomIdByColor(color = this.mMapSplitModel.selectColor(pointF), SweeperMapStateManager.getInstance().getRoomInfo(this.mapId))) != null) {
            this.sendClickSplitAreaEventToRN((String)pair.first);
        }
        if (this.onMapAreaSelectListener != null) {
            this.onMapAreaSelectListener.onSelect(this.mIsSelected);
        }
    }

    public void registerMapUpdateListener(ISweeperMapUpdateListener listener) {
        this.iSweeperMapUpdateListener = listener;
    }

    public void unRegisterMapUpdateListener() {
        this.iSweeperMapUpdateListener = null;
    }

    @Override
    public void updateSplitType(String mapId, int type) {
        if (!this.mapId.equals(mapId)) {
            return;
        }
        this.mapSplitEnum = MapSplitEnum.to(type);
        if (this.mapSplitEnum == MapSplitEnum.NORMAL) {
            this.clearSplit();
        }
        this.mMapSplitModel.refreshMap(5);
        this.postInvalidate();
    }

    public void setPreScale(float preScale) {
        this.preScale = preScale;
    }

    @Override
    public MapSplitData getMapPointsData(String mapId) {
        if (!this.mapId.equals(mapId)) {
            return null;
        }
        return this.mMapSplitModel.getMapPointsData();
    }

    @Override
    public Matrix getMapMatrix() {
        return this.matrix;
    }

    @Override
    public void refresh() {
        this.postInvalidate();
    }

    @Override
    public void updateLocation(float lineStartX, float lineStartY, float lineEndX, float lineEndY) {
        this.lineStartX = lineStartX;
        this.lineStartY = lineStartY;
        this.lineEndX = lineEndX;
        this.lineEndY = lineEndY;
    }

    @Override
    public void onStateChanged(String mapId, int state) {
        if (this.mapId != null && this.mapId.equals(mapId)) {
            boolean hasCleanData;
            this.postInvalidate();
            this.mapState = state;
            if (state != 6 && (hasCleanData = this.mMapSplitModel.cleanSelectedInfo())) {
                this.mMapSplitModel.refreshMap(6);
            }
            if (state != 5) {
                this.mMapSplitModel.whitePoint1 = null;
                this.mMapSplitModel.whitePoint2 = null;
                this.mMapSplitModel.whitePointMatrix = null;
            }
        }
    }

    private void clearSplit() {
        this.lineStartX = 0.0f;
        this.lineStartY = 0.0f;
        this.lineEndX = 0.0f;
        this.lineEndY = 0.0f;
        this.mIsSelected = false;
        if (this.onMapAreaSelectListener != null) {
            this.onMapAreaSelectListener.onSelect(this.mIsSelected);
        }
        this.mMapSplitModel.clear();
    }

    public void sendClickSplitAreaEventToRN(String id) {
        if (this.mContext instanceof ThemedReactContext) {
            WritableMap writableMap = Arguments.createMap();
            WritableMap writableMapData = Arguments.createMap();
            writableMapData.putString("pixel", id);
            writableMapData.putString("extend", "");
            WritableArray writableArray = Arguments.createArray();
            writableArray.pushMap(writableMapData);
            writableMap.putInt("type", 4);
            writableMap.putArray("data", writableArray);
            ((RCTEventEmitter)((ThemedReactContext)this.mContext).getJSModule(RCTEventEmitter.class)).receiveEvent(this.viewManagerId, "onClickSplitArea", writableMap);
            L.d((String)TAG, (String)("sendDialogEventToRN id:" + id));
        }
    }

    public void setViewManagerId(int id) {
        this.viewManagerId = id;
    }

    @Override
    public void postTranslate(float dx, float dy) {
        this.matrix.postTranslate(dx, dy);
        float[] points = new float[]{this.lineStartX, this.lineStartY, this.lineEndX, this.lineEndY};
        this.matrix.mapPoints(points);
        this.lineStartX = points[0];
        this.lineStartY = points[1];
        this.lineEndX = points[2];
        this.lineEndY = points[3];
        this.invalidate();
    }

    @Override
    public void postScale(float scale, PointF pointF) {
        if (null == this.mLinePath) {
            return;
        }
        this.matrix.postScale(scale / this.preScale, scale / this.preScale, pointF.x, pointF.y);
        float[] points = new float[]{this.lineStartX, this.lineStartY, this.lineEndX, this.lineEndY};
        this.matrix.mapPoints(points);
        this.lineStartX = points[0];
        this.lineStartY = points[1];
        this.lineEndX = points[2];
        this.lineEndY = points[3];
        this.preScale = scale;
        this.invalidate();
    }

    @Override
    public MapTypeAreaBean getMapTypeData(String mapId, int type) {
        if (type != 6) {
            return null;
        }
        if (!this.mapId.equals(mapId)) {
            return null;
        }
        MapTypeAreaBean mapTypeAreaBean = new MapTypeAreaBean();
        mapTypeAreaBean.setType(type);
        ArrayList<MapTypeAreaBean.DataBean> dataBeanList = new ArrayList<MapTypeAreaBean.DataBean>();
        mapTypeAreaBean.setData(dataBeanList);
        for (MergeInfoBean mergeInfoBean : this.mMapSplitModel.getIconInfoList()) {
            if (!mergeInfoBean.isShowing()) continue;
            MapTypeAreaBean.DataBean dataBean = new MapTypeAreaBean.DataBean();
            dataBean.setPixel(mergeInfoBean.getId());
            dataBean.setExtend(mergeInfoBean.getExtend());
            dataBeanList.add(dataBean);
        }
        return mapTypeAreaBean;
    }

    @Override
    public void onMapUpdate(Bitmap bitmap, int width, int height) {
        this.spiltMapLayerBitmap = bitmap;
    }

    @Override
    public void onOriginPointChanged(PointF originPoint) {
        this.refresh();
    }

    @Override
    public void onMatrixChanged(Matrix currentMatrix, Matrix outerMatrix) {
        this.currentMatrix = currentMatrix;
        this.mMapSplitModel.setMatrix(currentMatrix);
        this.refresh();
    }

    @Override
    public void onSplitColorChanaged(String mapId, String color) {
        if (!this.mapId.equals(mapId)) {
            return;
        }
        L.d((String)TAG, (String)("split color:" + color));
        if (this.mPaint != null) {
            this.mPaint.setColor(Color.parseColor((String)color));
            this.judgePaint.setColor(Color.parseColor((String)color));
            this.refresh();
        }
    }

    @Override
    public void onDoubleClick() {
    }

    @Override
    public void onSingleClick(float x, float y) {
        PointF pointF = new PointF(x, y);
        this.onSingleClick(pointF);
        this.invalidate();
    }

    public static interface OnMapAreaSelectListener {
        public void onSelect(boolean var1);
    }
}

