/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.reactnativesweeper.view.sweepercommon.map;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.Pair;
import com.tuya.react_sweeper_common.R;
import com.tuya.reactnativesweeper.bean.MapSplitData;
import com.tuya.reactnativesweeper.bean.MapSplitEnum;
import com.tuya.reactnativesweeper.bean.MergeInfoBean;
import com.tuya.reactnativesweeper.bean.RoomColorInfo;
import com.tuya.reactnativesweeper.manager.SweeperMapStateManager;
import com.tuya.reactnativesweeper.util.BitmapUtil;
import com.tuya.reactnativesweeper.util.CollectionUtils;
import com.tuya.reactnativesweeper.view.sweepercommon.SelectAreaUtil;
import com.tuya.reactnativesweeper.view.sweepercommon.map.IMapSplitView;
import com.tuya.reactnativesweeper.view.sweepercommon.map.ISweeperMapUpdateListener;
import com.tuya.smart.android.common.utils.L;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

public class MapSplitModel
implements SweeperMapStateManager.LaserMapRefreshListener {
    private static final String TAG = "MapSplitView";
    private static final String BACKGROUD_NAME = "unknown";
    private static final String OBSTACLE_NAME = "barrier";
    public static int OBSTACLE_COLOR = -10790295;
    public static int BACKGROUND_COLOR = 0xFFFFFF;
    public static int DEFAULT_DISTANCE = 20;
    public static int TYPE_MAP_SPILT_AREA_NUM = 1;
    public static int TYPE_MAP_MERGE_AREA_NUMM = 2;
    public static int TYPE_SPILIT_CLEAN_AREA_NUM = 0;
    float lineStartX = 0.0f;
    float lineStartY = 0.0f;
    float lineEndX = 0.0f;
    float lineEndY = 0.0f;
    public PointF whitePoint1;
    public PointF whitePoint2;
    public Matrix whitePointMatrix;
    private IMapSplitView iMapSplitView;
    private List<PointF> splitList = new ArrayList<PointF>();
    public Matrix splitListMatrix;
    private Pair<Integer, Integer> mapSize;
    private CopyOnWriteArrayList<Integer> selectedColorList;
    private List<Point> criticalMapPointList;
    private CopyOnWriteArrayList<MergeInfoBean> mIconInfoList;
    private Map<Integer, Integer> selectAreaMap = new HashMap<Integer, Integer>();
    private ISweeperMapUpdateListener iSweeperMapUpdateListener;
    private Context mContext;
    private String mapId;
    private Bitmap mMapBitmap;
    private Matrix matrix;

    public String getMapId() {
        return this.mapId;
    }

    public void setMapId(String mapId) {
        this.mapId = mapId;
    }

    public MapSplitModel(Context context, IMapSplitView iMapSplitView) {
        this.iMapSplitView = iMapSplitView;
        this.mIconInfoList = new CopyOnWriteArrayList();
        this.mContext = context;
        this.splitList = new ArrayList<PointF>();
        this.criticalMapPointList = new CopyOnWriteArrayList<Point>();
        this.selectedColorList = new CopyOnWriteArrayList();
        SweeperMapStateManager.getInstance().registerMapRefreshListener(this);
    }

    private String findRoomIdByColor(int color) {
        HashMap<String, String> roomIdMap;
        if (Build.VERSION.SDK_INT >= 26) {
            L.d((String)TAG, (String)("find color :" + color + " " + BitmapUtil.colorToHexValue(Color.valueOf((int)color))));
        }
        if ((roomIdMap = SweeperMapStateManager.getInstance().getRoomIdColorMap()) == null) {
            L.e((String)TAG, (String)"getRoomIdColorMap == null");
            return null;
        }
        Set<Map.Entry<String, String>> set = roomIdMap.entrySet();
        for (Map.Entry<String, String> entry : set) {
            if (entry.getValue() == null || Color.parseColor((String)entry.getValue()) != color) continue;
            return entry.getKey();
        }
        return null;
    }

    public boolean isOutIndex(Point pointF) {
        return pointF.x < 0 || pointF.y < 0 || pointF.x >= (Integer)this.mapSize.first || pointF.y >= (Integer)this.mapSize.second;
    }

    public List<PointF> getSplitList() {
        return this.splitList;
    }

    private void showIcon(int limit, MergeInfoBean iconInfoBean) {
        if (iconInfoBean.getBitmap() == null) {
            Drawable drawable2 = this.mContext.getResources().getDrawable(R.drawable.sweeper_map_merge_icon);
            BitmapDrawable bitmapDrawable = (BitmapDrawable)drawable2;
            Bitmap bitmap = bitmapDrawable.getBitmap();
            iconInfoBean.setBitmap(bitmap);
        }
        iconInfoBean.setShowing(true);
        this.keepShowingIconNum(limit);
        this.iMapSplitView.refresh();
    }

    private void showIcon(MergeInfoBean iconInfoBean) {
        this.showIcon(0, iconInfoBean);
    }

    private void hiddenIcon(MergeInfoBean iconInfoBean) {
        iconInfoBean.setShowing(false);
        this.iMapSplitView.refresh();
    }

    private MergeInfoBean getContainColor(int color) {
        for (MergeInfoBean iconInfoBean : this.mIconInfoList) {
            if (iconInfoBean.getColor() != color) continue;
            return iconInfoBean;
        }
        return null;
    }

    private void keepShowingIconNum(int limit) {
        if (limit == 0) {
            return;
        }
        int showNum = 0;
        for (MergeInfoBean iconInfoBean1 : this.mIconInfoList) {
            if (!iconInfoBean1.isShowing()) continue;
            ++showNum;
        }
        if (showNum > limit) {
            this.removeFirstShowingIcon();
            this.keepShowingIconNum(limit);
        }
    }

    private void removeFirstShowingIcon() {
        for (MergeInfoBean iconInfoBean1 : this.mIconInfoList) {
            if (!iconInfoBean1.isShowing()) continue;
            this.mIconInfoList.remove(iconInfoBean1);
            this.removeFromSelectedList(iconInfoBean1.getColor());
            break;
        }
    }

    private void removeFromSelectedList(int color) {
        for (Integer integer : this.selectedColorList) {
            if (integer != color) continue;
            this.selectedColorList.remove(integer);
        }
    }

    public CopyOnWriteArrayList<MergeInfoBean> getIconInfoList() {
        return this.mIconInfoList;
    }

    public CopyOnWriteArrayList<Integer> getSelectedColorList() {
        return this.selectedColorList;
    }

    public void clear() {
        this.clearSelect();
        if (this.mIconInfoList != null) {
            this.mIconInfoList.clear();
        }
        if (this.selectedColorList != null) {
            this.selectedColorList.clear();
        }
    }

    public void clearSelect() {
        this.splitList.clear();
        this.splitListMatrix = null;
        if (this.criticalMapPointList != null) {
            this.criticalMapPointList.clear();
        }
    }

    public MapSplitData getMapPointsData() {
        MapSplitData mapSplitData = new MapSplitData();
        mapSplitData.setType(SweeperMapStateManager.getInstance().getMapSplitType(this.mapId));
        ArrayList<MapSplitData.SplitData> data = new ArrayList<MapSplitData.SplitData>();
        mapSplitData.setData(data);
        switch (SweeperMapStateManager.getInstance().getMapSplitType(this.mapId)) {
            case 1: {
                break;
            }
            case 2: {
                if (this.mIconInfoList == null) break;
                for (MergeInfoBean iconInfoBean : this.mIconInfoList) {
                    if (!iconInfoBean.isShowing()) continue;
                    MapSplitData.SplitData mergeData = new MapSplitData.SplitData();
                    mergeData.setPixel(iconInfoBean.getId());
                    data.add(mergeData);
                }
                break;
            }
            case 3: {
                MapSplitData.SplitData<Point> splitData = new MapSplitData.SplitData<Point>();
                if (this.criticalMapPointList.size() < 2) break;
                if (this.selectedColorList.size() == 0) {
                    L.e((String)TAG, (String)"selectedColorList is null");
                    break;
                }
                int color = this.selectedColorList.get(0);
                String id = this.findRoomIdByColor(color);
                splitData.setPixel(id);
                splitData.setPoints(this.criticalMapPointList);
                data.add(splitData);
                break;
            }
        }
        return mapSplitData;
    }

    @Override
    public void onMapDataReached(String mapId) {
        if (!TextUtils.equals((CharSequence)this.mapId, (CharSequence)mapId)) {
            return;
        }
        HashMap<String, String> pointTypeMap = SweeperMapStateManager.getInstance().getPointTypeColorMap();
        if (pointTypeMap != null) {
            String backgroudValue = pointTypeMap.get(BACKGROUD_NAME);
            String obstacleValue = pointTypeMap.get(OBSTACLE_NAME);
            if (!TextUtils.isEmpty((CharSequence)backgroudValue)) {
                BACKGROUND_COLOR = Color.parseColor((String)backgroudValue);
            }
            if (!TextUtils.isEmpty((CharSequence)obstacleValue)) {
                OBSTACLE_COLOR = Color.parseColor((String)obstacleValue);
            }
        }
        this.selectAreaMap = SelectAreaUtil.getSelectAreaColorMap(SweeperMapStateManager.getInstance().getRoomInfo(mapId));
        if (this.selectAreaMap.size() > 0) {
            this.defaultSelectedInfo(this.selectAreaMap);
        }
        this.refreshMap(this.selectAreaMap);
    }

    public boolean selectArea(PointF pointF, MapSplitEnum mapSplitEnum, Matrix currMatrix) {
        int color = this.selectColorOrClean(pointF, false);
        if (mapSplitEnum == MapSplitEnum.SPLIT) {
            if (color == -1) {
                return this.mIconInfoList.size() > 0;
            }
            this.selectedColorList.clear();
            this.selectedColorList.add(color);
            this.mIconInfoList.clear();
            MergeInfoBean iconInfoBean = new MergeInfoBean(color, false, pointF, currMatrix);
            this.mIconInfoList.add(iconInfoBean);
            this.showIcon(1, iconInfoBean);
            return this.mIconInfoList.size() > 0;
        }
        if (mapSplitEnum == MapSplitEnum.MERGE) {
            if (color == -1) {
                return this.getSelectNum() > 0;
            }
            return this.selectMultiArea(color, TYPE_MAP_MERGE_AREA_NUMM, pointF, currMatrix) > 0;
        }
        return true;
    }

    public int selectColor(PointF pointF) {
        return this.selectColorOrClean(pointF, false);
    }

    private int selectColorOrClean(PointF pointF, boolean clean) {
        PointF pointFInMap = SweeperMapStateManager.getInstance().getXYInMap(this.mapId, pointF);
        Point point = new Point((int)pointFInMap.x, (int)pointFInMap.y);
        int[][] mapArray = SweeperMapStateManager.getInstance().getDataArray();
        this.mapSize = SweeperMapStateManager.getInstance().getMapSize();
        if (this.isOutIndex(point)) {
            L.d((String)TAG, (String)"out of index ");
            if (clean) {
                this.selectedColorList.clear();
            }
            return -1;
        }
        int color = mapArray[point.y][point.x];
        L.d((String)TAG, (String)("select color:" + color));
        if (color == BACKGROUND_COLOR || color == OBSTACLE_COLOR) {
            L.d((String)TAG, (String)"background color or OBSTACLE_COLOR");
            if (clean) {
                this.selectedColorList.clear();
            }
            return -1;
        }
        return color;
    }

    public int selectMultiArea(int limit, PointF pointF, Matrix matrix) {
        int color = this.selectColor(pointF);
        if (color == -1) {
            L.e((String)TAG, (String)"not select any areas");
            return 0;
        }
        return this.selectMultiArea(color, limit, pointF, matrix);
    }

    public int selectCleanAreaMode(int limit, PointF pointF, Matrix matrix) {
        int color = this.selectColor(pointF);
        if (color == -1 && this.selectAreaMap.size() == 0) {
            L.e((String)TAG, (String)"not select any areas");
            return 0;
        }
        this.getSelectAreaInfo(color, limit, pointF, matrix);
        return this.getSelectNum();
    }

    public int selectMultiArea(int color, int limit, PointF pointF, Matrix matrix) {
        if (color == -1) {
            return this.getSelectNum();
        }
        MergeInfoBean iconInfoBean = this.getContainColor(color);
        if (iconInfoBean == null) {
            iconInfoBean = new MergeInfoBean(color, false, pointF, matrix);
            this.mIconInfoList.add(iconInfoBean);
        }
        String id = this.findRoomIdByColor(color);
        L.d((String)TAG, (String)("map select id:" + id));
        iconInfoBean.setId(id);
        iconInfoBean.setLocation(pointF);
        iconInfoBean.setMatrix(matrix);
        if (iconInfoBean.isShowing()) {
            this.hiddenIcon(iconInfoBean);
            this.removeFromSelectedList(color);
        } else {
            this.selectedColorList.add(color);
            this.showIcon(limit, iconInfoBean);
        }
        return this.getSelectNum();
    }

    private void getSelectAreaInfo(int color, int limit, PointF pointF, Matrix matrix) {
        Pair<String, RoomColorInfo> pair;
        MergeInfoBean iconInfoBean = this.getContainColor(color);
        if (iconInfoBean == null) {
            iconInfoBean = new MergeInfoBean(color, false, pointF, matrix);
            this.mIconInfoList.add(iconInfoBean);
        }
        if ((pair = SelectAreaUtil.getRoomIdByColor(color, SweeperMapStateManager.getInstance().getRoomInfo(this.mapId))) == null) {
            L.e((String)TAG, (String)"get color info failed");
            return;
        }
        iconInfoBean.setLocation(pointF);
        iconInfoBean.setId((String)pair.first);
        iconInfoBean.setMatrix(matrix);
        iconInfoBean.setExtend(((RoomColorInfo)pair.second).getExtend());
        if (iconInfoBean.isShowing()) {
            this.hiddenIcon(iconInfoBean);
            this.selectAreaMap.remove(color);
        } else {
            Integer highLightColor = SelectAreaUtil.getHightLightColor(color, SweeperMapStateManager.getInstance().getRoomInfo(this.mapId));
            if (highLightColor != null) {
                this.selectAreaMap.put(color, highLightColor);
                iconInfoBean.setShowing(true);
                this.showIcon(iconInfoBean);
            }
        }
    }

    private void defaultSelectedInfo(Map<Integer, Integer> selectAreaMap) {
        Set<Integer> set = selectAreaMap.keySet();
        for (Integer color : set) {
            Pair<String, RoomColorInfo> pair;
            MergeInfoBean iconInfoBean = this.getContainColor(color);
            if (iconInfoBean == null) {
                iconInfoBean = new MergeInfoBean(color, true, null, this.matrix);
                this.mIconInfoList.add(iconInfoBean);
            }
            if ((pair = SelectAreaUtil.getRoomIdByColor(color, SweeperMapStateManager.getInstance().getRoomInfo(this.mapId))) == null) {
                L.e((String)TAG, (String)"get color info failed");
                return;
            }
            iconInfoBean.setId((String)pair.first);
            iconInfoBean.setMatrix(this.matrix);
            iconInfoBean.setExtend(((RoomColorInfo)pair.second).getExtend());
        }
    }

    private int getSelectNum() {
        int selectNum = 0;
        for (MergeInfoBean mergeInfoBean : this.mIconInfoList) {
            if (!mergeInfoBean.isShowing()) continue;
            ++selectNum;
        }
        return selectNum;
    }

    public void registerMapUpdateListener(ISweeperMapUpdateListener listener) {
        this.iSweeperMapUpdateListener = listener;
    }

    public void unregisterMapUpdateListener() {
        this.iSweeperMapUpdateListener = null;
    }

    public void refreshMap(Map<Integer, Integer> replaceColorMap) {
        if (this.iSweeperMapUpdateListener == null) {
            return;
        }
        int[][] mapArray = SweeperMapStateManager.getInstance().getDataArray();
        this.mapSize = SweeperMapStateManager.getInstance().getMapSize();
        if (this.mapSize == null) {
            return;
        }
        if (replaceColorMap == null) {
            replaceColorMap = new HashMap<Integer, Integer>();
            for (Integer color : this.selectedColorList) {
                replaceColorMap.put(color, this.getDarkerColor(color, 0.5f));
            }
        }
        int[] colors = new int[(Integer)this.mapSize.first * (Integer)this.mapSize.second];
        for (int i = 0; i < (Integer)this.mapSize.second; ++i) {
            for (int j = 0; j < (Integer)this.mapSize.first; ++j) {
                Integer replaceColor = replaceColorMap.get(mapArray[i][j]);
                colors[i * ((Integer)this.mapSize.first).intValue() + j] = replaceColor == null ? 0 : replaceColor;
            }
        }
        Bitmap bitmap = Bitmap.createBitmap((int[])colors, (int)((Integer)this.mapSize.first), (int)((Integer)this.mapSize.second), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.iSweeperMapUpdateListener.onMapUpdate(bitmap, (Integer)this.mapSize.first, (Integer)this.mapSize.second);
    }

    public void refreshMap() {
        this.refreshMap(null);
    }

    public void refreshMap(int type) {
        if (type == 6) {
            this.refreshMap(this.selectAreaMap);
        } else {
            this.refreshMap();
        }
    }

    public boolean cleanSelectedInfo() {
        if (CollectionUtils.isEmpty(this.selectedColorList) && CollectionUtils.isEmpty(this.mIconInfoList)) {
            return false;
        }
        if (!CollectionUtils.isEmpty(this.selectedColorList)) {
            this.selectedColorList.clear();
        }
        if (!CollectionUtils.isEmpty(this.mIconInfoList)) {
            this.mIconInfoList.clear();
        }
        return true;
    }

    private int getDarkerColor(int color, float darkRatio) {
        float[] hsv = new float[3];
        Color.colorToHSV((int)color, (float[])hsv);
        hsv[1] = hsv[1] + darkRatio;
        return Color.HSVToColor((float[])hsv);
    }

    public void refresh() {
    }

    public void areaSplit(float lineStartX, float lineStartY, float lineEndX, float lineEndY) {
        this.splitList.clear();
        this.splitListMatrix = null;
        this.lineStartX = lineStartX;
        this.lineStartY = lineStartY;
        this.lineEndX = lineEndX;
        this.lineEndY = lineEndY;
        if (this.mMapBitmap == null) {
            L.e((String)TAG, (String)"bitmap is null");
            this.iMapSplitView.updateLocation(0.0f, 0.0f, 0.0f, 0.0f);
            this.iMapSplitView.refresh();
            return;
        }
        if (this.isOutofBitmap(this.mMapBitmap, (int)lineStartX, (int)lineStartY) || this.isOutofBitmap(this.mMapBitmap, (int)lineEndX, (int)lineEndY)) {
            L.e((String)TAG, (String)"out of bitmap");
            this.iMapSplitView.updateLocation(0.0f, 0.0f, 0.0f, 0.0f);
            this.iMapSplitView.refresh();
            return;
        }
        int color1 = this.mMapBitmap.getPixel((int)lineStartX, (int)lineStartY);
        int color2 = this.mMapBitmap.getPixel((int)lineEndX, (int)lineEndY);
        if (this.selectedColorList.contains(color1) && this.selectedColorList.contains(color2)) {
            this.pointsInSameArea();
        } else if (this.selectedColorList.contains(color1) || this.selectedColorList.contains(color2)) {
            this.onePointInArea();
        } else {
            this.pointsNotInSameArea();
        }
    }

    public void genLineInArea() {
        int color;
        int i;
        int maxY = -1;
        int minY = -1;
        int bitmapWidth = this.mMapBitmap.getWidth();
        int bitmapHeight = this.mMapBitmap.getHeight();
        for (int i2 = 0; i2 < bitmapHeight; i2 += 4) {
            boolean hasSelectedColor = false;
            for (int j = 0; j < bitmapWidth; j += 4) {
                int color2 = this.mMapBitmap.getPixel(j, i2);
                if (!this.selectedColorList.contains(color2)) continue;
                if (minY == -1) {
                    minY = i2;
                }
                maxY = i2;
                hasSelectedColor = true;
                break;
            }
            if (maxY != -1 && minY != -1 && !hasSelectedColor) break;
        }
        if (maxY == -1 || minY == -1) {
            return;
        }
        int centerY = (maxY + minY) / 2;
        int left = -1;
        int right = -1;
        for (i = 0; i < bitmapWidth; i += 4) {
            color = this.mMapBitmap.getPixel(i, centerY);
            if (!this.selectedColorList.contains(color)) continue;
            if (left == -1) {
                left = i;
            }
            right = i;
        }
        i = left;
        while (i > 0 && this.selectedColorList.contains(color = this.mMapBitmap.getPixel(i, centerY))) {
            left = i--;
        }
        i = right;
        while (i < bitmapWidth && this.selectedColorList.contains(color = this.mMapBitmap.getPixel(i, centerY))) {
            right = i++;
        }
        if (left == -1 || right == -1) {
            return;
        }
        PointF leftPoint = new PointF((float)left, (float)centerY);
        PointF rightPoint = new PointF((float)right, (float)centerY);
        this.splitList.add(leftPoint);
        this.splitList.add(rightPoint);
        this.splitListMatrix = new Matrix(this.matrix);
        PointF firstPointF = SweeperMapStateManager.getInstance().getXYInMap(this.mapId, this.splitList.get(0));
        PointF secondPointF = SweeperMapStateManager.getInstance().getXYInMap(this.mapId, this.splitList.get(this.splitList.size() - 1));
        Point firstPoint = new Point((int)firstPointF.x, (int)firstPointF.y);
        Point secondPoint = new Point((int)secondPointF.x, (int)secondPointF.y);
        this.criticalMapPointList.add(firstPoint);
        this.criticalMapPointList.add(secondPoint);
        this.whitePoint1 = new PointF((float)left, (float)centerY);
        this.whitePoint2 = new PointF((float)right, (float)centerY);
        this.whitePointMatrix = new Matrix(this.matrix);
        this.lineStartX = this.whitePoint1.x;
        this.lineStartY = this.whitePoint1.y;
        this.lineEndX = this.whitePoint2.x;
        this.lineEndY = this.whitePoint2.y;
    }

    private void pointsInSameArea() {
        int color;
        PointF pointF;
        int i;
        float distanceY;
        float distanceX = Math.abs(this.lineEndX - this.lineStartX);
        if (distanceX < (distanceY = Math.abs(this.lineEndY - this.lineStartY))) {
            int endLocation;
            int startLocation;
            if (this.lineStartY >= this.lineEndY) {
                startLocation = (int)this.lineEndY;
                endLocation = (int)this.lineStartY;
            } else {
                startLocation = (int)this.lineStartY;
                endLocation = (int)this.lineEndY;
            }
            for (i = startLocation; i >= 0; i -= 4) {
                pointF = this.getPointOnLineByY(i);
                color = this.mMapBitmap.getPixel((int)pointF.x, (int)pointF.y);
                if (this.selectedColorList.contains(color)) continue;
                this.splitList.add(pointF);
                break;
            }
            for (i = endLocation; i <= this.mMapBitmap.getHeight(); i += 4) {
                pointF = this.getPointOnLineByY(i);
                color = this.mMapBitmap.getPixel((int)pointF.x, (int)pointF.y);
                if (this.selectedColorList.contains(color)) continue;
                this.splitList.add(pointF);
                break;
            }
        } else {
            int endLocation;
            int startLocation;
            if (this.lineStartX >= this.lineEndX) {
                startLocation = (int)this.lineEndX;
                endLocation = (int)this.lineStartX;
            } else {
                startLocation = (int)this.lineStartX;
                endLocation = (int)this.lineEndX;
            }
            for (i = startLocation; i >= 0; i -= 4) {
                pointF = this.getPointOnLineByX(i);
                color = this.mMapBitmap.getPixel((int)pointF.x, (int)pointF.y);
                if (this.selectedColorList.contains(color)) continue;
                this.splitList.add(pointF);
                break;
            }
            for (i = endLocation; i <= this.mMapBitmap.getWidth(); i += 4) {
                pointF = this.getPointOnLineByX(i);
                color = this.mMapBitmap.getPixel((int)pointF.x, (int)pointF.y);
                if (this.selectedColorList.contains(color)) continue;
                this.splitList.add(pointF);
                break;
            }
        }
        if (this.splitList.size() < 2) {
            this.splitList.clear();
            this.splitListMatrix = null;
            this.iMapSplitView.updateLocation(0.0f, 0.0f, 0.0f, 0.0f);
        } else {
            this.splitListMatrix = new Matrix(this.matrix);
            PointF firstPointF = SweeperMapStateManager.getInstance().getXYInMap(this.mapId, this.splitList.get(0));
            PointF secondPointF = SweeperMapStateManager.getInstance().getXYInMap(this.mapId, this.splitList.get(this.splitList.size() - 1));
            Point firstPoint = new Point((int)firstPointF.x, (int)firstPointF.y);
            Point secondPoint = new Point((int)secondPointF.x, (int)secondPointF.y);
            this.criticalMapPointList.add(firstPoint);
            this.criticalMapPointList.add(secondPoint);
        }
        this.iMapSplitView.refresh();
    }

    private void onePointInArea() {
        int color;
        PointF pointF;
        int i;
        float distanceX = Math.abs(this.lineEndX - this.lineStartX);
        float distanceY = Math.abs(this.lineEndY - this.lineStartY);
        int color1 = this.mMapBitmap.getPixel((int)this.lineStartX, (int)this.lineStartY);
        int color2 = this.mMapBitmap.getPixel((int)this.lineEndX, (int)this.lineEndY);
        if (distanceX < distanceY) {
            if (this.selectedColorList.contains(color1)) {
                for (i = (int)this.lineStartY; i > 0; i -= 4) {
                    pointF = this.getPointOnLineByY(i);
                    color = this.getBitmapColorWithPoint(pointF);
                    if (this.selectedColorList.contains(color)) continue;
                    this.splitList.add(pointF);
                    break;
                }
                for (i = (int)this.lineStartY; i < this.mMapBitmap.getHeight(); i += 4) {
                    pointF = this.getPointOnLineByY(i);
                    color = this.getBitmapColorWithPoint(pointF);
                    if (this.selectedColorList.contains(color)) continue;
                    this.splitList.add(pointF);
                    break;
                }
            }
            if (this.selectedColorList.contains(color2)) {
                for (i = (int)this.lineEndY; i > 0; i -= 4) {
                    pointF = this.getPointOnLineByY(i);
                    color = this.getBitmapColorWithPoint(pointF);
                    if (this.selectedColorList.contains(color)) continue;
                    this.splitList.add(pointF);
                    break;
                }
                for (i = (int)this.lineEndY; i < this.mMapBitmap.getHeight(); i += 4) {
                    pointF = this.getPointOnLineByY(i);
                    color = this.getBitmapColorWithPoint(pointF);
                    if (this.selectedColorList.contains(color)) continue;
                    this.splitList.add(pointF);
                    break;
                }
            }
        } else {
            if (this.selectedColorList.contains(color1)) {
                for (i = (int)this.lineStartX; i > 0; i -= 4) {
                    pointF = this.getPointOnLineByX(i);
                    color = this.getBitmapColorWithPoint(pointF);
                    if (this.selectedColorList.contains(color)) continue;
                    this.splitList.add(pointF);
                    break;
                }
                for (i = (int)this.lineStartX; i < this.mMapBitmap.getHeight(); i += 4) {
                    pointF = this.getPointOnLineByX(i);
                    color = this.getBitmapColorWithPoint(pointF);
                    if (this.selectedColorList.contains(color)) continue;
                    this.splitList.add(pointF);
                    break;
                }
            }
            if (this.selectedColorList.contains(color2)) {
                for (i = (int)this.lineEndX; i > 0; i -= 4) {
                    pointF = this.getPointOnLineByX(i);
                    color = this.getBitmapColorWithPoint(pointF);
                    if (this.selectedColorList.contains(color)) continue;
                    this.splitList.add(pointF);
                    break;
                }
                for (i = (int)this.lineEndX; i < this.mMapBitmap.getHeight(); i += 4) {
                    pointF = this.getPointOnLineByX(i);
                    color = this.getBitmapColorWithPoint(pointF);
                    if (this.selectedColorList.contains(color)) continue;
                    this.splitList.add(pointF);
                    break;
                }
            }
        }
        if (this.splitList.size() < 2) {
            this.splitList.clear();
            this.splitListMatrix = null;
            this.iMapSplitView.updateLocation(0.0f, 0.0f, 0.0f, 0.0f);
        } else {
            this.splitListMatrix = new Matrix(this.matrix);
            PointF firstPointF = SweeperMapStateManager.getInstance().getXYInMap(this.mapId, this.splitList.get(0));
            PointF secondPointF = SweeperMapStateManager.getInstance().getXYInMap(this.mapId, this.splitList.get(this.splitList.size() - 1));
            Point firstPoint = new Point((int)firstPointF.x, (int)firstPointF.y);
            Point secondPoint = new Point((int)secondPointF.x, (int)secondPointF.y);
            this.criticalMapPointList.add(firstPoint);
            this.criticalMapPointList.add(secondPoint);
        }
        this.iMapSplitView.refresh();
    }

    private int getBitmapColorWithPoint(PointF pointF) {
        int x = (int)pointF.x;
        int y = (int)pointF.y;
        if (x <= 0) {
            x = 1;
        }
        if (x >= this.mMapBitmap.getWidth()) {
            x = this.mMapBitmap.getWidth() - 1;
        }
        if (y <= 0) {
            y = 1;
        }
        if (y >= this.mMapBitmap.getHeight()) {
            y = this.mMapBitmap.getHeight() - 1;
        }
        return this.mMapBitmap.getPixel(x, y);
    }

    private void pointsNotInSameArea() {
        float distanceY;
        ArrayList<PointF> list = new ArrayList<PointF>();
        float distanceX = Math.abs(this.lineEndX - this.lineStartX);
        if (distanceX < (distanceY = Math.abs(this.lineEndY - this.lineStartY))) {
            int endLocation;
            int startLocation;
            if (this.lineStartY >= this.lineEndY) {
                startLocation = (int)this.lineEndY;
                endLocation = (int)this.lineStartY;
            } else {
                startLocation = (int)this.lineStartY;
                endLocation = (int)this.lineEndY;
            }
            for (int i = startLocation; i <= endLocation; i += 4) {
                list.add(this.getPointOnLineByY(i));
            }
        } else {
            int endLocation;
            int startLocation;
            if (this.lineStartX >= this.lineEndX) {
                startLocation = (int)this.lineEndX;
                endLocation = (int)this.lineStartX;
            } else {
                startLocation = (int)this.lineStartX;
                endLocation = (int)this.lineEndX;
            }
            for (int i = startLocation; i <= endLocation; i += 4) {
                list.add(this.getPointOnLineByX(i));
            }
        }
        L.d((String)TAG, (String)("list size:" + list.size() + "  "));
        this.parseColor(list);
    }

    private PointF getPointOnLineByX(float x) {
        PointF pointF = new PointF();
        pointF.x = x;
        pointF.y = (pointF.x - this.lineStartX) * (this.lineEndY - this.lineStartY) / (this.lineEndX - this.lineStartX) + this.lineStartY;
        return pointF;
    }

    private PointF getPointOnLineByY(float y) {
        PointF pointF = new PointF();
        pointF.y = y;
        pointF.x = (pointF.y - this.lineStartY) * (this.lineEndX - this.lineStartX) / (this.lineEndY - this.lineStartY) + this.lineStartX;
        return pointF;
    }

    private void parseColor(List<PointF> pointFList) {
        if (this.mMapBitmap == null) {
            L.d((String)TAG, (String)"bitmap is null");
            return;
        }
        LinkedHashMap<PointF, Integer> hashMap = new LinkedHashMap<PointF, Integer>();
        for (PointF pointF : pointFList) {
            if (this.isOutofBitmap(this.mMapBitmap, (int)pointF.x, (int)pointF.y)) continue;
            int color = this.mMapBitmap.getPixel((int)pointF.x, (int)pointF.y);
            hashMap.put(pointF, color);
        }
        L.d((String)TAG, (String)("before   hashMap size:" + hashMap.size()));
        this.findCriticalColor(hashMap);
    }

    private boolean isOutofBitmap(Bitmap bitmap, int x, int y) {
        try {
            bitmap.getPixel(x, y);
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    private void findCriticalColor(HashMap<PointF, Integer> hashMap) {
        int criticalPointNum = 0;
        Set<Map.Entry<PointF, Integer>> set = hashMap.entrySet();
        for (Map.Entry<PointF, Integer> entry : set) {
            if (entry.getValue() == 0 || !this.selectedColorList.contains(entry.getValue())) continue;
            ++criticalPointNum;
            this.splitList.add(entry.getKey());
        }
        L.d((String)TAG, (String)("after criticalList size:" + criticalPointNum + " " + this.splitList.toString()));
        if (criticalPointNum < 2) {
            this.splitList.clear();
            this.splitListMatrix = null;
            this.iMapSplitView.updateLocation(0.0f, 0.0f, 0.0f, 0.0f);
        } else {
            this.splitListMatrix = new Matrix(this.matrix);
            PointF firstPointF = SweeperMapStateManager.getInstance().getXYInMap(this.mapId, this.splitList.get(0));
            PointF secondPointF = SweeperMapStateManager.getInstance().getXYInMap(this.mapId, this.splitList.get(this.splitList.size() - 1));
            Point firstPoint = new Point((int)firstPointF.x, (int)firstPointF.y);
            Point secondPoint = new Point((int)secondPointF.x, (int)secondPointF.y);
            this.criticalMapPointList.add(firstPoint);
            this.criticalMapPointList.add(secondPoint);
        }
        this.iMapSplitView.refresh();
    }

    public void setBitMap(Bitmap bitmap) {
        this.mMapBitmap = bitmap;
    }

    public void setMatrix(Matrix matrix) {
        this.matrix = matrix;
    }
}

