/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.reactnativesweeper.view.sweepercommon;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.PointF;
import android.util.AttributeSet;
import android.view.View;
import android.widget.RelativeLayout;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.events.RCTEventEmitter;
import com.tuya.reactnativesweeper.bean.MapAreaData;
import com.tuya.reactnativesweeper.bean.RoomColorInfo;
import com.tuya.reactnativesweeper.manager.SweeperMapStateManager;
import com.tuya.reactnativesweeper.util.CollectionUtils;
import com.tuya.reactnativesweeper.util.RNComponentUtil;
import com.tuya.reactnativesweeper.view.sweepercommon.AppointView;
import com.tuya.reactnativesweeper.view.sweepercommon.map.MapSplitView;
import com.tuya.reactnativesweeper.view.sweepercommon.property.RoomPropertyView;
import com.tuya.reactnativesweeper.view.sweepercommon.sticker.StickerLayout;
import com.tuya.reactnativesweeper.view.sweepercommon.virtualwall.VirtualWallLayout;
import com.tuya.smart.android.common.utils.L;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class StateBaseMap
extends RelativeLayout {
    private final String TAG = "StateBaseMap";
    protected AtomicBoolean isAnimation = new AtomicBoolean(false);
    protected LinkedList<Runnable> pendingDrawTask = new LinkedList();
    protected String mapId = String.valueOf(System.currentTimeMillis());
    protected Context mContext;

    public StateBaseMap(Context context) {
        this(context, null);
    }

    public StateBaseMap(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public StateBaseMap(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.initView();
        this.getSweepRegionLayout().setMapId(this.mapId);
        this.getForbiddenLayout().setMapId(this.mapId);
        this.getWallLayout().setMapId(this.mapId);
        SweeperMapStateManager.getInstance().attachMap(this.mapId, this);
    }

    private void sendMapIdToRN(Context context) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (context instanceof ThemedReactContext) {
            map.put("mapId", this.mapId);
            WritableMap writableMap = RNComponentUtil.parseToWritableMap(map);
            if (this.getId() == -1) {
                return;
            }
            ((RCTEventEmitter)((ThemedReactContext)context).getJSModule(RCTEventEmitter.class)).receiveEvent(this.getId(), "onMapId", writableMap);
            L.d((String)"StateBaseMap", (String)("send mapid:" + this.mapId + " viewid:" + this.getId()));
            RNComponentUtil.sendEvent((ReactContext)((ThemedReactContext)context), "onMapId", RNComponentUtil.parseToWritableMap(map));
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        SweeperMapStateManager.getInstance().detachedMap(this.mapId);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
    }

    public void requestLayout() {
        super.requestLayout();
        this.reLayout();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
    }

    public String getMapId() {
        return this.mapId;
    }

    public void reLayout() {
        if (this.getWidth() > 0 && this.getHeight() > 0) {
            int w = View.MeasureSpec.makeMeasureSpec((int)this.getWidth(), (int)0x40000000);
            int h = View.MeasureSpec.makeMeasureSpec((int)this.getHeight(), (int)0x40000000);
            this.measure(w, h);
            this.layout(this.getPaddingLeft() + this.getLeft(), this.getPaddingTop() + this.getTop(), this.getWidth() + this.getPaddingLeft() + this.getLeft(), this.getHeight() + this.getPaddingTop() + this.getTop());
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
    }

    public abstract void initView();

    public abstract StickerLayout getSweepRegionLayout();

    public abstract StickerLayout getForbiddenLayout();

    public abstract VirtualWallLayout getWallLayout();

    public abstract MapSplitView getSplitView();

    public abstract RoomPropertyView getRoomPropertyView();

    public abstract AppointView getAppointIv();

    public abstract float getMapPreScale();

    public abstract PointF calculateInView(PointF var1);

    public abstract PointF calculateXYInMap(PointF var1);

    public PointF calculateXYInMap2(PointF pointF) {
        return null;
    }

    public PointF calculateInView2(PointF pointF) {
        return null;
    }

    public abstract boolean isInitMap();

    public void addSticker(final String color, final int state) {
        this.post(new Runnable(){

            @Override
            public void run() {
                if (state == 3) {
                    StateBaseMap.this.getForbiddenLayout().addSticker(color, state, StateBaseMap.this.getMapPreScale());
                } else {
                    StateBaseMap.this.getSweepRegionLayout().addSticker(color, state, StateBaseMap.this.getMapPreScale());
                }
            }
        });
    }

    public void addVirtualWall(String color) {
        this.getWallLayout().addVirtualWallVisible(color, this.getMapPreScale());
    }

    public void addAppointView(float x, float y) {
        this.getAppointIv().addPoint(x, y, true, this.getMapPreScale());
    }

    public void removeAppoint() {
        this.post(new Runnable(){

            @Override
            public void run() {
                StateBaseMap.this.getAppointIv().remove();
            }
        });
    }

    public void removeSweeperRegion() {
        this.post(new Runnable(){

            @Override
            public void run() {
                StateBaseMap.this.getSweepRegionLayout().removeAllSticker(2);
            }
        });
    }

    public void removeForbiddenArea() {
        this.post(new Runnable(){

            @Override
            public void run() {
                StateBaseMap.this.getForbiddenLayout().removeAllSticker(3);
            }
        });
    }

    public void drawAppoint(final PointF pointF) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                if (null == pointF) {
                    StateBaseMap.this.getAppointIv().remove();
                    return;
                }
                PointF pointInView = StateBaseMap.this.calculateInView(pointF);
                StateBaseMap.this.getAppointIv().addPoint(pointInView.x, pointInView.y, false, StateBaseMap.this.getMapPreScale());
            }
        };
        if (this.isAnimation.get()) {
            L.w((String)"LaserMapView", (String)"drawAppoint add pending ---");
            this.pendingDrawTask.add(task);
        } else {
            this.post(task);
        }
    }

    public void updateArea(final int state, final MapAreaData mapAreaData) {
        if (null == mapAreaData) {
            return;
        }
        Runnable task = new Runnable(){

            @Override
            public void run() {
                if (mapAreaData.getPoints() != null) {
                    List<PointF> viewPointList = StateBaseMap.this.convertPointsListInView(mapAreaData.getPoints());
                    mapAreaData.setPoints(viewPointList);
                }
                if (state == 2) {
                    StateBaseMap.this.getSweepRegionLayout().updateAreaInfo(mapAreaData);
                } else if (state == 3) {
                    StateBaseMap.this.getForbiddenLayout().updateAreaInfo(mapAreaData);
                }
            }
        };
        if (this.isAnimation.get()) {
            L.w((String)"LaserMapView", (String)"drawVirtualWall add pending ---");
            this.pendingDrawTask.add(task);
        } else {
            this.post(task);
        }
    }

    public void addArea(final MapAreaData mapAreaData) {
        if (null == mapAreaData) {
            return;
        }
        Runnable task = new Runnable(){

            @Override
            public void run() {
                MapAreaData data = mapAreaData.clone();
                List<PointF> viewPointList = StateBaseMap.this.convertPointsListInView(mapAreaData.getPoints());
                data.setPoints(viewPointList);
                if (mapAreaData.getType() == 2) {
                    StateBaseMap.this.getSweepRegionLayout().addArea(data, StateBaseMap.this.getMapPreScale(), false, true);
                } else if (mapAreaData.getType() == 3) {
                    StateBaseMap.this.getForbiddenLayout().addArea(data, StateBaseMap.this.getMapPreScale(), true, true);
                } else if (mapAreaData.getType() == 4) {
                    StateBaseMap.this.getWallLayout().addVirtualWall(data, StateBaseMap.this.getMapPreScale(), true);
                }
            }
        };
        if (this.isAnimation.get()) {
            L.w((String)"LaserMapView", (String)"drawVirtualWall add pending ---");
            this.pendingDrawTask.add(task);
        } else {
            this.post(task);
        }
    }

    public void addAreaList(List<MapAreaData> areaDataList) {
        if (areaDataList == null) {
            return;
        }
        ArrayList<MapAreaData> appointList = new ArrayList<MapAreaData>();
        ArrayList<MapAreaData> virtualWallList = new ArrayList<MapAreaData>();
        ArrayList<MapAreaData> sweepAreaList = new ArrayList<MapAreaData>();
        ArrayList<MapAreaData> forbiddenList = new ArrayList<MapAreaData>();
        for (MapAreaData mapAreaData : areaDataList) {
            switch (mapAreaData.getType()) {
                case 1: {
                    appointList.add(mapAreaData);
                    break;
                }
                case 3: {
                    forbiddenList.add(mapAreaData);
                    break;
                }
                case 2: {
                    sweepAreaList.add(mapAreaData);
                    break;
                }
                case 4: {
                    virtualWallList.add(mapAreaData);
                }
            }
        }
        this.addAreaList(appointList, 1);
        this.addAreaList(virtualWallList, 4);
        this.addAreaList(sweepAreaList, 2);
        this.addAreaList(forbiddenList, 3);
    }

    public void addAreaList(final List<MapAreaData> areaDataList, final int state) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                ArrayList<MapAreaData> pointsOnViewDataList = new ArrayList<MapAreaData>();
                for (MapAreaData mapAreaData : areaDataList) {
                    MapAreaData data = mapAreaData.clone();
                    List<PointF> viewPointList = StateBaseMap.this.convertPointsListInView(mapAreaData.getPoints());
                    data.setPoints(viewPointList);
                    pointsOnViewDataList.add(data);
                }
                L.d((String)"StateBaseMap", (String)("pointsOnViewDataList:" + ((Object)pointsOnViewDataList).toString()));
                if (state == 2) {
                    StateBaseMap.this.getSweepRegionLayout().removeAllSticker(state);
                    StateBaseMap.this.getSweepRegionLayout().addAreaList(pointsOnViewDataList, StateBaseMap.this.getMapPreScale(), false);
                } else if (state == 3) {
                    StateBaseMap.this.getForbiddenLayout().removeAllSticker(state);
                    StateBaseMap.this.getForbiddenLayout().addAreaList(pointsOnViewDataList, StateBaseMap.this.getMapPreScale(), false);
                } else if (state == 4) {
                    StateBaseMap.this.getWallLayout().removeAllWall();
                    StateBaseMap.this.getWallLayout().addVirtualWallList(pointsOnViewDataList, StateBaseMap.this.getMapPreScale());
                } else if (state == 1) {
                    if (areaDataList.size() > 0) {
                        StateBaseMap.this.drawAppoint(((MapAreaData)areaDataList.get(0)).getPoints().get(0));
                    } else {
                        StateBaseMap.this.drawAppoint(null);
                    }
                }
            }
        };
        if (this.isAnimation.get()) {
            L.w((String)"LaserMapView", (String)"drawVirtualWall add pending ---");
            this.pendingDrawTask.add(task);
        } else {
            this.post(task);
        }
    }

    private void addVirtual(int state, List<MapAreaData> areaDataList, boolean isEdit) {
        for (MapAreaData mapAreaData : areaDataList) {
            MapAreaData data = mapAreaData.clone();
            List<PointF> viewPointList = this.convertPointsListInView(mapAreaData.getPoints());
            data.setPoints(viewPointList);
            if (state == 2) {
                this.getSweepRegionLayout().addArea(data, this.getMapPreScale(), false, isEdit);
                continue;
            }
            if (state == 3) {
                this.getForbiddenLayout().addArea(data, this.getMapPreScale(), false, isEdit);
                continue;
            }
            if (state != 4) continue;
            this.getWallLayout().addVirtualWall(data, this.getMapPreScale(), isEdit);
        }
    }

    public void removeAllWall() {
        this.getWallLayout().removeAllWall();
    }

    public List<List<PointF>> getVirtualWallPoint() {
        return this.convertPointInMap(this.getWallLayout().getPointInfo());
    }

    public List<List<PointF>> getForbiddenZonePoint() {
        return this.convertPointInMap(this.getForbiddenLayout().getPointInfo(3));
    }

    public List<List<PointF>> getSweepRegionPoint() {
        return this.convertPointInMap(this.getSweepRegionLayout().getPointInfo(2));
    }

    public List<PointF> getPointsInMap(List<PointF> list) {
        if (list == null) {
            return null;
        }
        ArrayList<PointF> mapPointList = new ArrayList<PointF>();
        for (PointF pointF : list) {
            mapPointList.add(this.calculateXYInMap(pointF));
        }
        return mapPointList;
    }

    public List<PointF> getAppointPoint() {
        PointF currentPoint = this.getAppointIv().getCurrentPoint();
        if (null == currentPoint) {
            return null;
        }
        PointF pointInMap = this.calculateXYInMap(currentPoint);
        ArrayList<PointF> pointList = new ArrayList<PointF>();
        pointList.add(pointInMap);
        return pointList;
    }

    public HashMap<String, RoomColorInfo> getRoomInfo() {
        return this.getRoomPropertyView().getRoomInfo();
    }

    private List<List<PointF>> convertPointInMap(List<List<PointF>> pointList) {
        if (CollectionUtils.isEmpty(pointList)) {
            return null;
        }
        ArrayList<List<PointF>> finalList = new ArrayList<List<PointF>>();
        for (List<PointF> pointInViewList : pointList) {
            ArrayList<PointF> tempList = new ArrayList<PointF>();
            for (PointF pointF : pointInViewList) {
                PointF pointInMap = this.calculateXYInMap(pointF);
                tempList.add(pointInMap);
            }
            finalList.add(tempList);
        }
        return finalList;
    }

    public List<PointF> convertPointsListInView(List<PointF> pointList) {
        if (CollectionUtils.isEmpty(pointList)) {
            return null;
        }
        ArrayList<PointF> finalList = new ArrayList<PointF>();
        for (PointF pointF : pointList) {
            PointF pointInMap = this.calculateInView(pointF);
            finalList.add(pointInMap);
        }
        return finalList;
    }

    public List<PointF> convertPointsListInViewWithoutOriginPoint(List<PointF> pointList) {
        if (CollectionUtils.isEmpty(pointList)) {
            return null;
        }
        ArrayList<PointF> finalList = new ArrayList<PointF>();
        for (PointF pointF : pointList) {
            PointF pointInMap = this.calculateInView2(pointF);
            finalList.add(pointInMap);
        }
        return finalList;
    }

    private List<List<PointF>> convertPointInView(List<List<PointF>> pointList) {
        if (CollectionUtils.isEmpty(pointList)) {
            return null;
        }
        ArrayList<List<PointF>> finalList = new ArrayList<List<PointF>>();
        for (List<PointF> pointInViewList : pointList) {
            ArrayList<PointF> tempList = new ArrayList<PointF>();
            for (PointF pointF : pointInViewList) {
                PointF pointInMap = this.calculateInView(pointF);
                tempList.add(pointInMap);
            }
            finalList.add(tempList);
        }
        return finalList;
    }

    protected void dequeuePendingTask() {
        if (this.pendingDrawTask.isEmpty()) {
            return;
        }
        this.post(this.pendingDrawTask.poll());
        this.dequeuePendingTask();
    }
}

