/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.reactnativesweeper.view.sweepercommon;

import android.graphics.Color;
import android.text.TextUtils;
import android.util.Pair;
import com.tuya.reactnativesweeper.bean.RoomColorInfo;
import com.tuya.reactnativesweeper.util.CollectionUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SelectAreaUtil {
    public static String DEFAULTSELECTEDKEY = "defaultSelected";
    public static String NORMALCOLORKEY = "normalColor";
    public static String HIGHLIGHTCOLORKEY = "highlightColor";

    public static List<Integer> generateMapDataWithRoomInfo(List<Integer> data, HashMap<String, String> roomIdColorMap, HashMap<String, HashMap> roomInfo) {
        if (roomIdColorMap == null || roomInfo == null || CollectionUtils.isEmpty(data)) {
            return data;
        }
        ArrayList<Integer> ret = new ArrayList<Integer>(data.size());
        for (int i = 0; i < data.size(); ++i) {
            String roomId = SelectAreaUtil.getRoomIdWithColor(data.get(i), roomIdColorMap);
            if (TextUtils.isEmpty((CharSequence)roomId)) {
                ret.set(i, data.get(i));
                continue;
            }
            HashMap oneRoomInfo = roomInfo.get(roomId);
            boolean defaultSelected = (Boolean)oneRoomInfo.get(DEFAULTSELECTEDKEY);
            String normalColor = (String)oneRoomInfo.get(NORMALCOLORKEY);
            String highlightColor = (String)oneRoomInfo.get(HIGHLIGHTCOLORKEY);
            int normalColorValue = Color.parseColor((String)normalColor);
            int highlightColorValue = Color.parseColor((String)highlightColor);
            ret.set(i, defaultSelected ? highlightColorValue : normalColorValue);
        }
        return ret;
    }

    public static String getRoomIdWithColor(int color, HashMap<String, String> roomIdColorMap) {
        for (Map.Entry<String, String> entry : roomIdColorMap.entrySet()) {
            if (entry.getValue() == null || Color.parseColor((String)entry.getValue()) != color) continue;
            return entry.getKey();
        }
        return null;
    }

    public static Pair<String, RoomColorInfo> getRoomIdByColor(int color, Map<String, RoomColorInfo> roomColorInfoMap) {
        if (roomColorInfoMap == null) {
            return null;
        }
        Set<Map.Entry<String, RoomColorInfo>> set = roomColorInfoMap.entrySet();
        for (Map.Entry<String, RoomColorInfo> entry : set) {
            if (Color.parseColor((String)entry.getValue().getNormalColor()) != color) continue;
            return new Pair((Object)entry.getKey(), (Object)entry.getValue());
        }
        return null;
    }

    public static Map<Integer, Integer> getSelectAreaColorMap(HashMap<String, RoomColorInfo> roomColorInfoHashMap) {
        if (roomColorInfoHashMap == null) {
            return new HashMap<Integer, Integer>();
        }
        Set<Map.Entry<String, RoomColorInfo>> set = roomColorInfoHashMap.entrySet();
        Iterator<Map.Entry<String, RoomColorInfo>> iterator = set.iterator();
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        while (iterator.hasNext()) {
            Map.Entry<String, RoomColorInfo> entry = iterator.next();
            if (!entry.getValue().isDefaultSelected()) continue;
            map.put(Color.parseColor((String)entry.getValue().getNormalColor()), Color.parseColor((String)entry.getValue().getHighlightColor()));
        }
        return map;
    }

    public static Integer getHightLightColor(int color, HashMap<String, RoomColorInfo> roomColorInfoHashMap) {
        Set<Map.Entry<String, RoomColorInfo>> set = roomColorInfoHashMap.entrySet();
        for (Map.Entry<String, RoomColorInfo> entry : set) {
            if (Color.parseColor((String)entry.getValue().getNormalColor()) != color) continue;
            return Color.parseColor((String)entry.getValue().getHighlightColor());
        }
        return null;
    }

    public static Map<Integer, Integer> getAllSelectColorMap(HashMap<String, RoomColorInfo> roomColorInfoHashMap) {
        Set<Map.Entry<String, RoomColorInfo>> set = roomColorInfoHashMap.entrySet();
        Iterator<Map.Entry<String, RoomColorInfo>> iterator = set.iterator();
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        while (iterator.hasNext()) {
            Map.Entry<String, RoomColorInfo> entry = iterator.next();
            map.put(Color.parseColor((String)entry.getValue().getNormalColor()), Color.parseColor((String)entry.getValue().getHighlightColor()));
        }
        return map;
    }
}

