/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.reactnativesweeper.util;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import androidx.annotation.RequiresApi;

public class BitmapUtil {
    public static Bitmap getBitmap(Resources resources, int resId) {
        return BitmapUtil.drawableToBitmap(resources.getDrawable(resId), 0, 0);
    }

    public static Bitmap getBitmapFormColor(String color, int width, int height) {
        return BitmapUtil.drawableToBitmap((Drawable)BitmapUtil.getShapeDrawable(color), width, height);
    }

    public static Bitmap getBitmap(Bitmap bitmap, float width, float height) {
        if (null == bitmap) {
            return null;
        }
        if (width <= 0.0f || height <= 0.0f) {
            return bitmap;
        }
        Matrix matrix = new Matrix();
        matrix.postScale(width / (float)bitmap.getWidth(), height / (float)bitmap.getHeight());
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
    }

    private static Bitmap drawableToBitmap(Drawable drawable2, int width, int height) {
        if (drawable2 instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable2).getBitmap();
        }
        Bitmap bitmap = Bitmap.createBitmap((int)(width <= 0 ? drawable2.getIntrinsicWidth() : width), (int)(height <= 0 ? drawable2.getIntrinsicHeight() : height), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable2.draw(canvas);
        return bitmap;
    }

    private static GradientDrawable getShapeDrawable(String color) {
        GradientDrawable drawable2 = new GradientDrawable();
        drawable2.setColor(Color.parseColor((String)color));
        return drawable2;
    }

    public static Bitmap getBitmapByRes(Resources resources, int resId, float width, float height) {
        BitmapFactory.Options bmpFactoryOptions = new BitmapFactory.Options();
        bmpFactoryOptions.inJustDecodeBounds = true;
        BitmapFactory.decodeResource((Resources)resources, (int)resId, (BitmapFactory.Options)bmpFactoryOptions);
        int heightRatio = (int)Math.ceil((float)bmpFactoryOptions.outHeight / height);
        int widthRatio = (int)Math.ceil((float)bmpFactoryOptions.outWidth / width);
        if (heightRatio > 1 && widthRatio > 1) {
            bmpFactoryOptions.inSampleSize = heightRatio > widthRatio ? heightRatio : widthRatio;
        }
        bmpFactoryOptions.inJustDecodeBounds = false;
        return BitmapFactory.decodeResource((Resources)resources, (int)resId, (BitmapFactory.Options)bmpFactoryOptions);
    }

    @RequiresApi(api=26)
    public static String colorToHexValue(Color color) {
        return BitmapUtil.intToHexValue((int)color.alpha()) + BitmapUtil.intToHexValue((int)color.red()) + BitmapUtil.intToHexValue((int)color.green()) + BitmapUtil.intToHexValue((int)color.blue());
    }

    private static String intToHexValue(int number) {
        String result = Integer.toHexString(number & 0xFF);
        while (result.length() < 2) {
            result = "0" + result;
        }
        return result.toUpperCase();
    }
}

