/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.reactnativesweeper.manager;

import android.graphics.Bitmap;
import android.graphics.PointF;
import android.text.TextUtils;
import android.util.Pair;
import android.view.View;
import com.tuya.reactnativesweeper.bean.MapAppointBean;
import com.tuya.reactnativesweeper.bean.MapAreaBoxBean;
import com.tuya.reactnativesweeper.bean.MapAreaData;
import com.tuya.reactnativesweeper.bean.MapLineBean;
import com.tuya.reactnativesweeper.bean.MapPointsData;
import com.tuya.reactnativesweeper.bean.MapRoomOrderBean;
import com.tuya.reactnativesweeper.bean.MapSplitData;
import com.tuya.reactnativesweeper.bean.MapTypeAreaBean;
import com.tuya.reactnativesweeper.bean.RoomColorInfo;
import com.tuya.reactnativesweeper.util.CollectionUtils;
import com.tuya.reactnativesweeper.view.sweepercommon.ISweeperMapView;
import com.tuya.reactnativesweeper.view.sweepercommon.StateBaseMap;
import com.tuya.reactnativesweeper.view.sweepercommon.map.ISweeperDataObserver;
import com.tuya.reactnativesweeper.view.sweepercommon.map.ISweeperMapSplitView;
import com.tuya.reactnativesweeper.view.sweepercommon.map.ISweeperTypeData;
import com.tuya.smart.android.common.utils.L;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class SweeperMapStateManager
implements ISweeperMapView {
    private static volatile SweeperMapStateManager instance;
    private static final String TAG;
    private StateBaseMap mMainMap;
    private List<StateBaseMap> mMapList;
    private Map<View, Boolean> mLaserEditMap;
    private Map<String, StateBaseMap> mSweeperViewMap;
    private Map<String, List<MapAreaData>> mAreaDataMap;
    private Map<String, Boolean> mEditRecordMap;
    private Map<String, Integer> mStateRecordMap;
    private String mSweepRegionColor;
    private String mVirtualAreaColor;
    private String mVirtualWallColor;
    private Bitmap appointIcon;
    private float globalStrokeWidth;
    private float minAreaWidth;
    private boolean isMapType;
    private List<List<PointF>> mSweepRegionList;
    private List<List<PointF>> mVirtualAreaList;
    private List<List<PointF>> mVirtualWallList;
    private PointF mAppoint;
    private int mState;
    private int[][] dataArray;
    private Pair<Integer, Integer> mapSize;
    private HashMap<String, Object> zoomFactor;
    private CopyOnWriteArrayList<SweeperStateListener> sweeperStateListener = new CopyOnWriteArrayList();
    private boolean isRotate = false;
    private int mapSplitType = 0;
    private CopyOnWriteArrayList<ISweeperMapSplitView> iSweeperMapView;
    private float scale;
    private PointF scalePoint;
    private HashMap<String, String> pointTypeColorMap;
    private HashMap<String, String> roomIdColorMap;
    private HashMap<String, HashMap<String, RoomColorInfo>> roomInfo = new HashMap();
    private CopyOnWriteArrayList<LaserMapRefreshListener> mapRefreshListeners;
    private ConcurrentHashMap<String, HashMap<Integer, ISweeperTypeData>> iSweeperTypeDataMap;
    private CopyOnWriteArrayList<ISweeperDataObserver> iSweeperDataObservers;
    private HashMap<String, HashMap<String, Object>> mAttributeMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SweeperMapStateManager getInstance() {
        if (null != instance) return instance;
        Class<SweeperMapStateManager> clazz = SweeperMapStateManager.class;
        synchronized (SweeperMapStateManager.class) {
            if (null != instance) return instance;
            instance = new SweeperMapStateManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private SweeperMapStateManager() {
        this.mLaserEditMap = new HashMap<View, Boolean>();
        this.mMapList = new ArrayList<StateBaseMap>();
        this.mSweeperViewMap = new HashMap<String, StateBaseMap>();
        this.mStateRecordMap = new HashMap<String, Integer>();
        this.mAreaDataMap = new HashMap<String, List<MapAreaData>>();
        this.mEditRecordMap = new HashMap<String, Boolean>();
        this.mapRefreshListeners = new CopyOnWriteArrayList();
        this.iSweeperMapView = new CopyOnWriteArrayList();
        this.iSweeperTypeDataMap = new ConcurrentHashMap();
        this.mAttributeMap = new HashMap();
        this.iSweeperDataObservers = new CopyOnWriteArrayList();
    }

    public void setZoomFactor(HashMap<String, Object> zoomFactor) {
        this.zoomFactor = zoomFactor;
    }

    public void setGlobalStrokeWidth(float width) {
        this.globalStrokeWidth = width;
    }

    public float getGlobalStrokeWidth() {
        return this.globalStrokeWidth;
    }

    public HashMap<String, Object> getZoomFactor() {
        return this.zoomFactor;
    }

    public Bitmap getAppointIcon() {
        return this.appointIcon;
    }

    public void setAppointIcon(Bitmap appointIcon) {
        this.appointIcon = appointIcon;
    }

    public String getSweepRegionColor() {
        return this.mSweepRegionColor;
    }

    public String getVirtualAreaColor() {
        return this.mVirtualAreaColor;
    }

    public String getVirtualWallColor() {
        return this.mVirtualWallColor;
    }

    public void setSplitColor(String mapId, String color) {
        HashMap<String, Object> attribute = this.mAttributeMap.get(mapId);
        if (attribute != null) {
            attribute.put("split_color", color);
            for (ISweeperDataObserver observer : this.iSweeperDataObservers) {
                observer.onSplitColorChanaged(mapId, color);
            }
        } else {
            L.e((String)TAG, (String)("setSplitColor mapid :" + mapId + "not exist in cache"));
        }
    }

    public String getSplitColor(String mapId) {
        HashMap<String, Object> attribute = this.mAttributeMap.get(mapId);
        if (attribute == null) {
            return null;
        }
        Object color = attribute.get("split_color");
        if (color == null) {
            return "";
        }
        return (String)color;
    }

    public boolean isMainMap(View map) {
        return map == this.mMainMap;
    }

    public void setEdit(String mapId, boolean isEdit) {
        L.i((String)TAG, (String)("setEdit mapId=" + mapId + " edit=" + isEdit));
        this.mEditRecordMap.put(mapId, isEdit);
    }

    public boolean isEdit(String mapId) {
        if (TextUtils.isEmpty((CharSequence)mapId)) {
            return false;
        }
        Boolean editBoolean = this.mEditRecordMap.get(mapId);
        if (null == editBoolean) {
            return false;
        }
        return editBoolean;
    }

    public void attachMap(String mapId, StateBaseMap map) {
        if (TextUtils.isEmpty((CharSequence)mapId) || null == map) {
            return;
        }
        if (this.mSweeperViewMap.size() == 0) {
            this.mMainMap = map;
        }
        this.mSweeperViewMap.put(mapId, map);
        this.mAttributeMap.put(mapId, new HashMap());
    }

    public void detachedMap(String mapId) {
        if (TextUtils.isEmpty((CharSequence)mapId)) {
            return;
        }
        this.mSweeperViewMap.remove(mapId);
        if (this.mSweeperViewMap.size() == 0) {
            this.mMainMap = null;
            this.release();
        }
    }

    public void release() {
        if (null != this.appointIcon && !this.appointIcon.isRecycled()) {
            this.appointIcon.recycle();
            this.appointIcon = null;
        }
        instance = null;
    }

    public void registerMapSplitDataChannel(ISweeperMapSplitView iSweeperMapView) {
        if (!this.iSweeperMapView.contains(iSweeperMapView)) {
            this.iSweeperMapView.add(iSweeperMapView);
        }
    }

    public void unRegisterMapSplitDataChannel(ISweeperMapSplitView iSweeperMapSplitView) {
        if (this.iSweeperMapView != null) {
            this.iSweeperMapView.remove(iSweeperMapSplitView);
        }
    }

    public void setState(boolean isMainMap, String mapId, int state) {
        if (isMainMap && null != this.mMainMap) {
            mapId = this.mMainMap.getMapId();
        }
        if (TextUtils.isEmpty((CharSequence)mapId)) {
            return;
        }
        L.i((String)TAG, (String)("setState mapId=" + mapId + " state=" + state));
        this.mStateRecordMap.put(mapId, state);
        for (SweeperStateListener listener : this.sweeperStateListener) {
            listener.onStateChanged(mapId, state);
        }
    }

    public void setState(boolean isMainMap, String mapId, int state, boolean isEdit) {
        if (TextUtils.isEmpty((CharSequence)mapId) && isMainMap && null != this.mMainMap) {
            mapId = this.mMainMap.getMapId();
        }
        L.i((String)TAG, (String)("setState mapId=" + mapId + " state=" + state + " isEdit:" + isEdit));
        this.mStateRecordMap.put(mapId, state);
        this.setEdit(mapId, isEdit);
        for (SweeperStateListener listener : this.sweeperStateListener) {
            listener.onStateChanged(mapId, state);
        }
    }

    public void registerStateListener(SweeperStateListener listener) {
        if (!this.sweeperStateListener.contains(listener)) {
            this.sweeperStateListener.add(listener);
        }
    }

    public void unRegisterStateListener(SweeperStateListener listener) {
        if (this.sweeperStateListener.contains(listener)) {
            this.sweeperStateListener.remove(listener);
        }
    }

    public MapPointsData getTypePointsInfo() {
        if (null == this.mMainMap) {
            return null;
        }
        if (!this.mMainMap.isInitMap()) {
            L.w((String)TAG, (String)"Map not init getTypePointsInfo do nothing");
            return null;
        }
        int state = this.getState(this.mMainMap.getMapId());
        switch (state) {
            case 4: {
                MapPointsData<List<PointF>> typePointData = new MapPointsData<List<PointF>>();
                typePointData.setData(this.transformPointList(this.mMainMap.getVirtualWallPoint()));
                typePointData.setType(state);
                return typePointData;
            }
            case 3: {
                MapPointsData<List<PointF>> forbiddenZoneData = new MapPointsData<List<PointF>>();
                forbiddenZoneData.setData(this.transformPointList(this.mMainMap.getForbiddenZonePoint()));
                forbiddenZoneData.setType(state);
                return forbiddenZoneData;
            }
            case 2: {
                MapPointsData<List<PointF>> sweepRegionData = new MapPointsData<List<PointF>>();
                sweepRegionData.setData(this.transformPointList(this.mMainMap.getSweepRegionPoint()));
                sweepRegionData.setType(state);
                return sweepRegionData;
            }
            case 1: {
                MapPointsData<PointF> appointPointData = new MapPointsData<PointF>();
                appointPointData.setData(this.transformPoint(this.mMainMap.getAppointPoint()));
                appointPointData.setType(state);
                return appointPointData;
            }
        }
        return null;
    }

    public MapTypeAreaBean getMapPointsInfo(String mapId) {
        StateBaseMap stateBaseMap = this.mSweeperViewMap.get(mapId);
        if (stateBaseMap == null) {
            return null;
        }
        int state = this.getState(stateBaseMap.getMapId());
        MapTypeAreaBean mapTypeAreaBean = null;
        switch (state) {
            case 3: {
                mapTypeAreaBean = stateBaseMap.getForbiddenLayout().getMapAreaInfo(3);
                break;
            }
            case 2: {
                mapTypeAreaBean = stateBaseMap.getSweepRegionLayout().getMapAreaInfo(2);
                break;
            }
            case 4: {
                mapTypeAreaBean = stateBaseMap.getWallLayout().getVirtualWallInfo();
                break;
            }
            case 1: {
                mapTypeAreaBean = new MapTypeAreaBean();
                mapTypeAreaBean.setType(1);
                MapTypeAreaBean.DataBean dataBean = new MapTypeAreaBean.DataBean();
                dataBean.setId("appoint_0");
                dataBean.setPoints(this.transformPoint(this.mMainMap.getAppointPoint()));
                ArrayList<MapTypeAreaBean.DataBean> list = new ArrayList<MapTypeAreaBean.DataBean>();
                list.add(dataBean);
                mapTypeAreaBean.setData(list);
                break;
            }
            case 6: {
                ISweeperTypeData iSweeperTypeData = this.iSweeperTypeDataMap.get(mapId).get(6);
                if (iSweeperTypeData != null) {
                    mapTypeAreaBean = iSweeperTypeData.getMapTypeData(mapId, 6);
                    break;
                }
                L.e((String)TAG, (String)"MAP_SPILIT_CLEAN interface is null");
                break;
            }
            default: {
                return null;
            }
        }
        if (mapTypeAreaBean == null) {
            return null;
        }
        if (mapTypeAreaBean.getData() != null && mapTypeAreaBean.getType() != 1) {
            for (MapTypeAreaBean.DataBean dataBean : mapTypeAreaBean.getData()) {
                dataBean.setPoints(this.transformPoint(stateBaseMap.getPointsInMap(dataBean.getPoints())));
            }
        }
        return mapTypeAreaBean;
    }

    public MapAppointBean getAppointInfo(String mapId) {
        StateBaseMap stateBaseMap = this.mSweeperViewMap.get(mapId);
        if (stateBaseMap == null) {
            return null;
        }
        int state = this.getState(stateBaseMap.getMapId());
        if (state == 1) {
            MapAppointBean mapAppointBean = new MapAppointBean();
            mapAppointBean.setType(1);
            MapAppointBean.DataBean dataBean = new MapAppointBean.DataBean();
            dataBean.setId("appoint_0");
            if (this.mMainMap.getAppointPoint() != null) {
                dataBean.setPoints(this.transformPoint(this.mMainMap.getAppointPoint().get(0)));
            }
            ArrayList<MapAppointBean.DataBean> list = new ArrayList<MapAppointBean.DataBean>();
            list.add(dataBean);
            mapAppointBean.setData(list);
            return mapAppointBean;
        }
        return null;
    }

    public MapRoomOrderBean getRoomOrderInfo(String mapId) {
        StateBaseMap stateBaseMap = this.mSweeperViewMap.get(mapId);
        if (stateBaseMap == null) {
            return null;
        }
        int state = this.getState(stateBaseMap.getMapId());
        if (state == 6) {
            MapRoomOrderBean mapRoomOrderBean = new MapRoomOrderBean();
            mapRoomOrderBean.setType(6);
            HashMap<String, RoomColorInfo> roomInfo = stateBaseMap.getRoomInfo();
            ArrayList<MapRoomOrderBean.DataBean> list = new ArrayList<MapRoomOrderBean.DataBean>();
            if (roomInfo != null && roomInfo.size() > 0) {
                ArrayList<String> keys = new ArrayList<String>(roomInfo.keySet());
                for (String key : keys) {
                    MapRoomOrderBean.DataBean dataBean = new MapRoomOrderBean.DataBean();
                    RoomColorInfo roomColorInfo = roomInfo.get(key);
                    if (roomColorInfo == null || roomColorInfo.getDefaultOrder() <= 0) continue;
                    dataBean.setOrder(roomColorInfo.getDefaultOrder());
                    dataBean.setPixel(key);
                    dataBean.setExtend(roomColorInfo.getExtend());
                    list.add(dataBean);
                }
            }
            mapRoomOrderBean.setData(list);
            return mapRoomOrderBean;
        }
        return null;
    }

    public void addLaserMapRectWithType(int state) {
        if (null == this.mMainMap) {
            return;
        }
        if (!this.mMainMap.isInitMap()) {
            L.w((String)TAG, (String)"Map not init addLaserMapRectWithType do nothing");
            return;
        }
        switch (state) {
            case 2: {
                this.mMainMap.addSticker(this.mSweepRegionColor, state);
                break;
            }
            case 3: {
                this.mMainMap.addSticker(this.mVirtualAreaColor, state);
                break;
            }
            case 4: {
                this.mMainMap.addVirtualWall(this.mVirtualWallColor);
                break;
            }
            case 5: {
                this.mMainMap.addVirtualWall(this.mVirtualWallColor);
                break;
            }
        }
    }

    public int getState(String mapId) {
        if (TextUtils.isEmpty((CharSequence)mapId)) {
            return 0;
        }
        Integer stateInteger = this.mStateRecordMap.get(mapId);
        if (null == stateInteger) {
            return 0;
        }
        return stateInteger;
    }

    public void setMapSplitType(String mapId, int type) {
        L.d((String)TAG, (String)("map split type:" + type));
        this.mapSplitType = type;
        HashMap<String, Object> attribute = this.mAttributeMap.get(mapId);
        if (attribute == null) {
            L.e((String)TAG, (String)("setMapSplitType mapId :" + mapId + " not exist in Cache"));
            return;
        }
        attribute.put("split_type", type);
        if (this.iSweeperMapView != null) {
            for (ISweeperMapSplitView iSweeperMapSplitView : this.iSweeperMapView) {
                iSweeperMapSplitView.updateSplitType(mapId, type);
            }
        }
    }

    public int getMapSplitType(String mapId) {
        HashMap<String, Object> attribute = this.mAttributeMap.get(mapId);
        if (attribute == null) {
            return 0;
        }
        Object type = attribute.get("split_type");
        if (type == null) {
            return 0;
        }
        return (Integer)type;
    }

    public void addAppoint(StateBaseMap stateBaseMap, float x, float y) {
        if (null == stateBaseMap) {
            return;
        }
        if (!stateBaseMap.isInitMap()) {
            L.w((String)TAG, (String)"Map not init addAppoint do nothing");
            return;
        }
        int state = this.getState(stateBaseMap.getMapId());
        if (state != 1) {
            L.w((String)TAG, (String)("state is " + state + " addAppoint do nothing"));
            return;
        }
        if (!this.isEdit(stateBaseMap.getMapId())) {
            L.w((String)TAG, (String)"main map is not edit mode so addAppoint do nothing");
            return;
        }
        if (null == this.appointIcon) {
            L.w((String)TAG, (String)"addAppoint Icon null  addAppoint do nothing");
            return;
        }
        this.mMainMap.addAppointView(x, y);
    }

    public void drawAllStateView(boolean isForce) {
        if (this.mMainMap == null) {
            L.e((String)TAG, (String)"main map is null");
            return;
        }
        String mapId = this.mMainMap.getMapId();
        if (this.isEdit(mapId) && !isForce) {
            L.w((String)TAG, (String)"drawAllStateView  mainMap is editing draw nothing ");
            return;
        }
        this.addAreaViewList(mapId, 2);
        this.addAreaViewList(mapId, 3);
        this.addAreaViewList(mapId, 4);
        if (this.mAppoint != null) {
            this.drawAppointView(mapId, this.mAppoint);
        } else {
            this.addAreaViewList(mapId, 1);
        }
    }

    public void drawAllStateView(String mapId) {
        L.d((String)TAG, (String)("drawAllStateView mapId:" + mapId));
        this.drawAllStateView(mapId, false);
    }

    public void drawAllStateView(String mapId, boolean isForce) {
        L.d((String)TAG, (String)("drawAllStateView mapId:" + mapId + " isForce:" + isForce));
        if (TextUtils.isEmpty((CharSequence)mapId)) {
            return;
        }
        if (!isForce && (!this.isMapType ? this.getState(mapId) != 0 : this.getState(mapId) != 0 && this.isEdit(mapId))) {
            return;
        }
        this.addAreaViewList(mapId, 2);
        this.addAreaViewList(mapId, 3);
        this.addAreaViewList(mapId, 4);
        if (this.mAppoint != null) {
            this.drawAppointView(mapId, this.mAppoint);
        } else {
            this.addAreaViewList(mapId, 1);
        }
    }

    public void drawAppointView(String mapId, PointF pointF) {
        this.mAppoint = pointF;
        StateBaseMap stateBaseMap = this.mSweeperViewMap.get(mapId);
        if (null == stateBaseMap || !stateBaseMap.isInitMap()) {
            L.w((String)TAG, (String)("drawAppointView  mapId=" + mapId + " not init do nothing "));
            return;
        }
        if (null == this.mAppoint) {
            L.d((String)TAG, (String)"drawAppointView  mAppoint is empty CLEAR ");
        } else {
            L.d((String)TAG, (String)("drawAppointView  is called " + this.mAppoint.toString()));
        }
        stateBaseMap.drawAppoint(this.mAppoint);
    }

    public void setVirtualWallColor(String mapId, String mVirtualWallColor) {
        this.mVirtualWallColor = mVirtualWallColor;
        this.generateAreaList(mapId, this.mVirtualWallList, mVirtualWallColor, 4);
        this.addAreaViewList(mapId, 4);
    }

    public void setVirtualWallData(String mapId, List<List<PointF>> virtualWallList) {
        this.mVirtualWallList = virtualWallList;
        this.generateAreaList(mapId, this.mVirtualWallList, this.mVirtualWallColor, 4);
        this.addAreaViewList(mapId, 4);
    }

    public void setVirtualAreaColor(String mapId, String mVirtualAreaColor) {
        if (this.isMapType) {
            return;
        }
        this.mVirtualAreaColor = mVirtualAreaColor;
        this.generateAreaList(mapId, this.mVirtualAreaList, mVirtualAreaColor, 3);
        this.addAreaViewList(mapId, 3);
    }

    public void setVirtualAreaData(String mapId, List<List<PointF>> virtualAreaList) {
        if (this.isMapType) {
            return;
        }
        this.mVirtualAreaList = virtualAreaList;
        this.generateAreaList(mapId, this.mVirtualAreaList, this.mVirtualAreaColor, 3);
        this.addAreaViewList(mapId, 3);
    }

    public void setSweepRegionColor(String mapId, String color) {
        if (this.isMapType) {
            return;
        }
        this.mSweepRegionColor = color;
        this.generateAreaList(mapId, this.mSweepRegionList, this.mSweepRegionColor, 2);
        this.addAreaViewList(mapId, 2);
    }

    public void setSweepRegionData(String mapId, List<List<PointF>> sweepRegionList) {
        if (this.isMapType) {
            return;
        }
        this.mSweepRegionList = sweepRegionList;
        this.generateAreaList(mapId, this.mSweepRegionList, this.mSweepRegionColor, 2);
        this.addAreaViewList(mapId, 2);
    }

    public HashMap<String, String> getPointTypeColorMap() {
        return this.pointTypeColorMap;
    }

    public void setPointTypeColorMap(HashMap<String, String> pointTypeColorMap) {
        this.pointTypeColorMap = pointTypeColorMap;
    }

    public HashMap<String, String> getRoomIdColorMap() {
        return this.roomIdColorMap;
    }

    public void setRoomIdColorMap(HashMap<String, String> roomIdColorMap) {
        this.roomIdColorMap = roomIdColorMap;
    }

    public HashMap<String, RoomColorInfo> getRoomInfo(String id) {
        if (this.roomInfo.containsKey(id)) {
            return this.roomInfo.get(id);
        }
        return new HashMap<String, RoomColorInfo>();
    }

    public void setRoomInfo(String id, HashMap<String, RoomColorInfo> roomInfo) {
        this.roomInfo.put(id, roomInfo);
    }

    private void addAreaViewList(String mapId, int state) {
        StateBaseMap stateBaseMap = this.mSweeperViewMap.get(mapId);
        if (null == stateBaseMap || !stateBaseMap.isInitMap()) {
            return;
        }
        List<MapAreaData> mapAreaDataList = this.mAreaDataMap.get(mapId);
        ArrayList<MapAreaData> mapAreaDataStateList = new ArrayList<MapAreaData>();
        if (!CollectionUtils.isEmpty(mapAreaDataList)) {
            for (MapAreaData mapAreaData : mapAreaDataList) {
                if (state != mapAreaData.getType()) continue;
                mapAreaDataStateList.add(mapAreaData);
            }
        }
        stateBaseMap.addAreaList(mapAreaDataStateList, state);
    }

    public void addAreaList(String mapId, List<MapAreaData> mapAreaDataList) {
        this.clearCache(mapId);
        if (TextUtils.isEmpty((CharSequence)mapId) || null == mapAreaDataList) {
            return;
        }
        this.putInCache(mapId, mapAreaDataList);
        StateBaseMap stateBaseMap = this.mSweeperViewMap.get(mapId);
        if (null == stateBaseMap || !stateBaseMap.isInitMap()) {
            L.w((String)TAG, (String)"addArea  mMainMap  not init do nothing ");
            return;
        }
        for (MapAreaData mapAreaData : mapAreaDataList) {
            if (this.checkAreaData(mapAreaData)) continue;
            L.d((String)TAG, (String)"data is wrong");
            return;
        }
        stateBaseMap.addAreaList(mapAreaDataList);
    }

    public boolean addArea(String mapId, MapAreaData mapAreaData) {
        if (!this.isMapType) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)mapId) || null == mapAreaData) {
            return false;
        }
        this.putInCache(mapId, mapAreaData);
        StateBaseMap stateBaseMap = this.mSweeperViewMap.get(mapId);
        if (null == stateBaseMap || !stateBaseMap.isInitMap()) {
            L.w((String)TAG, (String)"addArea  mMainMap  not init do nothing ");
            return false;
        }
        int type = mapAreaData.getType();
        if (type == 3 || type == 2 || type == 4) {
            stateBaseMap.addArea(mapAreaData);
        }
        return true;
    }

    public boolean addAreaWithoutCache(String mapId, MapAreaData mapAreaData) {
        if (!this.isMapType) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)mapId) || null == mapAreaData) {
            return false;
        }
        StateBaseMap stateBaseMap = this.mSweeperViewMap.get(mapId);
        if (null == stateBaseMap || !stateBaseMap.isInitMap()) {
            L.w((String)TAG, (String)"addArea  mMainMap  not init do nothing ");
            return false;
        }
        int type = mapAreaData.getType();
        if (type == 3 || type == 2 || type == 4) {
            stateBaseMap.addArea(mapAreaData);
        }
        return true;
    }

    public boolean updateArea(String mapId, MapAreaData mapAreaData) {
        if (TextUtils.isEmpty((CharSequence)mapId) || null == mapAreaData) {
            return false;
        }
        StateBaseMap stateBaseMap = this.mSweeperViewMap.get(mapId);
        if (null == stateBaseMap || !stateBaseMap.isInitMap()) {
            L.w((String)TAG, (String)"addArea  mMainMap  not init do nothing ");
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)mapAreaData.getId())) {
            L.e((String)TAG, (String)"updateArea id is null");
            return false;
        }
        if (mapAreaData.getType() != -1) {
            stateBaseMap.updateArea(mapAreaData.getType(), mapAreaData);
        } else {
            stateBaseMap.updateArea(this.getState(mapId), mapAreaData);
        }
        return true;
    }

    public boolean checkAreaData(MapAreaData mapAreaData) {
        if (null == mapAreaData) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)mapAreaData.getId())) {
            L.w((String)TAG, (String)"checkAreaData  Id  empty ");
            return false;
        }
        return true;
    }

    private void putInCache(String mapId, MapAreaData mapAreaData) {
        List<MapAreaData> list = this.mAreaDataMap.get(mapId);
        if (list == null) {
            list = new ArrayList<MapAreaData>();
            list.add(mapAreaData);
            this.mAreaDataMap.put(mapId, list);
        } else {
            Iterator<MapAreaData> iterator = list.iterator();
            while (iterator.hasNext()) {
                MapAreaData data = iterator.next();
                if (!data.getId().equals(mapAreaData.getId())) continue;
                iterator.remove();
            }
            list.add(mapAreaData);
        }
    }

    private void putInCache(String mapId, List<MapAreaData> mapAreaDataList) {
        List<MapAreaData> list = this.mAreaDataMap.get(mapId);
        if (list == null) {
            list = new ArrayList<MapAreaData>();
            list.addAll(mapAreaDataList);
            this.mAreaDataMap.put(mapId, list);
        } else {
            list.clear();
            list.addAll(mapAreaDataList);
        }
    }

    private void clearCache(String mapId) {
        this.mAreaDataMap.remove(mapId);
    }

    public MapAreaData getMapAreaDataFromCache(String mapId, String id) {
        List<MapAreaData> list = this.mAreaDataMap.get(mapId);
        if (list == null) {
            return null;
        }
        for (MapAreaData data : list) {
            if (!data.getId().equals(id)) continue;
            return data;
        }
        return null;
    }

    public void updateCache(String mapId, List<MapAreaData> l, int type) {
        List<MapAreaData> list = this.mAreaDataMap.get(mapId);
        if (list == null) {
            list = new ArrayList<MapAreaData>();
            list.addAll(l);
            this.mAreaDataMap.put(mapId, list);
        } else {
            Iterator<MapAreaData> iterator = list.iterator();
            while (iterator.hasNext()) {
                MapAreaData data = iterator.next();
                if (data.getType() != type) continue;
                iterator.remove();
            }
            list.addAll(l);
        }
    }

    private void generateAreaList(String mapId, List<List<PointF>> areaPoints, String color, int state) {
        if (null == areaPoints || TextUtils.isEmpty((CharSequence)color)) {
            return;
        }
        ArrayList<MapAreaData> mapAreaDataList = new ArrayList<MapAreaData>();
        for (List<PointF> pointFList : areaPoints) {
            MapAreaData mapAreaData = this.generateAreaData(pointFList, color, state);
            if (null == mapAreaData) continue;
            mapAreaDataList.add(mapAreaData);
        }
        List<MapAreaData> mapList = this.mAreaDataMap.get(mapId);
        if (null == mapList) {
            this.mAreaDataMap.put(mapId, mapAreaDataList);
        } else {
            Iterator<MapAreaData> iterator = mapList.iterator();
            while (iterator.hasNext()) {
                MapAreaData next = iterator.next();
                if (state != next.getType()) continue;
                iterator.remove();
            }
            mapList.addAll(mapAreaDataList);
        }
    }

    private MapAreaData generateAreaData(List<PointF> pointFList, String color, int state) {
        if (TextUtils.isEmpty((CharSequence)color)) {
            return null;
        }
        MapLineBean mapLineBean = new MapLineBean();
        MapAreaBoxBean mapAreaBoxBean = new MapAreaBoxBean();
        switch (state) {
            case 2: 
            case 3: {
                mapAreaBoxBean.setBgColor(color);
                mapAreaBoxBean.setBorderColor("#FFFFFF");
                break;
            }
            case 4: {
                mapLineBean.setBgColor(color);
            }
        }
        return new MapAreaData.Builder().box(mapAreaBoxBean).line(mapLineBean).type(state).points(pointFList).build();
    }

    public void setMapData(String mapId, List<Integer> dataList, int width, int height) {
        this.mapSize = new Pair((Object)width, (Object)height);
        this.toArray(dataList, width, height);
        if (dataList.size() > 0) {
            for (LaserMapRefreshListener listener : this.mapRefreshListeners) {
                listener.onMapDataReached(mapId);
            }
        }
    }

    public MapSplitData getMapSplitData(String mapId) {
        if (null == this.mMainMap || !this.mMainMap.isInitMap()) {
            L.w((String)TAG, (String)"getMapSplitData  mMainMap not init do nothing ");
            return null;
        }
        if (this.iSweeperMapView != null) {
            for (ISweeperMapSplitView iSweeperMapSplitView : this.iSweeperMapView) {
                if (iSweeperMapSplitView.getMapPointsData(mapId) == null) continue;
                return iSweeperMapSplitView.getMapPointsData(mapId);
            }
        }
        return null;
    }

    private void toArray(List<Integer> dataList, int width, int height) {
        this.dataArray = new int[height][width];
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                this.dataArray[i][j] = dataList.get(i * width + j);
            }
        }
    }

    public Pair<Integer, Integer> getMapSize() {
        return this.mapSize;
    }

    public int[][] getDataArray() {
        return this.dataArray;
    }

    @Deprecated
    public PointF getXYInMap(PointF pointF) {
        PointF pointF1 = this.mMainMap.calculateXYInMap(pointF);
        PointF finalPoint = new PointF();
        finalPoint.x = pointF1.x;
        finalPoint.y = pointF1.y;
        return finalPoint;
    }

    public PointF getXYInMap(String mapId, PointF pointF) {
        StateBaseMap stateBaseMap = this.mSweeperViewMap.get(mapId);
        if (stateBaseMap == null) {
            L.e((String)TAG, (String)("getXYInMap mapid is " + mapId + " stateBaseMap = null"));
            stateBaseMap = this.mMainMap;
        }
        PointF pointF1 = stateBaseMap.calculateXYInMap(pointF);
        PointF finalPoint = new PointF();
        finalPoint.x = pointF1.x;
        finalPoint.y = pointF1.y;
        return finalPoint;
    }

    @Deprecated
    public PointF getXYInView(PointF pointF) {
        PointF pointF1 = this.mMainMap.calculateInView(pointF);
        PointF finalPoint = new PointF();
        finalPoint.x = pointF1.x;
        finalPoint.y = pointF1.y;
        return finalPoint;
    }

    public PointF getXYInView(String mapId, PointF pointF) {
        StateBaseMap stateBaseMap = this.mSweeperViewMap.get(mapId);
        if (stateBaseMap == null) {
            L.e((String)TAG, (String)("getXYInView mapid is " + mapId + " stateBaseMap = null"));
            stateBaseMap = this.mMainMap;
        }
        PointF pointF1 = stateBaseMap.calculateInView(pointF);
        PointF finalPoint = new PointF();
        finalPoint.x = pointF1.x;
        finalPoint.y = pointF1.y;
        return finalPoint;
    }

    public PointF getXYInView2(String mapId, PointF pointF) {
        StateBaseMap stateBaseMap = this.mSweeperViewMap.get(mapId);
        if (stateBaseMap == null) {
            L.e((String)TAG, (String)("getXYInView mapid is " + mapId + " stateBaseMap = null"));
            stateBaseMap = this.mMainMap;
        }
        PointF pointF1 = stateBaseMap.calculateInView2(pointF);
        PointF finalPoint = new PointF();
        finalPoint.x = pointF1.x;
        finalPoint.y = pointF1.y;
        return finalPoint;
    }

    private PointF transformPoint(PointF pointF) {
        PointF pointF1 = new PointF();
        pointF1.x = pointF.x;
        pointF1.y = pointF.y;
        return pointF1;
    }

    private List<PointF> transformPoint(List<PointF> pointList) {
        if (null == pointList) {
            return null;
        }
        ArrayList<PointF> transformPointList = new ArrayList<PointF>();
        if (pointList.isEmpty()) {
            return transformPointList;
        }
        for (PointF pointF : pointList) {
            transformPointList.add(new PointF(pointF.x, pointF.y));
        }
        return transformPointList;
    }

    private List<List<PointF>> transformPointList(List<List<PointF>> pointList) {
        if (null == pointList) {
            return null;
        }
        ArrayList<List<PointF>> transformPointList = new ArrayList<List<PointF>>();
        if (pointList.isEmpty()) {
            return transformPointList;
        }
        for (List<PointF> pointFS : pointList) {
            transformPointList.add(this.transformPoint(pointFS));
        }
        return transformPointList;
    }

    public void setMinAreaWidth(float realMinAreaWidth) {
        this.minAreaWidth = realMinAreaWidth;
    }

    public float getMinAreaWidth() {
        return this.minAreaWidth;
    }

    public void setIsRotate(Boolean isRotate) {
        this.isRotate = isRotate;
    }

    public boolean isRotate() {
        return this.isRotate;
    }

    public boolean isMapType() {
        return this.isMapType;
    }

    public void setMapType(boolean mapType) {
        this.isMapType = mapType;
    }

    public void setScale(float scale, PointF pointF) {
        this.scale = scale;
        this.scalePoint = pointF;
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public PointF getScalePoint() {
        return this.scalePoint;
    }

    public void setScalePoint(PointF scalePoint) {
        this.scalePoint = scalePoint;
    }

    public void registerMapRefreshListener(LaserMapRefreshListener listener) {
        if (this.mapRefreshListeners != null && !this.mapRefreshListeners.contains(listener)) {
            this.mapRefreshListeners.add(listener);
        }
    }

    public void unRegisterMapRefreshListener(LaserMapRefreshListener listener) {
        if (this.mapRefreshListeners != null) {
            this.mapRefreshListeners.remove(listener);
        }
    }

    public void registerSweepTypeListener(String mapId, int type, ISweeperTypeData iData) {
        HashMap<Integer, ISweeperTypeData> map = this.iSweeperTypeDataMap.get(mapId);
        if (map == null) {
            map = new HashMap();
            map.put(type, iData);
            this.iSweeperTypeDataMap.put(mapId, map);
        } else if (map.get(type) == null) {
            map.put(type, iData);
        }
    }

    public void unregisterSweepTypeListener(String mapId, int type) {
        HashMap<Integer, ISweeperTypeData> map = this.iSweeperTypeDataMap.get(mapId);
        if (map != null) {
            map.remove(type);
        }
    }

    public void registerMapAttributeChangedListener(ISweeperDataObserver dataObserver) {
        if (dataObserver != null && !this.iSweeperDataObservers.contains(dataObserver)) {
            this.iSweeperDataObservers.add(dataObserver);
        }
    }

    public void unregisterMapAttributeChangedListener(ISweeperDataObserver dataObserver) {
        this.iSweeperDataObservers.remove(dataObserver);
    }

    static {
        TAG = SweeperMapStateManager.class.getSimpleName();
    }

    public static interface SweeperStateListener {
        public void onStateChanged(String var1, int var2);
    }

    public static interface LaserMapRefreshListener {
        public void onMapDataReached(String var1);
    }
}

