/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.reactnativesweeper.manager;

import android.text.TextUtils;
import androidx.core.util.Pair;
import com.tuya.smart.android.common.utils.L;
import com.tuya.smart.asynclib.schedulers.ThreadEnv;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;

public class SweeperMapRunQueue {
    private static final String TAG = SweeperMapRunQueue.class.getSimpleName();
    private LinkedList<Pair<String, Runnable>> taskQueue = new LinkedList();
    private AtomicBoolean isRunning = new AtomicBoolean(false);

    public void enqueue(String type, Runnable runnable) {
        if (null != runnable && !TextUtils.isEmpty((CharSequence)type)) {
            this.taskQueue.add((Pair<String, Runnable>)new Pair((Object)type, (Object)runnable));
            L.d((String)TAG, (String)("IN   Command= " + type));
        }
        if (!this.isRunning.get()) {
            this.deQueue();
        }
    }

    public void deQueue() {
        if (this.isQueueEmpty()) {
            this.isRunning.set(false);
            L.d((String)TAG, (String)"dequeue but queue is empty finish ");
            return;
        }
        this.isRunning.set(true);
        Pair<String, Runnable> runnablePair = this.taskQueue.poll();
        L.d((String)TAG, (String)("OUT  command=" + (String)runnablePair.first));
        ThreadEnv.computation().execute((Runnable)runnablePair.second);
    }

    private boolean isQueueEmpty() {
        return null == this.taskQueue || this.taskQueue.isEmpty();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Command {
        public static final String DO_MAP_DATA = "MAP";
        public static final String DO_PATH_DATA = "PATH";
        public static final String DO_PLAN_PATH_DATA = "PLAN_PATH";
        public static final String APPOINT = "APPOINT";
        public static final String SWEEP_REGION = "SWEEP_REGION";
        public static final String VIRTUAL_WALL = "VIRTUAL_WALL";
        public static final String VIRTUAL_AREA = "VIRTUAL_AREA";
        public static final String PILE = "PILE";
    }
}

