/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.reactnativesweeper.manager;

import android.graphics.Bitmap;
import android.graphics.PointF;
import android.view.View;
import com.tuya.reactnativesweeper.bean.MapPointsData;
import com.tuya.reactnativesweeper.util.CollectionUtils;
import com.tuya.reactnativesweeper.view.sweepercommon.ISweeperMapView;
import com.tuya.reactnativesweeper.view.sweepercommon.StateBaseMap;
import com.tuya.smart.android.common.utils.L;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class HistoryMapStateManager
implements ISweeperMapView {
    private static volatile HistoryMapStateManager instance;
    private final String TAG = HistoryMapStateManager.class.getSimpleName();
    private StateBaseMap historyMap;
    private List<StateBaseMap> mMapList = new ArrayList<StateBaseMap>();
    private String mSweepRegionColor;
    private String mVirtualAreaColor;
    private String mVirtualWallColor;
    private Bitmap appointIcon;
    private List<List<PointF>> mSweepRegionList;
    private List<List<PointF>> mVirtualAreaList;
    private List<List<PointF>> mVirtualWallList;
    private PointF mAppoint;
    private int mState;
    private HashMap<String, Object> zoomFactor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HistoryMapStateManager getInstance() {
        if (instance != null) return instance;
        Class<HistoryMapStateManager> clazz = HistoryMapStateManager.class;
        synchronized (HistoryMapStateManager.class) {
            if (instance != null) return instance;
            instance = new HistoryMapStateManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private HistoryMapStateManager() {
    }

    public void setSweepRegionColor(String mSweepRegionColor) {
        this.mSweepRegionColor = mSweepRegionColor;
        this.drawSweepRegion(this.mSweepRegionList);
    }

    public void setVirtualAreaColor(String mVirtualAreaColor) {
        this.mVirtualAreaColor = mVirtualAreaColor;
        this.drawVirtualArea(this.mVirtualAreaList);
    }

    public void setVirtualWallColor(String mVirtualWallColor) {
        this.mVirtualWallColor = mVirtualWallColor;
        this.drawVirtualWall(this.mVirtualWallList);
    }

    public void setZoomFactor(HashMap<String, Object> zoomFactor) {
        this.zoomFactor = zoomFactor;
    }

    public HashMap<String, Object> getZoomFactor() {
        return this.zoomFactor;
    }

    public Bitmap getAppointIcon() {
        return this.appointIcon;
    }

    public void setAppointIcon(Bitmap appointIcon) {
        this.appointIcon = appointIcon;
    }

    public String getSweepRegionColor() {
        return this.mSweepRegionColor;
    }

    public String getVirtualAreaColor() {
        return this.mVirtualAreaColor;
    }

    public String getVirtualWallColor() {
        return this.mVirtualWallColor;
    }

    public void attachMap(StateBaseMap view) {
        L.i((String)this.TAG, (String)"attachMainLaserMap is called ");
        if (null == this.historyMap) {
            this.historyMap = view;
        }
        this.mMapList.add(view);
    }

    public void detachedMap(StateBaseMap view) {
        L.i((String)this.TAG, (String)"detachedLaserMap is called ");
        this.mMapList.remove((Object)view);
        if (this.mMapList.isEmpty()) {
            this.release();
            this.historyMap = null;
            instance = null;
        }
    }

    private void release() {
        if (null != this.appointIcon && !this.appointIcon.isRecycled()) {
            this.appointIcon.recycle();
            this.appointIcon = null;
        }
    }

    public void setState(int state) {
        if (this.mState != state) {
            L.i((String)this.TAG, (String)("setState  state=" + state));
            this.mState = state;
        }
    }

    public MapPointsData getTypePointsInfo() {
        if (null == this.historyMap) {
            return null;
        }
        if (!this.historyMap.isInitMap()) {
            L.w((String)this.TAG, (String)"Map not init getTypePointsInfo do nothing");
            return null;
        }
        switch (this.mState) {
            case 4: {
                MapPointsData<List<PointF>> typePointData = new MapPointsData<List<PointF>>();
                typePointData.setData(this.transformPointList(this.historyMap.getVirtualWallPoint()));
                typePointData.setType(this.mState);
                return typePointData;
            }
            case 3: {
                MapPointsData<List<PointF>> forbiddenZoneData = new MapPointsData<List<PointF>>();
                forbiddenZoneData.setData(this.transformPointList(this.historyMap.getForbiddenZonePoint()));
                forbiddenZoneData.setType(this.mState);
                return forbiddenZoneData;
            }
            case 2: {
                MapPointsData<List<PointF>> sweepRegionData = new MapPointsData<List<PointF>>();
                sweepRegionData.setData(this.transformPointList(this.historyMap.getSweepRegionPoint()));
                sweepRegionData.setType(this.mState);
                return sweepRegionData;
            }
            case 1: {
                MapPointsData<PointF> appointPointData = new MapPointsData<PointF>();
                appointPointData.setData(this.transformPoint(this.historyMap.getAppointPoint()));
                appointPointData.setType(this.mState);
                return appointPointData;
            }
        }
        return null;
    }

    public void addLaserMapRectWithType(int state) {
    }

    public int getState() {
        return this.mState;
    }

    public void addAppoint(View view, float x, float y) {
        if (view != this.historyMap) {
            L.w((String)this.TAG, (String)"addAppoint but  Operation of the map is not main map  do nothing ");
            return;
        }
        if (!this.historyMap.isInitMap()) {
            L.w((String)this.TAG, (String)"Map not init addAppoint do nothing");
            return;
        }
        if (this.mState != 1) {
            L.w((String)this.TAG, (String)("state is " + this.mState + " addAppoint do nothing"));
            return;
        }
        if (null == this.appointIcon) {
            L.w((String)this.TAG, (String)"addAppoint Icon null  addAppoint do nothing");
            return;
        }
        this.historyMap.addAppointView(x, y);
    }

    public void drawAllStateView() {
        this.drawAppointView(this.mAppoint);
        this.drawSweepRegion(this.mSweepRegionList);
        this.drawVirtualWall(this.mVirtualWallList);
        this.drawVirtualArea(this.mVirtualAreaList);
    }

    public void drawAppointView(PointF pointF) {
        this.mAppoint = pointF;
        if (null == this.historyMap || !this.historyMap.isInitMap()) {
            L.w((String)this.TAG, (String)"drawAppointView  historyMap not init do nothing ");
            return;
        }
        if (null == this.mAppoint) {
            L.d((String)this.TAG, (String)"drawAppointView  mAppoint is empty CLEAR ");
        } else {
            L.d((String)this.TAG, (String)("drawAppointView  is called " + this.mAppoint.toString()));
        }
        this.historyMap.drawAppoint(this.mAppoint);
    }

    public void drawVirtualWall(List<List<PointF>> virtualWallList) {
        this.mVirtualWallList = virtualWallList;
        if (null == this.historyMap || !this.historyMap.isInitMap()) {
            L.w((String)this.TAG, (String)"drawVirtualWall  historyMap not init do nothing ");
            return;
        }
        if (CollectionUtils.isEmpty(virtualWallList)) {
            L.d((String)this.TAG, (String)"drawVirtualWall  virtualWallList is empty CLEAR ");
        } else {
            L.d((String)this.TAG, (String)("drawVirtualWall is called size=" + virtualWallList));
        }
    }

    public void drawVirtualArea(List<List<PointF>> virtualAreaList) {
        this.mVirtualAreaList = virtualAreaList;
        if (null == this.historyMap || !this.historyMap.isInitMap()) {
            L.w((String)this.TAG, (String)"drawVirtualArea  historyMap not init do nothing ");
            return;
        }
        if (CollectionUtils.isEmpty(virtualAreaList)) {
            L.d((String)this.TAG, (String)"drawVirtualArea  virtualAreaList is empty CLEAR ");
        } else {
            L.d((String)this.TAG, (String)("drawVirtualArea is called size=" + virtualAreaList));
        }
    }

    public void drawSweepRegion(List<List<PointF>> sweepRegionList) {
        this.mSweepRegionList = sweepRegionList;
        if (null == this.historyMap || !this.historyMap.isInitMap()) {
            L.w((String)this.TAG, (String)"drawSweepRegion  historyMap not init do nothing ");
            return;
        }
        if (CollectionUtils.isEmpty(sweepRegionList)) {
            L.d((String)this.TAG, (String)"drawSweepRegion  sweepRegionList is empty CLEAR ");
        } else {
            L.d((String)this.TAG, (String)("drawSweepRegion is called size=" + sweepRegionList));
        }
    }

    public PointF getXYInMap(PointF pointF) {
        PointF pointF1 = this.historyMap.calculateXYInMap(pointF);
        PointF finalPoint = new PointF();
        finalPoint.x = pointF1.x;
        finalPoint.y = pointF1.y;
        return finalPoint;
    }

    private List<PointF> transformPoint(List<PointF> pointList) {
        if (null == pointList) {
            return null;
        }
        ArrayList<PointF> transformPointList = new ArrayList<PointF>();
        if (pointList.isEmpty()) {
            return transformPointList;
        }
        for (PointF pointF : pointList) {
            transformPointList.add(new PointF(pointF.x, pointF.y));
        }
        return transformPointList;
    }

    private List<List<PointF>> transformPointList(List<List<PointF>> pointList) {
        if (null == pointList) {
            return null;
        }
        ArrayList<List<PointF>> transformPointList = new ArrayList<List<PointF>>();
        if (pointList.isEmpty()) {
            return transformPointList;
        }
        for (List<PointF> pointFS : pointList) {
            transformPointList.add(this.transformPoint(pointFS));
        }
        return transformPointList;
    }
}

