/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.reactnativesweeper.bean;

import android.graphics.PointF;
import androidx.annotation.NonNull;
import com.tuya.reactnativesweeper.bean.MapAreaBoxBean;
import com.tuya.reactnativesweeper.bean.MapAreaContentBean;
import com.tuya.reactnativesweeper.bean.MapLineBean;
import java.util.ArrayList;
import java.util.List;

public class MapAreaData
implements Cloneable {
    private String id;
    private MapAreaBoxBean box;
    private MapAreaContentBean content;
    private List<PointF> points;
    private int type = -1;
    private String extend;
    private MapLineBean line;
    private ZoomFactorBean factor;

    public MapAreaData() {
    }

    private MapAreaData(Builder builder) {
        this.setId(builder.id);
        this.setBox(builder.box);
        this.setContent(builder.content);
        this.setPoints(builder.points);
        this.setType(builder.type);
        this.setExtend(builder.extend);
        this.setLine(builder.line);
        this.setFactor(builder.factor);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public MapLineBean getLine() {
        return this.line;
    }

    public void setLine(MapLineBean line) {
        this.line = line;
    }

    public MapAreaBoxBean getBox() {
        return this.box;
    }

    public void setBox(MapAreaBoxBean box) {
        this.box = box;
    }

    public MapAreaContentBean getContent() {
        return this.content;
    }

    public void setContent(MapAreaContentBean content) {
        this.content = content;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public List<PointF> getPoints() {
        return this.points;
    }

    public void setPoints(List<PointF> points) {
        this.points = points;
    }

    public String getExtend() {
        return this.extend;
    }

    public void setExtend(String extend) {
        this.extend = extend;
    }

    public ZoomFactorBean getFactor() {
        return this.factor;
    }

    public void setFactor(ZoomFactorBean factor) {
        this.factor = factor;
    }

    public MapAreaData clone() {
        MapAreaData mapAreaData = new MapAreaData();
        try {
            mapAreaData = (MapAreaData)super.clone();
            if (this.content != null) {
                mapAreaData.content = this.content.clone();
            }
            if (this.factor != null) {
                mapAreaData.factor = this.factor.clone();
            }
            if (this.line != null) {
                mapAreaData.line = this.line.clone();
            }
            if (this.box != null) {
                mapAreaData.box = this.box.clone();
            }
            mapAreaData.points = new ArrayList<PointF>();
            if (this.points != null) {
                mapAreaData.points.addAll(this.points);
            }
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return mapAreaData;
    }

    @NonNull
    public String toString() {
        return "id:" + this.id + " type:" + this.type + "  points:" + this.points.toString();
    }

    public static final class Builder {
        private String id;
        private MapAreaBoxBean box;
        private MapAreaContentBean content;
        private List<PointF> points;
        private int type;
        private String extend;
        private MapLineBean line;
        private ZoomFactorBean factor;

        public Builder areaId(String val) {
            this.id = val;
            return this;
        }

        public Builder box(MapAreaBoxBean val) {
            this.box = val;
            return this;
        }

        public Builder content(MapAreaContentBean val) {
            this.content = val;
            return this;
        }

        public Builder points(List<PointF> val) {
            this.points = val;
            return this;
        }

        public Builder type(int val) {
            this.type = val;
            return this;
        }

        public Builder extend(String val) {
            this.extend = val;
            return this;
        }

        public Builder line(MapLineBean val) {
            this.line = val;
            return this;
        }

        public Builder factor(ZoomFactorBean val) {
            this.factor = val;
            return this;
        }

        public MapAreaData build() {
            return new MapAreaData(this);
        }
    }

    public class ZoomFactorBean
    implements Cloneable {
        String factor;
        String factorColor;
        int fontSize;

        public String getFactor() {
            return this.factor;
        }

        public void setFactor(String factor) {
            this.factor = factor;
        }

        public String getFactorColor() {
            return this.factorColor;
        }

        public void setFactorColor(String factorColor) {
            this.factorColor = factorColor;
        }

        public int getFontSize() {
            return this.fontSize;
        }

        public void setFontSize(int fontSize) {
            this.fontSize = fontSize;
        }

        protected ZoomFactorBean clone() throws CloneNotSupportedException {
            return (ZoomFactorBean)super.clone();
        }
    }
}

