/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.reactnativesweeper.view.sweepercommon.virtualwall;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.DashPathEffect;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.Region;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.events.RCTEventEmitter;
import com.tuya.react_sweeper_common.R;
import com.tuya.reactnativesweeper.anim.MatrixAnimator;
import com.tuya.reactnativesweeper.bean.MapPointsData;
import com.tuya.reactnativesweeper.manager.SweeperMapStateManager;
import com.tuya.reactnativesweeper.util.RNComponentUtil;
import com.tuya.reactnativesweeper.util.SizeUtils;
import com.tuya.reactnativesweeper.view.sweepercommon.SweeperUtil;
import com.tuya.reactnativesweeper.view.sweepercommon.sticker.ActionIcon;
import com.tuya.reactnativesweeper.view.sweepercommon.virtualwall.OnVirtualActionListener;
import com.tuya.smart.android.common.utils.L;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class VirtualWallView
extends AppCompatImageView
implements SweeperMapStateManager.SweeperStateListener {
    public static final String TAG = VirtualWallView.class.getSimpleName();
    private Paint mPaint;
    private Paint judgePaint;
    private float mPathWidth;
    private Path mLinePath;
    private ActionIcon deleteIcon;
    private ActionIcon zoomIcon;
    private int drawMode;
    private float lineStartX;
    private float lineStartY;
    private float lineEndX;
    private float lineEndY;
    private float downX;
    private float downY;
    private boolean isEdit = true;
    private float preScale = 1.0f;
    private HashMap<String, Object> zoomFactor;
    private float factor;
    private Matrix matrix = new Matrix();
    private Paint textPaint;
    private Context mContext;
    private OnVirtualActionListener listener;

    @Override
    public void onStateChanged(int state) {
        this.postInvalidate();
    }

    public void setOnActionListener(OnVirtualActionListener listener) {
        this.listener = listener;
    }

    public VirtualWallView(Context context) {
        this(context, null);
    }

    public VirtualWallView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public VirtualWallView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.init();
    }

    private void init() {
        this.mLinePath = new Path();
        this.mPaint = new Paint();
        this.mPathWidth = SizeUtils.dip2px(this.getContext(), 1.0f);
        this.mPaint.setStrokeWidth(this.mPathWidth);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setAntiAlias(true);
        this.mPaint.setColor(Color.parseColor((String)"#F5A623"));
        this.mPaint.setPathEffect((PathEffect)new DashPathEffect(new float[]{20.0f, 10.0f, 20.0f, 10.0f}, 0.0f));
        this.judgePaint = new Paint();
        this.judgePaint.setStyle(Paint.Style.STROKE);
        this.judgePaint.setStrokeWidth(100.0f);
        this.zoomIcon = new ActionIcon(this.getContext());
        this.zoomIcon.setSrcIcon(R.drawable.panel_sticker_resize);
        this.deleteIcon = new ActionIcon(this.getContext());
        this.deleteIcon.setSrcIcon(R.drawable.panel_sticker_remove);
        SweeperMapStateManager.getInstance().registerStateListener(this);
    }

    public void setStartAndEnd(PointF start, PointF end) {
        if (null == start || null == end) {
            L.w((String)TAG, (String)"setStartAndEnd start or end point is null");
            return;
        }
        this.lineStartX = start.x;
        this.lineStartY = start.y;
        this.lineEndX = end.x;
        this.lineEndY = end.y;
        this.drawMode = 4;
    }

    public void setZoomFactor(HashMap<String, Object> zoomFactor) {
        this.zoomFactor = zoomFactor;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (Math.abs(this.lineStartX - this.lineEndX) < 5.0f && Math.abs(this.lineStartY - this.lineEndY) < 5.0f) {
            L.w((String)TAG, (String)("onDraw  --- dx=" + Math.abs(this.lineStartX - this.lineEndX) + " dy=" + Math.abs(this.lineStartY - this.lineEndY)));
            return;
        }
        this.drawLine(canvas);
        this.drawIcon(canvas);
        if (SweeperMapStateManager.getInstance().getState() == 4 && this.zoomFactor != null && this.zoomFactor.containsKey("factor") && (Double)this.zoomFactor.get("factor") > 0.0) {
            BigDecimal bigDecimal = new BigDecimal((Double)this.zoomFactor.get("factor"));
            this.factor = bigDecimal.floatValue();
            this.drawText(canvas);
        }
    }

    private void drawText(Canvas canvas) {
        PointF startPointInMap = this.getPointInMap(this.lineStartX, this.lineStartY);
        PointF endPointInMap = this.getPointInMap(this.lineEndX, this.lineEndY);
        String length = this.calculateLength(startPointInMap, endPointInMap);
        canvas.drawText(length + "m", this.lineStartX, this.lineStartY, this.getTextPaint());
    }

    private Paint getTextPaint() {
        if (this.textPaint != null) {
            return this.textPaint;
        }
        this.textPaint = new Paint();
        if (this.zoomFactor.containsKey("color")) {
            this.textPaint.setColor(Color.parseColor((String)((String)this.zoomFactor.get("color"))));
        } else {
            this.textPaint.setColor(-1);
        }
        if (this.zoomFactor.containsKey("font")) {
            double fontSize = (Double)this.zoomFactor.get("font");
            this.textPaint.setTextSize((float)SweeperUtil.dip2px(this.mContext, (int)fontSize));
        } else {
            this.textPaint.setTextSize(18.0f);
        }
        this.textPaint.setStrokeWidth(3.0f);
        this.textPaint.setTextSize(18.0f);
        return this.textPaint;
    }

    private String calculateLength(PointF startPointInMap, PointF endPointInMap) {
        double length = Math.sqrt(Math.pow(startPointInMap.x - endPointInMap.x, 2.0) + Math.pow(startPointInMap.y - endPointInMap.y, 2.0));
        DecimalFormat decimalFormat = new DecimalFormat("0.0");
        return decimalFormat.format(length * (double)this.factor);
    }

    private PointF getPointInMap(float x, float y) {
        PointF startPoint = new PointF();
        startPoint.x = x;
        startPoint.y = y;
        return SweeperMapStateManager.getInstance().getXYInMap(startPoint);
    }

    public void reset(Matrix matrix) {
        final float animatorStartX = this.lineStartX;
        final float animatorStartY = this.lineStartY;
        final float animatorEndX = this.lineEndX;
        final float animatorEndY = this.lineEndY;
        MatrixAnimator matrixAnimator = new MatrixAnimator(new Matrix(), matrix);
        matrixAnimator.setListener(new MatrixAnimator.AnimationListener(){

            @Override
            public void onAnimationUpdate(Matrix matrix) {
                float[] points = new float[]{animatorStartX, animatorStartY, animatorEndX, animatorEndY};
                L.i((String)TAG, (String)("onAnimationUpdate " + matrix.toShortString()));
                matrix.mapPoints(points);
                VirtualWallView.this.lineStartX = points[0];
                VirtualWallView.this.lineStartY = points[1];
                VirtualWallView.this.lineEndX = points[2];
                VirtualWallView.this.lineEndY = points[3];
                VirtualWallView.this.invalidate();
            }

            @Override
            public void onAnimationEnd() {
                VirtualWallView.this.preScale = 1.0f;
            }
        });
        matrixAnimator.start();
    }

    public void tran(float dx, float dy) {
        this.matrix.setTranslate(dx, dy);
        float[] points = new float[]{this.lineStartX, this.lineStartY, this.lineEndX, this.lineEndY};
        this.matrix.mapPoints(points);
        this.lineStartX = points[0];
        this.lineStartY = points[1];
        this.lineEndX = points[2];
        this.lineEndY = points[3];
        this.invalidate();
    }

    public void scale(float scale, PointF pointF) {
        if (null == this.mLinePath) {
            return;
        }
        this.matrix.setScale(scale / this.preScale, scale / this.preScale, pointF.x, pointF.y);
        float[] points = new float[]{this.lineStartX, this.lineStartY, this.lineEndX, this.lineEndY};
        this.matrix.mapPoints(points);
        this.lineStartX = points[0];
        this.lineStartY = points[1];
        this.lineEndX = points[2];
        this.lineEndY = points[3];
        this.preScale = scale;
        this.invalidate();
    }

    private void drawIcon(Canvas canvas) {
        if (this.isEdit) {
            this.deleteIcon.draw(canvas, this.lineStartX, this.lineStartY);
            this.zoomIcon.draw(canvas, this.lineEndX, this.lineEndY);
        }
    }

    private void drawLine(Canvas canvas) {
        this.mLinePath = new Path();
        this.mLinePath.moveTo(this.lineStartX, this.lineStartY);
        this.mLinePath.lineTo(this.lineEndX, this.lineEndY);
        canvas.drawPath(this.mLinePath, this.mPaint);
    }

    public boolean downInLine(float x, float y) {
        if (null == this.mLinePath) {
            return false;
        }
        RectF r = new RectF();
        Path path = new Path();
        this.judgePaint.getFillPath(this.mLinePath, path);
        path.computeBounds(r, true);
        Region re = new Region();
        re.setPath(path, new Region((int)r.left, (int)r.top, (int)r.right, (int)r.bottom));
        L.w((String)TAG, (String)("--downInLine----" + re.contains((int)x, (int)y)));
        return re.contains((int)x, (int)y);
    }

    public void setEdit(boolean edit, boolean invalidate) {
        if (edit == this.isEdit) {
            return;
        }
        this.isEdit = edit;
        if (invalidate) {
            this.postInvalidate();
        }
        L.i((String)TAG, (String)("setEdit edit=" + edit));
    }

    public void setColor(String color) {
        this.mPaint.setColor(Color.parseColor((String)color));
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (SweeperMapStateManager.getInstance().getState() != 4) {
            return false;
        }
        int action = event.getActionMasked();
        boolean isStickerOnEdit = true;
        switch (action) {
            case 0: {
                this.downX = event.getX();
                this.downY = event.getY();
                if (this.deleteIcon.isInActionCheck(event)) {
                    if (null != this.listener && this.isEdit) {
                        this.listener.onDelete();
                    }
                    this.drawMode = 5;
                    return true;
                }
                if (this.zoomIcon.isInActionCheck(event)) {
                    this.drawMode = 2;
                    return true;
                }
                if (this.downInLine(event.getX(), event.getY())) {
                    this.drawMode = 3;
                    return true;
                }
                if (this.drawMode == 0) {
                    this.lineStartX = event.getX();
                    this.lineStartY = event.getY();
                    this.drawMode = 2;
                    return true;
                }
                isStickerOnEdit = false;
                break;
            }
            case 2: {
                if (this.drawMode == 2 || this.drawMode == 0) {
                    this.lineEndX = event.getX();
                    this.lineEndY = event.getY();
                    if (Math.abs(this.lineStartX - this.lineEndX) < 5.0f || Math.abs(this.lineStartY - this.lineEndY) < 5.0f) {
                        this.drawMode = 0;
                        L.w((String)TAG, (String)"ACTION_MOVE  too nearly--- so reset NONE");
                        break;
                    }
                    this.drawMode = 2;
                    this.invalidate();
                    break;
                }
                if (this.drawMode != 3) break;
                this.lineStartX += event.getX() - this.downX;
                this.lineStartY += event.getY() - this.downY;
                this.lineEndX += event.getX() - this.downX;
                this.lineEndY += event.getY() - this.downY;
                this.downX = event.getX();
                this.downY = event.getY();
                this.invalidate();
                break;
            }
            case 1: {
                if (this.drawMode != 0 && this.drawMode != 5) {
                    this.drawMode = 4;
                }
                if (!(this.mContext instanceof ThemedReactContext)) break;
                MapPointsData<PointF> typePointData = new MapPointsData<PointF>();
                typePointData.setData(this.getStartAndEndPoint());
                typePointData.setType(4);
                WritableMap writableMap = RNComponentUtil.parseToWritableMap(typePointData);
                ((RCTEventEmitter)((ThemedReactContext)this.mContext).getJSModule(RCTEventEmitter.class)).receiveEvent(this.getId(), "onLaserMapPoints", writableMap);
                break;
            }
        }
        if (isStickerOnEdit && this.listener != null) {
            this.listener.onEdit(this);
        }
        return isStickerOnEdit;
    }

    public List<PointF> getStartAndEndPoint() {
        ArrayList<PointF> pointFList = new ArrayList<PointF>();
        pointFList.add(new PointF(this.lineStartX, this.lineStartY));
        pointFList.add(new PointF(this.lineEndX, this.lineEndY));
        return pointFList;
    }

    public int getDrawMode() {
        return this.drawMode;
    }

    public void setPreScale(float preScale) {
        this.preScale = preScale;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Mode {
        public static final int NONE = 0;
        public static final int LINE_ING = 2;
        public static final int TRAN = 3;
        public static final int DONE = 4;
        public static final int DEL = 5;
    }
}

