/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.reactnativesweeper.view.sweepercommon.virtualwall;

import android.content.Context;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.FrameLayout;
import com.tuya.reactnativesweeper.manager.HistoryMapStateManager;
import com.tuya.reactnativesweeper.manager.SweeperMapStateManager;
import com.tuya.reactnativesweeper.util.CollectionUtils;
import com.tuya.reactnativesweeper.view.sweepercommon.MatrixView;
import com.tuya.reactnativesweeper.view.sweepercommon.virtualwall.OnVirtualActionListener;
import com.tuya.reactnativesweeper.view.sweepercommon.virtualwall.VirtualWallView;
import com.tuya.smart.android.common.utils.L;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class VirtualWallLayout
extends FrameLayout
implements MatrixView {
    private static final String TAG = VirtualWallLayout.class.getSimpleName();
    private List<VirtualWallView> virtualWallViewList;
    private static final int WALL_POINT_COUNT = 2;

    public VirtualWallLayout(@NonNull Context context) {
        this(context, null);
    }

    public VirtualWallLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public VirtualWallLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.virtualWallViewList = new ArrayList<VirtualWallView>();
    }

    public boolean onTouchEvent(MotionEvent event) {
        for (VirtualWallView item : this.virtualWallViewList) {
            item.setEdit(false, true);
        }
        return super.onTouchEvent(event);
    }

    private boolean haveNotFinishWall() {
        if (this.virtualWallViewList.isEmpty()) {
            return false;
        }
        boolean mark = false;
        for (VirtualWallView virtualWallView : this.virtualWallViewList) {
            if (virtualWallView.getDrawMode() == 4) continue;
            mark = true;
        }
        return mark;
    }

    @Override
    public void postTranslate(float xDiff, float yDiff) {
        for (VirtualWallView item : this.virtualWallViewList) {
            item.tran(xDiff, yDiff);
        }
    }

    @Override
    public void postScale(float scale, PointF pointF) {
        for (VirtualWallView item : this.virtualWallViewList) {
            item.scale(scale, pointF);
        }
    }

    public void addVirtualWallList(List<List<PointF>> doublePointList, float mapScale) {
        this.addVirtualWallList(doublePointList, mapScale, true);
    }

    public void addVirtualWallList(List<List<PointF>> doublePointList, float mapScale, boolean isMainMap) {
        this.removeAllWall();
        if (CollectionUtils.isEmpty(doublePointList)) {
            return;
        }
        for (List<PointF> pointFS : doublePointList) {
            if (pointFS.size() != 2) continue;
            this.addVirtualWall(pointFS.get(0), pointFS.get(1), mapScale, isMainMap);
        }
    }

    private void addVirtualWall(PointF start, PointF end, float mapScale, boolean isMainMap) {
        if (this.haveNotFinishWall()) {
            L.w((String)TAG, (String)"haveNotFinishWall  so do nothing");
            return;
        }
        String color = isMainMap ? SweeperMapStateManager.getInstance().getVirtualWallColor() : HistoryMapStateManager.getInstance().getVirtualWallColor();
        if (TextUtils.isEmpty((CharSequence)color)) {
            return;
        }
        final VirtualWallView virtualWallView = new VirtualWallView(this.getContext());
        virtualWallView.setPreScale(mapScale);
        HashMap<String, Object> zoomFactor = SweeperMapStateManager.getInstance().getZoomFactor();
        virtualWallView.setZoomFactor(zoomFactor);
        virtualWallView.setOnActionListener(new OnVirtualActionListener(){

            @Override
            public void onDelete() {
                VirtualWallLayout.this.virtualWallViewList.remove(virtualWallView);
                VirtualWallLayout.this.removeView((View)virtualWallView);
                VirtualWallLayout.this.requestLayout();
            }

            @Override
            public void onEdit(VirtualWallView view) {
                int position = VirtualWallLayout.this.virtualWallViewList.indexOf(view);
                view.setEdit(true, true);
                view.bringToFront();
                int size = VirtualWallLayout.this.virtualWallViewList.size();
                for (int i = 0; i < size; ++i) {
                    VirtualWallView item = (VirtualWallView)VirtualWallLayout.this.virtualWallViewList.get(i);
                    if (item == null || position == i) continue;
                    item.setEdit(false, true);
                }
            }
        });
        if (null != start && null != end) {
            virtualWallView.setStartAndEnd(start, end);
            virtualWallView.setEdit(false, false);
        }
        virtualWallView.setColor(color);
        this.virtualWallViewList.add(virtualWallView);
        this.addView((View)virtualWallView, -1, -1);
        this.requestLayout();
    }

    public void addVirtualWall(float mapScale, boolean isMainMap) {
        this.addVirtualWall(null, null, mapScale, isMainMap);
    }

    public List<List<PointF>> getPointInfo() {
        ArrayList<List<PointF>> pointList = new ArrayList<List<PointF>>();
        for (VirtualWallView virtualWallView : this.virtualWallViewList) {
            pointList.add(virtualWallView.getStartAndEndPoint());
        }
        return pointList;
    }

    public void removeAllWall() {
        if (this.virtualWallViewList.isEmpty()) {
            return;
        }
        this.virtualWallViewList.clear();
        this.removeAllViews();
        this.requestLayout();
    }

    public void reset(Matrix matrix) {
        for (VirtualWallView virtualWallView : this.virtualWallViewList) {
            virtualWallView.reset(matrix);
        }
    }
}

