/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.reactnativesweeper.view.sweepercommon.sticker;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.RectF;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import android.util.Pair;
import android.view.MotionEvent;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.events.RCTEventEmitter;
import com.tuya.reactnativesweeper.anim.MatrixAnimator;
import com.tuya.reactnativesweeper.bean.MapPointsData;
import com.tuya.reactnativesweeper.manager.HistoryMapStateManager;
import com.tuya.reactnativesweeper.manager.SweeperMapStateManager;
import com.tuya.reactnativesweeper.util.RNComponentUtil;
import com.tuya.reactnativesweeper.view.sweepercommon.ISweeperMapView;
import com.tuya.reactnativesweeper.view.sweepercommon.SweeperUtil;
import com.tuya.reactnativesweeper.view.sweepercommon.sticker.ActionIcon;
import com.tuya.reactnativesweeper.view.sweepercommon.sticker.OnStickerActionListener;
import com.tuya.reactnativesweeper.view.sweepercommon.sticker.Sticker;
import com.tuya.sdk.tuyamesh.utils.L;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class StickerView
extends AppCompatImageView
implements SweeperMapStateManager.SweeperStateListener {
    private static final String TAG = "StickerView";
    private static float MIN_WIDTH = 30.0f;
    private static float MIN_HEIGHT = 30.0f;
    private Sticker sticker;
    private Matrix downMatrix = new Matrix();
    private Matrix moveMatrix = new Matrix();
    private Matrix mMatrix = new Matrix();
    private PointF leftTopPoint = new PointF();
    private int mode;
    private boolean isEdit;
    private OnStickerActionListener listener;
    float preScale = 1.0f;
    private float downX;
    private float downY;
    private float oldMoveLocationX;
    private float oldMoveLocationY;
    private ActionIcon rightBottomIcon;
    private ActionIcon rightTopIcon;
    private ActionIcon leftTopIcon;
    private boolean downInSticker;
    private int type;
    private HashMap<String, Object> zoomFactor;
    private float factor;
    private Paint areaSizePaint;
    private Context context;
    private boolean isMainMap = true;
    private ISweeperMapView iSweeperMapView;
    private int angle;
    private int initAngle;
    private Path mPath;

    public void setOnStickerActionListener(OnStickerActionListener listener) {
        this.listener = listener;
    }

    public StickerView(Context context) {
        this(context, null);
    }

    public StickerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public StickerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.context = context;
        this.init();
    }

    private void init() {
        this.setScaleType(ImageView.ScaleType.MATRIX);
        this.sticker = new Sticker();
        SweeperMapStateManager.getInstance().registerStateListener(this);
        this.iSweeperMapView = this.isMainMap ? SweeperMapStateManager.getInstance() : HistoryMapStateManager.getInstance();
        this.mPath = new Path();
        if (SweeperMapStateManager.getInstance().getMinAreaWidth() > 0.0f) {
            MIN_WIDTH = MIN_HEIGHT = SweeperMapStateManager.getInstance().getMinAreaWidth();
        }
    }

    public void postTranslate(float xDiff, float yDiff) {
        this.sticker.getMatrix().postTranslate(xDiff, yDiff);
        this.mMatrix.reset();
        this.mMatrix.postTranslate(xDiff, yDiff);
        this.sticker.updatePoints(this.mMatrix);
        this.invalidate();
    }

    public void postScale(float scale, PointF pointF) {
        this.sticker.getMatrix().postScale(scale / this.preScale, scale / this.preScale, pointF.x, pointF.y);
        this.mMatrix.reset();
        this.mMatrix.postScale(scale / this.preScale, scale / this.preScale, pointF.x, pointF.y);
        this.sticker.updatePoints(this.mMatrix);
        this.invalidate();
        this.preScale = scale;
    }

    private Paint getAreaSizePaint() {
        if (this.areaSizePaint != null) {
            return this.areaSizePaint;
        }
        this.areaSizePaint = new Paint();
        if (this.zoomFactor.containsKey("color")) {
            this.areaSizePaint.setColor(Color.parseColor((String)((String)this.zoomFactor.get("color"))));
        } else {
            this.areaSizePaint.setColor(-1);
        }
        if (this.zoomFactor.containsKey("font")) {
            double fontSize = (Double)this.zoomFactor.get("font");
            this.areaSizePaint.setTextSize((float)SweeperUtil.dip2px(this.context, (int)fontSize));
        } else {
            this.areaSizePaint.setTextSize(18.0f);
        }
        this.areaSizePaint.setStrokeWidth(3.0f);
        return this.areaSizePaint;
    }

    public boolean hasZoom() {
        return null != this.zoomFactor && this.zoomFactor.containsKey("factor") && (Double)this.zoomFactor.get("factor") > 0.0;
    }

    public void reset(Matrix matrix) {
        Matrix endMatrix = new Matrix();
        endMatrix.set(this.sticker.getMatrix());
        endMatrix.postConcat(matrix);
        MatrixAnimator matrixAnimator = new MatrixAnimator(this.sticker.getMatrix(), endMatrix);
        matrixAnimator.setListener(new MatrixAnimator.AnimationListener(){

            @Override
            public void onAnimationUpdate(Matrix matrix) {
                StickerView.this.sticker.setMatrix(matrix);
                StickerView.this.invalidate();
            }

            @Override
            public void onAnimationEnd() {
                StickerView.this.preScale = 1.0f;
            }
        });
        matrixAnimator.start();
    }

    protected void onDraw(Canvas canvas) {
        if (this.sticker == null) {
            return;
        }
        this.sticker.draw(canvas);
        PointF rightTopPoint = this.sticker.getRightTopPoint();
        PointF rightBottomPoint = this.sticker.getRightBottomPoint();
        PointF leftTopPoint = this.sticker.getLeftTopPoint();
        if (this.isEdit) {
            if (null != this.rightTopIcon) {
                this.rightTopIcon.draw(canvas, rightTopPoint.x, rightTopPoint.y);
            }
            if (null != this.rightBottomIcon) {
                this.rightBottomIcon.draw(canvas, rightBottomPoint.x, rightBottomPoint.y);
            }
            if (null != this.leftTopIcon) {
                this.leftTopIcon.draw(canvas, leftTopPoint.x, leftTopPoint.y);
            }
        }
        if (SweeperMapStateManager.getInstance().getState() == this.type && this.hasZoom()) {
            BigDecimal bigDecimal = new BigDecimal((Double)this.zoomFactor.get("factor"));
            this.factor = bigDecimal.floatValue();
            float width = this.sticker.getDistance(leftTopPoint, rightTopPoint);
            String realSize = this.getRealSize(this.getDistanceInMap(leftTopPoint, rightTopPoint)) + " x " + this.getRealSize(this.getDistanceInMap(rightTopPoint, rightBottomPoint)) + "m";
            this.mPath.reset();
            this.mPath.setLastPoint(this.sticker.getLeftBottomPoint().x, this.sticker.getLeftBottomPoint().y);
            this.mPath.lineTo(rightBottomPoint.x, rightBottomPoint.y);
            float halfWidth = this.getAreaSizePaint().measureText(realSize) / 2.0f;
            canvas.drawTextOnPath(realSize, this.mPath, width / 2.0f - halfWidth, 40.0f, this.getAreaSizePaint());
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (SweeperMapStateManager.getInstance().getState() != this.type) {
            return false;
        }
        int action = event.getActionMasked();
        boolean isStickerOnEdit = true;
        this.downInSticker = false;
        switch (action) {
            case 0: {
                this.downX = event.getX();
                this.downY = event.getY();
                if (this.sticker == null) {
                    return false;
                }
                if (null != this.rightTopIcon && this.rightTopIcon.isInActionCheck(event) && this.isEdit) {
                    if (this.listener != null) {
                        this.listener.onRightTopClick(this);
                    }
                    this.mode = 0;
                    break;
                }
                if (null != this.rightBottomIcon && this.rightBottomIcon.isInActionCheck(event) && this.isEdit) {
                    this.mode = 2;
                    this.downMatrix.set(this.sticker.getMatrix());
                    this.leftTopPoint = this.sticker.getLeftTopPoint();
                    break;
                }
                if (this.isInStickerArea(this.sticker, event)) {
                    this.downInSticker = true;
                    this.mode = 1;
                    this.downMatrix.set(this.sticker.getMatrix());
                    break;
                }
                if (null != this.leftTopIcon && this.leftTopIcon.isInActionCheck(event) && this.isEdit) {
                    this.mode = 3;
                    this.downMatrix.set(this.sticker.getMatrix());
                    this.oldMoveLocationX = event.getX();
                    this.oldMoveLocationY = event.getY();
                    this.angle = 0;
                    break;
                }
                isStickerOnEdit = false;
                break;
            }
            case 2: {
                if (this.mode == 2) {
                    this.moveMatrix.set(this.downMatrix);
                    PointF[] pointFS = this.getScalePoint(this.leftTopPoint, new PointF(event.getX(), event.getY()));
                    PointF leftBottom = pointFS[0];
                    PointF rightTop = pointFS[1];
                    ArrayList<PointF> list = new ArrayList<PointF>();
                    list.add(this.leftTopPoint);
                    list.add(rightTop);
                    list.add(new PointF(event.getX(), event.getY()));
                    list.add(leftBottom);
                    if (!this.checkWidthHeightLimit(list)) break;
                    this.sticker.updatePointList(list);
                    this.invalidate();
                    break;
                }
                if (this.mode == 1) {
                    this.moveMatrix.set(this.downMatrix);
                    this.moveMatrix.postTranslate(event.getX() - this.downX, event.getY() - this.downY);
                    this.mMatrix.reset();
                    this.mMatrix.postTranslate(event.getX() - this.downX, event.getY() - this.downY);
                    this.sticker.getMatrix().set(this.moveMatrix);
                    this.sticker.updatePoints(this.mMatrix);
                    this.invalidate();
                    this.downX = event.getX();
                    this.downY = event.getY();
                    break;
                }
                if (this.mode != 3) break;
                this.moveMatrix.set(this.downMatrix);
                PointF rotatePoint = new PointF((float)((int)event.getX()), (float)((int)event.getY()));
                PointF centerPoint = this.getCenterPoint();
                PointF initPoint = new PointF(this.oldMoveLocationX, this.oldMoveLocationY);
                this.initAngle = (int)this.sticker.calRotateAngle(centerPoint, initPoint, rotatePoint);
                this.angle += this.initAngle;
                L.d((String)TAG, (String)("angle:" + this.angle + "  initAngle:" + this.initAngle));
                if (this.angle > 360) {
                    this.angle -= 360;
                } else if (this.angle < -360) {
                    this.angle += 360;
                }
                if (this.initAngle == 0) break;
                this.moveMatrix.postRotate((float)this.angle, centerPoint.x, centerPoint.y);
                this.sticker.getMatrix().set(this.moveMatrix);
                this.mMatrix.reset();
                this.mMatrix.setRotate((float)this.initAngle, centerPoint.x, centerPoint.y);
                this.sticker.updatePoints(this.mMatrix);
                this.invalidate();
                this.oldMoveLocationX = event.getX();
                this.oldMoveLocationY = event.getY();
                break;
            }
            case 1: 
            case 6: {
                this.mode = 0;
                this.leftTopPoint = null;
                if (!(this.context instanceof ThemedReactContext) || this.type != 3) break;
                MapPointsData<PointF> typePointData = new MapPointsData<PointF>();
                typePointData.setData(this.getPointInfo());
                typePointData.setType(this.type);
                WritableMap writableMap = RNComponentUtil.parseToWritableMap(typePointData);
                ((RCTEventEmitter)((ThemedReactContext)this.context).getJSModule(RCTEventEmitter.class)).receiveEvent(this.getId(), "onLaserMapPoints", writableMap);
                break;
            }
        }
        if (this.downInSticker && this.listener != null) {
            this.listener.onCenterClick(this);
        }
        return isStickerOnEdit;
    }

    public boolean performClick() {
        return super.performClick();
    }

    private PointF[] getScalePoint(PointF leftTopPoint, PointF rightBottomPoint) {
        Matrix invertMatrix = new Matrix();
        this.sticker.getMatrix().invert(invertMatrix);
        float[] alreadyKnowPoint = new float[4];
        invertMatrix.mapPoints(alreadyKnowPoint, new float[]{leftTopPoint.x, leftTopPoint.y, rightBottomPoint.x, rightBottomPoint.y});
        PointF originLeftBottom = new PointF();
        originLeftBottom.x = alreadyKnowPoint[0];
        originLeftBottom.y = alreadyKnowPoint[3];
        PointF originRightTop = new PointF();
        originRightTop.x = alreadyKnowPoint[2];
        originRightTop.y = alreadyKnowPoint[1];
        float[] newCurrentPoint = new float[4];
        this.sticker.getMatrix().mapPoints(newCurrentPoint, new float[]{originLeftBottom.x, originLeftBottom.y, originRightTop.x, originRightTop.y});
        PointF leftBottom = new PointF();
        leftBottom.x = newCurrentPoint[0];
        leftBottom.y = newCurrentPoint[1];
        PointF rightTopPoint = new PointF();
        rightTopPoint.x = newCurrentPoint[2];
        rightTopPoint.y = newCurrentPoint[3];
        PointF[] pointFS = new PointF[]{leftBottom, rightTopPoint};
        return pointFS;
    }

    private boolean isMove(float oldMoveLocationX, float oldMoveLocationY, MotionEvent event) {
        return Math.abs(event.getRawX() - oldMoveLocationX) > 10.0f || Math.abs(event.getRawY() - oldMoveLocationY) > 10.0f;
    }

    private PointF getCenterPoint() {
        float centerX = (this.sticker.getLeftTopPoint().x + this.sticker.getRightBottomPoint().x) / 2.0f;
        float centerY = (this.sticker.getLeftTopPoint().y + this.sticker.getRightBottomPoint().y) / 2.0f;
        return new PointF(centerX, centerY);
    }

    private boolean isInStickerArea(Sticker sticker, MotionEvent event) {
        RectF dst = sticker.getBound();
        return dst.contains(event.getX(), event.getY());
    }

    private boolean checkWidthHeightLimit(Matrix matrix) {
        Pair<Float, Float> widthAndHeight = this.sticker.getWidthAndHeight(matrix);
        return ((Float)widthAndHeight.first).floatValue() > MIN_WIDTH && ((Float)widthAndHeight.second).floatValue() > MIN_HEIGHT;
    }

    private boolean checkWidthHeightLimit(List<PointF> list) {
        Pair<Float, Float> widthAndHeight = this.sticker.getWidthAndHeight(list);
        return ((Float)widthAndHeight.first).floatValue() > MIN_WIDTH && ((Float)widthAndHeight.second).floatValue() > MIN_HEIGHT;
    }

    public void setEdit(boolean edit) {
        this.isEdit = edit;
        this.postInvalidate();
    }

    public List<PointF> getPointInfo() {
        ArrayList<PointF> pointList = new ArrayList<PointF>();
        pointList.add(this.sticker.getLeftTopPoint());
        pointList.add(this.sticker.getRightTopPoint());
        pointList.add(this.sticker.getRightBottomPoint());
        pointList.add(this.sticker.getLeftBottomPoint());
        return pointList;
    }

    private float getDistanceInMap(PointF pointF, PointF pointF1) {
        PointF newPoint = SweeperMapStateManager.getInstance().getXYInMap(pointF);
        PointF newPoint1 = SweeperMapStateManager.getInstance().getXYInMap(pointF1);
        return (float)Math.sqrt(Math.pow(newPoint.x - newPoint1.x, 2.0) + Math.pow(newPoint.y - newPoint1.y, 2.0));
    }

    private float getHeightInMap(PointF bottomPointF, PointF topPointF) {
        return SweeperMapStateManager.getInstance().getXYInMap((PointF)bottomPointF).y - SweeperMapStateManager.getInstance().getXYInMap((PointF)topPointF).y;
    }

    private String getRealSize(float lengthOnScreen) {
        DecimalFormat decimalFormat = new DecimalFormat("0.0");
        return decimalFormat.format(lengthOnScreen * this.factor);
    }

    public Sticker getSticker() {
        return this.sticker;
    }

    public static Builder newBuilder(Context context) {
        return new Builder(context);
    }

    @Override
    public void onStateChanged(int state) {
        if (state == 0) {
            this.isEdit = false;
        }
        this.postInvalidate();
    }

    public static class Builder {
        private StickerView stickerView;

        private Builder(Context context) {
            this.stickerView = new StickerView(context);
        }

        public Builder edit(boolean edit) {
            this.stickerView.isEdit = edit;
            return this;
        }

        public Builder layoutParams(FrameLayout.LayoutParams layoutParams) {
            this.stickerView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            return this;
        }

        public Builder preScale(float scale) {
            this.stickerView.preScale = scale;
            return this;
        }

        public Builder type(int type) {
            this.stickerView.type = type;
            return this;
        }

        public Builder rightBottomIcon(ActionIcon rightBottomIcon) {
            this.stickerView.rightBottomIcon = rightBottomIcon;
            return this;
        }

        public Builder rightTopIcon(ActionIcon rightTopIcon) {
            this.stickerView.rightTopIcon = rightTopIcon;
            return this;
        }

        public Builder leftTopIcon(ActionIcon leftTopIcon) {
            this.stickerView.leftTopIcon = leftTopIcon;
            return this;
        }

        public Builder color(String color) {
            this.stickerView.sticker.setContentColor(color);
            return this;
        }

        public Builder points(List<PointF> pointList) {
            this.stickerView.sticker.setPointList(pointList);
            return this;
        }

        public Builder zoomFactor(HashMap<String, Object> zoomFactor) {
            this.stickerView.zoomFactor = zoomFactor;
            return this;
        }

        public Builder isMainMap(boolean isMainMap) {
            this.stickerView.isMainMap = isMainMap;
            return this;
        }

        public StickerView build() {
            return this.stickerView;
        }
    }
}

