/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.reactnativesweeper.view.sweepercommon.sticker;

import android.content.Context;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.MotionEvent;
import android.view.View;
import android.widget.FrameLayout;
import com.tuya.react_sweeper_common.R;
import com.tuya.reactnativesweeper.manager.HistoryMapStateManager;
import com.tuya.reactnativesweeper.manager.SweeperMapStateManager;
import com.tuya.reactnativesweeper.util.CollectionUtils;
import com.tuya.reactnativesweeper.util.SizeUtils;
import com.tuya.reactnativesweeper.view.sweepercommon.MatrixView;
import com.tuya.reactnativesweeper.view.sweepercommon.sticker.ActionIcon;
import com.tuya.reactnativesweeper.view.sweepercommon.sticker.OnStickerActionListener;
import com.tuya.reactnativesweeper.view.sweepercommon.sticker.StickerView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class StickerLayout
extends FrameLayout
implements MatrixView {
    private static final int POINT_COUNT = 4;
    private static final int DEFAULT_SIZE = 140;
    private SparseArray<List<StickerView>> mStateStickerArray;
    private Context mContext;
    private List<PointF> pointList;

    public StickerLayout(Context context) {
        this(context, null);
    }

    public StickerLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public StickerLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.mContext = context;
        this.mStateStickerArray = new SparseArray();
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.showPreview();
        return super.onTouchEvent(event);
    }

    @Override
    public void postTranslate(float xDiff, float yDiff) {
        for (int i = 0; i < this.mStateStickerArray.size(); ++i) {
            for (StickerView stickerView : (List)this.mStateStickerArray.valueAt(i)) {
                stickerView.postTranslate(xDiff, yDiff);
            }
        }
    }

    @Override
    public void postScale(float scale, PointF centerPoint) {
        for (int i = 0; i < this.mStateStickerArray.size(); ++i) {
            for (StickerView stickerView : (List)this.mStateStickerArray.valueAt(i)) {
                stickerView.postScale(scale, centerPoint);
            }
        }
    }

    public List<List<PointF>> getPointInfo(int type) {
        List stickerViewList = (List)this.mStateStickerArray.get(type);
        if (null == stickerViewList || stickerViewList.isEmpty()) {
            return null;
        }
        ArrayList<List<PointF>> pointList = new ArrayList<List<PointF>>();
        for (StickerView stickerView : stickerViewList) {
            pointList.add(stickerView.getPointInfo());
        }
        return pointList;
    }

    public void removeAllSticker(int type) {
        List stickerViewList = (List)this.mStateStickerArray.get(type);
        if (CollectionUtils.isEmpty(stickerViewList)) {
            return;
        }
        for (StickerView stickerView : stickerViewList) {
            this.removeView((View)stickerView);
        }
        this.mStateStickerArray.remove(type);
        this.requestLayout();
    }

    public void reset(Matrix matrix) {
        for (int i = 0; i < this.mStateStickerArray.size(); ++i) {
            for (StickerView stickerView : (List)this.mStateStickerArray.valueAt(i)) {
                stickerView.reset(matrix);
            }
        }
    }

    public void addStickerList(int type, List<List<PointF>> doublePointList, float mapScale) {
        this.addStickerList(type, doublePointList, mapScale, true);
    }

    public void addStickerList(int type, List<List<PointF>> doublePointList, float mapScale, boolean isMainMap) {
        this.removeAllSticker(type);
        if (CollectionUtils.isEmpty(doublePointList)) {
            return;
        }
        for (List<PointF> pointFS : doublePointList) {
            if (pointFS.size() < 4) continue;
            this.addSticker(type, pointFS, mapScale, false, isMainMap);
        }
    }

    public void addSticker(int type, float mapScale) {
        this.addSticker(type, this.generatePointList(), mapScale, true, true);
    }

    public void addSticker(int type, float mapScale, boolean isMainMap) {
        this.addSticker(type, this.generatePointList(), mapScale, true, isMainMap);
    }

    private void addSticker(final int type, List<PointF> pointList, float mapScale, boolean edit, boolean isMainMap) {
        if (CollectionUtils.isEmpty(pointList)) {
            return;
        }
        if (pointList.size() != 4) {
            return;
        }
        this.pointList = pointList;
        String contentColor = null;
        if (2 == type) {
            contentColor = isMainMap ? SweeperMapStateManager.getInstance().getSweepRegionColor() : HistoryMapStateManager.getInstance().getSweepRegionColor();
        }
        if (3 == type) {
            contentColor = isMainMap ? SweeperMapStateManager.getInstance().getVirtualAreaColor() : HistoryMapStateManager.getInstance().getVirtualAreaColor();
        }
        if (TextUtils.isEmpty((CharSequence)contentColor)) {
            return;
        }
        if (null == this.mStateStickerArray.get(type)) {
            this.mStateStickerArray.put(type, new ArrayList());
        }
        HashMap<String, Object> zoomFactor = SweeperMapStateManager.getInstance().getZoomFactor();
        final List stickerViewList = (List)this.mStateStickerArray.get(type);
        ActionIcon rightTopIcon = new ActionIcon(this.getContext());
        rightTopIcon.setSrcIcon(R.drawable.panel_sticker_remove);
        ActionIcon rightBottomIcon = new ActionIcon(this.getContext());
        rightBottomIcon.setSrcIcon(R.drawable.panel_sticker_resize);
        ActionIcon leftTopIcon = null;
        if (type == 3) {
            leftTopIcon = new ActionIcon(this.getContext());
            leftTopIcon.setSrcIcon(R.drawable.sweeper_rotate);
        }
        StickerView stickerView = StickerView.newBuilder(this.mContext).preScale(mapScale).layoutParams(new FrameLayout.LayoutParams(-1, -1)).rightTopIcon(rightTopIcon).rightBottomIcon(rightBottomIcon).leftTopIcon(leftTopIcon).color(contentColor).points(pointList).edit(edit).type(type).isMainMap(isMainMap).zoomFactor(zoomFactor).build();
        stickerView.setOnStickerActionListener(new OnStickerActionListener(){

            @Override
            public void onRightTopClick(StickerView view) {
                StickerLayout.this.removeViewRedraw(view, type);
            }

            @Override
            public void onCenterClick(StickerView view) {
                int index = stickerViewList.indexOf(view);
                view.bringToFront();
                StickerLayout.this.redrawByIndex(index, type);
            }
        });
        this.addViewRedraw(stickerView, type, edit);
    }

    private void addViewRedraw(StickerView stickerView, int state, boolean edit) {
        this.addView((View)stickerView);
        stickerView.requestLayout();
        List stickerViewList = (List)this.mStateStickerArray.get(state);
        if (null != stickerViewList) {
            stickerViewList.add(stickerView);
        }
        if (edit) {
            this.redraw(state);
        }
    }

    private void removeViewRedraw(StickerView stickerView, int state) {
        List stickerViewList = (List)this.mStateStickerArray.get(state);
        if (!CollectionUtils.isEmpty(stickerViewList)) {
            stickerViewList.remove(stickerView);
        }
        this.removeView((View)stickerView);
        this.redraw(state);
    }

    private List<PointF> generatePointList() {
        int bonds = (int)SizeUtils.dip2px(this.getContext(), 140.0f);
        int width = this.getWidth();
        int height = this.getHeight();
        float x = (width - bonds) / 2;
        float y = (height - bonds) / 2;
        ArrayList<PointF> pointFList = new ArrayList<PointF>();
        pointFList.add(new PointF(x, y));
        pointFList.add(new PointF(x + (float)bonds, y));
        pointFList.add(new PointF(x + (float)bonds, y + (float)bonds));
        pointFList.add(new PointF(x, y + (float)bonds));
        return pointFList;
    }

    private void showPreview() {
        for (int i = 0; i < this.mStateStickerArray.size(); ++i) {
            for (StickerView stickerView : (List)this.mStateStickerArray.valueAt(i)) {
                stickerView.setEdit(false);
            }
        }
    }

    private void redraw(int state) {
        List stickerViewList = (List)this.mStateStickerArray.get(state);
        if (CollectionUtils.isEmpty(stickerViewList)) {
            return;
        }
        this.redrawByIndex(stickerViewList.size() - 1, state);
    }

    private void redrawByIndex(int index, int state) {
        List stickerViewList = (List)this.mStateStickerArray.get(state);
        if (CollectionUtils.isEmpty(stickerViewList)) {
            return;
        }
        int size = stickerViewList.size();
        for (int i = 0; i < size; ++i) {
            StickerView item = (StickerView)stickerViewList.get(i);
            if (index != i) {
                item.setEdit(false);
                continue;
            }
            item.setEdit(true);
        }
    }
}

