/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.reactnativesweeper.view.sweepercommon.sticker;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.DashPathEffect;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PointF;
import android.graphics.RectF;
import android.text.TextUtils;
import android.util.Pair;
import android.view.MotionEvent;
import com.facebook.react.uimanager.PixelUtil;
import com.tuya.reactnativesweeper.util.CollectionUtils;
import com.tuya.smart.android.common.utils.L;
import java.util.ArrayList;
import java.util.List;

public class Sticker {
    private final String TAG = "Sticker";
    private Matrix mMatrix = new Matrix();
    private List<PointF> mPointList;
    private Path mPath;
    private Paint mBorderPaint = new Paint();
    private Paint mBgPaint;

    Sticker() {
        this.mBorderPaint.setAntiAlias(true);
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
        this.mBorderPaint.setColor(-1);
        this.mBorderPaint.setStrokeWidth(PixelUtil.toPixelFromDIP((float)1.0f));
        this.mBorderPaint.setPathEffect((PathEffect)new DashPathEffect(new float[]{10.0f, 5.0f, 10.0f, 5.0f}, 0.0f));
        this.mBgPaint = new Paint();
        this.mBgPaint.setAntiAlias(true);
        this.mBgPaint.setStyle(Paint.Style.FILL);
    }

    void setPointList(List<PointF> pointFList) {
        this.mPointList = pointFList;
        if (CollectionUtils.isEmpty(this.mPointList)) {
            return;
        }
        this.mPath = new Path();
        for (int i = 0; i < this.mPointList.size(); ++i) {
            if (i == 0) {
                this.mPath.setLastPoint(this.mPointList.get((int)i).x, this.mPointList.get((int)i).y);
                continue;
            }
            this.mPath.lineTo(this.mPointList.get((int)i).x, this.mPointList.get((int)i).y);
        }
        this.mPath.close();
        if (this.isRotated(this.mPointList)) {
            this.initRotateRect();
        }
    }

    void updatePointList(List<PointF> pointFList) {
        this.mPointList = pointFList;
        if (CollectionUtils.isEmpty(this.mPointList)) {
            return;
        }
        this.mPath = new Path();
        for (int i = 0; i < this.mPointList.size(); ++i) {
            if (i == 0) {
                this.mPath.setLastPoint(this.mPointList.get((int)i).x, this.mPointList.get((int)i).y);
                continue;
            }
            this.mPath.lineTo(this.mPointList.get((int)i).x, this.mPointList.get((int)i).y);
        }
        this.mPath.close();
    }

    private void initRotateRect() {
        PointF leftTopPoint = this.getUnRotatedLeftTopPoint();
        L.d((String)"Sticker", (String)("origin left:" + leftTopPoint.x + " y:" + leftTopPoint.y + "  now left x:" + this.mPointList.get((int)0).x + " y:" + this.mPointList.get((int)0).y));
        float originAngle = (int)this.calRotateAngle(this.getOriginCenterPoint(), leftTopPoint, this.mPointList.get(0));
        L.d((String)"Sticker", (String)("orgin angle:" + originAngle));
        this.mMatrix.postRotate(originAngle, this.getOriginCenterPoint().x, this.getOriginCenterPoint().y);
    }

    private PointF getOriginCenterPoint() {
        return new PointF((this.mPointList.get((int)0).x + this.mPointList.get((int)2).x) / 2.0f, (this.mPointList.get((int)0).y + this.mPointList.get((int)2).y) / 2.0f);
    }

    private boolean isRotated(List<PointF> mPointList) {
        return mPointList.get((int)1).y - mPointList.get((int)0).y != 0.0f || mPointList.get((int)0).x > mPointList.get((int)2).x && mPointList.get((int)0).y > mPointList.get((int)2).y;
    }

    private PointF getUnRotatedLeftTopPoint() {
        int acrossSide = (int)this.getDistance(this.mPointList.get(0), this.mPointList.get(1));
        int verticalSide = (int)this.getDistance(this.mPointList.get(1), this.mPointList.get(2));
        PointF centerPoint = this.getOriginCenterPoint();
        L.d((String)"Sticker", (String)("acrossSide:" + acrossSide + " verticalSide:" + verticalSide));
        L.d((String)"Sticker", (String)("center:" + centerPoint.x + " y:" + centerPoint.y));
        return new PointF(centerPoint.x - (float)(acrossSide / 2), centerPoint.y - (float)(verticalSide / 2));
    }

    void setContentColor(String color) {
        if (TextUtils.isEmpty((CharSequence)color)) {
            return;
        }
        this.mBgPaint.setColor(Color.parseColor((String)color));
    }

    void draw(Canvas canvas) {
        if (null == this.mPath) {
            return;
        }
        Path dst = new Path();
        dst.addPath(this.mPath);
        canvas.drawPath(dst, this.mBorderPaint);
        canvas.drawPath(dst, this.mBgPaint);
    }

    PointF getMidPoint(MotionEvent event) {
        PointF point = new PointF();
        float x = event.getX(0) + event.getX(1);
        float y = event.getY(0) + event.getY(1);
        point.set(x / 2.0f, y / 2.0f);
        return point;
    }

    PointF getLeftTopPoint() {
        return this.mPointList.get(0);
    }

    PointF getRightTopPoint() {
        return this.mPointList.get(1);
    }

    PointF getRightBottomPoint() {
        return this.mPointList.get(2);
    }

    PointF getLeftBottomPoint() {
        return this.mPointList.get(3);
    }

    public PointF getCenterPoint() {
        float[] points = new float[4];
        PointF leftTop = this.mPointList.get(0);
        PointF rightBottom = this.mPointList.get(2);
        this.mMatrix.mapPoints(points, new float[]{leftTop.x, leftTop.y, rightBottom.x, rightBottom.y});
        return new PointF((points[2] + points[0]) / 2.0f, (points[3] + points[1]) / 2.0f);
    }

    Pair<Float, Float> getWidthAndHeight(Matrix matrix) {
        PointF leftTop = this.mPointList.get(0);
        PointF rightTop = this.mPointList.get(1);
        PointF rightBottom = this.mPointList.get(2);
        float width = (float)Math.sqrt(Math.pow(leftTop.x - rightTop.x, 2.0) + Math.pow(leftTop.y - rightTop.y, 2.0));
        float height = (float)Math.sqrt(Math.pow(rightTop.x - rightBottom.x, 2.0) + Math.pow(rightTop.y - rightBottom.y, 2.0));
        return Pair.create((Object)Float.valueOf(width), (Object)Float.valueOf(height));
    }

    Pair<Float, Float> getWidthAndHeight(List<PointF> mPointList) {
        PointF leftTop = mPointList.get(0);
        PointF rightTop = mPointList.get(1);
        PointF rightBottom = mPointList.get(2);
        float width = (float)Math.sqrt(Math.pow(leftTop.x - rightTop.x, 2.0) + Math.pow(leftTop.y - rightTop.y, 2.0));
        float height = (float)Math.sqrt(Math.pow(rightTop.x - rightBottom.x, 2.0) + Math.pow(rightTop.y - rightBottom.y, 2.0));
        return Pair.create((Object)Float.valueOf(width), (Object)Float.valueOf(height));
    }

    float getMultiTouchDistance(MotionEvent event) {
        float x = event.getX(0) - event.getX(1);
        float y = event.getY(0) - event.getY(1);
        return (float)Math.sqrt(x * x + y * y);
    }

    float getSingleTouchDistance(MotionEvent event, PointF imageMidPoint) {
        float x = event.getX(0) - imageMidPoint.x;
        float y = event.getY(0) - imageMidPoint.y;
        return (float)Math.sqrt(x * x + y * y);
    }

    float getSingleTouchDistanceX(MotionEvent event, PointF imageMidPoint) {
        return event.getX(0) - imageMidPoint.x;
    }

    float getSingleTouchDistanceY(MotionEvent event, PointF imageMidPoint) {
        return event.getY(0) - imageMidPoint.y;
    }

    float getDistance(PointF pointF, PointF pointF1) {
        return (float)Math.sqrt(Math.pow(pointF.x - pointF1.x, 2.0) + Math.pow(pointF.y - pointF1.y, 2.0));
    }

    RectF getBound() {
        Path transformPath = new Path();
        transformPath.addPath(this.mPath);
        RectF dst = new RectF();
        transformPath.computeBounds(dst, true);
        return dst;
    }

    Matrix getMatrix() {
        return this.mMatrix;
    }

    public void setMatrix(Matrix matrix) {
        this.mMatrix = matrix;
    }

    public float calRotateAngle(PointF centerPoint, PointF initPoint, PointF rotatePoint) {
        float init_rotate;
        float center_rotate;
        float center_init = (float)Math.pow(centerPoint.x - initPoint.x, 2.0) + (float)Math.pow(centerPoint.y - initPoint.y, 2.0);
        double cosAngle = (double)(center_init + (center_rotate = (float)Math.pow(centerPoint.x - rotatePoint.x, 2.0) + (float)Math.pow(centerPoint.y - rotatePoint.y, 2.0)) - (init_rotate = (float)Math.pow(initPoint.x - rotatePoint.x, 2.0) + (float)Math.pow(initPoint.y - rotatePoint.y, 2.0))) / (2.0 * Math.sqrt(center_init) * Math.sqrt(center_rotate));
        if (cosAngle > 1.0) {
            cosAngle = 1.0;
        } else if (cosAngle < -1.0) {
            cosAngle = -1.0;
        }
        double angle = Math.acos(cosAngle);
        boolean isClockwise = (initPoint.x - centerPoint.x) * (rotatePoint.y - centerPoint.y) - (initPoint.y - centerPoint.y) * (rotatePoint.x - centerPoint.x) > 0.0f;
        return (float)(isClockwise ? Math.toDegrees(angle) : -Math.toDegrees(angle));
    }

    public void postTranslate(float xValue, float yValue) {
        ArrayList<PointF> list = new ArrayList<PointF>();
        list.addAll(this.mPointList);
        for (PointF pointF : list) {
            pointF.x += xValue;
            pointF.y += yValue;
        }
        this.updatePointList(list);
    }

    public void updatePoints(Matrix moveMatrix) {
        ArrayList<PointF> list = new ArrayList<PointF>();
        float[] dst = new float[8];
        moveMatrix.mapPoints(dst, new float[]{this.mPointList.get((int)0).x, this.mPointList.get((int)0).y, this.mPointList.get((int)1).x, this.mPointList.get((int)1).y, this.mPointList.get((int)2).x, this.mPointList.get((int)2).y, this.mPointList.get((int)3).x, this.mPointList.get((int)3).y});
        PointF pointF = new PointF(dst[0], dst[1]);
        PointF pointF1 = new PointF(dst[2], dst[3]);
        PointF pointF2 = new PointF(dst[4], dst[5]);
        PointF pointF3 = new PointF(dst[6], dst[7]);
        list.add(pointF);
        list.add(pointF1);
        list.add(pointF2);
        list.add(pointF3);
        this.updatePointList(list);
    }
}

