/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.reactnativesweeper.view.sweepercommon;

import android.content.Context;
import android.graphics.PointF;
import android.util.AttributeSet;
import android.view.View;
import android.widget.RelativeLayout;
import com.tuya.reactnativesweeper.manager.SweeperMapStateManager;
import com.tuya.reactnativesweeper.util.CollectionUtils;
import com.tuya.reactnativesweeper.view.sweepercommon.AppointView;
import com.tuya.reactnativesweeper.view.sweepercommon.sticker.StickerLayout;
import com.tuya.reactnativesweeper.view.sweepercommon.virtualwall.VirtualWallLayout;
import com.tuya.smart.android.common.utils.L;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class StateBaseMap
extends RelativeLayout {
    private final String TAG = "StateBaseMap";
    protected AtomicBoolean isAnimation = new AtomicBoolean(false);
    protected LinkedList<Runnable> pendingDrawTask = new LinkedList();

    public StateBaseMap(Context context) {
        this(context, null);
    }

    public StateBaseMap(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public StateBaseMap(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        SweeperMapStateManager.getInstance().attachMap(this);
        this.initView();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        SweeperMapStateManager.getInstance().detachedMap(this);
    }

    public void requestLayout() {
        super.requestLayout();
        this.reLayout();
    }

    public void reLayout() {
        if (this.getWidth() > 0 && this.getHeight() > 0) {
            int w = View.MeasureSpec.makeMeasureSpec((int)this.getWidth(), (int)0x40000000);
            int h = View.MeasureSpec.makeMeasureSpec((int)this.getHeight(), (int)0x40000000);
            this.measure(w, h);
            this.layout(this.getPaddingLeft() + this.getLeft(), this.getPaddingTop() + this.getTop(), this.getWidth() + this.getPaddingLeft() + this.getLeft(), this.getHeight() + this.getPaddingTop() + this.getTop());
        }
    }

    public abstract void initView();

    public abstract StickerLayout getSweepRegionLayout();

    public abstract StickerLayout getForbiddenLayout();

    public abstract VirtualWallLayout getWallLayout();

    public abstract AppointView getAppointIv();

    public abstract float getMapPreScale();

    public abstract PointF calculateInView(PointF var1);

    public abstract PointF calculateXYInMap(PointF var1);

    public abstract boolean isInitMap();

    public void addSticker(int state) {
        this.addSticker(state, true);
    }

    public void addSticker(final int state, final boolean isMainMap) {
        this.post(new Runnable(){

            @Override
            public void run() {
                if (state == 3) {
                    StateBaseMap.this.getForbiddenLayout().addSticker(state, StateBaseMap.this.getMapPreScale(), isMainMap);
                } else {
                    StateBaseMap.this.getSweepRegionLayout().addSticker(state, StateBaseMap.this.getMapPreScale(), isMainMap);
                }
            }
        });
    }

    public void addVirtualWall() {
        this.addVirtualWall(true);
    }

    public void addVirtualWall(final boolean isMainMap) {
        this.post(new Runnable(){

            @Override
            public void run() {
                StateBaseMap.this.getWallLayout().addVirtualWall(StateBaseMap.this.getMapPreScale(), isMainMap);
            }
        });
    }

    public void addAppointView(float x, float y) {
        this.getAppointIv().addPoint(x, y, true, this.getMapPreScale());
    }

    public void removeAppoint() {
        this.post(new Runnable(){

            @Override
            public void run() {
                StateBaseMap.this.getAppointIv().remove();
            }
        });
    }

    public void removeSweeperRegion() {
        this.post(new Runnable(){

            @Override
            public void run() {
                StateBaseMap.this.getSweepRegionLayout().removeAllSticker(2);
            }
        });
    }

    public void drawAppoint(final PointF pointF) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                if (null == pointF) {
                    StateBaseMap.this.getAppointIv().remove();
                    return;
                }
                PointF pointInView = StateBaseMap.this.calculateInView(pointF);
                StateBaseMap.this.getAppointIv().addPoint(pointInView.x, pointInView.y, false, StateBaseMap.this.getMapPreScale());
            }
        };
        if (this.isAnimation.get()) {
            L.w((String)"LaserMapView", (String)"drawAppoint add pending ---");
            this.pendingDrawTask.add(task);
        } else {
            this.post(task);
        }
    }

    public void drawSweepRegion(final List<List<PointF>> pointDoubleList) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                List convertPointInView = StateBaseMap.this.convertPointInView(pointDoubleList);
                StateBaseMap.this.getSweepRegionLayout().addStickerList(2, convertPointInView, StateBaseMap.this.getMapPreScale());
                try {
                    if (convertPointInView != null) {
                        for (List list : convertPointInView) {
                            if (list == null) continue;
                            for (PointF pointF : list) {
                                L.d((String)"StateBaseMap", (String)("drawSweepRegion " + pointF.toString()));
                            }
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        if (this.isAnimation.get()) {
            L.w((String)"LaserMapView", (String)"drawSweepRegion add pending ---");
            this.pendingDrawTask.add(task);
        } else {
            this.post(task);
        }
    }

    public void drawVirtualArea(final List<List<PointF>> pointDoubleList) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                List convertPointInView = StateBaseMap.this.convertPointInView(pointDoubleList);
                StateBaseMap.this.getForbiddenLayout().addStickerList(3, convertPointInView, StateBaseMap.this.getMapPreScale());
                try {
                    if (convertPointInView != null) {
                        for (List list : convertPointInView) {
                            if (list == null) continue;
                            for (PointF pointF : list) {
                                L.d((String)"StateBaseMap", (String)("drawVirtualArea " + pointF.toString()));
                            }
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        L.d((String)"LaserMapView", (String)("drawVirtualArea   isAnimation====" + this.isAnimation.get()));
        if (this.isAnimation.get()) {
            L.w((String)"LaserMapView", (String)"drawVirtualArea add pending ---");
            this.pendingDrawTask.add(task);
        } else {
            L.w((String)"LaserMapView", (String)"drawVirtualArea  directly  ---");
            this.post(task);
        }
    }

    public void drawVirtualWall(final List<List<PointF>> pointDoubleList) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                List convertPointInView = StateBaseMap.this.convertPointInView(pointDoubleList);
                StateBaseMap.this.getWallLayout().addVirtualWallList(convertPointInView, StateBaseMap.this.getMapPreScale());
                try {
                    if (convertPointInView != null) {
                        for (List list : convertPointInView) {
                            if (list == null) continue;
                            for (PointF pointF : list) {
                                L.d((String)"StateBaseMap", (String)("drawVirtualWall " + pointF.toString()));
                            }
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        if (this.isAnimation.get()) {
            L.w((String)"LaserMapView", (String)"drawVirtualWall add pending ---");
            this.pendingDrawTask.add(task);
        } else {
            this.post(task);
        }
    }

    public List<List<PointF>> getVirtualWallPoint() {
        return this.convertPointInMap(this.getWallLayout().getPointInfo());
    }

    public List<List<PointF>> getForbiddenZonePoint() {
        return this.convertPointInMap(this.getForbiddenLayout().getPointInfo(3));
    }

    public List<List<PointF>> getSweepRegionPoint() {
        return this.convertPointInMap(this.getSweepRegionLayout().getPointInfo(2));
    }

    public List<PointF> getAppointPoint() {
        PointF currentPoint = this.getAppointIv().getCurrentPoint();
        if (null == currentPoint) {
            return null;
        }
        PointF pointInMap = this.calculateXYInMap(currentPoint);
        ArrayList<PointF> pointList = new ArrayList<PointF>();
        pointList.add(pointInMap);
        return pointList;
    }

    private List<List<PointF>> convertPointInMap(List<List<PointF>> pointList) {
        if (CollectionUtils.isEmpty(pointList)) {
            return null;
        }
        ArrayList<List<PointF>> finalList = new ArrayList<List<PointF>>();
        for (List<PointF> pointInViewList : pointList) {
            ArrayList<PointF> tempList = new ArrayList<PointF>();
            for (PointF pointF : pointInViewList) {
                PointF pointInMap = this.calculateXYInMap(pointF);
                tempList.add(pointInMap);
            }
            finalList.add(tempList);
        }
        return finalList;
    }

    private List<List<PointF>> convertPointInView(List<List<PointF>> pointList) {
        if (CollectionUtils.isEmpty(pointList)) {
            return null;
        }
        ArrayList<List<PointF>> finalList = new ArrayList<List<PointF>>();
        for (List<PointF> pointInViewList : pointList) {
            ArrayList<PointF> tempList = new ArrayList<PointF>();
            for (PointF pointF : pointInViewList) {
                PointF pointInMap = this.calculateInView(pointF);
                tempList.add(pointInMap);
            }
            finalList.add(tempList);
        }
        return finalList;
    }

    protected void dequeuePendingTask() {
        if (this.pendingDrawTask.isEmpty()) {
            return;
        }
        this.post(this.pendingDrawTask.poll());
        this.dequeuePendingTask();
    }
}

