/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.reactnativesweeper.view.sweepercommon;

import android.content.Context;
import android.graphics.PointF;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.widget.RelativeLayout;
import com.tuya.reactnativesweeper.view.sweepercommon.MatrixView;
import java.util.ArrayList;
import java.util.List;

public class ScaleLayout
extends RelativeLayout {
    private static final String TAG = ScaleLayout.class.getSimpleName();
    private float minScale = 0.5f;
    private float maxScale = 4.0f;
    private float endScale = 1.0f;
    private float initScale = 1.0f;
    private float tempScale;
    private GestureDetector gestureDetector;
    private ScaleGestureDetector scaleGestureDetector;
    private List<MatrixView> matrixViewList;
    private ActionListener mActionListener;

    public ScaleLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    public ScaleLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public ScaleLayout(Context context) {
        super(context);
        this.init(context);
    }

    private void init(Context context) {
        this.matrixViewList = new ArrayList<MatrixView>();
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
            }
        });
        this.scaleGestureDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)new ScaleGestureListener());
        this.gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onDoubleTap(MotionEvent e) {
                ScaleLayout.this.endScale = ScaleLayout.this.initScale;
                if (null != ScaleLayout.this.mActionListener) {
                    ScaleLayout.this.mActionListener.onDoubleClick();
                }
                return true;
            }

            public boolean onSingleTapConfirmed(MotionEvent e) {
                if (null != ScaleLayout.this.mActionListener) {
                    ScaleLayout.this.mActionListener.onSingleClick(e.getX(), e.getY());
                }
                return super.onSingleTapConfirmed(e);
            }

            public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
                for (MatrixView matrixView : ScaleLayout.this.matrixViewList) {
                    matrixView.postTranslate(-distanceX, -distanceY);
                }
                return super.onScroll(e1, e2, distanceX, distanceY);
            }
        });
    }

    public void addMatrixView(MatrixView matrixView) {
        if (null != matrixView) {
            this.matrixViewList.add(matrixView);
        }
    }

    public void setMaxScale(float maxScale) {
        this.maxScale = maxScale;
    }

    public void setActionListener(ActionListener listener) {
        this.mActionListener = listener;
    }

    public void setInitScale(float scale) {
        this.initScale = scale;
        this.endScale = scale;
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.gestureDetector.onTouchEvent(event);
        int pointerCount = event.getPointerCount();
        if (pointerCount == 2) {
            switch (event.getAction()) {
                case 0: {
                    break;
                }
                case 2: {
                    break;
                }
                case 262: {
                    break;
                }
            }
            return this.scaleGestureDetector.onTouchEvent(event);
        }
        return super.onTouchEvent(event);
    }

    class ScaleGestureListener
    implements ScaleGestureDetector.OnScaleGestureListener {
        ScaleGestureListener() {
        }

        public boolean onScale(ScaleGestureDetector detector) {
            PointF center = new PointF(detector.getFocusX(), detector.getFocusY());
            ScaleLayout.this.tempScale = ScaleLayout.this.endScale * detector.getScaleFactor();
            if (ScaleLayout.this.tempScale < ScaleLayout.this.minScale) {
                ScaleLayout.this.tempScale = ScaleLayout.this.minScale;
            }
            if (ScaleLayout.this.tempScale > ScaleLayout.this.maxScale) {
                ScaleLayout.this.tempScale = ScaleLayout.this.maxScale;
            }
            for (MatrixView matrixView : ScaleLayout.this.matrixViewList) {
                matrixView.postScale(ScaleLayout.this.tempScale / ScaleLayout.this.initScale, center);
            }
            return false;
        }

        public boolean onScaleBegin(ScaleGestureDetector detector) {
            return true;
        }

        public void onScaleEnd(ScaleGestureDetector detector) {
            ScaleLayout.this.endScale = ScaleLayout.this.tempScale;
        }
    }

    public static interface ActionListener {
        public void onDoubleClick();

        public void onSingleClick(float var1, float var2);
    }
}

