/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.reactnativesweeper.view.sweepercommon;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import com.tuya.reactnativesweeper.anim.MatrixAnimator;
import com.tuya.reactnativesweeper.manager.SweeperMapStateManager;
import com.tuya.reactnativesweeper.view.sweepercommon.MatrixView;

public class AppointView
extends AppCompatImageView
implements MatrixView {
    private static final String TAG = AppointView.class.getSimpleName();
    private Bitmap bitmap;
    private Matrix allMatrix = new Matrix();
    private Matrix outerMatrix = new Matrix();
    private int width;
    private int height;
    private PointF mPointF;
    private boolean isEdit;
    private float preScale = 1.0f;

    public AppointView(Context context) {
        this(context, null);
    }

    public AppointView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AppointView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onDraw(Canvas canvas) {
        if (!this.isEdit) {
            return;
        }
        float[] values = new float[]{0.0f, 0.0f};
        this.allMatrix.mapPoints(values);
        float finalX = values[0] - (float)(this.width / 2);
        float finalY = values[1] - (float)this.height;
        canvas.drawBitmap(this.bitmap, finalX, finalY, null);
    }

    public void addPoint(float x, float y, boolean isClick, float mapScale) {
        this.bitmap = SweeperMapStateManager.getInstance().getAppointIcon();
        if (null == this.bitmap) {
            return;
        }
        this.width = this.bitmap.getWidth();
        this.height = this.bitmap.getHeight();
        this.outerMatrix.reset();
        this.mPointF = new PointF();
        this.preScale = mapScale;
        this.mPointF.x = x;
        this.mPointF.y = y;
        this.isEdit = true;
        if (isClick) {
            Matrix startImageMatrix = new Matrix();
            startImageMatrix.setTranslate(this.mPointF.x, 0.0f);
            Matrix endImageMatrix = new Matrix();
            endImageMatrix.setTranslate(this.mPointF.x, this.mPointF.y);
            MatrixAnimator matrixAnimator = new MatrixAnimator(startImageMatrix, endImageMatrix);
            matrixAnimator.setListener(new MatrixAnimator.AnimationListener(){

                @Override
                public void onAnimationUpdate(Matrix matrix) {
                    AppointView.this.allMatrix.set(matrix);
                    AppointView.this.invalidate();
                }

                @Override
                public void onAnimationEnd() {
                }
            });
            matrixAnimator.start();
        } else {
            this.allMatrix.setTranslate(this.mPointF.x, this.mPointF.y);
            this.invalidate();
        }
    }

    public void reset(Matrix matrix) {
        Matrix endMatrix = new Matrix();
        endMatrix.set(this.allMatrix);
        endMatrix.postConcat(matrix);
        MatrixAnimator matrixAnimator = new MatrixAnimator(this.allMatrix, endMatrix);
        matrixAnimator.setListener(new MatrixAnimator.AnimationListener(){

            @Override
            public void onAnimationUpdate(Matrix matrix) {
                AppointView.this.allMatrix.set(matrix);
                AppointView.this.invalidate();
            }

            @Override
            public void onAnimationEnd() {
                AppointView.this.preScale = 1.0f;
            }
        });
        matrixAnimator.start();
    }

    @Override
    public void postTranslate(float xDiff, float yDiff) {
        this.allMatrix.postTranslate(xDiff, yDiff);
        this.outerMatrix.postTranslate(xDiff, yDiff);
        this.invalidate();
    }

    @Override
    public void postScale(float scale, PointF pointF) {
        this.allMatrix.postScale(scale / this.preScale, scale / this.preScale, pointF.x, pointF.y);
        this.outerMatrix.postScale(scale / this.preScale, scale / this.preScale, pointF.x, pointF.y);
        this.preScale = scale;
        this.invalidate();
    }

    public void remove() {
        this.isEdit = false;
        this.allMatrix.reset();
        this.outerMatrix.reset();
        this.mPointF = null;
        this.invalidate();
    }

    public PointF getCurrentPoint() {
        if (null == this.mPointF) {
            return null;
        }
        float[] points = new float[]{this.mPointF.x, this.mPointF.y};
        this.outerMatrix.mapPoints(points);
        return new PointF(points[0], points[1]);
    }
}

