/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.reactnativesweeper.util;

import android.app.Activity;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;

public class RNComponentUtil {
    public static void sendEvent(ReactContext reactContext, String eventName, @Nullable WritableMap params) {
        ((DeviceEventManagerModule.RCTDeviceEventEmitter)reactContext.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class)).emit(eventName, (Object)params);
    }

    public static String getDeviceId(Activity activity) {
        String deviceId = "";
        if (activity != null) {
            deviceId = activity.getIntent().getStringExtra("devId");
        }
        return deviceId;
    }

    public static WritableMap parseToWritableMap(String s) {
        if (TextUtils.isEmpty((CharSequence)s)) {
            return Arguments.createMap();
        }
        return RNComponentUtil.parseToWritableMap(JSON.parseObject((String)s));
    }

    public static WritableMap parseToWritableMap(Object object) {
        if (null == object) {
            return Arguments.createMap();
        }
        return RNComponentUtil.parseToWritableMap(JSON.toJSONString((Object)object));
    }

    public static WritableMap parseToWritableMap(JSONObject json) {
        WritableMap map = Arguments.createMap();
        Set entries = json.entrySet();
        for (Map.Entry next : entries) {
            String key = (String)next.getKey();
            Object obv = next.getValue();
            if (obv instanceof JSONObject) {
                map.putMap(key, RNComponentUtil.parseToWritableMap((JSONObject)obv));
                continue;
            }
            if (obv instanceof Integer) {
                map.putInt(key, ((Integer)obv).intValue());
                continue;
            }
            if (obv instanceof String) {
                map.putString(key, String.valueOf(obv));
                continue;
            }
            if (obv instanceof Boolean) {
                map.putBoolean(key, ((Boolean)obv).booleanValue());
                continue;
            }
            if (obv instanceof Double || obv instanceof Float) {
                map.putDouble(key, ((Double)obv).doubleValue());
                continue;
            }
            if (obv instanceof JSONArray) {
                map.putArray(key, RNComponentUtil.parseToWritableArray((JSONArray)obv));
                continue;
            }
            if (obv instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)obv;
                map.putDouble(key, bigDecimal.doubleValue());
                continue;
            }
            map.putNull(key);
        }
        return map;
    }

    public static WritableArray parseToWritableArray(JSONArray jsonArray) {
        WritableArray list = Arguments.createArray();
        for (Object obv : jsonArray.toArray()) {
            if (obv instanceof JSONObject) {
                list.pushMap(RNComponentUtil.parseToWritableMap((JSONObject)obv));
                continue;
            }
            if (obv instanceof Integer) {
                list.pushInt(((Integer)obv).intValue());
                continue;
            }
            if (obv instanceof String) {
                list.pushString(String.valueOf(obv));
                continue;
            }
            if (obv instanceof Boolean) {
                list.pushBoolean(((Boolean)obv).booleanValue());
                continue;
            }
            if (obv instanceof Double || obv instanceof Float) {
                list.pushDouble(((Double)obv).doubleValue());
                continue;
            }
            if (obv instanceof JSONArray) {
                list.pushArray(RNComponentUtil.parseToWritableArray((JSONArray)obv));
                continue;
            }
            if (obv instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)obv;
                list.pushDouble(bigDecimal.doubleValue());
                continue;
            }
            list.pushNull();
        }
        return list;
    }
}

