/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.reactnativesweeper.util;

import com.tuya.reactnativesweeper.util.ScreenPoint;
import com.tuya.sdk.tuyamesh.utils.L;
import java.util.Arrays;
import java.util.List;

public class PointUtil {
    private static String TAG = "PointUtil";
    private static PointUtil instance;
    private int width;
    private int height;
    private int transparent;
    private int[][] newArray;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PointUtil getInstance() {
        if (null != instance) return instance;
        Class<PointUtil> clazz = PointUtil.class;
        synchronized (PointUtil.class) {
            if (null != instance) return instance;
            instance = new PointUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void initSize(int width, int height, int transparent) {
        this.width = width;
        this.height = height;
        this.transparent = transparent;
        this.newArray = new int[width][height];
    }

    public int[][] transToDoubleArray(List<Integer> dataList) {
        int[][] array = new int[this.width][this.height];
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                array[j][i] = dataList.get(this.width * i + j);
            }
        }
        return array;
    }

    public int[] trans(int[][] array, ScreenPoint point) {
        try {
            this.getNearbyPoint(array, point);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int[] colors = new int[this.width * this.height];
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                if (this.newArray[j][i] == 0) {
                    this.newArray[j][i] = this.transparent;
                }
                colors[this.width * i + j] = array[j][i];
            }
        }
        return colors;
    }

    public void getNearbyPoint(int[][] array, ScreenPoint point) {
        ScreenPoint leftPoint = this.getLeftPoint(array, point);
        ScreenPoint rightPoint = this.getRightPoint(array, point);
        ScreenPoint topPoint = this.getTopPoint(array, point);
        ScreenPoint bottomPoint = this.getBottomPoint(array, point);
        if (leftPoint != null) {
            L.d((String)TAG, (String)("leftPoint: x:" + leftPoint.x + " y:" + leftPoint.y));
            this.getNearbyPoint(array, leftPoint);
            this.newArray[leftPoint.x][leftPoint.y] = array[leftPoint.x][leftPoint.y];
        }
        if (rightPoint != null) {
            L.d((String)TAG, (String)("rightPoint: x:" + rightPoint.x + " y:" + rightPoint.y));
            this.getNearbyPoint(array, rightPoint);
            this.newArray[rightPoint.x][rightPoint.y] = array[rightPoint.x][rightPoint.y];
        }
        if (topPoint != null) {
            L.d((String)TAG, (String)("topPoint: x:" + topPoint.x + " y:" + topPoint.y));
            this.getNearbyPoint(array, topPoint);
            this.newArray[topPoint.x][topPoint.y] = array[topPoint.x][topPoint.y];
        }
        if (bottomPoint != null) {
            L.d((String)TAG, (String)("bottomPoint: x:" + bottomPoint.x + " y:" + bottomPoint.y));
            this.getNearbyPoint(array, bottomPoint);
            this.newArray[bottomPoint.x][bottomPoint.y] = array[bottomPoint.x][bottomPoint.y];
        }
    }

    public void getNearbyPointN(int[][] array, ScreenPoint point) {
        for (int j = 0; j < this.height; ++j) {
        }
    }

    public ScreenPoint getLeftPoint(int[][] array, ScreenPoint pointF) {
        if (pointF.x - 1 < 0) {
            return null;
        }
        if (array[pointF.x - 1][pointF.y] == this.transparent || this.newArray[pointF.x - 1][pointF.y] != 0) {
            return null;
        }
        return new ScreenPoint(pointF.x - 1, pointF.y);
    }

    public ScreenPoint getRightPoint(int[][] array, ScreenPoint point) {
        if (point.x + 1 >= this.width) {
            return null;
        }
        if (array[point.x + 1][point.y] == this.transparent || this.newArray[point.x + 1][point.y] != 0) {
            return null;
        }
        return new ScreenPoint(point.x + 1, point.y);
    }

    public ScreenPoint getTopPoint(int[][] array, ScreenPoint point) {
        if (point.y - 1 < 0) {
            return null;
        }
        if (array[point.x][point.y - 1] == this.transparent || this.newArray[point.x][point.y - 1] != 0) {
            return null;
        }
        return new ScreenPoint(point.x, point.y - 1);
    }

    public ScreenPoint getBottomPoint(int[][] array, ScreenPoint point) {
        if (point.y + 1 >= this.height) {
            return null;
        }
        if (array[point.x][point.y + 1] == this.transparent || this.newArray[point.x][point.y + 1] != 0) {
            return null;
        }
        return new ScreenPoint(point.x, point.y + 1);
    }

    public int[] medianFiltering(List<Integer> pix, int w, int h) {
        int[] newpix = new int[w * h];
        int[] temp = new int[9];
        int r = 0;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                if (x != 0 && x != w - 1 && y != 0 && y != h - 1) {
                    temp[0] = pix.get(x - 1 + (y - 1) * w);
                    temp[1] = pix.get(x + (y - 1) * w);
                    temp[2] = pix.get(x + 1 + (y - 1) * w);
                    temp[3] = pix.get(x - 1 + y * w);
                    temp[4] = pix.get(x + y * w);
                    temp[5] = pix.get(x + 1 + y * w);
                    temp[6] = pix.get(x - 1 + (y + 1) * w);
                    temp[7] = pix.get(x + (y + 1) * w);
                    temp[8] = pix.get(x + 1 + (y + 1) * w);
                    Arrays.sort(temp);
                    newpix[y * w + x] = r = temp[4];
                    continue;
                }
                newpix[y * w + x] = pix.get(y * w + x);
            }
        }
        return newpix;
    }
}

