/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.reactnativesweeper.util;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;

public class BitmapUtil {
    public static Bitmap getBitmap(Resources resources, int resId) {
        return BitmapUtil.drawableToBitmap(resources.getDrawable(resId), 0, 0);
    }

    public static Bitmap getBitmapFormColor(String color, int width, int height) {
        return BitmapUtil.drawableToBitmap((Drawable)BitmapUtil.getShapeDrawable(color), width, height);
    }

    public static Bitmap getBitmap(Bitmap bitmap, float width, float height) {
        if (null == bitmap) {
            return null;
        }
        if (width <= 0.0f || height <= 0.0f) {
            return bitmap;
        }
        Matrix matrix = new Matrix();
        matrix.postScale(width / (float)bitmap.getWidth(), height / (float)bitmap.getHeight());
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
    }

    private static Bitmap drawableToBitmap(Drawable drawable, int width, int height) {
        if (drawable instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable).getBitmap();
        }
        Bitmap bitmap = Bitmap.createBitmap((int)(width <= 0 ? drawable.getIntrinsicWidth() : width), (int)(height <= 0 ? drawable.getIntrinsicHeight() : height), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable.draw(canvas);
        return bitmap;
    }

    private static GradientDrawable getShapeDrawable(String color) {
        GradientDrawable drawable = new GradientDrawable();
        drawable.setColor(Color.parseColor((String)color));
        return drawable;
    }

    public static Bitmap getBitmapByRes(Resources resources, int resId, float width, float height) {
        BitmapFactory.Options bmpFactoryOptions = new BitmapFactory.Options();
        bmpFactoryOptions.inJustDecodeBounds = true;
        BitmapFactory.decodeResource((Resources)resources, (int)resId, (BitmapFactory.Options)bmpFactoryOptions);
        int heightRatio = (int)Math.ceil((float)bmpFactoryOptions.outHeight / height);
        int widthRatio = (int)Math.ceil((float)bmpFactoryOptions.outWidth / width);
        if (heightRatio > 1 && widthRatio > 1) {
            bmpFactoryOptions.inSampleSize = heightRatio > widthRatio ? heightRatio : widthRatio;
        }
        bmpFactoryOptions.inJustDecodeBounds = false;
        return BitmapFactory.decodeResource((Resources)resources, (int)resId, (BitmapFactory.Options)bmpFactoryOptions);
    }
}

