/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.reactnativesweeper.manager;

import android.graphics.Bitmap;
import android.graphics.PointF;
import android.view.View;
import com.tuya.reactnativesweeper.bean.MapPointsData;
import com.tuya.reactnativesweeper.util.CollectionUtils;
import com.tuya.reactnativesweeper.view.sweepercommon.ISweeperMapView;
import com.tuya.reactnativesweeper.view.sweepercommon.StateBaseMap;
import com.tuya.smart.android.common.utils.L;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class SweeperMapStateManager
implements ISweeperMapView {
    private static volatile SweeperMapStateManager instance;
    private static final String TAG;
    private StateBaseMap mMainMap;
    private List<StateBaseMap> mMapList;
    private Map<View, Boolean> mLaserEditMap;
    private String mSweepRegionColor;
    private String mVirtualAreaColor;
    private String mVirtualWallColor;
    private Bitmap appointIcon;
    private float globalStrokeWidth;
    private float minAreaWidth;
    private List<List<PointF>> mSweepRegionList;
    private List<List<PointF>> mVirtualAreaList;
    private List<List<PointF>> mVirtualWallList;
    private PointF mAppoint;
    private int mState;
    private HashMap<String, Object> zoomFactor;
    private CopyOnWriteArrayList<SweeperStateListener> sweeperStateListener = new CopyOnWriteArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SweeperMapStateManager getInstance() {
        if (null != instance) return instance;
        Class<SweeperMapStateManager> clazz = SweeperMapStateManager.class;
        synchronized (SweeperMapStateManager.class) {
            if (null != instance) return instance;
            instance = new SweeperMapStateManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private SweeperMapStateManager() {
        this.mLaserEditMap = new HashMap<View, Boolean>();
        this.mMapList = new ArrayList<StateBaseMap>();
    }

    @Override
    public void setSweepRegionColor(String mSweepRegionColor) {
        this.mSweepRegionColor = mSweepRegionColor;
        this.drawSweepRegion(this.mSweepRegionList);
    }

    @Override
    public void setVirtualAreaColor(String mVirtualAreaColor) {
        this.mVirtualAreaColor = mVirtualAreaColor;
        this.drawVirtualArea(this.mVirtualAreaList);
    }

    @Override
    public void setVirtualWallColor(String mVirtualWallColor) {
        this.mVirtualWallColor = mVirtualWallColor;
        this.drawVirtualWall(this.mVirtualWallList);
    }

    public void setZoomFactor(HashMap<String, Object> zoomFactor) {
        this.zoomFactor = zoomFactor;
    }

    public void setGlobalStrokeWidth(float width) {
        this.globalStrokeWidth = width;
    }

    public float getGlobalStrokeWidth() {
        return this.globalStrokeWidth;
    }

    public HashMap<String, Object> getZoomFactor() {
        return this.zoomFactor;
    }

    @Override
    public Bitmap getAppointIcon() {
        return this.appointIcon;
    }

    @Override
    public void setAppointIcon(Bitmap appointIcon) {
        this.appointIcon = appointIcon;
    }

    @Override
    public String getSweepRegionColor() {
        return this.mSweepRegionColor;
    }

    @Override
    public String getVirtualAreaColor() {
        return this.mVirtualAreaColor;
    }

    @Override
    public String getVirtualWallColor() {
        return this.mVirtualWallColor;
    }

    public void putMapEdit(StateBaseMap view, boolean isEdit) {
        L.d((String)TAG, (String)("putMapEdit view=" + (Object)((Object)view) + " edit=" + isEdit));
        boolean beforeMainMapEdit = this.isEdit(this.mMainMap);
        this.mLaserEditMap.put((View)view, isEdit);
        boolean afterMainMapEdit = this.isEdit(this.mMainMap);
        if (beforeMainMapEdit && !afterMainMapEdit) {
            L.d((String)TAG, (String)"mainMap EXIT EDIT --- ");
        }
    }

    public boolean isMainMap(View map) {
        return map == this.mMainMap;
    }

    public boolean isEdit(StateBaseMap view) {
        if (null == view) {
            return false;
        }
        Boolean editBoolean = this.mLaserEditMap.get((Object)view);
        if (null == editBoolean) {
            return false;
        }
        return editBoolean;
    }

    public void attachMap(StateBaseMap view) {
        L.i((String)TAG, (String)"attachMainLaserMap is called ");
        if (null == this.mMainMap) {
            this.mMainMap = view;
        }
        this.mMapList.add(view);
    }

    public void detachedMap(StateBaseMap view) {
        L.i((String)TAG, (String)"detachedLaserMap is called ");
        this.mLaserEditMap.remove((Object)view);
        this.mMapList.remove((Object)view);
        if (this.mMapList.isEmpty()) {
            this.release();
            this.mMainMap = null;
            instance = null;
        }
    }

    private void release() {
        if (null != this.appointIcon && !this.appointIcon.isRecycled()) {
            this.appointIcon.recycle();
            this.appointIcon = null;
        }
    }

    public void setState(int state) {
        if (this.mState != state) {
            L.i((String)TAG, (String)("setState  state=" + state));
            this.mState = state;
            for (SweeperStateListener listener : this.sweeperStateListener) {
                listener.onStateChanged(state);
            }
        }
    }

    public void registerStateListener(SweeperStateListener listener) {
        if (!this.sweeperStateListener.contains(listener)) {
            this.sweeperStateListener.add(listener);
        }
    }

    public void unRegisterStateListener(SweeperStateListener listener) {
        if (this.sweeperStateListener.contains(listener)) {
            this.sweeperStateListener.remove(listener);
        }
    }

    public MapPointsData getTypePointsInfo() {
        if (null == this.mMainMap) {
            return null;
        }
        if (!this.mMainMap.isInitMap()) {
            L.w((String)TAG, (String)"Map not init getTypePointsInfo do nothing");
            return null;
        }
        switch (this.mState) {
            case 4: {
                MapPointsData<List<PointF>> typePointData = new MapPointsData<List<PointF>>();
                typePointData.setData(this.transformPointList(this.mMainMap.getVirtualWallPoint()));
                typePointData.setType(this.mState);
                return typePointData;
            }
            case 3: {
                MapPointsData<List<PointF>> forbiddenZoneData = new MapPointsData<List<PointF>>();
                forbiddenZoneData.setData(this.transformPointList(this.mMainMap.getForbiddenZonePoint()));
                forbiddenZoneData.setType(this.mState);
                return forbiddenZoneData;
            }
            case 2: {
                MapPointsData<List<PointF>> sweepRegionData = new MapPointsData<List<PointF>>();
                sweepRegionData.setData(this.transformPointList(this.mMainMap.getSweepRegionPoint()));
                sweepRegionData.setType(this.mState);
                return sweepRegionData;
            }
            case 1: {
                MapPointsData<PointF> appointPointData = new MapPointsData<PointF>();
                appointPointData.setData(this.transformPoint(this.mMainMap.getAppointPoint()));
                appointPointData.setType(this.mState);
                return appointPointData;
            }
        }
        return null;
    }

    public void addLaserMapRectWithType(int state) {
        if (null == this.mMainMap) {
            return;
        }
        if (!this.mMainMap.isInitMap()) {
            L.w((String)TAG, (String)"Map not init addLaserMapRectWithType do nothing");
            return;
        }
        switch (state) {
            case 2: {
                this.mMainMap.addSticker(state);
                break;
            }
            case 3: {
                this.mMainMap.addSticker(state);
                break;
            }
            case 4: {
                this.mMainMap.addVirtualWall();
                break;
            }
        }
    }

    public int getState() {
        return this.mState;
    }

    public void addAppoint(View view, float x, float y) {
        if (view != this.mMainMap) {
            L.w((String)TAG, (String)"addAppoint but  Operation of the map is not main map  do nothing ");
            return;
        }
        if (!this.mMainMap.isInitMap()) {
            L.w((String)TAG, (String)"Map not init addAppoint do nothing");
            return;
        }
        if (this.mState != 1) {
            L.w((String)TAG, (String)("state is " + this.mState + " addAppoint do nothing"));
            return;
        }
        if (!this.isEdit(this.mMainMap)) {
            L.w((String)TAG, (String)"main map is not edit mode so addAppoint do nothing");
            return;
        }
        if (null == this.appointIcon) {
            L.w((String)TAG, (String)"addAppoint Icon null  addAppoint do nothing");
            return;
        }
        this.mMainMap.addAppointView(x, y);
    }

    public void drawAllStateView(boolean isForce) {
        if (this.isEdit(this.mMainMap) && !isForce) {
            L.w((String)TAG, (String)"drawAllStateView  mainMap is editing draw nothing ");
            return;
        }
        this.drawAppointView(this.mAppoint);
        this.drawSweepRegion(this.mSweepRegionList);
        this.drawVirtualWall(this.mVirtualWallList);
        this.drawVirtualArea(this.mVirtualAreaList);
    }

    @Override
    public void drawAppointView(PointF pointF) {
        this.mAppoint = pointF;
        if (null == this.mMainMap || !this.mMainMap.isInitMap()) {
            L.w((String)TAG, (String)"drawAppointView  mMainMap not init do nothing ");
            return;
        }
        if (null == this.mAppoint) {
            L.d((String)TAG, (String)"drawAppointView  mAppoint is empty CLEAR ");
        } else {
            L.d((String)TAG, (String)("drawAppointView  is called " + this.mAppoint.toString()));
        }
        this.mMainMap.drawAppoint(this.mAppoint);
    }

    @Override
    public void drawVirtualWall(List<List<PointF>> virtualWallList) {
        this.mVirtualWallList = virtualWallList;
        if (null == this.mMainMap || !this.mMainMap.isInitMap()) {
            L.w((String)TAG, (String)"drawVirtualWall  mMainMap not init do nothing ");
            return;
        }
        if (CollectionUtils.isEmpty(virtualWallList)) {
            L.d((String)TAG, (String)"drawVirtualWall  virtualWallList is empty CLEAR ");
        } else {
            L.d((String)TAG, (String)("drawVirtualWall is called size=" + virtualWallList));
        }
        this.mMainMap.drawVirtualWall(virtualWallList);
    }

    @Override
    public void drawVirtualArea(List<List<PointF>> virtualAreaList) {
        this.mVirtualAreaList = virtualAreaList;
        if (null == this.mMainMap || !this.mMainMap.isInitMap()) {
            L.w((String)TAG, (String)"drawVirtualArea  mMainMap not init do nothing ");
            return;
        }
        if (CollectionUtils.isEmpty(virtualAreaList)) {
            L.d((String)TAG, (String)"drawVirtualArea  virtualAreaList is empty CLEAR ");
        } else {
            L.d((String)TAG, (String)("drawVirtualArea is called size=" + virtualAreaList));
        }
        this.mMainMap.drawVirtualArea(virtualAreaList);
    }

    @Override
    public void drawSweepRegion(List<List<PointF>> sweepRegionList) {
        this.mSweepRegionList = sweepRegionList;
        if (null == this.mMainMap || !this.mMainMap.isInitMap()) {
            L.w((String)TAG, (String)"drawSweepRegion  mMainMap not init do nothing ");
            return;
        }
        if (CollectionUtils.isEmpty(sweepRegionList)) {
            L.d((String)TAG, (String)"drawSweepRegion  sweepRegionList is empty CLEAR ");
        } else {
            L.d((String)TAG, (String)("drawSweepRegion is called size=" + sweepRegionList));
        }
        this.mMainMap.drawSweepRegion(sweepRegionList);
    }

    public PointF getXYInMap(PointF pointF) {
        PointF pointF1 = this.mMainMap.calculateXYInMap(pointF);
        PointF finalPoint = new PointF();
        finalPoint.x = pointF1.x;
        finalPoint.y = pointF1.y;
        return finalPoint;
    }

    private List<PointF> transformPoint(List<PointF> pointList) {
        if (null == pointList) {
            return null;
        }
        ArrayList<PointF> transformPointList = new ArrayList<PointF>();
        if (pointList.isEmpty()) {
            return transformPointList;
        }
        for (PointF pointF : pointList) {
            transformPointList.add(new PointF(pointF.x, pointF.y));
        }
        return transformPointList;
    }

    private List<List<PointF>> transformPointList(List<List<PointF>> pointList) {
        if (null == pointList) {
            return null;
        }
        ArrayList<List<PointF>> transformPointList = new ArrayList<List<PointF>>();
        if (pointList.isEmpty()) {
            return transformPointList;
        }
        for (List<PointF> pointFS : pointList) {
            transformPointList.add(this.transformPoint(pointFS));
        }
        return transformPointList;
    }

    public void setMinAreaWidth(float realMinAreaWidth) {
        this.minAreaWidth = realMinAreaWidth;
    }

    public float getMinAreaWidth() {
        return this.minAreaWidth;
    }

    static {
        TAG = SweeperMapStateManager.class.getSimpleName();
    }

    public static interface SweeperStateListener {
        public void onStateChanged(int var1);
    }
}

