/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.reactnativesweeper.anim;

import android.animation.ValueAnimator;
import android.graphics.Matrix;

public class MatrixAnimator
extends ValueAnimator
implements ValueAnimator.AnimatorUpdateListener {
    private AnimationListener mListener;
    private static final int DEFAULT_DURATION = 200;
    private float[] mStart = new float[9];
    private float[] mEnd = new float[9];
    private float[] mResult = new float[9];
    Matrix mAnimtionMatrix = new Matrix();

    public void setListener(AnimationListener listener) {
        this.mListener = listener;
    }

    public MatrixAnimator(Matrix start, Matrix end) {
        this(start, end, 200L);
    }

    public MatrixAnimator(Matrix start, Matrix end, long duration) {
        this.setFloatValues(new float[]{0.0f, 1.0f});
        this.setDuration(duration);
        this.addUpdateListener(this);
        start.getValues(this.mStart);
        end.getValues(this.mEnd);
    }

    public void onAnimationUpdate(ValueAnimator animation) {
        float value = ((Float)animation.getAnimatedValue()).floatValue();
        for (int i = 0; i < 9; ++i) {
            this.mResult[i] = this.mStart[i] + (this.mEnd[i] - this.mStart[i]) * value;
        }
        if (this.mListener != null) {
            this.mAnimtionMatrix.setValues(this.mResult);
            this.mListener.onAnimationUpdate(this.mAnimtionMatrix);
        }
        if (value == 1.0f && this.mListener != null) {
            this.mListener.onAnimationEnd();
        }
    }

    public static interface AnimationListener {
        public void onAnimationUpdate(Matrix var1);

        public void onAnimationEnd();
    }
}

