/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.panel.reactnative.utils;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableMapKeySetIterator;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.tuya.smart.android.device.bean.SchemaBean;
import com.tuya.smart.panel.base.utils.PanelUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class TYRCTCommonUtil {
    public static final String RESULT_SUCCESS = "TY_SUCCESS";
    public static final String RESULT_FAILURE = "TY_FAILURE";
    private static final String RESULT_KEY = "ret";
    private static final String RESULT_ERROR_UPGRADING = "UPGRADEING";
    public static final int RNTYPE_GROUP = 1;
    public static final int RNTYPE_DEVICE = 0;

    public static HashMap<String, Object> parseToMap(ReadableMap readableMap) {
        ReadableMapKeySetIterator iterator = readableMap.keySetIterator();
        HashMap<String, Object> deconstructedMap = new HashMap<String, Object>();
        block10: while (iterator.hasNextKey()) {
            String key = iterator.nextKey();
            ReadableType type = readableMap.getType(key);
            switch (type) {
                case Null: {
                    deconstructedMap.put(key, null);
                    break;
                }
                case Boolean: {
                    deconstructedMap.put(key, readableMap.getBoolean(key));
                    break;
                }
                case Number: {
                    double value = readableMap.getDouble(key);
                    try {
                        if (value % 1.0 == 0.0) {
                            if (value >= -2.147483648E9 && value <= 2.147483647E9) {
                                deconstructedMap.put(key, (int)value);
                                break;
                            }
                            if (!(value > 2.147483647E9) && !(value < -2.147483648E9)) continue block10;
                            deconstructedMap.put(key, (long)value);
                            break;
                        }
                        deconstructedMap.put(key, value);
                    }
                    catch (Exception e) {
                        deconstructedMap.put(key, value);
                    }
                    break;
                }
                case String: {
                    deconstructedMap.put(key, readableMap.getString(key));
                    break;
                }
                case Map: {
                    deconstructedMap.put(key, TYRCTCommonUtil.parseToMap(readableMap.getMap(key)));
                    break;
                }
                case Array: {
                    deconstructedMap.put(key, TYRCTCommonUtil.parseToList(readableMap.getArray(key)));
                    break;
                }
            }
        }
        return deconstructedMap;
    }

    public static ArrayList<Object> parseToList(ReadableArray readableArray) {
        ArrayList<Object> deconstructedList = new ArrayList<Object>(readableArray.size());
        block10: for (int i = 0; i < readableArray.size(); ++i) {
            ReadableType indexType = readableArray.getType(i);
            switch (indexType) {
                case Null: {
                    deconstructedList.add(i, null);
                    continue block10;
                }
                case Boolean: {
                    deconstructedList.add(i, readableArray.getBoolean(i));
                    continue block10;
                }
                case Number: {
                    double value = readableArray.getDouble(i);
                    try {
                        if (value % 1.0 == 0.0) {
                            if (value >= -2.147483648E9 && value <= 2.147483647E9) {
                                deconstructedList.add(i, (int)value);
                                continue block10;
                            }
                            if (!(value > 2.147483647E9) && !(value < -2.147483648E9)) continue block10;
                            deconstructedList.add(i, (long)value);
                            continue block10;
                        }
                        deconstructedList.add(i, value);
                    }
                    catch (Exception e) {
                        deconstructedList.add(i, value);
                    }
                    continue block10;
                }
                case String: {
                    deconstructedList.add(i, readableArray.getString(i));
                    continue block10;
                }
                case Map: {
                    deconstructedList.add(i, TYRCTCommonUtil.parseToMap(readableArray.getMap(i)));
                    continue block10;
                }
                case Array: {
                    deconstructedList.add(i, TYRCTCommonUtil.parseToList(readableArray.getArray(i)));
                    continue block10;
                }
            }
        }
        return deconstructedList;
    }

    public static void sendEvent(ReactContext reactContext, String eventName, @Nullable WritableMap params) {
        ((DeviceEventManagerModule.RCTDeviceEventEmitter)reactContext.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class)).emit(eventName, (Object)params);
    }

    public static WritableMap toErrorResult(String code) {
        WritableMap result = Arguments.createMap();
        result.putString(RESULT_KEY, PanelUtils.checkCommandErrorCode(code));
        return result;
    }

    public static WritableMap toResult(String code) {
        WritableMap result = Arguments.createMap();
        if (TextUtils.isEmpty((CharSequence)code)) {
            code = "";
        }
        result.putString(RESULT_KEY, code);
        return result;
    }

    public static WritableMap parseToWritableMap(String s) {
        if (TextUtils.isEmpty((CharSequence)s)) {
            return Arguments.createMap();
        }
        return TYRCTCommonUtil.parseToWritableMap(JSON.parseObject((String)s));
    }

    public static WritableMap parseToWritableMap(Object object) {
        if (null == object) {
            return Arguments.createMap();
        }
        return TYRCTCommonUtil.parseToWritableMap(JSON.toJSONString((Object)object));
    }

    public static WritableMap parseToWritableMap(JSONObject json) {
        WritableMap map = Arguments.createMap();
        Set entries = json.entrySet();
        for (Map.Entry next : entries) {
            String key = (String)next.getKey();
            Object obv = next.getValue();
            if (obv instanceof JSONObject) {
                map.putMap(key, TYRCTCommonUtil.parseToWritableMap((JSONObject)obv));
                continue;
            }
            if (obv instanceof Integer) {
                map.putInt(key, ((Integer)obv).intValue());
                continue;
            }
            if (obv instanceof String) {
                map.putString(key, String.valueOf(obv));
                continue;
            }
            if (obv instanceof Boolean) {
                map.putBoolean(key, ((Boolean)obv).booleanValue());
                continue;
            }
            if (obv instanceof Double || obv instanceof Float) {
                map.putDouble(key, ((Double)obv).doubleValue());
                continue;
            }
            if (obv instanceof JSONArray) {
                map.putArray(key, TYRCTCommonUtil.parseToWritableArray((JSONArray)obv));
                continue;
            }
            if (obv instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)obv;
                map.putDouble(key, bigDecimal.doubleValue());
                continue;
            }
            map.putNull(key);
        }
        return map;
    }

    public static WritableArray parseToWritableArray(JSONArray jsonArray) {
        WritableArray list = Arguments.createArray();
        for (Object obv : jsonArray.toArray()) {
            if (obv instanceof JSONObject) {
                list.pushMap(TYRCTCommonUtil.parseToWritableMap((JSONObject)obv));
                continue;
            }
            if (obv instanceof Integer) {
                list.pushInt(((Integer)obv).intValue());
                continue;
            }
            if (obv instanceof String) {
                list.pushString(String.valueOf(obv));
                continue;
            }
            if (obv instanceof Boolean) {
                list.pushBoolean(((Boolean)obv).booleanValue());
                continue;
            }
            if (obv instanceof Double || obv instanceof Float) {
                list.pushDouble(((Double)obv).doubleValue());
                continue;
            }
            if (obv instanceof JSONArray) {
                list.pushArray(TYRCTCommonUtil.parseToWritableArray((JSONArray)obv));
                continue;
            }
            if (obv instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)obv;
                list.pushDouble(bigDecimal.doubleValue());
                continue;
            }
            list.pushNull();
        }
        return list;
    }

    public static WritableArray schemaParseToWritableArray(Map<String, SchemaBean> schemaMap) {
        WritableArray list = Arguments.createArray();
        for (Map.Entry<String, SchemaBean> set : schemaMap.entrySet()) {
            SchemaBean bean = set.getValue();
            WritableMap map = Arguments.createMap();
            map.putString("id", bean.getId());
            map.putString("code", bean.getCode());
            map.putString("name", bean.getName());
            map.putString("mode", bean.getMode());
            map.putString("type", bean.getType());
            map.putString("schemaType", bean.getSchemaType());
            if (null != bean.getPassive()) {
                map.putBoolean("passive", bean.getPassive().booleanValue());
            }
            map.putString("property", bean.getProperty());
            map.putString("iconname", bean.getIconname());
            list.pushMap(map);
        }
        return list;
    }

    public static WritableMap panelConfigToWritableMap(Map<String, Object> panelConfig) {
        WritableMap list = Arguments.createMap();
        if (panelConfig != null) {
            for (Map.Entry<String, Object> set : panelConfig.entrySet()) {
                String key = set.getKey();
                Object value = set.getValue();
                list.putString(key, value == null ? "" : JSONObject.toJSONString((Object)value));
            }
        }
        return list;
    }
}

