/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.reactnativesweeper.view.laserMap.layer;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.CornerPathEffect;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PointF;
import com.tuya.reactnativesweeper.b.b;
import com.tuya.reactnativesweeper.view.laserMap.LaserPoint;
import com.tuya.reactnativesweeper.view.laserMap.MatrixUtils;
import com.tuya.reactnativesweeper.view.laserMap.layer.LaserBaseLayer;
import com.tuya.smart.android.common.utils.L;
import java.util.ArrayList;
import java.util.List;

public class PathLayer
extends LaserBaseLayer {
    private static final int PATH_LAYER = 2;
    private List<PointF> mPathList;
    private float mPathWidth;
    private String mPathColor;
    private Paint mPathPaint;
    private Path mPath;
    private Path mTransformPath;
    private List<LaserPoint> mPointList;

    public PathLayer() {
        CornerPathEffect cornerPathEffect;
        PathLayer pathLayer = pathLayer2;
        super(2);
        PathLayer pathLayer2 = cornerPathEffect;
        cornerPathEffect = new CornerPathEffect(50.0f);
        pathLayer.mPathPaint = new Paint();
        pathLayer.mPath = new Path();
        pathLayer.mTransformPath = new Path();
        pathLayer.mPathPaint.setStyle(Paint.Style.STROKE);
        pathLayer.mPathPaint.setAntiAlias(true);
        pathLayer.mPathPaint.setPathEffect((PathEffect)pathLayer2);
    }

    @Override
    public void draw(Canvas canvas, Matrix matrix, Matrix matrix2) {
        float f2;
        if (!this.isInit()) {
            L.w((String)"LaserMapView", (String)"Not init PathLayer draw nothing");
            return;
        }
        if (this.mPathColor != null && (f2 = this.mPathWidth) != 0.0f) {
            Canvas canvas2 = canvas;
            PathLayer pathLayer = this;
            this.mPathPaint.setStrokeWidth(f2 * MatrixUtils.getScaleX(matrix2));
            canvas.save();
            pathLayer.mTransformPath.reset();
            pathLayer.mPath.transform(matrix, this.mTransformPath);
            canvas2.drawPath(pathLayer.mTransformPath, this.mPathPaint);
            canvas2.restore();
            return;
        }
        L.w((String)"LaserMapView", (String)("drawPath pathWidth=" + this.mPathWidth + " pathColor=" + this.mPathColor));
    }

    @Override
    public void setOriginPoint(PointF object) {
        PathLayer pathLayer = this;
        super.setOriginPoint((PointF)object);
        object = pathLayer.mPointList;
        if (object != null) {
            this.setNewPathList((List<LaserPoint>)object);
        } else {
            PathLayer pathLayer2 = this;
            pathLayer2.setPathList(pathLayer2.mPathList);
        }
    }

    public void setPathList(List<PointF> list) {
        PathLayer pathLayer = this;
        pathLayer.mPathList = list;
        pathLayer.mPath.reset();
        if (!pathLayer.isInit()) {
            L.w((String)"LaserMapView", (String)"setPathList  not  init ");
            return;
        }
        if (b.a(this.mPathList)) {
            return;
        }
        L.i((String)"LaserMapView", (String)("setPathList is called = " + this.mPathList.size()));
        for (int i2 = 0; i2 < this.mPathList.size(); ++i2) {
            if (i2 == 0) {
                this.mPath.setLastPoint(this.mPathList.get((int)i2).x + this.getOriginPoint().x, this.mPathList.get((int)i2).y + this.getOriginPoint().y);
                continue;
            }
            this.mPath.lineTo(this.mPathList.get((int)i2).x + this.getOriginPoint().x, this.mPathList.get((int)i2).y + this.getOriginPoint().y);
        }
    }

    public void setNewPathList(List<LaserPoint> list) {
        PathLayer pathLayer = this;
        L.e((String)"LaserMapView", (String)("setNewPathList size=" + list.size()));
        pathLayer.mPointList = list;
        pathLayer.mPathList = pathLayer.getPathList(pathLayer.mPointList);
        pathLayer.mPath.reset();
        if (!pathLayer.isInit()) {
            L.w((String)"LaserMapView", (String)"setPathList  not  init ");
            return;
        }
        if (b.a(list)) {
            return;
        }
        PathLayer pathLayer2 = this;
        L.i((String)"LaserMapView", (String)("setPathList is called = " + list.size()));
        list = pathLayer2.getCriticalPoint(pathLayer2.mPathList, list);
        for (int i2 = 0; i2 < this.mPathList.size(); ++i2) {
            if (i2 == 0) {
                this.mPath.setLastPoint(this.mPathList.get((int)i2).x + this.getOriginPoint().x, this.mPathList.get((int)i2).y + this.getOriginPoint().y);
                continue;
            }
            if (list.contains(i2)) {
                this.mPath.moveTo(this.mPathList.get((int)i2).x + this.getOriginPoint().x, this.mPathList.get((int)i2).y + this.getOriginPoint().y);
                continue;
            }
            this.mPath.lineTo(this.mPathList.get((int)i2).x + this.getOriginPoint().x, this.mPathList.get((int)i2).y + this.getOriginPoint().y);
        }
    }

    public List<PointF> getPathList(List<LaserPoint> object) {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        object = object.iterator();
        while (object.hasNext()) {
            LaserPoint laserPoint = (LaserPoint)((Object)object.next());
            if (laserPoint.skip == 1) continue;
            arrayList2.add(laserPoint.getPointF());
        }
        return arrayList2;
    }

    public List<Integer> getCriticalPoint(List<PointF> list, List<LaserPoint> list2) {
        ArrayList<Integer> arrayList;
        boolean bl = true;
        ArrayList<Integer> arrayList2 = arrayList;
        arrayList = new ArrayList<Integer>();
        for (int i2 = 0; i2 < list2.size(); ++i2) {
            boolean bl2;
            if (list2.get((int)i2).skip == 1) {
                bl2 = bl = false;
            } else if (!bl) {
                PointF pointF = list2.get(i2).getPointF();
                bl2 = true;
                for (int i3 = 0; i3 < list.size(); ++i3) {
                    if (!list.get(i3).equals((Object)pointF)) continue;
                    arrayList2.add(i3);
                }
            } else {
                bl2 = bl;
            }
            bl = bl2;
        }
        return arrayList2;
    }

    public void setPathWidth(float f2) {
        this.mPathWidth = f2;
        this.mPathPaint.setStrokeWidth(f2);
    }

    public void setPathColor(String string) {
        this.mPathColor = string;
        this.mPathPaint.setColor(Color.parseColor((String)string.trim()));
    }
}

