/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.reactnativesweeper.view.laserMap;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.tuya.reactnativesweeper.R;
import com.tuya.reactnativesweeper.a.a;
import com.tuya.reactnativesweeper.manager.f;
import com.tuya.reactnativesweeper.view.laserMap.LaserMapListener;
import com.tuya.reactnativesweeper.view.laserMap.LaserMapView;
import com.tuya.reactnativesweeper.view.laserMap.LaserPoint;
import com.tuya.reactnativesweeper.view.sweepercommon.AppointView;
import com.tuya.reactnativesweeper.view.sweepercommon.ScaleLayout;
import com.tuya.reactnativesweeper.view.sweepercommon.o;
import com.tuya.reactnativesweeper.view.sweepercommon.sticker.StickerLayout;
import com.tuya.reactnativesweeper.view.sweepercommon.virtualwall.VirtualWallLayout;
import com.tuya.smart.android.common.utils.L;
import java.util.List;

public class TYRCTLaserMap
extends o {
    private StickerLayout stickerLayout;
    private ScaleLayout scaleLayout;
    private AppointView appointIv;
    private VirtualWallLayout virtualWallLayout;
    private LaserMapView laserMapView;
    protected List<List<PointF>> mSweepRegionList;
    protected List<List<PointF>> mVirtualAreaList;
    protected List<List<PointF>> mVirtualWallList;
    protected PointF mAppoint;

    public TYRCTLaserMap(Context context) {
        this(context, null);
    }

    public TYRCTLaserMap(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public TYRCTLaserMap(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
    }

    private void setListener() {
        TYRCTLaserMap tYRCTLaserMap = this;
        tYRCTLaserMap.scaleLayout.setActionListener(new ScaleLayout.a(){

            @Override
            public void onDoubleClick() {
                TYRCTLaserMap.this.reset();
            }

            @Override
            public void onSingleClick(float f2, float f3) {
                f.c().a((View)TYRCTLaserMap.this, f2, f3);
            }
        });
        tYRCTLaserMap.laserMapView.setListener(new LaserMapListener(){

            @Override
            public void onMapInit() {
                f.c().a(true);
                TYRCTLaserMap.this.drawAllStateView();
            }

            @Override
            public void onMapRefresh() {
                f.c().a(false);
            }
        });
    }

    @Override
    public void initView() {
        TYRCTLaserMap tYRCTLaserMap = this;
        View view = LayoutInflater.from((Context)tYRCTLaserMap.getContext()).inflate(R.layout.panel_layout_laser_map, (ViewGroup)this);
        this.scaleLayout = (ScaleLayout)view.findViewById(R.id.panel_laser_map_scale_layout);
        this.stickerLayout = (StickerLayout)view.findViewById(R.id.sticker_layout);
        this.virtualWallLayout = (VirtualWallLayout)view.findViewById(R.id.panel_laser_virtual_wall_layer);
        this.appointIv = (AppointView)view.findViewById(R.id.panel_laser_appoint_iv);
        tYRCTLaserMap.laserMapView = (LaserMapView)view.findViewById(R.id.panel_laser_virtual_map_layer);
        tYRCTLaserMap.scaleLayout.a(this.laserMapView);
        tYRCTLaserMap.scaleLayout.a(this.stickerLayout);
        tYRCTLaserMap.scaleLayout.a(this.virtualWallLayout);
        tYRCTLaserMap.scaleLayout.a(this.appointIv);
        tYRCTLaserMap.setListener();
    }

    @Override
    public StickerLayout getStickerLayout() {
        return this.stickerLayout;
    }

    @Override
    public VirtualWallLayout getWallLayout() {
        return this.virtualWallLayout;
    }

    @Override
    public AppointView getAppointIv() {
        return this.appointIv;
    }

    @Override
    public float getMapPreScale() {
        return this.laserMapView.getPreScale();
    }

    @Override
    public PointF calculateInView(PointF pointF) {
        return this.laserMapView.calculateInView(pointF);
    }

    @Override
    public PointF calculateXYInMap(PointF pointF) {
        return this.laserMapView.calculateXYInMap(pointF);
    }

    @Override
    public boolean isInitMap() {
        return this.laserMapView.isInit();
    }

    public void reset() {
        Matrix matrix;
        TYRCTLaserMap tYRCTLaserMap = this;
        L.d((String)"LaserMapView", (String)" animation is called ----");
        tYRCTLaserMap.isAnimation.set(true);
        Matrix matrix2 = matrix;
        matrix = new Matrix();
        tYRCTLaserMap.laserMapView.getCurrentImageMatrix().invert(matrix2);
        tYRCTLaserMap.laserMapView.reset(new a.a(){

            @Override
            public void onAnimationUpdate(Matrix matrix) {
            }

            @Override
            public void onAnimationEnd() {
                3 v0 = this;
                L.d((String)"LaserMapView", (String)" animation is end ----");
                v0.TYRCTLaserMap.this.isAnimation.set(false);
                v0.TYRCTLaserMap.this.dequeuePendingTask();
            }
        });
        tYRCTLaserMap.stickerLayout.a(matrix2);
        tYRCTLaserMap.virtualWallLayout.a(matrix2);
        tYRCTLaserMap.appointIv.a(matrix2);
    }

    public void setViewSize(float f2, float f3) {
    }

    public void drawMap(Bitmap bitmap, int n2, int n3, PointF pointF) {
        this.laserMapView.drawMap(bitmap, n2, n3, pointF);
    }

    public void setPathWidth(float f2) {
        this.laserMapView.setPathWidth(f2);
    }

    public void setPathColor(String string) {
        this.laserMapView.setPathColor(string);
    }

    public void drawPath(List<PointF> list) {
        this.laserMapView.setPathList(list);
    }

    public void drawPath(List<LaserPoint> list, boolean bl) {
        this.laserMapView.setPathList(list, bl);
    }

    public void setPlanPathWidth(float f2) {
        this.laserMapView.setPlanPathWidth(f2);
    }

    public void setPlanPathColor(String string) {
        this.laserMapView.setPlanPathColor(string);
    }

    public void drawPlanPath(List<PointF> list) {
        this.laserMapView.setPlanPathList(list);
    }

    public void setMarkerIcon(Bitmap bitmap) {
        this.laserMapView.setCurrentPointIcon(bitmap);
    }

    public void setPileIcon(Bitmap bitmap) {
        this.laserMapView.setPileIcon(bitmap);
    }

    public void setPilePosition(PointF pointF) {
        this.laserMapView.setPilePosition(pointF);
    }

    public void setMaxScale(float f2) {
        this.scaleLayout.setMaxScale(f2);
    }

    @Override
    public void drawAppoint(PointF pointF) {
        this.mAppoint = pointF;
        if (this.isInitMap()) {
            super.drawAppoint(pointF);
        }
    }

    @Override
    public void drawSweepRegion(List<List<PointF>> list) {
        this.mSweepRegionList = list;
        if (this.isInitMap()) {
            super.drawSweepRegion(list);
        }
    }

    @Override
    public void drawVirtualArea(List<List<PointF>> list) {
        this.mVirtualAreaList = list;
        if (this.isInitMap()) {
            super.drawVirtualArea(list);
        }
    }

    @Override
    public void drawVirtualWall(List<List<PointF>> list) {
        this.mVirtualWallList = list;
        if (this.isInitMap()) {
            super.drawVirtualWall(list);
        }
    }

    public void drawAllStateView() {
        TYRCTLaserMap tYRCTLaserMap = this;
        tYRCTLaserMap.drawAppoint(tYRCTLaserMap.mAppoint);
        tYRCTLaserMap.drawSweepRegion(tYRCTLaserMap.mSweepRegionList);
        tYRCTLaserMap.drawVirtualWall(tYRCTLaserMap.mVirtualWallList);
        tYRCTLaserMap.drawVirtualArea(tYRCTLaserMap.mVirtualAreaList);
    }
}

