/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.googlemap.view;

import android.content.Context;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.Polygon;
import com.google.android.gms.maps.model.PolygonOptions;
import com.tuya.smart.googlemap.view.MapFeature;
import java.util.ArrayList;
import java.util.List;

public class GoogleMapPolygon
extends MapFeature<GoogleMap> {
    private PolygonOptions polygonOptions;
    private Polygon polygon;
    private List<LatLng> coordinates;
    private int strokeColor;
    private int fillColor;
    private float strokeWidth;
    private boolean geodesic;
    private float zIndex;

    public GoogleMapPolygon(Context context) {
        super(context);
    }

    public void setCoordinates(ReadableArray coordinates) {
        this.coordinates = new ArrayList<LatLng>(coordinates.size());
        for (int i = 0; i < coordinates.size(); ++i) {
            ReadableMap coordinate = coordinates.getMap(i);
            this.coordinates.add(i, new LatLng(coordinate.getDouble("latitude"), coordinate.getDouble("longitude")));
        }
        if (this.polygon != null) {
            this.polygon.setPoints(this.coordinates);
        }
    }

    public void setFillColor(int color) {
        this.fillColor = color;
        if (this.polygon != null) {
            this.polygon.setFillColor(color);
        }
    }

    public void setStrokeColor(int color) {
        this.strokeColor = color;
        if (this.polygon != null) {
            this.polygon.setStrokeColor(color);
        }
    }

    public void setStrokeWidth(float width) {
        this.strokeWidth = width;
        if (this.polygon != null) {
            this.polygon.setStrokeWidth(width);
        }
    }

    public void setGeodesic(boolean geodesic) {
        this.geodesic = geodesic;
        if (this.polygon != null) {
            this.polygon.setGeodesic(geodesic);
        }
    }

    public void setZIndex(float zIndex) {
        this.zIndex = zIndex;
        if (this.polygon != null) {
            this.polygon.setZIndex(zIndex);
        }
    }

    public PolygonOptions getPolygonOptions() {
        if (this.polygonOptions == null) {
            this.polygonOptions = this.createPolygonOptions();
        }
        return this.polygonOptions;
    }

    private PolygonOptions createPolygonOptions() {
        PolygonOptions options = new PolygonOptions();
        options.addAll(this.coordinates);
        options.fillColor(this.fillColor);
        options.strokeColor(this.strokeColor);
        options.strokeWidth(this.strokeWidth);
        options.geodesic(this.geodesic);
        options.zIndex(this.zIndex);
        return options;
    }

    @Override
    public Object getFeature() {
        return this.polygon;
    }

    @Override
    public void addToMap(GoogleMap map) {
        this.polygon = map.addPolygon(this.getPolygonOptions());
    }

    @Override
    public void removeFromMap(GoogleMap map) {
        this.polygon.remove();
    }
}

