/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.amap.view;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.os.Build;
import android.os.Handler;
import android.support.v4.content.PermissionChecker;
import android.support.v4.view.GestureDetectorCompat;
import android.support.v4.view.MotionEventCompat;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import com.amap.api.maps2d.AMap;
import com.amap.api.maps2d.CameraUpdate;
import com.amap.api.maps2d.CameraUpdateFactory;
import com.amap.api.maps2d.MapView;
import com.amap.api.maps2d.Projection;
import com.amap.api.maps2d.model.CameraPosition;
import com.amap.api.maps2d.model.Circle;
import com.amap.api.maps2d.model.LatLng;
import com.amap.api.maps2d.model.LatLngBounds;
import com.amap.api.maps2d.model.Marker;
import com.amap.api.maps2d.model.Polygon;
import com.amap.api.maps2d.model.Polyline;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.bridge.WritableNativeMap;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.events.Event;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.tuya.smart.amap.manager.AMapManager;
import com.tuya.smart.amap.view.AMapCallout;
import com.tuya.smart.amap.view.AMapCircle;
import com.tuya.smart.amap.view.AMapLatLngBoundsUtils;
import com.tuya.smart.amap.view.AMapMarker;
import com.tuya.smart.amap.view.AMapPolygon;
import com.tuya.smart.amap.view.AMapPolyline;
import com.tuya.smart.amap.view.AMapRegionChangeEvent;
import com.tuya.smart.amap.view.MapFeature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AMapView
extends MapView
implements AMap.InfoWindowAdapter,
AMap.OnMarkerDragListener {
    public AMap map;
    private ProgressBar mapLoadingProgressBar;
    private RelativeLayout mapLoadingLayout;
    private ImageView cacheImageView;
    private Boolean isMapLoaded = false;
    private Integer loadingBackgroundColor = null;
    private Integer loadingIndicatorColor = null;
    private LatLngBounds boundsToMove;
    private boolean showUserLocation = false;
    private boolean isMonitoringRegion = false;
    private boolean isTouchDown = false;
    private boolean handlePanDrag = false;
    private boolean cacheEnabled = false;
    private boolean loadingEnabled = false;
    private static final String[] PERMISSIONS = new String[]{"android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_COARSE_LOCATION"};
    private final List<MapFeature> features = new ArrayList<MapFeature>();
    private final Map<Marker, AMapMarker> markerMap = new HashMap<Marker, AMapMarker>();
    private final Map<Polyline, AMapPolyline> polylineMap = new HashMap<Polyline, AMapPolyline>();
    private final Map<Polygon, AMapPolygon> polygonMap = new HashMap<Polygon, AMapPolygon>();
    private final Map<Circle, AMapCircle> circleMap = new HashMap<Circle, AMapCircle>();
    private final ScaleGestureDetector scaleDetector;
    private final GestureDetectorCompat gestureDetector;
    private final AMapManager manager;
    private LifecycleEventListener lifecycleListener;
    private View.OnLayoutChangeListener onLayoutChangeListener;
    private boolean paused = false;
    private ThemedReactContext context;
    final EventDispatcher eventDispatcher;
    private LatLngBounds lastBoundsEmitted;
    Handler timerHandler = new Handler();
    Runnable timerRunnable = new Runnable(){

        @Override
        public void run() {
            CameraPosition cameraPosition;
            LatLngBounds bounds = AMapView.this.map.getProjection().getVisibleRegion().latLngBounds;
            if ((AMapView.this.lastBoundsEmitted == null || AMapLatLngBoundsUtils.BoundsAreDifferent(bounds, AMapView.this.lastBoundsEmitted)) && (cameraPosition = AMapView.this.map.getCameraPosition()) != null) {
                LatLng center = cameraPosition.target;
                AMapView.this.lastBoundsEmitted = bounds;
                AMapView.this.eventDispatcher.dispatchEvent((Event)new AMapRegionChangeEvent(AMapView.this.getId(), bounds, center, true));
            }
            AMapView.this.timerHandler.postDelayed((Runnable)this, 100L);
        }
    };

    public AMapView(ThemedReactContext context, AMapManager manager) {
        super((Context)context);
        this.manager = manager;
        this.context = context;
        super.onCreate(null);
        super.onResume();
        final AMapView view = this;
        this.scaleDetector = new ScaleGestureDetector((Context)context, (ScaleGestureDetector.OnScaleGestureListener)new ScaleGestureDetector.SimpleOnScaleGestureListener(){

            public boolean onScaleBegin(ScaleGestureDetector detector) {
                view.startMonitoringRegion();
                return true;
            }
        });
        this.gestureDetector = new GestureDetectorCompat((Context)context, (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onDoubleTap(MotionEvent e) {
                view.startMonitoringRegion();
                return false;
            }

            public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
                if (AMapView.this.handlePanDrag) {
                    AMapView.this.onPanDrag(e2);
                }
                view.startMonitoringRegion();
                return false;
            }
        });
        this.onLayoutChangeListener = new View.OnLayoutChangeListener(){

            public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                if (!AMapView.this.paused) {
                    AMapView.this.cacheView();
                }
            }
        };
        this.addOnLayoutChangeListener(this.onLayoutChangeListener);
        this.eventDispatcher = ((UIManagerModule)context.getNativeModule(UIManagerModule.class)).getEventDispatcher();
        AMap map = this.getMap();
        if (map != null) {
            this.onMapReady(map);
        }
    }

    public void onMapReady(final AMap map) {
        this.map = map;
        this.map.setInfoWindowAdapter((AMap.InfoWindowAdapter)this);
        this.map.setOnMarkerDragListener((AMap.OnMarkerDragListener)this);
        this.manager.pushEvent((View)this, "onMapReady", (WritableMap)new WritableNativeMap());
        final AMapView view = this;
        map.setOnMarkerClickListener(new AMap.OnMarkerClickListener(){

            public boolean onMarkerClick(Marker marker) {
                WritableMap event = AMapView.this.makeClickEventData(marker.getPosition());
                event.putString("action", "marker-press");
                AMapView.this.manager.pushEvent((View)view, "onMarkerPress", event);
                event = AMapView.this.makeClickEventData(marker.getPosition());
                event.putString("action", "marker-press");
                AMapView.this.manager.pushEvent((View)AMapView.this.markerMap.get(marker), "onPress", event);
                return false;
            }
        });
        map.setOnInfoWindowClickListener(new AMap.OnInfoWindowClickListener(){

            public void onInfoWindowClick(Marker marker) {
                WritableMap event = AMapView.this.makeClickEventData(marker.getPosition());
                event.putString("action", "callout-press");
                AMapView.this.manager.pushEvent((View)view, "onCalloutPress", event);
                event = AMapView.this.makeClickEventData(marker.getPosition());
                event.putString("action", "callout-press");
                AMapMarker markerView = (AMapMarker)((Object)AMapView.this.markerMap.get(marker));
                AMapView.this.manager.pushEvent((View)markerView, "onCalloutPress", event);
                event = AMapView.this.makeClickEventData(marker.getPosition());
                event.putString("action", "callout-press");
                AMapCallout infoWindow = markerView.getCalloutView();
                if (infoWindow != null) {
                    AMapView.this.manager.pushEvent((View)infoWindow, "onPress", event);
                }
            }
        });
        map.setOnMapClickListener(new AMap.OnMapClickListener(){

            public void onMapClick(LatLng point) {
                WritableMap event = AMapView.this.makeClickEventData(point);
                event.putString("action", "press");
                AMapView.this.manager.pushEvent((View)view, "onPress", event);
            }
        });
        map.setOnMapLongClickListener(new AMap.OnMapLongClickListener(){

            public void onMapLongClick(LatLng point) {
                WritableMap event = AMapView.this.makeClickEventData(point);
                event.putString("action", "long-press");
                AMapView.this.manager.pushEvent((View)view, "onLongPress", AMapView.this.makeClickEventData(point));
            }
        });
        map.setOnCameraChangeListener(new AMap.OnCameraChangeListener(){

            public void onCameraChange(CameraPosition position) {
                LatLngBounds bounds = map.getProjection().getVisibleRegion().latLngBounds;
                LatLng center = position.target;
                AMapView.this.lastBoundsEmitted = bounds;
                AMapView.this.eventDispatcher.dispatchEvent((Event)new AMapRegionChangeEvent(AMapView.this.getId(), bounds, center, AMapView.this.isTouchDown));
                view.stopMonitoringRegion();
            }

            public void onCameraChangeFinish(CameraPosition cameraPosition) {
            }
        });
        map.setOnMapLoadedListener(new AMap.OnMapLoadedListener(){

            public void onMapLoaded() {
                AMapView.this.isMapLoaded = true;
                AMapView.this.cacheView();
            }
        });
        this.lifecycleListener = new LifecycleEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onHostResume() {
                if (AMapView.this.hasPermissions()) {
                    map.setMyLocationEnabled(AMapView.this.showUserLocation);
                }
                AMapView aMapView = AMapView.this;
                synchronized (aMapView) {
                    AMapView.this.onResume();
                    AMapView.this.paused = false;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onHostPause() {
                if (AMapView.this.hasPermissions()) {
                    map.setMyLocationEnabled(false);
                }
                AMapView aMapView = AMapView.this;
                synchronized (aMapView) {
                    AMapView.this.onPause();
                    AMapView.this.paused = true;
                }
            }

            public void onHostDestroy() {
                AMapView.this.doDestroy();
            }
        };
        this.context.addLifecycleEventListener(this.lifecycleListener);
    }

    private boolean hasPermissions() {
        return PermissionChecker.checkSelfPermission((Context)this.getContext(), (String)PERMISSIONS[0]) == 0 || PermissionChecker.checkSelfPermission((Context)this.getContext(), (String)PERMISSIONS[1]) == 0;
    }

    public synchronized void doDestroy() {
        if (this.lifecycleListener != null) {
            this.context.removeLifecycleEventListener(this.lifecycleListener);
            this.lifecycleListener = null;
        }
        if (!this.paused) {
            this.onPause();
        }
        this.onDestroy();
    }

    public void setRegion(ReadableMap region) {
        if (region == null) {
            return;
        }
        Double lng = region.getDouble("longitude");
        Double lat = region.getDouble("latitude");
        Double lngDelta = region.getDouble("longitudeDelta");
        Double latDelta = region.getDouble("latitudeDelta");
        LatLngBounds bounds = new LatLngBounds(new LatLng(lat - latDelta / 2.0, lng - lngDelta / 2.0), new LatLng(lat + latDelta / 2.0, lng + lngDelta / 2.0));
        if (super.getHeight() <= 0 || super.getWidth() <= 0) {
            this.map.moveCamera(CameraUpdateFactory.newLatLngZoom((LatLng)new LatLng(lat.doubleValue(), lng.doubleValue()), (float)10.0f));
            this.boundsToMove = bounds;
        } else {
            this.map.moveCamera(CameraUpdateFactory.newLatLngBounds((LatLngBounds)bounds, (int)0));
            this.boundsToMove = null;
        }
    }

    public void setShowsUserLocation(boolean showUserLocation) {
        this.showUserLocation = showUserLocation;
        if (this.hasPermissions()) {
            this.map.setMyLocationEnabled(showUserLocation);
        }
    }

    public void setToolbarEnabled(boolean toolbarEnabled) {
        if (this.hasPermissions()) {
            // empty if block
        }
    }

    public void setCacheEnabled(boolean cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
        this.cacheView();
    }

    public void enableMapLoading(boolean loadingEnabled) {
        if (loadingEnabled && !this.isMapLoaded.booleanValue()) {
            this.getMapLoadingLayoutView().setVisibility(0);
        }
    }

    public void setLoadingBackgroundColor(Integer loadingBackgroundColor) {
        this.loadingBackgroundColor = loadingBackgroundColor;
        if (this.mapLoadingLayout != null) {
            if (loadingBackgroundColor == null) {
                this.mapLoadingLayout.setBackgroundColor(-1);
            } else {
                this.mapLoadingLayout.setBackgroundColor(this.loadingBackgroundColor.intValue());
            }
        }
    }

    public void setLoadingIndicatorColor(Integer loadingIndicatorColor) {
        this.loadingIndicatorColor = loadingIndicatorColor;
        if (this.mapLoadingProgressBar != null) {
            Integer color = loadingIndicatorColor;
            if (color == null) {
                color = Color.parseColor((String)"#606060");
            }
            if (Build.VERSION.SDK_INT >= 21) {
                ColorStateList progressTintList = ColorStateList.valueOf((int)loadingIndicatorColor);
                ColorStateList secondaryProgressTintList = ColorStateList.valueOf((int)loadingIndicatorColor);
                ColorStateList indeterminateTintList = ColorStateList.valueOf((int)loadingIndicatorColor);
                this.mapLoadingProgressBar.setProgressTintList(progressTintList);
                this.mapLoadingProgressBar.setSecondaryProgressTintList(secondaryProgressTintList);
                this.mapLoadingProgressBar.setIndeterminateTintList(indeterminateTintList);
            } else {
                PorterDuff.Mode mode = PorterDuff.Mode.SRC_IN;
                if (Build.VERSION.SDK_INT <= 10) {
                    mode = PorterDuff.Mode.MULTIPLY;
                }
                if (this.mapLoadingProgressBar.getIndeterminateDrawable() != null) {
                    this.mapLoadingProgressBar.getIndeterminateDrawable().setColorFilter(color.intValue(), mode);
                }
                if (this.mapLoadingProgressBar.getProgressDrawable() != null) {
                    this.mapLoadingProgressBar.getProgressDrawable().setColorFilter(color.intValue(), mode);
                }
            }
        }
    }

    public void setHandlePanDrag(boolean handlePanDrag) {
        this.handlePanDrag = handlePanDrag;
    }

    public void addFeature(View child, int index) {
        if (child instanceof AMapMarker) {
            AMapMarker annotation = (AMapMarker)child;
            annotation.addToMap(this.map);
            this.features.add(index, annotation);
            Marker marker = (Marker)annotation.getFeature();
            this.markerMap.put(marker, annotation);
        } else if (child instanceof AMapPolyline) {
            AMapPolyline polylineView = (AMapPolyline)child;
            polylineView.addToMap(this.map);
            this.features.add(index, polylineView);
            Polyline polyline = (Polyline)polylineView.getFeature();
            this.polylineMap.put(polyline, polylineView);
        } else if (child instanceof AMapPolygon) {
            AMapPolygon polygonView = (AMapPolygon)child;
            polygonView.addToMap(this.map);
            this.features.add(index, polygonView);
            Polygon polygon = (Polygon)polygonView.getFeature();
            this.polygonMap.put(polygon, polygonView);
        } else if (child instanceof AMapCircle) {
            AMapCircle circleView = (AMapCircle)child;
            circleView.addToMap(this.map);
            this.features.add(index, circleView);
            Circle circle = (Circle)circleView.getFeature();
            this.circleMap.put(circle, circleView);
        }
    }

    public int getFeatureCount() {
        return this.features.size();
    }

    public View getFeatureAt(int index) {
        return (View)this.features.get(index);
    }

    public void removeFeatureAt(int index) {
        MapFeature feature = this.features.remove(index);
        if (feature instanceof AMapMarker) {
            this.markerMap.remove(feature.getFeature());
        } else if (feature instanceof AMapPolyline) {
            this.polylineMap.remove(feature.getFeature());
        } else if (feature instanceof AMapPolygon) {
            this.polygonMap.remove(feature.getFeature());
        } else if (feature instanceof AMapCircle) {
            this.circleMap.remove(feature.getFeature());
        }
        feature.removeFromMap(this.map);
    }

    public WritableMap makeClickEventData(LatLng point) {
        WritableNativeMap event = new WritableNativeMap();
        WritableNativeMap coordinate = new WritableNativeMap();
        coordinate.putDouble("latitude", point.latitude);
        coordinate.putDouble("longitude", point.longitude);
        event.putMap("coordinate", (WritableMap)coordinate);
        Projection projection = this.map.getProjection();
        Point screenPoint = projection.toScreenLocation(point);
        WritableNativeMap position = new WritableNativeMap();
        position.putDouble("x", (double)screenPoint.x);
        position.putDouble("y", (double)screenPoint.y);
        event.putMap("position", (WritableMap)position);
        return event;
    }

    public void updateExtraData(Object extraData) {
        if (this.boundsToMove != null) {
            HashMap data = (HashMap)extraData;
            float width = ((Float)data.get("width")).floatValue();
            float height = ((Float)data.get("height")).floatValue();
            this.map.moveCamera(CameraUpdateFactory.newLatLngBounds((LatLngBounds)this.boundsToMove, (int)((int)width), (int)((int)height), (int)0));
            this.boundsToMove = null;
        }
    }

    public void animateToRegion(LatLngBounds bounds, int duration) {
        this.startMonitoringRegion();
        this.map.animateCamera(CameraUpdateFactory.newLatLngBounds((LatLngBounds)bounds, (int)0), (long)duration, null);
    }

    public void animateToCoordinate(LatLng coordinate, int duration) {
        this.startMonitoringRegion();
        this.map.animateCamera(CameraUpdateFactory.newLatLng((LatLng)coordinate), (long)duration, null);
    }

    public void fitToElements(boolean animated) {
        LatLngBounds.Builder builder = new LatLngBounds.Builder();
        for (MapFeature feature : this.features) {
            if (!(feature instanceof AMapMarker)) continue;
            Marker marker = (Marker)feature.getFeature();
            builder.include(marker.getPosition());
        }
        LatLngBounds bounds = builder.build();
        CameraUpdate cu = CameraUpdateFactory.newLatLngBounds((LatLngBounds)bounds, (int)50);
        if (animated) {
            this.startMonitoringRegion();
            this.map.animateCamera(cu);
        } else {
            this.map.moveCamera(cu);
        }
    }

    public View getInfoWindow(Marker marker) {
        AMapMarker markerView = this.markerMap.get(marker);
        return markerView.getCallout();
    }

    public View getInfoContents(Marker marker) {
        AMapMarker markerView = this.markerMap.get(marker);
        return markerView.getInfoContents();
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        this.scaleDetector.onTouchEvent(ev);
        this.gestureDetector.onTouchEvent(ev);
        int action = MotionEventCompat.getActionMasked((MotionEvent)ev);
        switch (action) {
            case 0: {
                this.isTouchDown = true;
                break;
            }
            case 2: {
                this.startMonitoringRegion();
                break;
            }
            case 1: {
                this.isTouchDown = false;
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    public void startMonitoringRegion() {
        if (this.isMonitoringRegion) {
            return;
        }
        this.timerHandler.postDelayed(this.timerRunnable, 100L);
        this.isMonitoringRegion = true;
    }

    public void stopMonitoringRegion() {
        if (!this.isMonitoringRegion) {
            return;
        }
        this.timerHandler.removeCallbacks(this.timerRunnable);
        this.isMonitoringRegion = false;
    }

    public void onMarkerDragStart(Marker marker) {
        WritableMap event = this.makeClickEventData(marker.getPosition());
        this.manager.pushEvent((View)this, "onMarkerDragStart", event);
        AMapMarker markerView = this.markerMap.get(marker);
        event = this.makeClickEventData(marker.getPosition());
        this.manager.pushEvent((View)markerView, "onDragStart", event);
    }

    public void onMarkerDrag(Marker marker) {
        WritableMap event = this.makeClickEventData(marker.getPosition());
        this.manager.pushEvent((View)this, "onMarkerDrag", event);
        AMapMarker markerView = this.markerMap.get(marker);
        event = this.makeClickEventData(marker.getPosition());
        this.manager.pushEvent((View)markerView, "onDrag", event);
    }

    public void onMarkerDragEnd(Marker marker) {
        WritableMap event = this.makeClickEventData(marker.getPosition());
        this.manager.pushEvent((View)this, "onMarkerDragEnd", event);
        AMapMarker markerView = this.markerMap.get(marker);
        event = this.makeClickEventData(marker.getPosition());
        this.manager.pushEvent((View)markerView, "onDragEnd", event);
    }

    private ProgressBar getMapLoadingProgressBar() {
        if (this.mapLoadingProgressBar == null) {
            this.mapLoadingProgressBar = new ProgressBar(this.getContext());
            this.mapLoadingProgressBar.setIndeterminate(true);
        }
        this.setLoadingIndicatorColor(this.loadingIndicatorColor);
        return this.mapLoadingProgressBar;
    }

    private RelativeLayout getMapLoadingLayoutView() {
        if (this.mapLoadingLayout == null) {
            this.mapLoadingLayout = new RelativeLayout(this.getContext());
            this.mapLoadingLayout.setBackgroundColor(-3355444);
            this.addView((View)this.mapLoadingLayout, new ViewGroup.LayoutParams(-1, -1));
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
            params.addRule(13);
            this.mapLoadingLayout.addView((View)this.getMapLoadingProgressBar(), (ViewGroup.LayoutParams)params);
            this.mapLoadingLayout.setVisibility(4);
        }
        this.setLoadingBackgroundColor(this.loadingBackgroundColor);
        return this.mapLoadingLayout;
    }

    private ImageView getCacheImageView() {
        if (this.cacheImageView == null) {
            this.cacheImageView = new ImageView(this.getContext());
            this.addView((View)this.cacheImageView, new ViewGroup.LayoutParams(-1, -1));
            this.cacheImageView.setVisibility(4);
        }
        return this.cacheImageView;
    }

    private void removeCacheImageView() {
        if (this.cacheImageView != null) {
            ((ViewGroup)this.cacheImageView.getParent()).removeView((View)this.cacheImageView);
            this.cacheImageView = null;
        }
    }

    private void removeMapLoadingProgressBar() {
        if (this.mapLoadingProgressBar != null) {
            ((ViewGroup)this.mapLoadingProgressBar.getParent()).removeView((View)this.mapLoadingProgressBar);
            this.mapLoadingProgressBar = null;
        }
    }

    private void removeMapLoadingLayoutView() {
        this.removeMapLoadingProgressBar();
        if (this.mapLoadingLayout != null) {
            ((ViewGroup)this.mapLoadingLayout.getParent()).removeView((View)this.mapLoadingLayout);
            this.mapLoadingLayout = null;
        }
    }

    private void cacheView() {
        if (this.cacheEnabled) {
            final ImageView cacheImageView = this.getCacheImageView();
            final RelativeLayout mapLoadingLayout = this.getMapLoadingLayoutView();
            cacheImageView.setVisibility(4);
            mapLoadingLayout.setVisibility(0);
            if (this.isMapLoaded.booleanValue()) {
                this.map.getMapScreenShot(new AMap.OnMapScreenShotListener(){

                    public void onMapScreenShot(Bitmap bitmap) {
                        cacheImageView.setImageBitmap(bitmap);
                        cacheImageView.setVisibility(0);
                        mapLoadingLayout.setVisibility(4);
                    }
                });
            }
        } else {
            this.removeCacheImageView();
            if (this.isMapLoaded.booleanValue()) {
                this.removeMapLoadingLayoutView();
            }
        }
    }

    public void onPanDrag(MotionEvent ev) {
        Point point = new Point((int)ev.getX(), (int)ev.getY());
        LatLng coords = this.map.getProjection().fromScreenLocation(point);
        WritableMap event = this.makeClickEventData(coords);
        this.manager.pushEvent((View)this, "onPanDrag", event);
    }
}

