/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.amap.view;

import com.amap.api.maps2d.model.LatLng;
import com.amap.api.maps2d.model.LatLngBounds;

public class AMapLatLngBoundsUtils {
    public static boolean BoundsAreDifferent(LatLngBounds a, LatLngBounds b) {
        LatLng centerA = AMapLatLngBoundsUtils.getCenter(a);
        double latA = centerA.latitude;
        double lngA = centerA.longitude;
        double latDeltaA = a.northeast.latitude - a.southwest.latitude;
        double lngDeltaA = a.northeast.longitude - a.southwest.longitude;
        LatLng centerB = AMapLatLngBoundsUtils.getCenter(b);
        double latB = centerB.latitude;
        double lngB = centerB.longitude;
        double latDeltaB = b.northeast.latitude - b.southwest.latitude;
        double lngDeltaB = b.northeast.longitude - b.southwest.longitude;
        double latEps = AMapLatLngBoundsUtils.LatitudeEpsilon(a, b);
        double lngEps = AMapLatLngBoundsUtils.LongitudeEpsilon(a, b);
        return AMapLatLngBoundsUtils.different(latA, latB, latEps) || AMapLatLngBoundsUtils.different(lngA, lngB, lngEps) || AMapLatLngBoundsUtils.different(latDeltaA, latDeltaB, latEps) || AMapLatLngBoundsUtils.different(lngDeltaA, lngDeltaB, lngEps);
    }

    public static LatLng getCenter(LatLngBounds bounds) {
        LatLng northeast = bounds.northeast;
        LatLng southwest = bounds.southwest;
        return new LatLng((northeast.latitude + southwest.latitude) / 2.0, (northeast.longitude + southwest.longitude) / 2.0);
    }

    private static boolean different(double a, double b, double epsilon) {
        return Math.abs(a - b) > epsilon;
    }

    private static double LatitudeEpsilon(LatLngBounds a, LatLngBounds b) {
        double sizeA = a.northeast.latitude - a.southwest.latitude;
        double sizeB = b.northeast.latitude - b.southwest.latitude;
        double size = Math.min(Math.abs(sizeA), Math.abs(sizeB));
        return size / 2560.0;
    }

    private static double LongitudeEpsilon(LatLngBounds a, LatLngBounds b) {
        double sizeA = a.northeast.longitude - a.southwest.longitude;
        double sizeB = b.northeast.longitude - b.southwest.longitude;
        double size = Math.min(Math.abs(sizeA), Math.abs(sizeB));
        return size / 2560.0;
    }
}

