/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.amap.view;

import android.content.Context;
import com.amap.api.maps2d.AMap;
import com.amap.api.maps2d.model.Circle;
import com.amap.api.maps2d.model.CircleOptions;
import com.amap.api.maps2d.model.LatLng;
import com.tuya.smart.amap.view.MapFeature;

public class AMapCircle
extends MapFeature<AMap> {
    private CircleOptions circleOptions;
    private Circle circle;
    private LatLng center;
    private double radius;
    private int strokeColor;
    private int fillColor;
    private float strokeWidth;
    private float zIndex;

    public AMapCircle(Context context) {
        super(context);
    }

    public void setCenter(LatLng center) {
        this.center = center;
        if (this.circle != null) {
            this.circle.setCenter(this.center);
        }
    }

    public void setRadius(double radius) {
        this.radius = radius;
        if (this.circle != null) {
            this.circle.setRadius(this.radius);
        }
    }

    public void setFillColor(int color) {
        this.fillColor = color;
        if (this.circle != null) {
            this.circle.setFillColor(color);
        }
    }

    public void setStrokeColor(int color) {
        this.strokeColor = color;
        if (this.circle != null) {
            this.circle.setStrokeColor(color);
        }
    }

    public void setStrokeWidth(float width) {
        this.strokeWidth = width;
        if (this.circle != null) {
            this.circle.setStrokeWidth(width);
        }
    }

    public void setZIndex(float zIndex) {
        this.zIndex = zIndex;
        if (this.circle != null) {
            this.circle.setZIndex(zIndex);
        }
    }

    public CircleOptions getCircleOptions() {
        if (this.circleOptions == null) {
            this.circleOptions = this.createCircleOptions();
        }
        return this.circleOptions;
    }

    private CircleOptions createCircleOptions() {
        CircleOptions options = new CircleOptions();
        options.center(this.center);
        options.radius(this.radius);
        options.fillColor(this.fillColor);
        options.strokeColor(this.strokeColor);
        options.strokeWidth(this.strokeWidth);
        options.zIndex(this.zIndex);
        return options;
    }

    @Override
    public Object getFeature() {
        return this.circle;
    }

    @Override
    public void addToMap(AMap map) {
        this.circle = map.addCircle(this.getCircleOptions());
    }

    @Override
    public void removeFromMap(AMap map) {
        this.circle.remove();
    }
}

