/*
 * Decompiled with CFR 0.152.
 */
package com.tuya.smart.amap.manager;

import android.content.Context;
import android.graphics.Color;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import com.amap.api.maps2d.model.Marker;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.uimanager.LayoutShadowNode;
import com.facebook.react.uimanager.ThemedReactContext;
import com.tuya.smart.amap.manager.MapMarkerManager;
import com.tuya.smart.amap.view.AMapCallout;
import com.tuya.smart.amap.view.AMapMarker;
import com.tuya.smart.amap.view.SizeReportingShadowNode;
import java.util.HashMap;
import java.util.Map;

public class AMapMarkerManager
extends MapMarkerManager<AMapMarker> {
    public static final int SHOW_INFO_WINDOW = 1;
    public static final int HIDE_INFO_WINDOW = 2;

    @Override
    public AMapMarker createViewInstance(ThemedReactContext context) {
        return new AMapMarker((Context)context);
    }

    @Override
    public void setCoordinate(AMapMarker view, ReadableMap map) {
        view.setCoordinate(map);
    }

    @Override
    public void setTitle(AMapMarker view, String title) {
        view.setTitle(title);
    }

    @Override
    public void setDescription(AMapMarker view, String description) {
        view.setSnippet(description);
    }

    @Override
    public void setAnchor(AMapMarker view, ReadableMap map) {
        double x = map != null && map.hasKey("x") ? map.getDouble("x") : 0.5;
        double y = map != null && map.hasKey("y") ? map.getDouble("y") : 1.0;
        view.setAnchor(x, y);
    }

    @Override
    public void setCalloutAnchor(AMapMarker view, ReadableMap map) {
        double x = map != null && map.hasKey("x") ? map.getDouble("x") : 0.5;
        double y = map != null && map.hasKey("y") ? map.getDouble("y") : 0.0;
        view.setCalloutAnchor(x, y);
    }

    @Override
    public void setImage(AMapMarker view, @Nullable String source) {
        view.setImage(source);
    }

    @Override
    public void setPinColor(AMapMarker view, int pinColor) {
        float[] hsv = new float[3];
        Color.colorToHSV((int)pinColor, (float[])hsv);
        view.setMarkerHue(hsv[0]);
    }

    @Override
    public void setMarkerRotation(AMapMarker view, float rotation) {
        view.setRotation(rotation);
    }

    @Override
    public void setFlat(AMapMarker view, boolean flat) {
        view.setFlat(flat);
    }

    @Override
    public void setDraggable(AMapMarker view, boolean draggable) {
        view.setDraggable(draggable);
    }

    public void addView(AMapMarker parent, View child, int index) {
        if (child instanceof AMapCallout) {
            parent.setCalloutView((AMapCallout)child);
        } else {
            super.addView((ViewGroup)parent, child, index);
            parent.update();
        }
    }

    public void removeViewAt(AMapMarker parent, int index) {
        super.removeViewAt((ViewGroup)parent, index);
        parent.update();
    }

    @Nullable
    public Map<String, Integer> getCommandsMap() {
        return MapBuilder.of((Object)"showCallout", (Object)1, (Object)"hideCallout", (Object)2);
    }

    public void receiveCommand(AMapMarker view, int commandId, @Nullable ReadableArray args) {
        switch (commandId) {
            case 1: {
                ((Marker)view.getFeature()).showInfoWindow();
                break;
            }
            case 2: {
                ((Marker)view.getFeature()).hideInfoWindow();
            }
        }
    }

    @Nullable
    public Map getExportedCustomDirectEventTypeConstants() {
        Map map = MapBuilder.of((Object)"onPress", (Object)MapBuilder.of((Object)"registrationName", (Object)"onPress"), (Object)"onCalloutPress", (Object)MapBuilder.of((Object)"registrationName", (Object)"onCalloutPress"), (Object)"onDragStart", (Object)MapBuilder.of((Object)"registrationName", (Object)"onDragStart"), (Object)"onDrag", (Object)MapBuilder.of((Object)"registrationName", (Object)"onDrag"), (Object)"onDragEnd", (Object)MapBuilder.of((Object)"registrationName", (Object)"onDragEnd"));
        map.putAll(MapBuilder.of((Object)"onDragStart", (Object)MapBuilder.of((Object)"registrationName", (Object)"onDragStart"), (Object)"onDrag", (Object)MapBuilder.of((Object)"registrationName", (Object)"onDrag"), (Object)"onDragEnd", (Object)MapBuilder.of((Object)"registrationName", (Object)"onDragEnd")));
        return map;
    }

    public LayoutShadowNode createShadowNodeInstance() {
        return new SizeReportingShadowNode();
    }

    public void updateExtraData(AMapMarker view, Object extraData) {
        HashMap data = (HashMap)extraData;
        float width = ((Float)data.get("width")).floatValue();
        float height = ((Float)data.get("height")).floatValue();
        view.update((int)width, (int)height);
    }
}

